/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starters.local.wizard;

import com.intellij.ide.projectWizard.ProjectWizardJdkIntent;
import com.intellij.ide.starters.JavaStartersBundle;
import com.intellij.ide.starters.local.DependencyConfig;
import com.intellij.ide.starters.local.Starter;
import com.intellij.ide.starters.local.StarterContext;
import com.intellij.ide.starters.local.StarterContextProvider;
import com.intellij.ide.starters.local.StarterModuleBuilder;
import com.intellij.ide.starters.local.StarterPack;
import com.intellij.ide.starters.local.StarterUtils;
import com.intellij.ide.starters.local.wizard.StarterInitialStep;
import com.intellij.ide.starters.shared.CommonStarterInitialStep;
import com.intellij.ide.starters.shared.CustomizedMessages;
import com.intellij.ide.starters.shared.FormUiUtilKt;
import com.intellij.ide.starters.shared.StarterLanguage;
import com.intellij.ide.starters.shared.StarterProjectType;
import com.intellij.ide.starters.shared.StarterTestRunner;
import com.intellij.ide.wizard.UIWizardUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.roots.ui.configuration.JdkComboBoxKt;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SegmentedButton;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0012H\u0002J\b\u0010\"\u001a\u00020\u001aH\u0016J\b\u0010#\u001a\u00020\u001eH\u0016J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u0010H\u0002J\u0016\u0010&\u001a\u00020\u001e2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0003J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u001cH\u0003J\u001e\u0010-\u001a\u0010\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u001c\u0018\u00010.2\u0006\u0010,\u001a\u00020\u001cH\u0003J\u0018\u00100\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u001c2\u0006\u00101\u001a\u00020/H\u0003J\u0018\u00102\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u001c2\u0006\u00101\u001a\u00020+H\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\u001c2\u0006\u0010,\u001a\u00020\u001cH\u0002J\u0010\u00104\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\u001cH\u0002J\u0010\u00105\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\u001cH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/ide/starters/local/wizard/StarterInitialStep;", "Lcom/intellij/ide/starters/shared/CommonStarterInitialStep;", "contextProvider", "Lcom/intellij/ide/starters/local/StarterContextProvider;", "<init>", "(Lcom/intellij/ide/starters/local/StarterContextProvider;)V", "moduleBuilder", "Lcom/intellij/ide/starters/local/StarterModuleBuilder;", "getModuleBuilder", "()Lcom/intellij/ide/starters/local/StarterModuleBuilder;", "starterContext", "Lcom/intellij/ide/starters/local/StarterContext;", "getStarterContext", "()Lcom/intellij/ide/starters/local/StarterContext;", "starterPackProvider", "Lkotlin/Function0;", "Lcom/intellij/ide/starters/local/StarterPack;", "contentPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "getContentPanel", "()Lcom/intellij/openapi/ui/DialogPanel;", "contentPanel$delegate", "Lkotlin/Lazy;", "languageRow", "Lcom/intellij/ui/dsl/builder/Row;", "isDisposed", "", "getHelpId", "", "updateDataModel", "", "getComponent", "Ljavax/swing/JComponent;", "createComponent", "validate", "onStepLeaving", "updateStartersDependencies", "starterPack", "checkDependencyUpdates", "starters", "", "Lcom/intellij/ide/starters/local/Starter;", "loadStarterDependencyUpdatesFromFile", "Lcom/intellij/ide/starters/local/DependencyConfig;", "starterId", "loadStarterDependencyUpdatesFromNetwork", "Lkotlin/Pair;", "Lorg/jdom/Element;", "saveStarterDependencyUpdatesToFile", "dependencyConfigUpdate", "setStarterDependencyUpdates", "buildStarterPatchUrl", "getDependencyConfigUpdatesDirLocation", "getPatchFileName", "intellij.java.ui"})
@SourceDebugExtension(value={"SMAP\nStarterInitialStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StarterInitialStep.kt\ncom/intellij/ide/starters/local/wizard/StarterInitialStep\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,283:1\n1#2:284\n13#3:285\n13#3:286\n13#3:287\n13#3:288\n*S KotlinDebug\n*F\n+ 1 StarterInitialStep.kt\ncom/intellij/ide/starters/local/wizard/StarterInitialStep\n*L\n223#1:285\n241#1:286\n244#1:287\n247#1:288\n*E\n"})
public class StarterInitialStep
extends CommonStarterInitialStep {
    @NotNull
    private final StarterModuleBuilder moduleBuilder;
    @NotNull
    private final StarterContext starterContext;
    @NotNull
    private final Function0<StarterPack> starterPackProvider;
    @NotNull
    private final Lazy contentPanel$delegate;
    private Row languageRow;
    private volatile boolean isDisposed;

    public StarterInitialStep(@NotNull StarterContextProvider contextProvider) {
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        super(contextProvider.getWizardContext(), contextProvider.getStarterContext(), contextProvider.getModuleBuilder(), contextProvider.getParentDisposable(), contextProvider.getSettings());
        this.moduleBuilder = contextProvider.getModuleBuilder();
        this.starterContext = contextProvider.getStarterContext();
        this.starterPackProvider = contextProvider.getStarterPackProvider();
        this.contentPanel$delegate = LazyKt.lazy(() -> StarterInitialStep.contentPanel_delegate$lambda$0(this));
        Disposer.register((Disposable)this.getParentDisposable(), () -> StarterInitialStep._init_$lambda$0(this));
    }

    @NotNull
    protected final StarterModuleBuilder getModuleBuilder() {
        return this.moduleBuilder;
    }

    @NotNull
    protected final StarterContext getStarterContext() {
        return this.starterContext;
    }

    private final DialogPanel getContentPanel() {
        Lazy lazy = this.contentPanel$delegate;
        return (DialogPanel)lazy.getValue();
    }

    @Nullable
    public String getHelpId() {
        return this.moduleBuilder.getHelpId();
    }

    public void updateDataModel() {
        this.starterContext.setProjectType((StarterProjectType)this.getProjectTypeProperty().get());
        this.starterContext.setLanguage((StarterLanguage)this.getLanguageProperty().get());
        this.starterContext.setGroup(this.getGroupId());
        this.starterContext.setArtifact(this.getArtifactId());
        this.starterContext.setTestFramework((StarterTestRunner)this.getTestFrameworkProperty().get());
        this.starterContext.setIncludeExamples((Boolean)this.getExampleCodeProperty().get());
        this.starterContext.setGitIntegration((Boolean)this.getGitProperty().get());
        this.getWizardContext().setProjectName(this.getEntityName());
        String[] stringArray = new String[]{this.getLocation(), this.getEntityName()};
        this.getWizardContext().setProjectFileDirectory(FileUtil.join((String[])stringArray));
        this.moduleBuilder.setModuleJdk(this.getWizardContext().getProjectJdk());
    }

    @NotNull
    public JComponent getComponent() {
        return (JComponent)this.getContentPanel();
    }

    private final DialogPanel createComponent() {
        DialogPanel dialogPanel;
        this.getEntityNameProperty().dependsOn((ObservableProperty)this.getArtifactIdProperty(), () -> StarterInitialStep.createComponent$lambda$0(this));
        this.getArtifactIdProperty().dependsOn((ObservableProperty)this.getEntityNameProperty(), () -> StarterInitialStep.createComponent$lambda$1(this));
        StarterPack starterPack = (StarterPack)this.starterPackProvider.invoke();
        this.starterContext.setStarterPack(starterPack);
        this.updateStartersDependencies(starterPack);
        DialogPanel $this$createComponent_u24lambda_u243 = dialogPanel = UIWizardUtil.withVisualPadding((DialogPanel)BuilderKt.panel(arg_0 -> StarterInitialStep.createComponent$lambda$2(this, arg_0)), (boolean)true);
        boolean bl = false;
        $this$createComponent_u24lambda_u243.registerValidators(this.getParentDisposable());
        return dialogPanel;
    }

    public boolean validate() {
        if (!FormUiUtilKt.validateFormFields(this.getComponent(), this.getContentPanel(), this.getValidatedTextComponents())) {
            return false;
        }
        JavaVersion javaVersion = this.moduleBuilder.getMinJavaVersionInternal$intellij_java_ui();
        if (!JdkComboBoxKt.validateJdkIntentVersion((ObservableProperty<ProjectWizardJdkIntent>)((ObservableProperty)this.getJdkIntentProperty()), javaVersion != null ? javaVersion.toFeatureString() : null, this.moduleBuilder.getPresentableName())) {
            return false;
        }
        return !(!((Collection)this.getContentPanel().validateAll()).isEmpty());
    }

    public void onStepLeaving() {
        this.getContentPanel().apply();
    }

    private final void updateStartersDependencies(StarterPack starterPack) {
        List<Starter> starters = starterPack.getStarters();
        AppExecutorUtil.getAppExecutorService().submit(() -> StarterInitialStep.updateStartersDependencies$lambda$0(this, starters));
    }

    @RequiresBackgroundThread
    private final void checkDependencyUpdates(List<Starter> starters) {
        for (Starter starter : starters) {
            Pair<Element, String> externalUpdates;
            DependencyConfig localUpdates = this.loadStarterDependencyUpdatesFromFile(starter.getId());
            if (localUpdates != null) {
                this.setStarterDependencyUpdates(starter.getId(), localUpdates);
                return;
            }
            if (this.loadStarterDependencyUpdatesFromNetwork(starter.getId()) == null) {
                return;
            }
            Element dependencyUpdates = (Element)externalUpdates.component1();
            String resourcePath = (String)externalUpdates.component2();
            if (this.isDisposed) {
                return;
            }
            DependencyConfig dependencyConfig = StarterUtils.parseDependencyConfig$default(StarterUtils.INSTANCE, dependencyUpdates, resourcePath, false, 4, null);
            if (this.isDisposed) {
                return;
            }
            this.saveStarterDependencyUpdatesToFile(starter.getId(), dependencyUpdates);
            this.setStarterDependencyUpdates(starter.getId(), dependencyConfig);
        }
    }

    @RequiresBackgroundThread
    private final DependencyConfig loadStarterDependencyUpdatesFromFile(String starterId) {
        DependencyConfig dependencyConfig;
        File configUpdateDir = new File(PathManager.getTempPath(), this.getDependencyConfigUpdatesDirLocation(starterId));
        File configUpdateFile = new File(configUpdateDir, this.getPatchFileName(starterId));
        if (!configUpdateFile.exists() || StarterUtils.INSTANCE.isDependencyUpdateFileExpired$intellij_java_ui(configUpdateFile)) {
            return null;
        }
        String resourcePath = configUpdateFile.getAbsolutePath();
        try {
            Element element = JDOMUtil.load((File)configUpdateFile);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
            Intrinsics.checkNotNull((Object)resourcePath);
            dependencyConfig = StarterUtils.parseDependencyConfig$default(StarterUtils.INSTANCE, element, resourcePath, false, 4, null);
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(StarterInitialStep.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to load starter dependency updates from file: " + resourcePath + ". The file will be deleted.");
            FileUtil.delete((File)configUpdateFile);
            dependencyConfig = null;
        }
        return dependencyConfig;
    }

    @RequiresBackgroundThread
    private final Pair<Element, String> loadStarterDependencyUpdatesFromNetwork(String starterId) {
        String string = this.buildStarterPatchUrl(starterId);
        if (string == null) {
            return null;
        }
        String url = string;
        try {
            String string2 = HttpRequests.request((String)url).accept("application/xml").readString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
            String content = string2;
            return TuplesKt.to((Object)JDOMUtil.load((CharSequence)content), (Object)url);
        }
        catch (Exception e) {
            if (e instanceof HttpRequests.HttpStatusException && (((HttpRequests.HttpStatusException)e).getStatusCode() == 403 || ((HttpRequests.HttpStatusException)e).getStatusCode() == 404)) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(StarterInitialStep.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.debug("No updates for " + starterId + ": " + url);
            } else if (e instanceof SocketTimeoutException) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(StarterInitialStep.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.debug("Socket timeout for " + starterId + ": " + url);
            } else {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(StarterInitialStep.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Unable to load external starter " + starterId + " dependency updates from: " + url, (Throwable)e);
            }
            return null;
        }
    }

    @RequiresBackgroundThread
    private final void saveStarterDependencyUpdatesToFile(String starterId, Element dependencyConfigUpdate) {
        String[] stringArray = new String[]{this.getDependencyConfigUpdatesDirLocation(starterId)};
        Path configUpdateDir = Path.of(PathManager.getTempPath(), stringArray);
        Intrinsics.checkNotNull((Object)configUpdateDir);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(configUpdateDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Files.createDirectories(configUpdateDir, new FileAttribute[0]);
        }
        Path configUpdateFile = configUpdateDir.resolve(this.getPatchFileName(starterId));
        JDOMUtil.write((Element)dependencyConfigUpdate, (Path)configUpdateFile);
    }

    private final void setStarterDependencyUpdates(String starterId, DependencyConfig dependencyConfigUpdate) {
        UIUtil.invokeLaterIfNeeded(() -> StarterInitialStep.setStarterDependencyUpdates$lambda$0(this, starterId, dependencyConfigUpdate));
    }

    private final String buildStarterPatchUrl(String starterId) {
        String string = StringKt.nullize((String)Registry.Companion.stringValue("starters.dependency.update.host"), (boolean)true);
        if (string == null) {
            return null;
        }
        String host = string;
        ApplicationInfoEx it = ApplicationInfoImpl.getShadowInstance();
        boolean bl = false;
        String ideVersion = it.getMajorVersion() + "." + it.getMinorVersion();
        String patchFileName = this.getPatchFileName(starterId);
        return host + "/starter/" + starterId + "/" + ideVersion + "/" + patchFileName;
    }

    private final String getDependencyConfigUpdatesDirLocation(String starterId) {
        return "framework-starters/" + starterId + "/";
    }

    private final String getPatchFileName(String starterId) {
        return starterId + "_patch.pom";
    }

    private static final DialogPanel contentPanel_delegate$lambda$0(StarterInitialStep this$0) {
        return this$0.createComponent();
    }

    private static final void _init_$lambda$0(StarterInitialStep this$0) {
        this$0.isDisposed = true;
    }

    private static final String createComponent$lambda$2$0$0(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Unit createComponent$lambda$2$1$0(SegmentedButton.ItemPresentation $this$segmentedButton, StarterLanguage it) {
        Intrinsics.checkNotNullParameter((Object)$this$segmentedButton, (String)"$this$segmentedButton");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$segmentedButton.setText(it.getTitle());
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$2$2$0(SegmentedButton.ItemPresentation $this$segmentedButton, StarterProjectType it) {
        Intrinsics.checkNotNullParameter((Object)$this$segmentedButton, (String)"$this$segmentedButton");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$segmentedButton.setText(it.getTitle());
        $this$segmentedButton.setToolTipText(it.getDescription());
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$2$3$0(SegmentedButton.ItemPresentation $this$segmentedButton, StarterTestRunner it) {
        Intrinsics.checkNotNullParameter((Object)$this$segmentedButton, (String)"$this$segmentedButton");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$segmentedButton.setText(it.getTitle());
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$2$0(StarterInitialStep this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        DefaultComboBoxModel applicationTypesModel = new DefaultComboBoxModel();
        applicationTypesModel.addAll(this$0.getStarterSettings().getApplicationTypes());
        ComboBoxKt.columns((Cell)ComboBoxKt.bindItem((Cell)$this$row.comboBox((ComboBoxModel)applicationTypesModel, (ListCellRenderer)SimpleListCellRenderer.create((String)"", arg_0 -> StarterInitialStep.createComponent$lambda$2$0$0((Function1)createComponent.3.1.1.INSTANCE, arg_0))), (ObservableMutableProperty)((ObservableMutableProperty)this$0.getApplicationTypeProperty())), (int)25);
        $this$row.bottomGap(BottomGap.SMALL);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$2$1(StarterInitialStep this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.languageRow = $this$row;
        $this$row.segmentedButton((Collection)this$0.getStarterSettings().getLanguages(), StarterInitialStep::createComponent$lambda$2$1$0).bind((ObservableMutableProperty)this$0.getLanguageProperty());
        $this$row.bottomGap(BottomGap.SMALL);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$2$2(StarterInitialStep this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.segmentedButton((Collection)this$0.getStarterSettings().getProjectTypes(), StarterInitialStep::createComponent$lambda$2$2$0).bind((ObservableMutableProperty)this$0.getProjectTypeProperty());
        $this$row.bottomGap(BottomGap.SMALL);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$2$3(StarterInitialStep this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.segmentedButton((Collection)this$0.getStarterSettings().getTestFrameworks(), StarterInitialStep::createComponent$lambda$2$3$0).bind((ObservableMutableProperty)this$0.getTestFrameworkProperty());
        $this$row.bottomGap(BottomGap.SMALL);
        return Unit.INSTANCE;
    }

    private static final String createComponent$lambda$0(StarterInitialStep this$0) {
        return this$0.getArtifactId();
    }

    private static final String createComponent$lambda$1(StarterInitialStep this$0) {
        return this$0.getEntityName();
    }

    private static final Unit createComponent$lambda$2(StarterInitialStep this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        this$0.addProjectLocationUi($this$panel);
        this$0.addFieldsBefore($this$panel);
        if (!((Collection)this$0.getStarterSettings().getApplicationTypes()).isEmpty()) {
            String string = JavaStartersBundle.message("title.project.app.type.label", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $this$panel.row(string, arg_0 -> StarterInitialStep.createComponent$lambda$2$0(this$0, arg_0));
        }
        if (this$0.getStarterSettings().getLanguages().size() > 1) {
            String string = JavaStartersBundle.message("title.project.language.label", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $this$panel.row(string, arg_0 -> StarterInitialStep.createComponent$lambda$2$1(this$0, arg_0));
        }
        if (!((Collection)this$0.getStarterSettings().getProjectTypes()).isEmpty()) {
            CustomizedMessages messages = this$0.getStarterSettings().getCustomizedMessages();
            Object object = messages;
            if (object == null || (object = ((CustomizedMessages)object).getProjectTypeLabel()) == null) {
                String string = JavaStartersBundle.message("title.project.build.system.label", new Object[0]);
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            }
            $this$panel.row((String)object, arg_0 -> StarterInitialStep.createComponent$lambda$2$2(this$0, arg_0));
        }
        if (this$0.getStarterSettings().getTestFrameworks().size() > 1) {
            String string = JavaStartersBundle.message("title.project.test.framework.label", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $this$panel.row(string, arg_0 -> StarterInitialStep.createComponent$lambda$2$3(this$0, arg_0));
        }
        this$0.addGroupArtifactUi($this$panel);
        this$0.addSdkUi($this$panel);
        this$0.addSampleCodeUi($this$panel);
        this$0.addFieldsAfter($this$panel);
        return Unit.INSTANCE;
    }

    private static final void updateStartersDependencies$lambda$0(StarterInitialStep this$0, List $starters) {
        this$0.checkDependencyUpdates($starters);
    }

    private static final void setStarterDependencyUpdates$lambda$0(StarterInitialStep this$0, String $starterId, DependencyConfig $dependencyConfigUpdate) {
        if (this$0.isDisposed) {
            return;
        }
        this$0.starterContext.getStartersDependencyUpdates().put($starterId, $dependencyConfigUpdate);
    }
}

