/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starters.shared.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.starters.JavaStartersBundle;
import com.intellij.ide.starters.shared.LibraryInfo;
import com.intellij.ide.starters.shared.LibraryLink;
import com.intellij.ide.starters.shared.ui.LibraryDescriptionPanel;
import com.intellij.openapi.roots.ui.componentsList.components.ScrollablePanel;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u001a\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013J\u0006\u0010\u0016\u001a\u00020\u000fJ\b\u0010\u0017\u001a\u00020\u000fH\u0002J\b\u0010\u0018\u001a\u00020\u000fH\u0002J\u0012\u0010\u0019\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J\u0012\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001bH\u0014J\u0018\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/ide/starters/shared/ui/LibraryDescriptionPanel;", "Lcom/intellij/openapi/roots/ui/componentsList/components/ScrollablePanel;", "<init>", "()V", "descriptionHeader", "Lcom/intellij/ui/components/JBLabel;", "descriptionText", "Ljavax/swing/JTextArea;", "descriptionVersion", "Lcom/intellij/openapi/ui/ex/MultiLineLabel;", "linksPanel", "Ljavax/swing/JPanel;", "emptyState", "Lcom/intellij/util/ui/StatusText;", "update", "", "library", "Lcom/intellij/ide/starters/shared/LibraryInfo;", "versionConstraint", "", "title", "description", "reset", "showEmptyState", "showDescriptionUi", "paintComponent", "g", "Ljava/awt/Graphics;", "getComponentGraphics", "graphics", "addDescriptionLinks", "item", "WrappedFlowLayout", "intellij.java.ui"})
@ApiStatus.Internal
public final class LibraryDescriptionPanel
extends ScrollablePanel {
    @NotNull
    private final JBLabel descriptionHeader = new JBLabel();
    @NotNull
    private final JTextArea descriptionText = new JTextArea();
    @NotNull
    private final MultiLineLabel descriptionVersion = new MultiLineLabel();
    @NotNull
    private final JPanel linksPanel = new JPanel(new WrappedFlowLayout());
    @NotNull
    private final StatusText emptyState = new StatusText(this){
        final /* synthetic */ LibraryDescriptionPanel this$0;
        {
            this.this$0 = $receiver;
            super((JComponent)((Object)$receiver));
        }

        protected boolean isStatusVisible() {
            return UIUtil.uiChildren((Component)((Component)((Object)this.this$0))).filter(arg_0 -> emptyState.1.isStatusVisible$lambda$1(emptyState.1::isStatusVisible$lambda$0, arg_0)).isEmpty();
        }

        private static final boolean isStatusVisible$lambda$0(Component obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            return obj.isVisible();
        }

        private static final boolean isStatusVisible$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    };

    public LibraryDescriptionPanel() {
        super((LayoutManager)new VerticalLayout(4));
        this.setBorder(JBUI.Borders.empty((int)4));
        JPanel headerPanel = new JPanel(new BorderLayout());
        this.descriptionHeader.setFont(StartupUiUtil.getLabelFont().deriveFont(1));
        this.descriptionHeader.setBorder((Border)JBUI.Borders.empty((int)4, (int)0));
        this.descriptionVersion.setIcon(AllIcons.General.BalloonWarning);
        this.descriptionVersion.setBorder((Border)JBUI.Borders.empty((int)4, (int)0, (int)8, (int)0));
        this.descriptionVersion.setVisible(false);
        headerPanel.add((Component)this.descriptionHeader, "North");
        headerPanel.add((Component)this.descriptionVersion, "Center");
        this.add(headerPanel);
        this.descriptionText.setBackground(JBColor.PanelBackground);
        this.descriptionText.setFocusable(false);
        this.descriptionText.setLineWrap(true);
        this.descriptionText.setWrapStyleWord(true);
        this.descriptionText.setEditable(false);
        this.descriptionText.setFont((Font)JBUI.Fonts.label());
        this.add(this.descriptionText);
        this.linksPanel.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        this.add(this.linksPanel);
        this.emptyState.setText(JavaStartersBundle.message("hint.no.library.selected", new Object[0]));
        this.showEmptyState();
    }

    public final void update(@NotNull LibraryInfo library, @NlsSafe @Nullable String versionConstraint) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        this.descriptionHeader.setText(library.getTitle());
        String string = versionConstraint;
        if (string == null) {
            string = "";
        }
        this.descriptionVersion.setText(string);
        this.descriptionVersion.setVisible(versionConstraint != null);
        this.descriptionText.setText(library.getDescription());
        this.addDescriptionLinks(this.linksPanel, library);
        this.showDescriptionUi();
    }

    public final void update(@NlsSafe @NotNull String title, @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.descriptionHeader.setText(title);
        this.descriptionVersion.setText("");
        this.descriptionVersion.setVisible(false);
        this.descriptionText.setText(description);
        this.linksPanel.removeAll();
        this.showDescriptionUi();
    }

    public final void reset() {
        this.descriptionHeader.setText("");
        this.descriptionVersion.setText("");
        this.descriptionText.setText("");
        this.descriptionVersion.setVisible(false);
        this.linksPanel.removeAll();
        this.showEmptyState();
    }

    private final void showEmptyState() {
        Component[] componentArray = this.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        for (Component component : componentArray) {
            component.setVisible(false);
        }
        this.revalidate();
        this.repaint();
    }

    private final void showDescriptionUi() {
        Component[] componentArray = this.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        for (Component component : componentArray) {
            component.setVisible(true);
        }
        this.revalidate();
        this.repaint();
    }

    protected void paintComponent(@Nullable Graphics g) {
        super.paintComponent(g);
        this.emptyState.paint((Component)((Object)this), g);
    }

    @NotNull
    protected Graphics getComponentGraphics(@Nullable Graphics graphics) {
        Graphics2D graphics2D = JBSwingUtilities.runGlobalCGTransform((JComponent)((JComponent)((Object)this)), (Graphics)super.getComponentGraphics(graphics));
        Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"runGlobalCGTransform(...)");
        return graphics2D;
    }

    /*
     * WARNING - void declaration
     */
    private final void addDescriptionLinks(JPanel linksPanel, LibraryInfo item) {
        linksPanel.removeAll();
        for (LibraryLink link : item.getLinks()) {
            void $this$addDescriptionLinks_u24lambda_u240;
            BorderLayoutPanel borderLayoutPanel;
            if (StringsKt.contains$default((CharSequence)link.getUrl(), (char)'{', (boolean)false, (int)2, null)) continue;
            String string = link.getTitle();
            if (string == null) {
                string = link.getType().getTitle();
            }
            HyperlinkLabel linkLabel = new HyperlinkLabel(string);
            linkLabel.setFont((Font)JBUI.Fonts.smallFont());
            linkLabel.setHyperlinkTarget(link.getUrl());
            linkLabel.setToolTipText(link.getUrl());
            BorderLayoutPanel borderLayoutPanel2 = borderLayoutPanel = new BorderLayoutPanel();
            JPanel jPanel = linksPanel;
            boolean bl = false;
            $this$addDescriptionLinks_u24lambda_u240.addToCenter((Component)linkLabel);
            $this$addDescriptionLinks_u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)0, (int)5));
            jPanel.add((Component)borderLayoutPanel);
        }
        linksPanel.revalidate();
        linksPanel.repaint();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/starters/shared/ui/LibraryDescriptionPanel$WrappedFlowLayout;", "Ljava/awt/FlowLayout;", "<init>", "()V", "preferredLayoutSize", "Ljava/awt/Dimension;", "target", "Ljava/awt/Container;", "getWrappedSize", "getDimension", "maxWidth", "", "minimumLayoutSize", "intellij.java.ui"})
    private static final class WrappedFlowLayout
    extends FlowLayout {
        public WrappedFlowLayout() {
            super(3, 0, 4);
        }

        @Override
        @NotNull
        public Dimension preferredLayoutSize(@NotNull Container target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Dimension baseSize = super.preferredLayoutSize(target);
            if (this.getAlignOnBaseline()) {
                Intrinsics.checkNotNull((Object)baseSize);
                return baseSize;
            }
            return this.getWrappedSize(target);
        }

        private final Dimension getWrappedSize(Container target) {
            Container parent = SwingUtilities.getUnwrappedParent(target);
            int maxWidth = parent.getWidth() - (parent.getInsets().left + parent.getInsets().right);
            return this.getDimension(target, maxWidth);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Dimension getDimension(Container target, int maxWidth) {
            Insets insets = target.getInsets();
            int height = 0;
            height = insets.top + insets.bottom;
            int width = 0;
            width = insets.left + insets.right;
            int rowHeight = 0;
            int rowWidth = 0;
            rowWidth = insets.left + insets.right;
            boolean isVisible = false;
            boolean start = false;
            start = true;
            Object object = target.getTreeLock();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTreeLock(...)");
            Object object2 = object;
            synchronized (object2) {
                block6: {
                    boolean bl = false;
                    int n = target.getComponentCount();
                    for (int i = 0; i < n; ++i) {
                        Component component = target.getComponent(i);
                        if (!component.isVisible()) continue;
                        isVisible = true;
                        Dimension size = component.getPreferredSize();
                        if (rowWidth + this.getHgap() + size.width > maxWidth && !start) {
                            height += this.getVgap() + rowHeight;
                            width = Math.max(width, rowWidth);
                            rowWidth = insets.left + insets.right;
                            rowHeight = 0;
                        }
                        rowWidth += this.getHgap() + size.width;
                        rowHeight = Math.max(rowHeight, size.height);
                        start = false;
                    }
                    height += this.getVgap() + rowHeight;
                    width = Math.max(width, rowWidth);
                    if (isVisible) break block6;
                    Dimension dimension = super.preferredLayoutSize(target);
                    Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"preferredLayoutSize(...)");
                    Dimension dimension2 = dimension;
                    return dimension2;
                }
                Dimension dimension = new Dimension(width, height);
                return dimension;
            }
        }

        @Override
        @NotNull
        public Dimension minimumLayoutSize(@NotNull Container target) {
            Dimension dimension;
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            if (this.getAlignOnBaseline()) {
                Dimension dimension2 = super.minimumLayoutSize(target);
                dimension = dimension2;
                Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"minimumLayoutSize(...)");
            } else {
                dimension = this.getWrappedSize(target);
            }
            return dimension;
        }
    }
}

