/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starters.shared.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.starters.JavaStartersBundle;
import com.intellij.ide.starters.shared.DependencyState;
import com.intellij.ide.starters.shared.DependencyUnavailable;
import com.intellij.ide.starters.shared.LibraryInfo;
import com.intellij.openapi.roots.ui.componentsList.components.ScrollablePanel;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0019\u001a\u00020\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R(\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0012\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0010R(\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0016\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000e\"\u0004\b\u0018\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ide/starters/shared/ui/SelectedLibrariesPanel;", "Lcom/intellij/ui/components/JBPanelWithEmptyText;", "<init>", "()V", "scrollablePanel", "Lcom/intellij/openapi/roots/ui/componentsList/components/ScrollablePanel;", "scrollPane", "Ljavax/swing/JScrollPane;", "Lorg/jetbrains/annotations/NotNull;", "libraryRemoveListener", "Lkotlin/Function1;", "Lcom/intellij/ide/starters/shared/LibraryInfo;", "", "getLibraryRemoveListener", "()Lkotlin/jvm/functions/Function1;", "setLibraryRemoveListener", "(Lkotlin/jvm/functions/Function1;)V", "dependencyStateFunction", "Lcom/intellij/ide/starters/shared/DependencyState;", "getDependencyStateFunction", "setDependencyStateFunction", "libraryRemovablePredicate", "", "getLibraryRemovablePredicate", "setLibraryRemovablePredicate", "update", "libraries", "", "intellij.java.ui"})
@ApiStatus.Internal
public final class SelectedLibrariesPanel
extends JBPanelWithEmptyText {
    @NotNull
    private final ScrollablePanel scrollablePanel = new ScrollablePanel((LayoutManager)new VerticalLayout(4));
    @NotNull
    private final JScrollPane scrollPane;
    @Nullable
    private Function1<? super LibraryInfo, Unit> libraryRemoveListener;
    @Nullable
    private Function1<? super LibraryInfo, ? extends DependencyState> dependencyStateFunction;
    @Nullable
    private Function1<? super LibraryInfo, Boolean> libraryRemovablePredicate;

    public SelectedLibrariesPanel() {
        super((LayoutManager)new BorderLayout());
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)this.scrollablePanel), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        this.scrollPane = jScrollPane;
        this.setBackground(UIUtil.getListBackground());
        this.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1));
        this.add(this.scrollPane, "Center");
        this.scrollablePanel.setBorder(JBUI.Borders.empty((int)5));
        this.scrollablePanel.setBackground(UIUtil.getListBackground());
        this.scrollPane.setVisible(false);
    }

    @Nullable
    public final Function1<LibraryInfo, Unit> getLibraryRemoveListener() {
        return this.libraryRemoveListener;
    }

    public final void setLibraryRemoveListener(@Nullable Function1<? super LibraryInfo, Unit> function1) {
        this.libraryRemoveListener = function1;
    }

    @Nullable
    public final Function1<LibraryInfo, DependencyState> getDependencyStateFunction() {
        return this.dependencyStateFunction;
    }

    public final void setDependencyStateFunction(@Nullable Function1<? super LibraryInfo, ? extends DependencyState> function1) {
        this.dependencyStateFunction = function1;
    }

    @Nullable
    public final Function1<LibraryInfo, Boolean> getLibraryRemovablePredicate() {
        return this.libraryRemovablePredicate;
    }

    public final void setLibraryRemovablePredicate(@Nullable Function1<? super LibraryInfo, Boolean> function1) {
        this.libraryRemovablePredicate = function1;
    }

    public final void update(@NotNull Collection<? extends LibraryInfo> libraries) {
        Intrinsics.checkNotNullParameter(libraries, (String)"libraries");
        this.scrollablePanel.removeAll();
        for (LibraryInfo libraryInfo : libraries) {
            boolean libraryCanBeRemoved;
            DependencyState state;
            if (libraryInfo.isRequired()) continue;
            BorderLayoutPanel dependencyPanel = new BorderLayoutPanel();
            dependencyPanel.setBackground(UIUtil.getListBackground());
            JLabel dependencyLabel = new JLabel(libraryInfo.getTitle());
            dependencyLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)4, (int)0));
            Function1<? super LibraryInfo, ? extends DependencyState> dependencyStateFunction = this.dependencyStateFunction;
            if (dependencyStateFunction != null && (state = (DependencyState)dependencyStateFunction.invoke((Object)libraryInfo)) instanceof DependencyUnavailable) {
                dependencyLabel.setEnabled(false);
                dependencyLabel.setToolTipText(((DependencyUnavailable)state).getMessage());
            }
            dependencyPanel.addToCenter((Component)dependencyLabel);
            Function1<? super LibraryInfo, Boolean> function1 = this.libraryRemovablePredicate;
            boolean bl = libraryCanBeRemoved = !(function1 != null ? !((Boolean)function1.invoke((Object)libraryInfo)).booleanValue() : false);
            if (libraryCanBeRemoved) {
                InplaceButton removeButton = new InplaceButton(new IconButton(JavaStartersBundle.message("button.tooltip.remove", new Object[0]), AllIcons.Actions.Close, AllIcons.Actions.CloseHovered), arg_0 -> SelectedLibrariesPanel.update$lambda$0(this, libraryInfo, arg_0));
                removeButton.setTransform(0, -JBUIScale.scale((int)RangesKt.coerceAtLeast((int)2, (int)(dependencyLabel.getFont().getSize() / 15))));
                removeButton.setCursor(Cursor.getPredefinedCursor(12));
                dependencyPanel.addToRight((Component)removeButton);
            }
            this.scrollablePanel.add((Component)dependencyPanel);
        }
        this.scrollPane.setVisible(this.scrollablePanel.getComponentCount() > 0);
        this.scrollablePanel.revalidate();
        this.scrollPane.revalidate();
        this.revalidate();
    }

    private static final void update$lambda$0(SelectedLibrariesPanel this$0, LibraryInfo $library, ActionEvent it) {
        block0: {
            Function1<? super LibraryInfo, Unit> function1 = this$0.libraryRemoveListener;
            if (function1 == null) break block0;
            function1.invoke((Object)$library);
        }
    }
}

