/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.impl.FrameworkDetectionContextBase;
import com.intellij.ide.util.importProject.FacetBasedDetectedFrameworkDescriptionInWizard;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworkDetectionInWizardContext
extends FrameworkDetectionContextBase {
    protected FrameworkDetectionInWizardContext() {
    }

    @NotNull
    public <F extends Facet, C extends FacetConfiguration> List<? extends DetectedFrameworkDescription> createDetectedFacetDescriptions(@NotNull FacetBasedFrameworkDetector<F, C> detector, @NotNull Collection<? extends VirtualFile> files) {
        if (detector == null) {
            FrameworkDetectionInWizardContext.$$$reportNull$$$0(0);
        }
        if (files == null) {
            FrameworkDetectionInWizardContext.$$$reportNull$$$0(1);
        }
        List<ModuleDescriptor> descriptors = this.getModuleDescriptors();
        MultiMap filesByModule = new MultiMap();
        for (VirtualFile virtualFile : files) {
            File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
            ModuleDescriptor descriptor = FrameworkDetectionInWizardContext.findDescriptorByFile(descriptors, ioFile);
            if (descriptor == null) continue;
            filesByModule.putValue((Object)descriptor, (Object)virtualFile);
        }
        ArrayList<FacetBasedDetectedFrameworkDescriptionInWizard<F, FacetConfiguration>> result = new ArrayList<FacetBasedDetectedFrameworkDescriptionInWizard<F, FacetConfiguration>>();
        FacetType facetType = detector.getFacetType();
        for (ModuleDescriptor module : filesByModule.keySet()) {
            if (!facetType.isSuitableModuleType(module.getModuleType())) continue;
            List pairs = detector.createConfigurations(filesByModule.get((Object)module), Collections.emptyList());
            for (Pair pair : pairs) {
                result.add(new FacetBasedDetectedFrameworkDescriptionInWizard<F, FacetConfiguration>(module, detector, (FacetConfiguration)pair.getFirst(), new HashSet((Collection)pair.getSecond())));
            }
        }
        ArrayList<FacetBasedDetectedFrameworkDescriptionInWizard<F, FacetConfiguration>> arrayList = result;
        if (arrayList == null) {
            FrameworkDetectionInWizardContext.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    protected abstract List<ModuleDescriptor> getModuleDescriptors();

    @Nullable
    private static ModuleDescriptor findDescriptorByFile(List<? extends ModuleDescriptor> descriptors, File file) {
        ModuleDescriptor result = null;
        File nearestRoot = null;
        for (ModuleDescriptor moduleDescriptor : descriptors) {
            for (File root : moduleDescriptor.getContentRoots()) {
                if (!FileUtil.isAncestor((File)root, (File)file, (boolean)false) || nearestRoot != null && !FileUtil.isAncestor(nearestRoot, (File)root, (boolean)true)) continue;
                result = moduleDescriptor;
                nearestRoot = root;
            }
        }
        return result;
    }

    public VirtualFile getBaseDir() {
        String path = this.getContentPath();
        return path != null ? LocalFileSystem.getInstance().refreshAndFindFileByPath(path) : null;
    }

    @Nullable
    protected abstract String getContentPath();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/importProject/FrameworkDetectionInWizardContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/importProject/FrameworkDetectionInWizardContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDetectedFacetDescriptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDetectedFacetDescriptions";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

