/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.util.importProject.Dependency;
import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.importProject.ProjectLayoutPanel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

class ModulesLayoutPanel
extends ProjectLayoutPanel<ModuleDescriptor> {
    private final LibraryFilter myLibrariesFilter;

    ModulesLayoutPanel(ModuleInsight insight, LibraryFilter libFilter) {
        super(insight);
        this.myLibrariesFilter = libFilter;
    }

    @Override
    protected String getElementName(ModuleDescriptor entry) {
        return entry.getName();
    }

    @Override
    protected void setElementName(ModuleDescriptor entry, String name) {
        entry.setName(name);
    }

    @Override
    protected @Unmodifiable List<ModuleDescriptor> getEntries() {
        List<ModuleDescriptor> modules = this.getInsight().getSuggestedModules();
        return modules != null ? modules : Collections.emptyList();
    }

    @Override
    protected Collection<Dependency> getDependencies(ModuleDescriptor entry) {
        ArrayList<Dependency> deps = new ArrayList<Dependency>(entry.getDependencies());
        Collection<LibraryDescriptor> libDependencies = this.getInsight().getLibraryDependencies(entry);
        for (LibraryDescriptor libDependency : libDependencies) {
            if (!this.myLibrariesFilter.isLibraryChosen(libDependency)) continue;
            deps.add(libDependency);
        }
        return deps;
    }

    @Override
    @Nullable
    protected ModuleDescriptor merge(List<? extends ModuleDescriptor> entries) {
        ModuleInsight insight = this.getInsight();
        ModuleDescriptor mainDescr = null;
        for (ModuleDescriptor moduleDescriptor : entries) {
            if (mainDescr == null) {
                mainDescr = moduleDescriptor;
                continue;
            }
            insight.merge(mainDescr, moduleDescriptor);
        }
        return mainDescr;
    }

    @Override
    protected ModuleDescriptor split(ModuleDescriptor entry, String newEntryName, Collection<? extends File> extractedData) {
        return this.getInsight().splitModule(entry, newEntryName, extractedData);
    }

    @Override
    protected Collection<File> getContent(ModuleDescriptor entry) {
        return entry.getContentRoots();
    }

    @Override
    protected String getEntriesChooserTitle() {
        return JavaUiBundle.message("title.modules", new Object[0]);
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Title)
    protected String getDependenciesTitle() {
        return JavaUiBundle.message("title.module.dependencies", new Object[0]);
    }

    @Override
    @NotNull
    protected Set<String> getExistingNames() {
        Set<String> set = this.getInsight().getExistingModuleNames();
        if (set == null) {
            ModulesLayoutPanel.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    protected String getElementTypeNamePlural() {
        return JavaUiBundle.message("title.modules", new Object[0]);
    }

    @Override
    protected ProjectLayoutPanel.ElementType getElementType() {
        return ProjectLayoutPanel.ElementType.MODULE;
    }

    @Override
    protected String getSplitDialogChooseFilesPrompt() {
        return JavaUiBundle.message("label.select.content.roots.to.extract.to.new.module", new Object[0]);
    }

    @Override
    protected String getNameAlreadyUsedMessage(String name) {
        return JavaUiBundle.message("error.module.with.name.already.exists", name);
    }

    @Override
    protected String getStepDescriptionText() {
        return JavaUiBundle.message("module.structure.step.description", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/importProject/ModulesLayoutPanel", "getExistingNames"));
    }

    public static interface LibraryFilter {
        public boolean isLibraryChosen(LibraryDescriptor var1);
    }
}

