/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.MultiStateElementsChooser;
import com.intellij.ide.util.importProject.Dependency;
import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

abstract class ProjectLayoutPanel<T extends Dependency>
extends JPanel {
    private final ElementsChooser<T> myEntriesChooser;
    private final JList<Dependency> myDependenciesList;
    private final ModuleInsight myInsight;
    private final Comparator<Dependency> COMPARATOR = Comparator.comparingInt(Dependency::getWeight).thenComparing(dependency -> ProjectLayoutPanel.getElementText(dependency), String.CASE_INSENSITIVE_ORDER);

    ProjectLayoutPanel(ModuleInsight insight) {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.myInsight = insight;
        this.myEntriesChooser = new ElementsChooser<T>(true){

            public String getItemText(@NotNull T element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return ProjectLayoutPanel.getElementText(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/util/importProject/ProjectLayoutPanel$1", "getItemText"));
            }
        };
        this.myDependenciesList = this.createList();
        Splitter splitter = new Splitter(false);
        JPanel entriesPanel = new JPanel(new BorderLayout());
        entriesPanel.add((Component)this.myEntriesChooser, "Center");
        entriesPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)this.getElementTypeNamePlural(), (boolean)false));
        splitter.setFirstComponent((JComponent)entriesPanel);
        JScrollPane depsPane = ScrollPaneFactory.createScrollPane(this.myDependenciesList);
        JPanel depsPanel = new JPanel(new BorderLayout());
        depsPanel.add((Component)depsPane, "Center");
        depsPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)this.getDependenciesTitle(), (boolean)false));
        splitter.setSecondComponent((JComponent)depsPanel);
        DefaultActionGroup toolbarActions = this.createEntriesToolbarActions();
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ProjectLayoutPanel.Entries", (ActionGroup)toolbarActions, true);
        toolbar.setTargetComponent(this.myEntriesChooser);
        JPanel groupPanel = new JPanel(new BorderLayout());
        groupPanel.add((Component)toolbar.getComponent(), "North");
        groupPanel.add((Component)splitter, "Center");
        groupPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        MultiLineLabel description = new MultiLineLabel(this.getStepDescriptionText());
        this.add((Component)description, "North");
        this.add((Component)groupPanel, "Center");
        this.myEntriesChooser.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                List entries = ProjectLayoutPanel.this.getSelectedEntries();
                Collection<Dependency> deps = ProjectLayoutPanel.this.getDependencies(entries);
                DefaultListModel depsModel = (DefaultListModel)ProjectLayoutPanel.this.myDependenciesList.getModel();
                depsModel.clear();
                ArrayList<Dependency> depsList = new ArrayList<Dependency>(deps);
                depsList.sort(ProjectLayoutPanel.this.COMPARATOR);
                for (Dependency dep : depsList) {
                    depsModel.addElement(dep);
                }
            }
        });
    }

    private DefaultActionGroup createEntriesToolbarActions() {
        DefaultActionGroup entriesActions = new DefaultActionGroup();
        RenameAction rename = new RenameAction();
        rename.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(117, 64)), this);
        entriesActions.add((AnAction)rename);
        MergeAction merge = new MergeAction();
        merge.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(114, 0)), this);
        entriesActions.add((AnAction)merge);
        SplitAction split = new SplitAction();
        split.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(115, 0)), this);
        entriesActions.add((AnAction)split);
        return entriesActions;
    }

    public final ModuleInsight getInsight() {
        return this.myInsight;
    }

    private JList<Dependency> createList() {
        JBList list2 = new JBList(new DefaultListModel());
        list2.getSelectionModel().setSelectionMode(2);
        list2.setCellRenderer(new MyListCellRenderer());
        return list2;
    }

    public final Collection<Dependency> getDependencies(List<? extends T> entries) {
        HashSet<Dependency> deps = new HashSet<Dependency>();
        for (Dependency et : entries) {
            deps.addAll(this.getDependencies(et));
        }
        return deps;
    }

    @NotNull
    public List<T> getSelectedEntries() {
        List list2 = this.myEntriesChooser.getSelectedElements();
        if (list2 == null) {
            ProjectLayoutPanel.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @NotNull
    public List<T> getChosenEntries() {
        List list2 = this.myEntriesChooser.getMarkedElements();
        if (list2 == null) {
            ProjectLayoutPanel.$$$reportNull$$$0(1);
        }
        return list2;
    }

    public void rebuild() {
        this.myEntriesChooser.clear();
        List<T> entries = this.getEntries();
        for (Dependency entry : ContainerUtil.sorted(entries, this.COMPARATOR)) {
            this.myEntriesChooser.addElement((Object)entry, true, (MultiStateElementsChooser.ElementProperties)new EntryProperties(this, entry));
        }
        if (this.myEntriesChooser.getElementCount() > 0) {
            this.myEntriesChooser.selectElements(Collections.singleton((Dependency)this.myEntriesChooser.getElementAt(0)));
        }
    }

    @Nullable
    protected Icon getElementIcon(Object element) {
        if (element instanceof ModuleDescriptor) {
            return ((ModuleDescriptor)element).getModuleType().getIcon();
        }
        if (element instanceof LibraryDescriptor) {
            return PlatformIcons.LIBRARY_ICON;
        }
        if (element instanceof File) {
            File file = (File)element;
            return file.isDirectory() ? PlatformIcons.FOLDER_ICON : PlatformIcons.JAR_ICON;
        }
        return null;
    }

    @NlsSafe
    protected static String getElementText(Object element) {
        if (element instanceof LibraryDescriptor) {
            return ProjectLayoutPanel.getElementTextFromLibraryDescriptor((LibraryDescriptor)element);
        }
        if (element instanceof File) {
            return ProjectLayoutPanel.getElementTextFromFile((File)element);
        }
        if (element instanceof ModuleDescriptor) {
            Collection<? extends DetectedProjectRoot> sourceRoots;
            ModuleDescriptor moduleDescriptor = (ModuleDescriptor)element;
            StringBuilder builder = new StringBuilder(moduleDescriptor.getName());
            Set<File> contents = moduleDescriptor.getContentRoots();
            int rootCount = contents.size();
            if (rootCount > 0) {
                builder.append(" (");
                builder.append(contents.iterator().next().getPath());
                if (rootCount > 1) {
                    builder.append("...");
                }
                builder.append(")");
            }
            if (!(sourceRoots = moduleDescriptor.getSourceRoots()).isEmpty()) {
                StringJoiner joiner = new StringJoiner(",", " [", "]");
                for (DetectedProjectRoot detectedProjectRoot : sourceRoots) {
                    joiner.add(detectedProjectRoot.getDirectory().getName());
                }
                builder.append(joiner);
            }
            return builder.toString();
        }
        return "";
    }

    @NotNull
    @NlsSafe
    private static String getElementTextFromFile(File element) {
        File parentFile = element.getParentFile();
        if (parentFile == null) {
            String string = element.getName();
            if (string == null) {
                ProjectLayoutPanel.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = element.getName() + " (" + parentFile.getPath() + ")";
        if (string == null) {
            ProjectLayoutPanel.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    private static String getElementTextFromLibraryDescriptor(LibraryDescriptor element) {
        Collection<File> jars = element.getJars();
        if (jars.size() != 1) {
            String string = element.getName();
            if (string == null) {
                ProjectLayoutPanel.$$$reportNull$$$0(4);
            }
            return string;
        }
        File parentFile = jars.iterator().next().getParentFile();
        String string = element.getName() + " (" + parentFile.getPath() + ")";
        if (string == null) {
            ProjectLayoutPanel.$$$reportNull$$$0(5);
        }
        return string;
    }

    protected abstract @Unmodifiable List<T> getEntries();

    protected abstract @Unmodifiable Collection<? extends Dependency> getDependencies(T var1);

    @Nullable
    protected abstract T merge(List<? extends T> var1);

    @Nullable
    protected abstract T split(T var1, String var2, Collection<? extends File> var3);

    protected abstract Collection<File> getContent(T var1);

    @Nls
    protected abstract String getElementName(T var1);

    protected abstract void setElementName(T var1, String var2);

    @NlsContexts.Label
    protected abstract String getSplitDialogChooseFilesPrompt();

    @NlsContexts.DialogMessage
    protected abstract String getNameAlreadyUsedMessage(String var1);

    @NlsContexts.DialogMessage
    protected abstract String getStepDescriptionText();

    @NlsContexts.TabTitle
    protected abstract String getEntriesChooserTitle();

    @NlsContexts.BorderTitle
    protected abstract String getDependenciesTitle();

    @NotNull
    protected abstract Set<String> getExistingNames();

    @NlsContexts.BorderTitle
    protected abstract String getElementTypeNamePlural();

    protected abstract ElementType getElementType();

    private boolean isNameAlreadyUsed(String entryName) {
        HashSet itemsToIgnore = new HashSet(this.myEntriesChooser.getSelectedElements());
        for (Dependency entry : this.getEntries()) {
            if (itemsToIgnore.contains(entry) || !entryName.equals(this.getElementName(entry))) continue;
            return true;
        }
        return this.getExistingNames().contains(entryName);
    }

    @NotNull
    private InputValidator getValidator() {
        return new InputValidator(){

            public boolean checkInput(String inputString) {
                return true;
            }

            public boolean canClose(String inputString) {
                if (ProjectLayoutPanel.this.isNameAlreadyUsed(inputString.trim())) {
                    Messages.showErrorDialog((String)ProjectLayoutPanel.this.getNameAlreadyUsedMessage(inputString), (String)"");
                    return false;
                }
                return true;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/util/importProject/ProjectLayoutPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEntries";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChosenEntries";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementTextFromFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementTextFromLibraryDescriptor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private final class RenameAction
    extends AnAction {
        private RenameAction() {
            super(CommonBundle.messagePointer((String)"action.text.rename", (Object[])new Object[0]), () -> "", IconUtil.getEditIcon());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List elements;
            if (e == null) {
                RenameAction.$$$reportNull$$$0(0);
            }
            if ((elements = ProjectLayoutPanel.this.myEntriesChooser.getSelectedElements()).size() == 1) {
                Dependency element = (Dependency)elements.get(0);
                String newName = Messages.showInputDialog((Component)ProjectLayoutPanel.this, (String)JavaUiBundle.message("label.new.name.for.0.1", ProjectLayoutPanel.this.getElementType().id, ProjectLayoutPanel.this.getElementName(element)), (String)JavaUiBundle.message("dialog.title.rename.module.or.library.0", ProjectLayoutPanel.this.getElementType().id), (Icon)Messages.getQuestionIcon(), (String)ProjectLayoutPanel.this.getElementName(element), (InputValidator)ProjectLayoutPanel.this.getValidator());
                if (newName != null) {
                    ProjectLayoutPanel.this.setElementName(element, newName);
                    ProjectLayoutPanel.this.myEntriesChooser.sort(ProjectLayoutPanel.this.COMPARATOR);
                    ProjectLayoutPanel.this.myEntriesChooser.selectElements(Collections.singleton(element));
                }
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RenameAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(ProjectLayoutPanel.this.myEntriesChooser.getSelectedElements().size() == 1);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                RenameAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/importProject/ProjectLayoutPanel$RenameAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/importProject/ProjectLayoutPanel$RenameAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class MergeAction
    extends AnAction {
        private MergeAction() {
            super(CommonBundle.messagePointer((String)"action.text.merge", (Object[])new Object[0]), () -> "", AllIcons.Vcs.Merge);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String newName;
            List elements;
            if (e == null) {
                MergeAction.$$$reportNull$$$0(0);
            }
            if ((elements = ProjectLayoutPanel.this.myEntriesChooser.getSelectedElements()).size() > 1 && (newName = Messages.showInputDialog((Component)ProjectLayoutPanel.this, (String)JavaUiBundle.message("label.enter.new.name.for.merge.result", new Object[0]), (String)JavaUiBundle.message("dialog.title.merge.module.or.library", new Object[0]), (Icon)Messages.getQuestionIcon(), (String)ProjectLayoutPanel.this.getElementName((Dependency)elements.get(0)), (InputValidator)ProjectLayoutPanel.this.getValidator())) != null) {
                Object merged = ProjectLayoutPanel.this.merge(elements);
                ProjectLayoutPanel.this.setElementName(merged, newName);
                for (Dependency element : elements) {
                    ProjectLayoutPanel.this.myEntriesChooser.removeElement((Object)element);
                }
                ProjectLayoutPanel.this.myEntriesChooser.addElement(merged, true, (MultiStateElementsChooser.ElementProperties)new EntryProperties(ProjectLayoutPanel.this, merged));
                ProjectLayoutPanel.this.myEntriesChooser.sort(ProjectLayoutPanel.this.COMPARATOR);
                ProjectLayoutPanel.this.myEntriesChooser.selectElements(Collections.singleton(merged));
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MergeAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(ProjectLayoutPanel.this.myEntriesChooser.getSelectedElements().size() > 1);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MergeAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/importProject/ProjectLayoutPanel$MergeAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/importProject/ProjectLayoutPanel$MergeAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class SplitAction
    extends AnAction {
        private SplitAction() {
            super(CommonBundle.messagePointer((String)"action.text.split", (Object[])new Object[0]), () -> "", AllIcons.Modules.Split);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Collection<File> chosenFiles;
            String newName;
            Dependency extracted;
            Dependency entry;
            Collection<File> files;
            SplitDialog dialog;
            List elements;
            if (e == null) {
                SplitAction.$$$reportNull$$$0(0);
            }
            if ((elements = ProjectLayoutPanel.this.myEntriesChooser.getSelectedElements()).size() == 1 && (dialog = new SplitDialog(files = ProjectLayoutPanel.this.getContent(entry = (Dependency)elements.get(0)))).showAndGet() && (extracted = ProjectLayoutPanel.this.split(entry, newName = dialog.getName(), chosenFiles = dialog.getChosenFiles())) != null) {
                if (!ProjectLayoutPanel.this.getEntries().contains(entry)) {
                    ProjectLayoutPanel.this.myEntriesChooser.removeElement((Object)entry);
                }
                ProjectLayoutPanel.this.myEntriesChooser.addElement((Object)extracted, true, (MultiStateElementsChooser.ElementProperties)new EntryProperties(ProjectLayoutPanel.this, extracted));
                ProjectLayoutPanel.this.myEntriesChooser.sort(ProjectLayoutPanel.this.COMPARATOR);
                ProjectLayoutPanel.this.myEntriesChooser.selectElements(Collections.singleton(extracted));
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SplitAction.$$$reportNull$$$0(1);
            }
            List elements = ProjectLayoutPanel.this.myEntriesChooser.getSelectedElements();
            e.getPresentation().setEnabled(elements.size() == 1 && ProjectLayoutPanel.this.getContent((Dependency)elements.get(0)).size() > 1);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                SplitAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/importProject/ProjectLayoutPanel$SplitAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/importProject/ProjectLayoutPanel$SplitAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list2, value, index, isSelected, cellHasFocus);
            this.setText(ProjectLayoutPanel.getElementText(value));
            this.setIcon(ProjectLayoutPanel.this.getElementIcon(value));
            return comp;
        }
    }

    private static class EntryProperties
    implements MultiStateElementsChooser.ElementProperties {
        private final T myEntry;
        final /* synthetic */ ProjectLayoutPanel this$0;

        EntryProperties(T entry) {
            this.this$0 = var1_1;
            this.myEntry = entry;
        }

        public Icon getIcon() {
            return this.this$0.getElementIcon(this.myEntry);
        }
    }

    private final class SplitDialog
    extends DialogWrapper {
        final JTextField myNameField;
        final ElementsChooser<File> myChooser;

        private SplitDialog(Collection<File> files) {
            super(ProjectLayoutPanel.this.myEntriesChooser, true);
            this.setTitle(JavaUiBundle.message("dialog.title.split.module.or.library.0", ProjectLayoutPanel.this.getElementType().id));
            this.myNameField = new JTextField();
            this.myChooser = new ElementsChooser<File>(true){

                protected String getItemText(@NotNull File value) {
                    if (value == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return ProjectLayoutPanel.getElementText(value);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ide/util/importProject/ProjectLayoutPanel$SplitDialog$1", "getItemText"));
                }
            };
            for (final File file : files) {
                this.myChooser.addElement((Object)file, false, new MultiStateElementsChooser.ElementProperties(){

                    public Icon getIcon() {
                        return ProjectLayoutPanel.this.getElementIcon(file);
                    }
                });
            }
            this.myChooser.selectElements((Collection)ContainerUtil.createMaybeSingletonList((Object)((File)ContainerUtil.getFirstItem(files))));
            this.myChooser.addElementsMarkListener((ElementsChooser.ElementsMarkListener)new ElementsChooser.ElementsMarkListener<File>(){

                public void elementMarkChanged(File element, boolean isMarked) {
                    SplitDialog.this.updateOkButton();
                }
            });
            this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    SplitDialog.this.updateOkButton();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/importProject/ProjectLayoutPanel$SplitDialog$4", "textChanged"));
                }
            });
            this.init();
            this.updateOkButton();
        }

        private void updateOkButton() {
            this.setOKActionEnabled(!this.getName().isEmpty() && !this.getChosenFiles().isEmpty());
        }

        protected void doOKAction() {
            String name = this.getName();
            if (ProjectLayoutPanel.this.isNameAlreadyUsed(name)) {
                Messages.showErrorDialog((String)ProjectLayoutPanel.this.getNameAlreadyUsedMessage(name), (String)"");
                return;
            }
            super.doOKAction();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            FormBuilder builder = FormBuilder.createFormBuilder().setVertical(true);
            builder.addLabeledComponent(JavaUiBundle.message("label.project.layout.panel.name", new Object[0]), (JComponent)this.myNameField);
            builder.addLabeledComponent(ProjectLayoutPanel.this.getSplitDialogChooseFilesPrompt(), this.myChooser);
            this.myChooser.setPreferredSize((Dimension)JBUI.size((int)450, (int)300));
            return builder.getPanel();
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myNameField;
        }

        public String getName() {
            return this.myNameField.getText().trim();
        }

        public Collection<File> getChosenFiles() {
            return this.myChooser.getMarkedElements();
        }
    }

    static enum ElementType {
        LIBRARY(0),
        MODULE(1);

        private final int id;

        private ElementType(int id) {
            this.id = id;
        }
    }
}

