/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.core.CoreBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.Path;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NotNull;

public final class NamePathComponent
extends JPanel {
    private static final Logger LOG = Logger.getInstance(NamePathComponent.class);
    private final JTextField myTfName = new JTextField();
    private final JTextField myTfPath;
    private final JLabel myNameLabel;
    private final FieldPanel myPathPanel;
    private boolean myIsNameChangedByUser = false;
    private boolean myIsPathChangedByUser = false;
    private boolean myIsPathNameSyncEnabled = true;
    private boolean myIsNamePathSyncEnabled = true;
    private boolean myShouldBeAbsolute;

    public NamePathComponent(@NlsContexts.Label String nameLabelText, @NlsContexts.Label String pathLabelText, @NlsContexts.DialogTitle String pathChooserTitle, @NlsContexts.Label String pathChooserDescription) {
        this(nameLabelText, pathLabelText, pathChooserTitle, pathChooserDescription, true);
    }

    public NamePathComponent(@NlsContexts.Label String nameLabelText, @NlsContexts.Label String pathLabelText, @NlsContexts.DialogTitle String pathChooserTitle, @NlsContexts.Label String pathChooserDescription, boolean hideIgnored) {
        this(nameLabelText, pathLabelText, pathChooserTitle, pathChooserDescription, hideIgnored, true);
    }

    public NamePathComponent(@NlsContexts.Label String nameLabelText, @NlsContexts.Label String pathLabelText, @NlsContexts.DialogTitle String pathChooserTitle, @NlsContexts.Label String pathChooserDescription, boolean hideIgnored, boolean bold) {
        super(new GridBagLayout());
        this.myTfName.setDocument(new NameFieldDocument());
        this.myTfName.setPreferredSize(new Dimension(200, this.myTfName.getPreferredSize().height));
        this.myTfPath = new JTextField();
        this.myTfPath.setDocument(new PathFieldDocument());
        this.myTfPath.setPreferredSize(new Dimension(200, this.myTfPath.getPreferredSize().height));
        this.myNameLabel = new JLabel(nameLabelText);
        if (bold) {
            this.myNameLabel.setFont(StartupUiUtil.getLabelFont().deriveFont(1));
        }
        this.myNameLabel.setLabelFor(this.myTfName);
        FileChooserDescriptor chooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(pathChooserTitle).withDescription(pathChooserDescription).withHideIgnored(hideIgnored);
        BrowseFilesListener browseButtonActionListener = new BrowseFilesListener(this.myTfPath, chooserDescriptor){

            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                NamePathComponent.this.myIsPathChangedByUser = true;
            }
        };
        this.myPathPanel = new FieldPanel(this.myTfPath, null, null, (ActionListener)browseButtonActionListener, null);
        JLabel pathLabel = new JLabel(pathLabelText);
        if (bold) {
            pathLabel.setFont(StartupUiUtil.getLabelFont().deriveFont(1));
        }
        pathLabel.setLabelFor(this.myTfPath);
        this.add((Component)this.myNameLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insets((int)0, (int)0, (int)5, (int)4), 0, 0));
        this.add((Component)this.myTfName, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insetsBottom((int)5), 0, 0));
        this.add((Component)pathLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insets((int)0, (int)0, (int)5, (int)4), 0, 0));
        this.add((Component)this.myPathPanel, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insetsBottom((int)5), 0, 0));
    }

    public static NamePathComponent initNamePathComponent(WizardContext context) {
        NamePathComponent component = new NamePathComponent(IdeBundle.message((String)"label.project.name", (Object[])new Object[0]), IdeBundle.message((String)"label.project.files.location", (Object[])new Object[0]), JavaUiBundle.message("title.select.project.file.directory", IdeCoreBundle.message((String)"project.new.wizard.project.identification", (Object[])new Object[0])), JavaUiBundle.message("description.select.project.file.directory", StringUtil.capitalize((String)IdeCoreBundle.message((String)"project.new.wizard.project.identification", (Object[])new Object[0]))), true, false);
        String baseDir = context.getProjectFileDirectory();
        String projectName = context.getProjectName();
        String initialProjectName = projectName != null ? projectName : ProjectWizardUtil.findNonExistingFileName(baseDir, "untitled", "");
        component.setPath((String)(projectName == null ? baseDir + File.separator + initialProjectName : baseDir));
        component.setNameValue(initialProjectName);
        component.getNameComponent().select(0, initialProjectName.length());
        return component;
    }

    public boolean validateNameAndPath(WizardContext context, boolean defaultFormat) throws ConfigurationException {
        Object fileName;
        File projectFile;
        String name = this.getNameValue();
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            ApplicationNamesInfo info = ApplicationNamesInfo.getInstance();
            throw new ConfigurationException(JavaUiBundle.message("prompt.new.project.file.name", info.getFullProductName(), context.getPresentationName()));
        }
        String projectDirectoryPath = this.getPath();
        if (StringUtil.isEmptyOrSpaces((String)projectDirectoryPath)) {
            throw new ConfigurationException(JavaUiBundle.message("prompt.enter.project.file.location", context.getPresentationName()));
        }
        if (this.myShouldBeAbsolute && !new File(projectDirectoryPath).isAbsolute()) {
            throw new ConfigurationException(JavaUiBundle.message("file.location.should.be.absolute", StringUtil.capitalize((String)context.getPresentationName())));
        }
        boolean shouldPromptCreation = this.isPathChangedByUser();
        String message = JavaUiBundle.message("directory.project.file.directory", context.getPresentationName());
        if (!ProjectWizardUtil.createDirectoryIfNotExists(message, projectDirectoryPath, shouldPromptCreation)) {
            return false;
        }
        File projectDirectory = new File(projectDirectoryPath);
        if (projectDirectory.exists() && !projectDirectory.canWrite()) {
            throw new ConfigurationException(JavaUiBundle.message("project.directory.is.not.writable", projectDirectoryPath));
        }
        for (Project p : ProjectManager.getInstance().getOpenProjects()) {
            if (!ProjectUtil.isSameProject((Path)projectDirectory.toPath(), (Project)p)) continue;
            throw new ConfigurationException(JavaUiBundle.message("project.directory.is.already.taken", projectDirectoryPath, p.getName()));
        }
        if (projectDirectory.exists() && !projectDirectory.isDirectory()) {
            LOG.warn(String.format("Project '%s' directory should be a directory", projectDirectoryPath));
        }
        boolean shouldContinue = true;
        if (!ApplicationManager.getApplication().isUnitTestMode() && (projectFile = new File(projectDirectory, (String)(fileName = defaultFormat ? name + ".ipr" : ".idea"))).exists()) {
            message = CoreBundle.message((String)"prompt.overwrite.project.file", (Object[])new Object[]{projectFile.getAbsolutePath(), context.getPresentationName()});
            shouldContinue = MessageDialogBuilder.yesNo((String)IdeBundle.message((String)"title.file.already.exists", (Object[])new Object[0]), (String)message).show() == 0;
        }
        return shouldContinue;
    }

    public String getNameValue() {
        return this.myTfName.getText().trim();
    }

    public void setNameValue(String name) {
        boolean isNameChangedByUser = this.myIsNameChangedByUser;
        this.myIsNamePathSyncEnabled = false;
        try {
            this.myTfName.setText(name);
        }
        finally {
            this.myIsNameChangedByUser = isNameChangedByUser;
            this.myIsNamePathSyncEnabled = true;
        }
    }

    public String getPath() {
        String text = this.myTfPath.getText();
        return UiUtils.getCanonicalPath((String)text);
    }

    public void setPath(String path) {
        boolean isPathChangedByUser = this.myIsPathChangedByUser;
        this.myIsPathNameSyncEnabled = false;
        try {
            this.myTfPath.setText(UiUtils.getPresentablePath((String)path));
        }
        finally {
            this.myIsPathChangedByUser = isPathChangedByUser;
            this.myIsPathNameSyncEnabled = true;
        }
    }

    @NotNull
    public JTextField getNameComponent() {
        JTextField jTextField = this.myTfName;
        if (jTextField == null) {
            NamePathComponent.$$$reportNull$$$0(0);
        }
        return jTextField;
    }

    public void setNameComponentVisible(boolean visible) {
        this.myTfName.setVisible(visible);
        this.myNameLabel.setVisible(visible);
    }

    @NotNull
    public JTextField getPathComponent() {
        JTextField jTextField = this.myTfPath;
        if (jTextField == null) {
            NamePathComponent.$$$reportNull$$$0(1);
        }
        return jTextField;
    }

    @NotNull
    public FieldPanel getPathPanel() {
        FieldPanel fieldPanel = this.myPathPanel;
        if (fieldPanel == null) {
            NamePathComponent.$$$reportNull$$$0(2);
        }
        return fieldPanel;
    }

    public boolean isNameChangedByUser() {
        return this.myIsNameChangedByUser;
    }

    public boolean isPathChangedByUser() {
        return this.myIsPathChangedByUser;
    }

    public void addChangeListener(final Runnable callback) {
        DocumentAdapter adapter = new DocumentAdapter(this){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                callback.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/util/projectWizard/NamePathComponent$2", "textChanged"));
            }
        };
        this.myTfName.getDocument().addDocumentListener((DocumentListener)adapter);
        this.myTfPath.getDocument().addDocumentListener((DocumentListener)adapter);
    }

    public void setShouldBeAbsolute(boolean shouldBeAbsolute) {
        this.myShouldBeAbsolute = shouldBeAbsolute;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/util/projectWizard/NamePathComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathPanel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class NameFieldDocument
    extends PlainDocument {
        NameFieldDocument() {
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){

                public void textChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    NamePathComponent.this.myIsNameChangedByUser = true;
                    NameFieldDocument.this.syncNameAndPath();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/util/projectWizard/NamePathComponent$NameFieldDocument$1", "textChanged"));
                }
            });
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            boolean ok = true;
            for (int idx = 0; idx < str.length() && ok; ++idx) {
                char ch = str.charAt(idx);
                ok = ch != File.separatorChar && ch != '\\' && ch != '/' && ch != '|' && ch != ':';
            }
            if (ok) {
                super.insertString(offs, str, a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void syncNameAndPath() {
            if (NamePathComponent.this.myIsNamePathSyncEnabled && !NamePathComponent.this.isPathChangedByUser()) {
                try {
                    NamePathComponent.this.myIsPathNameSyncEnabled = false;
                    String name = this.getText(0, this.getLength());
                    String path = NamePathComponent.this.myTfPath.getText().trim();
                    int lastSeparatorIndex = path.lastIndexOf(File.separator);
                    if (lastSeparatorIndex >= 0) {
                        NamePathComponent.this.setPath(path.substring(0, lastSeparatorIndex + 1) + name);
                    } else if (!path.isEmpty()) {
                        NamePathComponent.this.setPath(path + File.separatorChar + name);
                    }
                }
                catch (BadLocationException e) {
                    LOG.error((Throwable)e);
                }
                finally {
                    NamePathComponent.this.myIsPathNameSyncEnabled = true;
                }
            }
        }
    }

    private class PathFieldDocument
    extends PlainDocument {
        PathFieldDocument() {
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){

                public void textChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    NamePathComponent.this.myIsPathChangedByUser = true;
                    PathFieldDocument.this.syncPathAndName();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/util/projectWizard/NamePathComponent$PathFieldDocument$1", "textChanged"));
                }
            });
        }

        private void syncPathAndName() {
            if (NamePathComponent.this.myIsPathNameSyncEnabled && !NamePathComponent.this.isNameChangedByUser()) {
                try {
                    NamePathComponent.this.myIsNamePathSyncEnabled = false;
                    String path = this.getText(0, this.getLength());
                    int lastSeparatorIndex = path.lastIndexOf(File.separator);
                    if (lastSeparatorIndex >= 0 && lastSeparatorIndex + 1 < path.length()) {
                        NamePathComponent.this.setNameValue(path.substring(lastSeparatorIndex + 1));
                    }
                }
                catch (BadLocationException e) {
                    LOG.error((Throwable)e);
                }
                finally {
                    NamePathComponent.this.myIsNamePathSyncEnabled = true;
                }
            }
        }
    }
}

