/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.ProjectJdksConfigurable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;

public class ProjectJdkStep
extends ModuleWizardStep {
    private final WizardContext myContext;
    private ProjectDescriptor myProjectDescriptor;
    protected final ProjectJdksConfigurable myProjectJdksConfigurable;
    private final JComponent myJDKsComponent;

    public ProjectJdkStep(WizardContext context) {
        this.myContext = context;
        this.myProjectJdksConfigurable = new ProjectJdksConfigurable(ProjectManager.getInstance().getDefaultProject());
        this.myProjectJdksConfigurable.reset();
        this.myJDKsComponent = this.myProjectJdksConfigurable.createComponent();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myJDKsComponent;
    }

    public String getHelpId() {
        return "reference.dialogs.new.project.fromScratch.sdk";
    }

    public JComponent getComponent() {
        JLabel label = new JLabel(JavaUiBundle.message("prompt.please.select.project.jdk", new Object[0]));
        label.setUI((LabelUI)new MultiLineLabelUI());
        JPanel panel2 = new JPanel(new GridBagLayout()){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(-1, 200);
            }
        };
        panel2.add((Component)label, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBInsets.emptyInsets(), 0, 0));
        this.myJDKsComponent.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        panel2.add((Component)this.myJDKsComponent, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 1, (Insets)JBInsets.emptyInsets(), 0, 0));
        return panel2;
    }

    public void updateStep() {
        Sdk jdk = this.myContext.getProjectJdk();
        if (jdk == null) {
            JavaSdkVersion requiredJdkVersion;
            JavaSdkVersion javaSdkVersion = requiredJdkVersion = this.myProjectDescriptor != null ? this.myProjectDescriptor.getRequiredJdkVersion() : null;
            if (requiredJdkVersion != null) {
                this.myProjectJdksConfigurable.selectJdkVersion(requiredJdkVersion);
            }
        }
    }

    public void updateDataModel() {
        this.myContext.setProjectJdk(this.getJdk());
    }

    public Sdk getJdk() {
        return this.myProjectJdksConfigurable.getSelectedJdk();
    }

    public Icon getIcon() {
        return this.myContext.getStepIcon();
    }

    public boolean validate() throws ConfigurationException {
        int result;
        Sdk jdk = this.myProjectJdksConfigurable.getSelectedJdk();
        if (jdk == null && !ApplicationManager.getApplication().isUnitTestMode() && (result = Messages.showOkCancelDialog((String)JavaUiBundle.message("prompt.confirm.project.no.jdk", new Object[0]), (String)JavaUiBundle.message("title.no.jdk.specified", new Object[0]), (Icon)Messages.getWarningIcon())) != 0) {
            return false;
        }
        this.myProjectJdksConfigurable.apply();
        return true;
    }

    public String getName() {
        return "Project JDK";
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        this.myProjectJdksConfigurable.disposeUIResources();
    }

    public void setProjectDescriptor(ProjectDescriptor projectDescriptor) {
        this.myProjectDescriptor = projectDescriptor;
    }
}

