/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.ide.JavaUiBundle;
import com.intellij.jarFinder.AbstractAttachSourceProvider;
import com.intellij.jarFinder.MavenCentralSourceSearcher;
import com.intellij.jarFinder.SonatypeSourceSearcher;
import com.intellij.jarFinder.SourceSearchException;
import com.intellij.jarFinder.SourceSearcher;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.LibrarySourceRootDetectorUtil;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InternetAttachSourceProvider
extends AbstractAttachSourceProvider {
    private static final Logger LOG = Logger.getInstance(InternetAttachSourceProvider.class);
    private static final Pattern ARTIFACT_IDENTIFIER = Pattern.compile("[A-Za-z0-9.\\-_]+");

    private static MavenCoords parsePath(VirtualFile jar) {
        String version;
        String jarName = jar.getNameWithoutExtension();
        VirtualFile parent1 = jar.getParent();
        if (parent1 == null) {
            return null;
        }
        VirtualFile parent2 = parent1.getParent();
        if (parent2 == null) {
            return null;
        }
        String artifactId = parent2.getName();
        String jarPathName = artifactId + "-" + (version = parent1.getName());
        if (!jarPathName.equals(jarName)) {
            return null;
        }
        return new MavenCoords(artifactId, version);
    }

    private static MavenCoords parseName(VirtualFile jar) {
        String jarName = jar.getNameWithoutExtension();
        int index = jarName.lastIndexOf(45);
        if (index == -1) {
            return null;
        }
        String version = jarName.substring(index + 1);
        String artifactId = jarName.substring(0, index);
        return new MavenCoords(artifactId, version);
    }

    private static MavenCoords parse(VirtualFile jar) {
        MavenCoords result = InternetAttachSourceProvider.parsePath(jar);
        if (null != result) {
            return result;
        }
        return InternetAttachSourceProvider.parseName(jar);
    }

    @NotNull
    public Collection<? extends AttachSourcesProvider.AttachSourcesAction> getActions(@NotNull List<? extends LibraryOrderEntry> orderEntries, final @NotNull PsiFile psiFile) {
        VirtualFile jar;
        if (orderEntries == null) {
            InternetAttachSourceProvider.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            InternetAttachSourceProvider.$$$reportNull$$$0(1);
        }
        if ((jar = InternetAttachSourceProvider.getJarByPsiFile(psiFile)) == null) {
            List list2 = List.of();
            if (list2 == null) {
                InternetAttachSourceProvider.$$$reportNull$$$0(2);
            }
            return list2;
        }
        final String jarName = jar.getNameWithoutExtension();
        int index = jarName.lastIndexOf(45);
        if (index == -1) {
            List list3 = List.of();
            if (list3 == null) {
                InternetAttachSourceProvider.$$$reportNull$$$0(3);
            }
            return list3;
        }
        MavenCoords mavenCoords = InternetAttachSourceProvider.parse(jar);
        if (null == mavenCoords) {
            List list4 = List.of();
            if (list4 == null) {
                InternetAttachSourceProvider.$$$reportNull$$$0(4);
            }
            return list4;
        }
        final String artifactId = mavenCoords.artifactId();
        final String version = mavenCoords.version();
        if (!ARTIFACT_IDENTIFIER.matcher(version).matches() || !ARTIFACT_IDENTIFIER.matcher(artifactId).matches()) {
            List list5 = List.of();
            if (list5 == null) {
                InternetAttachSourceProvider.$$$reportNull$$$0(5);
            }
            return list5;
        }
        final HashSet libraries = new HashSet();
        for (LibraryOrderEntry libraryOrderEntry : orderEntries) {
            ContainerUtil.addIfNotNull(libraries, (Object)libraryOrderEntry.getLibrary());
        }
        if (libraries.isEmpty()) {
            List list6 = List.of();
            if (list6 == null) {
                InternetAttachSourceProvider.$$$reportNull$$$0(6);
            }
            return list6;
        }
        final String sourceFileName = jarName + "-sources.jar";
        for (Library library : libraries) {
            for (VirtualFile file : library.getFiles(OrderRootType.SOURCES)) {
                if (!file.getPath().contains(sourceFileName) || !InternetAttachSourceProvider.isRootInExistingFile(file)) continue;
                List list7 = List.of();
                if (list7 == null) {
                    InternetAttachSourceProvider.$$$reportNull$$$0(7);
                }
                return list7;
            }
        }
        final File file = InternetAttachSourceProvider.getLibrarySourceDir();
        final File sourceFile = new File(file, sourceFileName);
        if (sourceFile.exists()) {
            List<1> list8 = List.of(new AttachSourcesProvider.LightAttachSourcesAction(){

                @NlsContexts.LinkLabel
                @Nls(capitalization=Nls.Capitalization.Title)
                public String getName() {
                    return JavaUiBundle.message("internet.attach.source.provider.name", new Object[0]);
                }

                public String getBusyText() {
                    return this.getName();
                }

                @NotNull
                public ActionCallback perform(@NotNull List<? extends LibraryOrderEntry> orderEntriesContainingFile) {
                    if (orderEntriesContainingFile == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    InternetAttachSourceProvider.attachSourceJar(sourceFile, (Collection<? extends Library>)libraries);
                    ActionCallback actionCallback = ActionCallback.DONE;
                    if (actionCallback == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return actionCallback;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "orderEntriesContainingFile";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/jarFinder/InternetAttachSourceProvider$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/jarFinder/InternetAttachSourceProvider$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "perform";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "perform";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            });
            if (list8 == null) {
                InternetAttachSourceProvider.$$$reportNull$$$0(8);
            }
            return list8;
        }
        List<2> list9 = List.of(new AttachSourcesProvider.LightAttachSourcesAction(){

            @Nls(capitalization=Nls.Capitalization.Title)
            public String getName() {
                return JavaUiBundle.message("internet.attach.source.provider.action.name", new Object[0]);
            }

            public String getBusyText() {
                return JavaUiBundle.message("internet.attach.source.provider.action.busy.text", new Object[0]);
            }

            @NotNull
            public ActionCallback perform(@NotNull List<? extends LibraryOrderEntry> orderEntriesContainingFile) {
                if (orderEntriesContainingFile == null) {
                    2.$$$reportNull$$$0(0);
                }
                Task.Modal task2 = new Task.Modal(psiFile.getProject(), JavaUiBundle.message("progress.title.searching.source", new Object[0]), true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        SourceSearcher[] searchers;
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        String artifactUrl = null;
                        for (SourceSearcher searcher : searchers = new SourceSearcher[]{new MavenCentralSourceSearcher(), new SonatypeSourceSearcher()}) {
                            try {
                                artifactUrl = searcher.findSourceJar(indicator, artifactId, version, jar);
                            }
                            catch (SourceSearchException e) {
                                LOG.warn((Throwable)e);
                                String title = JavaUiBundle.message("internet.attach.source.provider.action.notification.title.downloading.failed", new Object[0]);
                                this.showMessage(title, e.getMessage(), NotificationType.ERROR);
                                continue;
                            }
                            if (artifactUrl != null) break;
                        }
                        if (artifactUrl == null) {
                            this.showMessage(JavaUiBundle.message("internet.attach.source.provider.action.notification.title.sources.not.found", new Object[0]), JavaUiBundle.message("internet.attach.source.provider.action.notification.content.sources.for.jar.not.found", jarName), NotificationType.WARNING);
                            return;
                        }
                        if (!file.isDirectory() && !file.mkdirs()) {
                            this.showMessage(JavaUiBundle.message("internet.attach.source.provider.action.notification.title.downloading.failed", new Object[0]), JavaUiBundle.message("internet.attach.source.provider.action.notification.content.failed.to.create.directory", file), NotificationType.ERROR);
                            return;
                        }
                        try {
                            File tmpDownload = FileUtil.createTempFile((File)file, (String)"download.", (String)".tmp", (boolean)false, (boolean)false);
                            HttpRequests.request((String)artifactUrl).saveToFile(tmpDownload, indicator);
                            if (!sourceFile.exists() && !tmpDownload.renameTo(sourceFile)) {
                                LOG.warn("Failed to rename file " + String.valueOf(tmpDownload) + " to " + sourceFileName);
                            }
                        }
                        catch (IOException e) {
                            LOG.warn((Throwable)e);
                            this.showMessage(JavaUiBundle.message("internet.attach.source.provider.action.notification.title.downloading.failed", new Object[0]), JavaUiBundle.message("internet.attach.source.provider.action.notification.content.connection.problem", new Object[0]), NotificationType.ERROR);
                        }
                    }

                    public void onSuccess() {
                        InternetAttachSourceProvider.attachSourceJar(sourceFile, (Collection<? extends Library>)libraries);
                    }

                    private void showMessage(@NlsContexts.NotificationTitle String title, @NlsContexts.NotificationContent String message, NotificationType notificationType) {
                        new Notification("Source searcher", title, message, notificationType).notify(this.getProject());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarFinder/InternetAttachSourceProvider$2$1", "run"));
                    }
                };
                task2.queue();
                ActionCallback actionCallback = ActionCallback.DONE;
                if (actionCallback == null) {
                    2.$$$reportNull$$$0(1);
                }
                return actionCallback;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "orderEntriesContainingFile";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/jarFinder/InternetAttachSourceProvider$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/jarFinder/InternetAttachSourceProvider$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "perform";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "perform";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        });
        if (list9 == null) {
            InternetAttachSourceProvider.$$$reportNull$$$0(9);
        }
        return list9;
    }

    private static boolean isRootInExistingFile(VirtualFile root) {
        VirtualFile jar;
        return !(root.getFileSystem() instanceof JarFileSystem) || (jar = JarFileSystem.getInstance().getVirtualFileForJar(root)) != null && VfsUtilCore.virtualToIoFile((VirtualFile)jar).exists();
    }

    @Deprecated
    public static void attachSourceJar(@NotNull File sourceJar, @NotNull Collection<? extends Library> libraries) {
        if (sourceJar == null) {
            InternetAttachSourceProvider.$$$reportNull$$$0(10);
        }
        if (libraries == null) {
            InternetAttachSourceProvider.$$$reportNull$$$0(11);
        }
        InternetAttachSourceProvider.attachSourceJar(LocalFileSystem.getInstance().refreshAndFindFileByIoFile(sourceJar), libraries);
    }

    public static void attachSourceJar(@NotNull Path sourceJar, @NotNull Collection<? extends Library> libraries) {
        if (sourceJar == null) {
            InternetAttachSourceProvider.$$$reportNull$$$0(12);
        }
        if (libraries == null) {
            InternetAttachSourceProvider.$$$reportNull$$$0(13);
        }
        InternetAttachSourceProvider.attachSourceJar(LocalFileSystem.getInstance().refreshAndFindFileByNioFile(sourceJar), libraries);
    }

    private static void attachSourceJar(@Nullable VirtualFile srcFile, @NotNull Collection<? extends Library> libraries) {
        if (libraries == null) {
            InternetAttachSourceProvider.$$$reportNull$$$0(14);
        }
        if (srcFile == null) {
            return;
        }
        VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(srcFile);
        if (jarRoot == null) {
            return;
        }
        VirtualFile[] roots = LibrarySourceRootDetectorUtil.scanAndSelectDetectedJavaSourceRoots(null, new VirtualFile[]{jarRoot});
        if (roots.length == 0) {
            roots = new VirtualFile[]{jarRoot};
        }
        InternetAttachSourceProvider.doAttachSourceJars(libraries, roots);
    }

    private static void doAttachSourceJars(@NotNull Collection<? extends Library> libraries, VirtualFile[] roots) {
        if (libraries == null) {
            InternetAttachSourceProvider.$$$reportNull$$$0(15);
        }
        WriteAction.run(() -> {
            for (Library library : libraries) {
                Library.ModifiableModel model = library.getModifiableModel();
                HashSet alreadyExistingFiles = ContainerUtil.newHashSet((Object[])model.getFiles(OrderRootType.SOURCES));
                for (VirtualFile root : roots) {
                    if (alreadyExistingFiles.contains(root)) continue;
                    model.addRoot(root, OrderRootType.SOURCES);
                }
                model.commit();
            }
        });
    }

    public static File getLibrarySourceDir() {
        String path = System.getProperty("idea.library.source.dir");
        return path != null ? new File(path) : new File(SystemProperties.getUserHome(), ".ideaLibSources");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntries";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarFinder/InternetAttachSourceProvider";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceJar";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarFinder/InternetAttachSourceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "attachSourceJar";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doAttachSourceJars";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    private record MavenCoords(String artifactId, String version) {
    }
}

