/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.ide.JavaUiBundle;
import com.intellij.jarFinder.AbstractAttachSourceProvider;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class IvyAttachSourceProvider
extends AbstractAttachSourceProvider {
    private static final Logger LOG = Logger.getInstance(IvyAttachSourceProvider.class);

    IvyAttachSourceProvider() {
    }

    @NotNull
    public Collection<? extends AttachSourcesProvider.AttachSourcesAction> getActions(@NotNull List<? extends LibraryOrderEntry> orderEntries, @NotNull PsiFile psiFile) {
        VirtualFile srcFile;
        String artifactName;
        VirtualFile jar;
        if (orderEntries == null) {
            IvyAttachSourceProvider.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            IvyAttachSourceProvider.$$$reportNull$$$0(1);
        }
        if ((jar = IvyAttachSourceProvider.getJarByPsiFile(psiFile)) == null) {
            List list2 = List.of();
            if (list2 == null) {
                IvyAttachSourceProvider.$$$reportNull$$$0(2);
            }
            return list2;
        }
        VirtualFile jarsDir = jar.getParent();
        if (jarsDir == null || !jarsDir.getName().equals("jars")) {
            List list3 = List.of();
            if (list3 == null) {
                IvyAttachSourceProvider.$$$reportNull$$$0(3);
            }
            return list3;
        }
        final VirtualFile artifactDir = jarsDir.getParent();
        if (artifactDir == null) {
            List list4 = List.of();
            if (list4 == null) {
                IvyAttachSourceProvider.$$$reportNull$$$0(4);
            }
            return list4;
        }
        String jarNameWithoutExt = jar.getNameWithoutExtension();
        if (!jarNameWithoutExt.startsWith(artifactName = artifactDir.getName()) || !jarNameWithoutExt.substring(artifactName.length()).startsWith("-")) {
            List list5 = List.of();
            if (list5 == null) {
                IvyAttachSourceProvider.$$$reportNull$$$0(5);
            }
            return list5;
        }
        String version = jarNameWithoutExt.substring(artifactName.length() + 1);
        VirtualFile propertiesFile = artifactDir.findChild("ivydata-" + version + ".properties");
        if (propertiesFile == null) {
            List list6 = List.of();
            if (list6 == null) {
                IvyAttachSourceProvider.$$$reportNull$$$0(6);
            }
            return list6;
        }
        final Library library = IvyAttachSourceProvider.getLibraryFromOrderEntriesList(orderEntries);
        if (library == null) {
            List list7 = List.of();
            if (list7 == null) {
                IvyAttachSourceProvider.$$$reportNull$$$0(7);
            }
            return list7;
        }
        final String sourceFileName = artifactName + "-" + version + "-sources.jar";
        final VirtualFile sources = artifactDir.findChild("sources");
        if (sources != null && (srcFile = sources.findChild(sourceFileName)) != null) {
            VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(srcFile);
            if (jarRoot == null || ArrayUtil.contains((Object)jarRoot, (Object[])library.getFiles(OrderRootType.SOURCES))) {
                List list8 = List.of();
                if (list8 == null) {
                    IvyAttachSourceProvider.$$$reportNull$$$0(8);
                }
                return list8;
            }
            List<AbstractAttachSourceProvider.AttachExistingSourceAction> list9 = List.of(new AbstractAttachSourceProvider.AttachExistingSourceAction(jarRoot, library, JavaUiBundle.message("ivi.attach.source.provider.action.name", new Object[0])));
            if (list9 == null) {
                IvyAttachSourceProvider.$$$reportNull$$$0(9);
            }
            return list9;
        }
        String url = IvyAttachSourceProvider.extractUrl(propertiesFile, artifactName);
        if (StringUtil.isEmptyOrSpaces((String)url)) {
            List list10 = List.of();
            if (list10 == null) {
                IvyAttachSourceProvider.$$$reportNull$$$0(10);
            }
            return list10;
        }
        List<1> list11 = List.of(new AbstractAttachSourceProvider.DownloadSourcesAction(psiFile.getProject(), "Downloading Ivy Sources", url){

            @Override
            protected void storeFile(byte[] content) {
                try {
                    VirtualFile existingSourcesFolder = sources;
                    if (existingSourcesFolder == null) {
                        existingSourcesFolder = artifactDir.createChildDirectory((Object)this, "sources");
                    }
                    VirtualFile srcFile = existingSourcesFolder.createChildData((Object)this, sourceFileName);
                    srcFile.setBinaryContent(content);
                    IvyAttachSourceProvider.this.addSourceFile(JarFileSystem.getInstance().getJarRootForLocalFile(srcFile), library);
                }
                catch (IOException e) {
                    String message = JavaUiBundle.message("error.message.failed.to.save.0", artifactDir.getPath() + "/sources/" + sourceFileName);
                    new Notification(this.myMessageGroupId, JavaUiBundle.message("notification.title.io.error", new Object[0]), message, NotificationType.ERROR).notify(this.myProject);
                    LOG.warn((Throwable)e);
                }
            }
        });
        if (list11 == null) {
            IvyAttachSourceProvider.$$$reportNull$$$0(11);
        }
        return list11;
    }

    @Nullable
    private static String extractUrl(VirtualFile properties, String artifactName) {
        String prefix = "artifact:" + artifactName + "#source#jar#";
        try {
            Properties p = new Properties();
            p.load(new StringReader(VfsUtilCore.loadText((VirtualFile)properties)));
            for (Object o : p.keySet()) {
                String key = o.toString();
                if (key == null || !key.startsWith(prefix) || !key.endsWith(".location")) continue;
                return p.getProperty(key);
            }
        }
        catch (Exception e) {
            LOG.debug(properties.getPath(), (Throwable)e);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntries";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarFinder/IvyAttachSourceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarFinder/IvyAttachSourceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

