/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.jarRepository.JarHttpDownloader;
import com.intellij.jarRepository.JarRepositoryAuthenticationDataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DigestUtilKt;
import com.intellij.util.io.HttpRequests;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.idea.maven.aether.Retry;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0003 !\"B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JH\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u000e\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010\u0015J,\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u0011\u001a\u00020\u0012J@\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0014\b\u0002\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u001bR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/jarRepository/JarHttpDownloader;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "forceHttps", "", "downloadLibraryFilesAsync", "", "Ljava/nio/file/Path;", "relativePaths", "Lcom/intellij/jarRepository/JarHttpDownloader$RelativePathToDownload;", "localRepository", "remoteRepositories", "Lcom/intellij/jarRepository/JarHttpDownloader$RemoteRepository;", "retry", "Lorg/jetbrains/idea/maven/aether/Retry;", "downloadDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Ljava/util/List;Ljava/nio/file/Path;Ljava/util/List;Lorg/jetbrains/idea/maven/aether/Retry;Lkotlinx/coroutines/CoroutineDispatcher;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "downloadArtifact", "artifactPath", "downloadFile", "", "url", "", "targetFile", "headers", "", "expectedSha256", "RemoteRepository", "RelativePathToDownload", "BadChecksumException", "intellij.java.ui"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nJarHttpDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JarHttpDownloader.kt\ncom/intellij/jarRepository/JarHttpDownloader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,279:1\n1915#2,2:280\n1586#2:282\n1661#2,3:283\n1586#2:286\n1661#2,3:287\n1915#2,2:290\n1586#2:292\n1661#2,3:293\n221#3,2:296\n1#4:298\n*S KotlinDebug\n*F\n+ 1 JarHttpDownloader.kt\ncom/intellij/jarRepository/JarHttpDownloader\n*L\n75#1:280,2\n107#1:282\n107#1:283,3\n154#1:286\n154#1:287,3\n155#1:290,2\n159#1:292\n159#1:293,3\n190#1:296,2\n*E\n"})
public final class JarHttpDownloader {
    @NotNull
    public static final JarHttpDownloader INSTANCE = new JarHttpDownloader();
    @NotNull
    private static final Logger LOG;
    @VisibleForTesting
    @JvmField
    public static volatile boolean forceHttps;

    private JarHttpDownloader() {
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object downloadLibraryFilesAsync(@NotNull List<RelativePathToDownload> relativePaths, @NotNull Path localRepository, @NotNull List<RemoteRepository> remoteRepositories, @NotNull Retry retry, @NotNull CoroutineDispatcher downloadDispatcher, @NotNull Continuation<? super List<? extends Path>> $completion) {
        if (!($completion instanceof downloadLibraryFilesAsync.1)) ** GOTO lbl-1000
        var18_7 = $completion;
        if ((var18_7.label & -2147483648) != 0) {
            var18_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                /* synthetic */ Object result;
                final /* synthetic */ JarHttpDownloader this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.downloadLibraryFilesAsync(null, null, null, null, null, (Continuation<? super List<? extends Path>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var19_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (JarHttpDownloader.LOG.isTraceEnabled()) {
                    JarHttpDownloader.LOG.trace("Downloading roots " + relativePaths + ", localRepository=" + localRepository + ", remoteRepositories=" + remoteRepositories);
                }
                v0 = ContainerUtil.createConcurrentList();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"createConcurrentList(...)");
                errors = v0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)relativePaths);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)localRepository);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)remoteRepositories);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)retry);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)downloadDispatcher);
                $continuation.L$5 = errors;
                $continuation.label = 1;
                v1 = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends Path>>, Object>(relativePaths, downloadDispatcher, localRepository, (List<RemoteRepository>)remoteRepositories, retry, (ConcurrentList<Throwable>)errors, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ List<RelativePathToDownload> $relativePaths;
                    final /* synthetic */ CoroutineDispatcher $downloadDispatcher;
                    final /* synthetic */ Path $localRepository;
                    final /* synthetic */ List<RemoteRepository> $remoteRepositories;
                    final /* synthetic */ Retry $retry;
                    final /* synthetic */ ConcurrentList<Throwable> $errors;
                    {
                        this.$relativePaths = $relativePaths;
                        this.$downloadDispatcher = $downloadDispatcher;
                        this.$localRepository = $localRepository;
                        this.$remoteRepositories = $remoteRepositories;
                        this.$retry = $retry;
                        this.$errors = $errors;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void $this$coroutineScope;
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                ResultKt.throwOnFailure((Object)$result);
                                Iterable iterable = this.$relativePaths;
                                CoroutineDispatcher coroutineDispatcher = this.$downloadDispatcher;
                                Path path = this.$localRepository;
                                List<RemoteRepository> list2 = this.$remoteRepositories;
                                Retry retry = this.$retry;
                                ConcurrentList<Throwable> concurrentList = this.$errors;
                                boolean $i$f$map = false;
                                void var10_11 = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void relativePath;
                                    RelativePathToDownload relativePathToDownload = (RelativePathToDownload)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(BuildersKt.async$default((CoroutineScope)$this$coroutineScope, (CoroutineContext)((CoroutineContext)coroutineDispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>((RelativePathToDownload)relativePath, path, list2, retry, concurrentList, null){
                                        int label;
                                        final /* synthetic */ RelativePathToDownload $relativePath;
                                        final /* synthetic */ Path $localRepository;
                                        final /* synthetic */ List<RemoteRepository> $remoteRepositories;
                                        final /* synthetic */ Retry $retry;
                                        final /* synthetic */ ConcurrentList<Throwable> $errors;
                                        {
                                            this.$relativePath = $relativePath;
                                            this.$localRepository = $localRepository;
                                            this.$remoteRepositories = $remoteRepositories;
                                            this.$retry = $retry;
                                            this.$errors = $errors;
                                            super(2, $completion);
                                        }

                                        public final Object invokeSuspend(Object $result) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    Path path;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    try {
                                                        path = JarHttpDownloader.INSTANCE.downloadArtifact(this.$relativePath, this.$localRepository, this.$remoteRepositories, this.$retry);
                                                    }
                                                    catch (Throwable t) {
                                                        this.$errors.add((Object)t);
                                                        return null;
                                                    }
                                                    return path;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        public final Object invoke(CoroutineScope p1, Continuation<? super Path> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (int)2, null));
                                }
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$coroutineScope);
                                this.label = 1;
                                Object object2 = AwaitKt.awaitAll((Collection)((List)destination$iv$iv), (Continuation)((Continuation)this));
                                if (object2 != object) return CollectionsKt.filterNotNull((Iterable)((Iterable)object2));
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return CollectionsKt.filterNotNull((Iterable)((Iterable)object2));
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends Path>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var19_9) {
                    return var19_9;
                }
                ** GOTO lbl37
            }
            case 1: {
                errors = (ConcurrentList)$continuation.L$5;
                downloadDispatcher = (CoroutineDispatcher)$continuation.L$4;
                retry = (Retry)$continuation.L$3;
                remoteRepositories = (List)$continuation.L$2;
                localRepository = (Path)$continuation.L$1;
                relativePaths = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl37:
                // 2 sources

                downloadedFiles = (List)v1;
                if (!errors.isEmpty()) {
                    first = (Throwable)CollectionsKt.first((List)((List)errors));
                    exception = new IllegalStateException("Failed to download " + errors.size() + " artifact(s): (first exception) " + first.getMessage(), first);
                    $this$forEach$iv = CollectionsKt.drop((Iterable)((Iterable)errors), (int)1);
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (Throwable)element$iv;
                        $i$a$-forEach-JarHttpDownloader$downloadLibraryFilesAsync$2 = false;
                        v2 = exception;
                        Intrinsics.checkNotNull((Object)it);
                        ExceptionsKt.addSuppressed((Throwable)v2, (Throwable)it);
                    }
                    if (JarHttpDownloader.LOG.isTraceEnabled()) {
                        JarHttpDownloader.LOG.trace(ExceptionsKt.stackTraceToString((Throwable)exception));
                    }
                    throw exception;
                }
                return downloadedFiles;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Path downloadArtifact(@NotNull RelativePathToDownload artifactPath, @NotNull Path localRepository, @NotNull List<RemoteRepository> remoteRepositories, @NotNull Retry retry) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object exception;
        Object authHeader;
        Object object;
        Object object2;
        Object $this$mapTo$iv$iv22;
        Intrinsics.checkNotNullParameter((Object)artifactPath, (String)"artifactPath");
        Intrinsics.checkNotNullParameter((Object)localRepository, (String)"localRepository");
        Intrinsics.checkNotNullParameter(remoteRepositories, (String)"remoteRepositories");
        Intrinsics.checkNotNullParameter((Object)retry, (String)"retry");
        Path targetFile = localRepository.resolve(artifactPath.getRelativePath());
        Intrinsics.checkNotNull((Object)targetFile);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(targetFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            String actualSha256;
            if (artifactPath.getExpectedSha256() != null && !Intrinsics.areEqual((Object)(actualSha256 = DigestUtilKt.sha256Hex((Path)targetFile)), (Object)artifactPath.getExpectedSha256())) {
                boolean $i$a$-check-JarHttpDownloader$downloadArtifact$22 = false;
                String $i$a$-check-JarHttpDownloader$downloadArtifact$22 = "Wrong file checksum on disk for '" + targetFile + "': expected checksum " + artifactPath.getExpectedSha256() + ", but got " + actualSha256 + " (fileSize: " + Files.size(targetFile) + ")";
                throw new IllegalStateException($i$a$-check-JarHttpDownloader$downloadArtifact$22.toString());
            }
            return targetFile;
        }
        String string = FileUtil.toSystemIndependentName((String)((Object)artifactPath.getRelativePath()).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String systemIndependentNormalizedRelativePath = string;
        Iterable $this$map$iv2 = remoteRepositories;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv22) {
            void remoteRepository;
            RemoteRepository remoteRepository2 = (RemoteRepository)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object = new char[]{'/'};
            object2.add(TuplesKt.to((Object)(StringsKt.trimEnd((String)remoteRepository.getUrl(), (char[])object) + "/" + systemIndependentNormalizedRelativePath), (Object)remoteRepository));
        }
        List remoteRepositoriesAndUrl = (List)destination$iv$iv;
        List authExceptions = new ArrayList();
        for (Object $this$mapTo$iv$iv22 : remoteRepositoriesAndUrl) {
            String url = (String)$this$mapTo$iv$iv22.component1();
            RemoteRepository remoteRepository = (RemoteRepository)$this$mapTo$iv$iv22.component2();
            try {
                Object credentials;
                Map map;
                if (remoteRepository.getAuthenticationData() == null) {
                    map = MapsKt.emptyMap();
                } else {
                    credentials = remoteRepository.getAuthenticationData().getUserName() + ":" + remoteRepository.getAuthenticationData().getPassword();
                    Base64.Encoder encoder = Base64.getEncoder();
                    Object bl = credentials;
                    byte[] byArray = ((String)bl).getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    authHeader = "Basic " + encoder.encodeToString(byArray);
                    map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Authorization", (Object)authHeader));
                }
                Map headers = map;
                credentials = targetFile;
                authHeader = artifactPath.getExpectedSha256();
                this.downloadFile(url, (Path)credentials, retry, headers, (String)authHeader);
                return targetFile;
            }
            catch (HttpRequests.HttpStatusException e) {
                if (e.getStatusCode() == 404) continue;
                if (e.getStatusCode() == 401) {
                    authExceptions.add(TuplesKt.to((Object)url, (Object)((Object)e)));
                    continue;
                }
                throw e;
            }
        }
        if (!((Collection)authExceptions).isEmpty()) {
            Iterator $this$mapTo$iv$iv3;
            void $this$map$iv3;
            $this$mapTo$iv$iv22 = authExceptions;
            String string2 = systemIndependentNormalizedRelativePath;
            boolean $i$f$map2 = false;
            void remoteRepository = $this$map$iv3;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo2 = false;
            authHeader = $this$mapTo$iv$iv3.iterator();
            while (authHeader.hasNext()) {
                void it;
                Object item$iv$iv2 = authHeader.next();
                object = (Pair)item$iv$iv2;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add((String)it.getFirst());
            }
            String string3 = "Artifact '" + string2 + "' was not found in remote repositories, some of them returned 401 Unauthorized: " + (List)destination$iv$iv2;
            exception = new IllegalStateException(string3);
            Iterable $this$forEach$iv = authExceptions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                ExceptionsKt.addSuppressed((Throwable)((Throwable)exception), (Throwable)((Throwable)it.getSecond()));
            }
            throw exception;
        }
        exception = remoteRepositoriesAndUrl;
        object2 = systemIndependentNormalizedRelativePath;
        boolean $i$f$map3 = false;
        void $i$f$forEach = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair item$iv$iv2 = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv3;
            boolean bl = false;
            collection.add((String)it.getFirst());
        }
        String string4 = "Artifact '" + (String)object2 + "' was not found in remote repositories: " + (List)destination$iv$iv3;
        throw new IllegalStateException(string4.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void downloadFile(@NotNull String url, @NotNull Path targetFile, @NotNull Retry retry, @NotNull Map<String, String> headers, @Nullable String expectedSha256) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter((Object)retry, (String)"retry");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        if (forceHttps && !StringsKt.startsWith$default((String)url, (String)"https://", (boolean)false, (int)2, null)) {
            boolean $i$a$-check-JarHttpDownloader$downloadFile$22 = false;
            String $i$a$-check-JarHttpDownloader$downloadFile$22 = "Url must have https protocol: " + url;
            throw new IllegalStateException($i$a$-check-JarHttpDownloader$downloadFile$22.toString());
        }
        LOG.trace("Starting downloading '" + url + "' to '" + targetFile + "', headers=" + CollectionsKt.sorted((Iterable)headers.keySet()) + ", expectedSha256=" + expectedSha256);
        Path path = targetFile.getParent();
        if (path == null) {
            throw new IllegalStateException(("Could not get parent directory for " + targetFile).toString());
        }
        Path targetDirectory = path;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(targetDirectory, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Path tempFile = Files.createTempFile(targetDirectory, "." + PathsKt.getName((Path)targetFile), ".tmp", new FileAttribute[0]);
        Intrinsics.checkNotNull((Object)tempFile);
        Files.deleteIfExists(tempFile);
        try {
            Ref.ObjectRef lastFileSize = new Ref.ObjectRef();
            Exception exception = (Exception)retry.retry(() -> JarHttpDownloader.downloadFile$lambda$1(url, headers, tempFile, lastFileSize, expectedSha256, targetFile), LOG);
            if (exception != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Downloading of '" + url + "' to '" + targetFile + "' failed (headers=" + CollectionsKt.sorted((Iterable)headers.keySet()) + ": " + ExceptionsKt.stackTraceToString((Throwable)exception));
                }
                throw exception;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Downloaded file from '" + url + "' to '" + targetFile + "', size=" + lastFileSize.element + ", headers=" + CollectionsKt.sorted((Iterable)headers.keySet()) + ", expectedSha256=" + expectedSha256);
            }
            return;
        }
        finally {
            Files.deleteIfExists(tempFile);
        }
    }

    public static /* synthetic */ void downloadFile$default(JarHttpDownloader jarHttpDownloader, String string, Path path, Retry retry, Map map, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        jarHttpDownloader.downloadFile(string, path, retry, map, string2);
    }

    private static final void downloadFile$lambda$1$0(Map $headers, URLConnection tuner) {
        Intrinsics.checkNotNullParameter((Object)tuner, (String)"tuner");
        Map $this$forEach$iv = $headers;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            tuner.addRequestProperty(name, value);
        }
    }

    private static final Path downloadFile$lambda$1$1(Path $tempFile, Map $headers, Ref.ObjectRef $lastFileSize, String $expectedSha256, String $url, Path $targetFile, HttpRequests.Request processor) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        processor.saveToFile($tempFile, null);
        long contentLength = processor.getConnection().getHeaderFieldLong("Content-Length", -1L);
        if (!(contentLength > 0L)) {
            boolean $i$a$-check-JarHttpDownloader$downloadFile$exception$1$2$42 = false;
            String $i$a$-check-JarHttpDownloader$downloadFile$exception$1$2$42 = "Header 'Content-Length' is missing or zero for " + $url;
            throw new IllegalStateException($i$a$-check-JarHttpDownloader$downloadFile$exception$1$2$42.toString());
        }
        String contentEncoding = (String)$headers.get("Content-Encoding");
        if (!(contentEncoding == null || Intrinsics.areEqual((Object)contentEncoding, (Object)"identity"))) {
            boolean bl = false;
            String string = "Unsupported encoding '" + contentEncoding + "' for " + $url + ". Only 'identity' encoding is supported";
            throw new IllegalStateException(string.toString());
        }
        long fileSize = Files.size($tempFile);
        if (!(fileSize == contentLength)) {
            boolean bl = false;
            String string = "Wrong file length after downloading uri '" + $url + "' to '" + $tempFile + "': expected length " + contentLength + " from Content-Encoding header, but got " + fileSize + " on disk";
            throw new IllegalStateException(string.toString());
        }
        $lastFileSize.element = fileSize;
        if ($expectedSha256 != null) {
            Intrinsics.checkNotNull((Object)$tempFile);
            String actualSha256 = DigestUtilKt.sha256Hex((Path)$tempFile);
            if (!Intrinsics.areEqual((Object)actualSha256, (Object)$expectedSha256)) {
                throw new BadChecksumException("Wrong file checksum after downloading '" + $url + "' to '" + $tempFile + "': expected checksum " + $expectedSha256 + ", but got " + actualSha256 + " (fileSize: " + fileSize + ")");
            }
        }
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING};
        return Files.move($tempFile, $targetFile, copyOptionArray);
    }

    private static final Exception downloadFile$lambda$1(String $url, Map $headers, Path $tempFile, Ref.ObjectRef $lastFileSize, String $expectedSha256, Path $targetFile) {
        Exception exception;
        try {
            HttpRequests.request((String)$url).tuner(arg_0 -> JarHttpDownloader.downloadFile$lambda$1$0($headers, arg_0)).productNameAsUserAgent().connect(arg_0 -> JarHttpDownloader.downloadFile$lambda$1$1($tempFile, $headers, $lastFileSize, $expectedSha256, $url, $targetFile, arg_0));
            exception = null;
        }
        catch (HttpRequests.HttpStatusException e) {
            if (e.getStatusCode() < 200 || e.getStatusCode() >= 500) {
                throw e;
            }
            exception = (Exception)((Object)e);
        }
        catch (BadChecksumException e) {
            exception = e;
        }
        return exception;
    }

    static {
        Logger logger = Logger.getInstance(JarHttpDownloader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        forceHttps = true;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/jarRepository/JarHttpDownloader$BadChecksumException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "<init>", "(Ljava/lang/String;)V", "intellij.java.ui"})
    public static final class BadChecksumException
    extends RuntimeException {
        public BadChecksumException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0005H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/jarRepository/JarHttpDownloader$RelativePathToDownload;", "", "relativePath", "Ljava/nio/file/Path;", "expectedSha256", "", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "getRelativePath", "()Ljava/nio/file/Path;", "getExpectedSha256", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.java.ui"})
    public static final class RelativePathToDownload {
        @NotNull
        private final Path relativePath;
        @Nullable
        private final String expectedSha256;

        public RelativePathToDownload(@NotNull Path relativePath, @Nullable String expectedSha256) {
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            this.relativePath = relativePath;
            this.expectedSha256 = expectedSha256;
            if (!(!this.relativePath.isAbsolute())) {
                boolean $i$a$-require-JarHttpDownloader$RelativePathToDownload$32 = false;
                String $i$a$-require-JarHttpDownloader$RelativePathToDownload$32 = "Path " + this.relativePath + " should be relative";
                throw new IllegalArgumentException($i$a$-require-JarHttpDownloader$RelativePathToDownload$32.toString());
            }
            Path path = this.relativePath.normalize();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"normalize(...)");
            if (!Intrinsics.areEqual((Object)((Object)path).toString(), (Object)((Object)this.relativePath).toString())) {
                boolean bl = false;
                String string = "Path " + this.relativePath + " should be normalized";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final Path getRelativePath() {
            return this.relativePath;
        }

        @Nullable
        public final String getExpectedSha256() {
            return this.expectedSha256;
        }

        @NotNull
        public final Path component1() {
            return this.relativePath;
        }

        @Nullable
        public final String component2() {
            return this.expectedSha256;
        }

        @NotNull
        public final RelativePathToDownload copy(@NotNull Path relativePath, @Nullable String expectedSha256) {
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            return new RelativePathToDownload(relativePath, expectedSha256);
        }

        public static /* synthetic */ RelativePathToDownload copy$default(RelativePathToDownload relativePathToDownload, Path path, String string, int n, Object object) {
            if ((n & 1) != 0) {
                path = relativePathToDownload.relativePath;
            }
            if ((n & 2) != 0) {
                string = relativePathToDownload.expectedSha256;
            }
            return relativePathToDownload.copy(path, string);
        }

        @NotNull
        public String toString() {
            return "RelativePathToDownload(relativePath=" + this.relativePath + ", expectedSha256=" + this.expectedSha256 + ")";
        }

        public int hashCode() {
            int result = ((Object)this.relativePath).hashCode();
            result = result * 31 + (this.expectedSha256 == null ? 0 : this.expectedSha256.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RelativePathToDownload)) {
                return false;
            }
            RelativePathToDownload relativePathToDownload = (RelativePathToDownload)other;
            if (!Intrinsics.areEqual((Object)this.relativePath, (Object)relativePathToDownload.relativePath)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.expectedSha256, (Object)relativePathToDownload.expectedSha256);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/jarRepository/JarHttpDownloader$RemoteRepository;", "", "url", "", "authenticationData", "Lcom/intellij/jarRepository/JarRepositoryAuthenticationDataProvider$AuthenticationData;", "<init>", "(Ljava/lang/String;Lcom/intellij/jarRepository/JarRepositoryAuthenticationDataProvider$AuthenticationData;)V", "getUrl", "()Ljava/lang/String;", "getAuthenticationData", "()Lcom/intellij/jarRepository/JarRepositoryAuthenticationDataProvider$AuthenticationData;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.java.ui"})
    public static final class RemoteRepository {
        @NotNull
        private final String url;
        @Nullable
        private final JarRepositoryAuthenticationDataProvider.AuthenticationData authenticationData;

        public RemoteRepository(@NotNull String url, @Nullable JarRepositoryAuthenticationDataProvider.AuthenticationData authenticationData) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.url = url;
            this.authenticationData = authenticationData;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @Nullable
        public final JarRepositoryAuthenticationDataProvider.AuthenticationData getAuthenticationData() {
            return this.authenticationData;
        }

        @NotNull
        public final String component1() {
            return this.url;
        }

        @Nullable
        public final JarRepositoryAuthenticationDataProvider.AuthenticationData component2() {
            return this.authenticationData;
        }

        @NotNull
        public final RemoteRepository copy(@NotNull String url, @Nullable JarRepositoryAuthenticationDataProvider.AuthenticationData authenticationData) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new RemoteRepository(url, authenticationData);
        }

        public static /* synthetic */ RemoteRepository copy$default(RemoteRepository remoteRepository, String string, JarRepositoryAuthenticationDataProvider.AuthenticationData authenticationData, int n, Object object) {
            if ((n & 1) != 0) {
                string = remoteRepository.url;
            }
            if ((n & 2) != 0) {
                authenticationData = remoteRepository.authenticationData;
            }
            return remoteRepository.copy(string, authenticationData);
        }

        @NotNull
        public String toString() {
            return "RemoteRepository(url=" + this.url + ", authenticationData=" + this.authenticationData + ")";
        }

        public int hashCode() {
            int result = this.url.hashCode();
            result = result * 31 + (this.authenticationData == null ? 0 : this.authenticationData.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RemoteRepository)) {
                return false;
            }
            RemoteRepository remoteRepository = (RemoteRepository)other;
            if (!Intrinsics.areEqual((Object)this.url, (Object)remoteRepository.url)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.authenticationData, (Object)remoteRepository.authenticationData);
        }
    }
}

