/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.jarRepository.JarHttpDownloader;
import com.intellij.jarRepository.JarHttpDownloaderJps;
import com.intellij.jarRepository.JarRepositoryAuthenticationDataProvider;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RemoteRepositoriesConfiguration;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryLibrarySynchronizerKt;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.idea.maven.aether.Retry;
import org.jetbrains.idea.maven.aether.RetryProvider;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;
import org.jetbrains.jps.model.serialization.JpsMavenSettings;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000  2\u00020\u0001:\u0002 !B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/jarRepository/JarHttpDownloaderJps;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "defaultRetryProvider", "Lorg/jetbrains/idea/maven/aether/Retry;", "kotlin.jvm.PlatformType", "NUMBER_OF_DOWNLOAD_THREADS", "", "limitedDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "getLimitedDispatcher$annotations", "()V", "filesToRefresh", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Ljava/nio/file/Path;", "downloadLibraryFilesAsync", "Lorg/jetbrains/concurrency/Promise;", "library", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "obtainAuthenticationData", "Lcom/intellij/jarRepository/JarRepositoryAuthenticationDataProvider$AuthenticationData;", "repository", "Lcom/intellij/jarRepository/RemoteRepositoryDescription;", "Companion", "CollectResult", "intellij.java.ui"})
@ApiStatus.Internal
public final class JarHttpDownloaderJps {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    private final Retry defaultRetryProvider;
    private final int NUMBER_OF_DOWNLOAD_THREADS;
    @NotNull
    private final CoroutineDispatcher limitedDispatcher;
    @NotNull
    private final ConcurrentLinkedDeque<Path> filesToRefresh;
    @NotNull
    private static final Logger LOG;

    public JarHttpDownloaderJps(@NotNull Project project2, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project2;
        this.coroutineScope = coroutineScope;
        String string = System.getProperty("jar.http.downloader.retry.initial.delay.ms", "1000");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        long l = Long.parseLong(string);
        String string2 = System.getProperty("jar.http.downloader.retry.backoff.limit.ms", "5000");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        long l2 = Long.parseLong(string2);
        String string3 = System.getProperty("jar.http.downloader.retry.max.attempts", "3");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getProperty(...)");
        this.defaultRetryProvider = RetryProvider.withExponentialBackOff((long)l, (long)l2, (int)Integer.parseInt(string3));
        String string4 = System.getProperty("jar.http.downloader.threads", "10");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getProperty(...)");
        this.NUMBER_OF_DOWNLOAD_THREADS = Integer.parseInt(string4);
        this.limitedDispatcher = CoroutineDispatcher.limitedParallelism$default((CoroutineDispatcher)Dispatchers.getIO(), (int)this.NUMBER_OF_DOWNLOAD_THREADS, null, (int)2, null);
        this.filesToRefresh = new ConcurrentLinkedDeque();
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ JarHttpDownloaderJps this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        while (true) {
                            this.label = 1;
                            v0 = DelayKt.delay((long)15000L, (Continuation)((Continuation)this));
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl15
                            break;
                        }
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        while (true) {
                            if (!(((Collection)JarHttpDownloaderJps.access$getFilesToRefresh$p(this.this$0)).isEmpty() == false)) ** continue;
                            file = (Path)JarHttpDownloaderJps.access$getFilesToRefresh$p(this.this$0).removeFirst();
                            if (JarHttpDownloaderJps.access$getLOG$cp().isTraceEnabled()) {
                                JarHttpDownloaderJps.access$getLOG$cp().trace("Refreshing VFS for file '" + file + "'");
                            }
                            v1 = (NewVirtualFileSystem)LocalFileSystem.getInstance();
                            Intrinsics.checkNotNull((Object)file);
                            VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)v1, (String)FileUtil.toSystemIndependentName((String)file.toString()), (Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, invokeSuspend$lambda$1(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)V)((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(java.nio.file.Path com.intellij.openapi.vfs.newvfs.NewVirtualFile ), (Lcom/intellij/openapi/vfs/newvfs/NewVirtualFile;)Lkotlin/Unit;)((Path)file)));
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(Path $file, NewVirtualFile virtualFile) {
                if (virtualFile == null) {
                    Logger logger = LOG;
                    Intrinsics.checkNotNull((Object)$file);
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    logger.warn("File '" + $file + "' could not be found in VFS after VfsImplUtil.refreshAndFindFileByPath, exists=" + Files.exists($file, Arrays.copyOf(linkOptionArray, linkOptionArray.length)));
                }
                return Unit.INSTANCE;
            }

            private static final void invokeSuspend$lambda$1(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        }), (int)3, null);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    private static /* synthetic */ void getLimitedDispatcher$annotations() {
    }

    @NotNull
    public final Promise<?> downloadLibraryFilesAsync(@NotNull LibraryEx library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        CollectResult result = JarHttpDownloaderJps.Companion.collectRelativePathsForJarHttpDownloaderOrLog(this.project, library);
        if (result instanceof CollectResult.Failure) {
            return Promises.rejectedPromise((String)((CollectResult.Failure)result).getReason());
        }
        if (!(result instanceof CollectResult.Success)) {
            throw new NoWhenBranchMatchedException();
        }
        List<JarHttpDownloader.RelativePathToDownload> relativePaths = ((CollectResult.Success)result).getFiles();
        LOG.debug("Downloading library '" + library.getName() + "'");
        Path path = JarRepositoryManager.getJPSLocalMavenRepositoryForIdeaProject(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getJPSLocalMavenRepositoryForIdeaProject(...)");
        Path localRepository = path;
        List list2 = RemoteRepositoriesConfiguration.getInstance((Project)this.project).getRepositories();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getRepositories(...)");
        List remoteRepositories = list2;
        AsyncPromise<Unit> promise2 = new AsyncPromise<Unit>(){

            protected boolean shouldLogErrors() {
                return false;
            }
        };
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((List<RemoteRepositoryDescription>)remoteRepositories, relativePaths, localRepository, this, promise2, null){
            Object L$0;
            int label;
            final /* synthetic */ List<RemoteRepositoryDescription> $remoteRepositories;
            final /* synthetic */ List<JarHttpDownloader.RelativePathToDownload> $relativePaths;
            final /* synthetic */ Path $localRepository;
            final /* synthetic */ JarHttpDownloaderJps this$0;
            final /* synthetic */ downloadLibraryFilesAsync.promise.1 $promise;
            {
                this.$remoteRepositories = $remoteRepositories;
                this.$relativePaths = $relativePaths;
                this.$localRepository = $localRepository;
                this.this$0 = $receiver;
                this.$promise = $promise;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var15_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var3_3 = this.$remoteRepositories;
                        var4_4 = this.this$0;
                        $i$f$map = false;
                        var6_7 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var11_12 = (RemoteRepositoryDescription)item$iv$iv;
                            var14_15 = destination$iv$iv;
                            $i$a$-map-JarHttpDownloaderJps$downloadLibraryFilesAsync$1$remotes$1 = false;
                            Intrinsics.checkNotNull((Object)repository);
                            authData = JarHttpDownloaderJps.access$obtainAuthenticationData(var4_4, (RemoteRepositoryDescription)repository);
                            v0 = repository.getUrl();
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getUrl(...)");
                            var14_15.add(new JarHttpDownloader.RemoteRepository(v0, authData));
                        }
                        remotes = (List)destination$iv$iv;
                        v1 = JarHttpDownloaderJps.access$getDefaultRetryProvider$p(this.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"access$getDefaultRetryProvider$p(...)");
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)remotes);
                        this.label = 1;
                        v2 = JarHttpDownloader.INSTANCE.downloadLibraryFilesAsync(this.$relativePaths, this.$localRepository, remotes, v1, JarHttpDownloaderJps.access$getLimitedDispatcher$p(this.this$0), (Continuation<? super List<? extends Path>>)((Continuation)this));
                        ** if (v2 != var15_2) goto lbl33
lbl32:
                        // 1 sources

                        return var15_2;
lbl33:
                        // 1 sources

                        ** GOTO lbl40
                    }
                    case 1: {
                        remotes = (List)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl40:
                            // 2 sources

                            downloadedFiles = (List)v2;
                            JarHttpDownloaderJps.access$getFilesToRefresh$p(this.this$0).addAll(downloadedFiles);
                            this.$promise.setResult(Unit.INSTANCE);
                        }
                        catch (Throwable e) {
                            this.$promise.setError(e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return (Promise)promise2;
    }

    private final JarRepositoryAuthenticationDataProvider.AuthenticationData obtainAuthenticationData(RemoteRepositoryDescription repository) {
        for (JarRepositoryAuthenticationDataProvider extension : JarRepositoryAuthenticationDataProvider.KEY.getExtensionList()) {
            JarRepositoryAuthenticationDataProvider.AuthenticationData authData = extension.provideAuthenticationData(repository);
            if (authData == null) continue;
            return new JarRepositoryAuthenticationDataProvider.AuthenticationData(authData.getUserName(), authData.getPassword());
        }
        return null;
    }

    @JvmStatic
    public static final boolean enabled() {
        return Companion.enabled();
    }

    @JvmStatic
    @NotNull
    public static final JarHttpDownloaderJps getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    public static final /* synthetic */ JarRepositoryAuthenticationDataProvider.AuthenticationData access$obtainAuthenticationData(JarHttpDownloaderJps $this, RemoteRepositoryDescription repository) {
        return $this.obtainAuthenticationData(repository);
    }

    public static final /* synthetic */ Retry access$getDefaultRetryProvider$p(JarHttpDownloaderJps $this) {
        return $this.defaultRetryProvider;
    }

    public static final /* synthetic */ CoroutineDispatcher access$getLimitedDispatcher$p(JarHttpDownloaderJps $this) {
        return $this.limitedDispatcher;
    }

    public static final /* synthetic */ ConcurrentLinkedDeque access$getFilesToRefresh$p(JarHttpDownloaderJps $this) {
        return $this.filesToRefresh;
    }

    static {
        Logger logger = Logger.getInstance(JarHttpDownloaderJps.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/jarRepository/JarHttpDownloaderJps$CollectResult;", "", "Success", "Failure", "Lcom/intellij/jarRepository/JarHttpDownloaderJps$CollectResult$Failure;", "Lcom/intellij/jarRepository/JarHttpDownloaderJps$CollectResult$Success;", "intellij.java.ui"})
    public static sealed interface CollectResult {

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0083\u0004J\n\u0010\u000e\u001a\u00020\u000fH\u00d6\u0081\u0004J\n\u0010\u0010\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jarRepository/JarHttpDownloaderJps$CollectResult$Failure;", "Lcom/intellij/jarRepository/JarHttpDownloaderJps$CollectResult;", "reason", "", "<init>", "(Ljava/lang/String;)V", "getReason", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.java.ui"})
        public static final class Failure
        implements CollectResult {
            @NotNull
            private final String reason;

            public Failure(@NotNull String reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                this.reason = reason;
            }

            @NotNull
            public final String getReason() {
                return this.reason;
            }

            @NotNull
            public final String component1() {
                return this.reason;
            }

            @NotNull
            public final Failure copy(@NotNull String reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                return new Failure(reason);
            }

            public static /* synthetic */ Failure copy$default(Failure failure, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = failure.reason;
                }
                return failure.copy(string);
            }

            @NotNull
            public String toString() {
                return "Failure(reason=" + this.reason + ")";
            }

            public int hashCode() {
                return this.reason.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Failure)) {
                    return false;
                }
                Failure failure = (Failure)other;
                return Intrinsics.areEqual((Object)this.reason, (Object)failure.reason);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0014\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0083\u0004J\n\u0010\u000f\u001a\u00020\u0010H\u00d6\u0081\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jarRepository/JarHttpDownloaderJps$CollectResult$Success;", "Lcom/intellij/jarRepository/JarHttpDownloaderJps$CollectResult;", "files", "", "Lcom/intellij/jarRepository/JarHttpDownloader$RelativePathToDownload;", "<init>", "(Ljava/util/List;)V", "getFiles", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.java.ui"})
        public static final class Success
        implements CollectResult {
            @NotNull
            private final List<JarHttpDownloader.RelativePathToDownload> files;

            public Success(@NotNull List<JarHttpDownloader.RelativePathToDownload> files) {
                Intrinsics.checkNotNullParameter(files, (String)"files");
                this.files = files;
            }

            @NotNull
            public final List<JarHttpDownloader.RelativePathToDownload> getFiles() {
                return this.files;
            }

            @NotNull
            public final List<JarHttpDownloader.RelativePathToDownload> component1() {
                return this.files;
            }

            @NotNull
            public final Success copy(@NotNull List<JarHttpDownloader.RelativePathToDownload> files) {
                Intrinsics.checkNotNullParameter(files, (String)"files");
                return new Success(files);
            }

            public static /* synthetic */ Success copy$default(Success success, List list2, int n, Object object) {
                if ((n & 1) != 0) {
                    list2 = success.files;
                }
                return success.copy(list2);
            }

            @NotNull
            public String toString() {
                return "Success(files=" + this.files + ")";
            }

            public int hashCode() {
                return ((Object)this.files).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success = (Success)other;
                return Intrinsics.areEqual(this.files, success.files);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u001a\u0010\r\u001a\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jarRepository/JarHttpDownloaderJps$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "enabled", "", "getInstance", "Lcom/intellij/jarRepository/JarHttpDownloaderJps;", "project", "Lcom/intellij/openapi/project/Project;", "collectRelativePathsForJarHttpDownloaderOrLog", "Lcom/intellij/jarRepository/JarHttpDownloaderJps$CollectResult;", "library", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "whyLibraryCouldNotBeDownloaded", "", "intellij.java.ui"})
    @SourceDebugExtension(value={"SMAP\nJarHttpDownloaderJps.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JarHttpDownloaderJps.kt\ncom/intellij/jarRepository/JarHttpDownloaderJps$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,260:1\n30#2,2:261\n1205#3,2:263\n1282#3,4:265\n1586#3:270\n1661#3,3:271\n1642#3,10:284\n1915#3:294\n296#3,2:295\n1916#3:298\n1652#3:299\n1#4:269\n1#4:297\n10574#5:274\n11007#5,2:275\n11705#5:277\n12052#5,3:278\n11009#5,3:281\n*S KotlinDebug\n*F\n+ 1 JarHttpDownloaderJps.kt\ncom/intellij/jarRepository/JarHttpDownloaderJps$Companion\n*L\n54#1:261,2\n70#1:263,2\n70#1:265,4\n89#1:270\n89#1:271,3\n92#1:284,10\n92#1:294\n102#1:295,2\n92#1:298\n92#1:299\n92#1:297\n91#1:274\n91#1:275,2\n91#1:277\n91#1:278,3\n91#1:281,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean enabled() {
            return Registry.Companion.is("jar.http.downloader.enabled");
        }

        @JvmStatic
        @NotNull
        public final JarHttpDownloaderJps getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<JarHttpDownloaderJps> serviceClass$iv = JarHttpDownloaderJps.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (JarHttpDownloaderJps)object;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final CollectResult collectRelativePathsForJarHttpDownloaderOrLog(Project project2, LibraryEx library) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$flatMapTo$iv$iv;
            void $this$mapTo$iv$iv;
            String string;
            Iterable it;
            Object[] objectArray;
            Object[] objectArray2;
            Object object;
            Project $this$associateTo$iv$iv;
            RepositoryLibraryProperties libraryProperties;
            if (!Intrinsics.areEqual((Object)library.getKind(), RepositoryLibraryType.REPOSITORY_LIBRARY_KIND)) {
                return new CollectResult.Failure("Library '" + library.getName() + "' is not a repository library");
            }
            LibraryProperties libraryProperties2 = library.getProperties();
            RepositoryLibraryProperties repositoryLibraryProperties = libraryProperties = libraryProperties2 instanceof RepositoryLibraryProperties ? (RepositoryLibraryProperties)libraryProperties2 : null;
            if (libraryProperties == null) {
                return new CollectResult.Failure("Library '" + library.getName() + "' has no repository library properties");
            }
            if (!RepositoryLibrarySynchronizerKt.isLibraryHasFixedVersion(libraryProperties)) {
                return new CollectResult.Failure("Library '" + library.getName() + "' does not have fixed version (version=" + libraryProperties.getVersion() + ")");
            }
            List list2 = libraryProperties.getArtifactsVerification();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getArtifactsVerification(...)");
            Iterable $this$associate$iv = list2;
            boolean bl = false;
            int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(n);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                object = destination$iv$iv;
                JpsMavenRepositoryLibraryDescriptor.ArtifactVerification it2 = (JpsMavenRepositoryLibraryDescriptor.ArtifactVerification)element$iv$iv;
                boolean bl2 = false;
                it2 = TuplesKt.to((Object)it2.getUrl(), (Object)it2);
                object.put(it2.getFirst(), it2.getSecond());
            }
            Map verification = destination$iv$iv;
            Object[] objectArray3 = objectArray2 = new String[4];
            int n2 = 0;
            Project project3 = project2;
            if (project3 != null) {
                $this$associateTo$iv$iv = project3;
                int n3 = n2;
                objectArray = objectArray3;
                boolean bl3 = false;
                String string2 = ((Object)JarRepositoryManager.getJPSLocalMavenRepositoryForIdeaProject((Project)it)).toString();
                objectArray3 = objectArray;
                n2 = n3;
                string = string2;
            } else {
                string = null;
            }
            objectArray3[n2] = string;
            objectArray2[1] = JarRepositoryManager.getLocalRepositoryPath().getPath();
            objectArray2[2] = PathMacroManager.getInstance((ComponentManager)((ComponentManager)ApplicationManager.getApplication())).expandPath("$MAVEN_REPOSITORY$");
            objectArray2[3] = JpsMavenSettings.getMavenRepositoryPath();
            Iterable iterable2 = CollectionsKt.listOfNotNull((Object[])objectArray2);
            boolean bl4 = false;
            it = iterable2;
            Object[] destination$iv$iv2 = (Object[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                object = (String)item$iv$iv;
                objectArray = destination$iv$iv2;
                boolean bl5 = false;
                objectArray.add(Path.of(FileUtil.toSystemDependentName((String)it3), new String[0]).normalize());
            }
            List possibleMavenLocalRepositoryRoots = (List)destination$iv$iv2;
            OrderRootType[] orderRootTypeArray = OrderRootType.getAllTypes();
            Intrinsics.checkNotNullExpressionValue((Object)orderRootTypeArray, (String)"getAllTypes(...)");
            Object[] objectArray4 = orderRootTypeArray;
            boolean $i$f$flatMap = false;
            destination$iv$iv2 = objectArray4;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (void element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                OrderRootType rootType = (OrderRootType)element$iv$iv;
                boolean bl6 = false;
                String[] stringArray = library.getUrls(rootType);
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getUrls(...)");
                Object[] $this$map$iv = stringArray;
                boolean $i$f$map = false;
                Object[] objectArray5 = $this$map$iv;
                Collection destination$iv$iv4 = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo2 = false;
                for (void item$iv$iv : $this$mapTo$iv$iv2) {
                    void it4;
                    String string3 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv4;
                    boolean bl7 = false;
                    collection.add(TuplesKt.to((Object)rootType, (Object)it4));
                }
                Iterable list$iv$iv = (List)destination$iv$iv4;
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            Iterable iterable3 = (List)destination$iv$iv3;
            boolean $i$f$mapNotNull = false;
            $this$flatMapTo$iv$iv = iterable3;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                JarHttpDownloader.RelativePathToDownload relativePathToDownload;
                Object v8;
                Path path;
                OrderRootType rootType;
                block17: {
                    String urlToPath;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl8 = false;
                    Pair pair = (Pair)element$iv$iv;
                    boolean bl9 = false;
                    rootType = (OrderRootType)pair.component1();
                    String url = (String)pair.component2();
                    Intrinsics.checkNotNullExpressionValue((Object)VfsUtil.urlToPath((String)url), (String)"urlToPath(...)");
                    if (Intrinsics.areEqual((Object)urlToPath, (Object)url)) {
                        return new CollectResult.Failure("Library '" + library.getName() + "': root '" + url + "' could not be converted to path");
                    }
                    String independentPath = StringsKt.removeSuffix((String)urlToPath, (CharSequence)"!/");
                    path = Path.of(FileUtil.toSystemDependentName((String)independentPath), new String[0]).normalize();
                    Iterable $this$firstOrNull$iv = possibleMavenLocalRepositoryRoots;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Path it5 = (Path)element$iv;
                        boolean bl10 = false;
                        if (!path.startsWith(it5)) continue;
                        v8 = element$iv;
                        break block17;
                    }
                    v8 = null;
                }
                Path prefix = v8;
                if (prefix == null) {
                    if (!Intrinsics.areEqual((Object)rootType, (Object)AnnotationOrderRootType.getInstance())) return new CollectResult.Failure("Library '" + library.getName() + "': root path '" + path + "' does not belong to local maven repository cache (" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)possibleMavenLocalRepositoryRoots), (CharSequence)", ", null, null, (int)0, null, Companion::collectRelativePathsForJarHttpDownloaderOrLog$lambda$4$1, (int)30, null) + ").)");
                    Intrinsics.checkNotNull((Object)path);
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return new CollectResult.Failure("Library '" + library.getName() + "': root path '" + path + "' does not belong to local maven repository cache (" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)possibleMavenLocalRepositoryRoots), (CharSequence)", ", null, null, (int)0, null, Companion::collectRelativePathsForJarHttpDownloaderOrLog$lambda$4$1, (int)30, null) + ").)");
                    relativePathToDownload = null;
                } else {
                    String string4;
                    Intrinsics.checkNotNull((Object)path);
                    Path relativePath = PathsKt.relativeTo((Path)path, (Path)prefix);
                    if (libraryProperties.isEnableSha256Checksum()) {
                        String sha256;
                        String fileUrl;
                        Intrinsics.checkNotNullExpressionValue((Object)VfsUtil.pathToUrl((String)((Object)path).toString()), (String)"pathToUrl(...)");
                        JpsMavenRepositoryLibraryDescriptor.ArtifactVerification artifactVerification = (JpsMavenRepositoryLibraryDescriptor.ArtifactVerification)verification.get(fileUrl);
                        String string5 = sha256 = artifactVerification != null ? artifactVerification.getSha256sum() : null;
                        if (sha256 == null && Intrinsics.areEqual((Object)rootType, (Object)OrderRootType.CLASSES)) {
                            throw new IllegalStateException(("Library '" + library.getName() + "': SHA-256 checksum is not specified for url '" + fileUrl + "' in library '" + library.getName() + "'.\nAvailable checksums:\n" + CollectionsKt.joinToString$default((Iterable)verification.entrySet(), (CharSequence)"\n", null, null, (int)0, null, Companion::collectRelativePathsForJarHttpDownloaderOrLog$lambda$4$2, (int)30, null)).toString());
                        }
                        string4 = sha256;
                    } else {
                        string4 = null;
                    }
                    String sha256 = string4;
                    relativePathToDownload = new JarHttpDownloader.RelativePathToDownload(relativePath, sha256);
                }
                if (relativePathToDownload == null) continue;
                JarHttpDownloader.RelativePathToDownload it$iv$iv = relativePathToDownload;
                boolean bl11 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            List list3 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv3));
            if (!list3.isEmpty()) return new CollectResult.Success(list3);
            return new CollectResult.Failure("Library '" + library.getName() + "': no roots (files) to download");
        }

        @TestOnly
        @Nullable
        public final String whyLibraryCouldNotBeDownloaded(@NotNull LibraryEx library) {
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            CollectResult result = this.collectRelativePathsForJarHttpDownloaderOrLog(null, library);
            return result instanceof CollectResult.Failure ? ((CollectResult.Failure)result).getReason() : null;
        }

        private static final CharSequence collectRelativePathsForJarHttpDownloaderOrLog$lambda$4$1(Path it) {
            return "'" + it + "'";
        }

        private static final CharSequence collectRelativePathsForJarHttpDownloaderOrLog$lambda$4$2(Map.Entry it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return "  " + it.getKey() + " -> " + ((JpsMavenRepositoryLibraryDescriptor.ArtifactVerification)it.getValue()).getSha256sum();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

