/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository.settings;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryPropertiesEntity;
import com.intellij.platform.workspace.jps.entities.LibraryPropertiesEntityBuilder;
import com.intellij.platform.workspace.jps.entities.LibraryPropertiesEntityModifications;
import com.intellij.platform.workspace.jps.entities.LibraryTypeId;
import com.intellij.platform.workspace.jps.entities.Library_extensionsKt;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.util.xmlb.DomAdapter;
import com.intellij.util.xmlb.JdomAdapter;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0000\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\tH\u0000\u001a\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0000\u001a$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\tH\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "countBindLibraries", "", "storage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "jarRepositoryIds", "", "", "remoteRepository", "Lcom/intellij/jarRepository/RemoteRepositoryDescription;", "updateLibrariesRepositoryId", "", "builder", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "fromJarRepositoryIds", "toJarRepositoryId", "fromJarRepository", "getUsagesInLibraryProperties", "", "Lcom/intellij/platform/workspace/jps/entities/LibraryPropertiesEntity;", "deserializeRepositoryLibraryProperties", "Lorg/jetbrains/idea/maven/utils/library/RepositoryLibraryProperties;", "xmlTag", "intellij.java.ui"})
@JvmName(name="JarRepositoryLibraryBindUtils")
@SourceDebugExtension(value={"SMAP\njarRepositoryLibraryBindUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 jarRepositoryLibraryBindUtils.kt\ncom/intellij/jarRepository/settings/JarRepositoryLibraryBindUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 xmlSerializer.kt\ncom/intellij/configurationStore/XmlSerializer\n*L\n1#1,90:1\n1915#2,2:91\n29#3:93\n*S KotlinDebug\n*F\n+ 1 jarRepositoryLibraryBindUtils.kt\ncom/intellij/jarRepository/settings/JarRepositoryLibraryBindUtils\n*L\n44#1:91,2\n89#1:93\n*E\n"})
public final class JarRepositoryLibraryBindUtils {
    @NotNull
    private static final Logger LOG;

    public static final int countBindLibraries(@NotNull EntityStorage storage, @NotNull Set<String> jarRepositoryIds) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter(jarRepositoryIds, (String)"jarRepositoryIds");
        return JarRepositoryLibraryBindUtils.getUsagesInLibraryProperties(storage, jarRepositoryIds).size();
    }

    public static final int countBindLibraries(@NotNull EntityStorage storage, @NotNull RemoteRepositoryDescription remoteRepository) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)remoteRepository, (String)"remoteRepository");
        return JarRepositoryLibraryBindUtils.getUsagesInLibraryProperties(storage, SetsKt.setOf((Object)remoteRepository.getId())).size();
    }

    public static final void updateLibrariesRepositoryId(@NotNull MutableEntityStorage builder, @NotNull Set<String> fromJarRepositoryIds, @Nullable String toJarRepositoryId) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(fromJarRepositoryIds, (String)"fromJarRepositoryIds");
        Iterable $this$forEach$iv = JarRepositoryLibraryBindUtils.getUsagesInLibraryProperties((EntityStorage)builder, fromJarRepositoryIds);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            LibraryPropertiesEntity entity = (LibraryPropertiesEntity)element$iv;
            boolean bl = false;
            try {
                String string2 = entity.getPropertiesXmlTag();
                Intrinsics.checkNotNull((Object)string2);
                RepositoryLibraryProperties libraryProperties = JarRepositoryLibraryBindUtils.deserializeRepositoryLibraryProperties(string2);
                libraryProperties.setJarRepositoryId(toJarRepositoryId);
                Element element = XmlSerializer.serialize$default((Object)libraryProperties, null, (boolean)false, (int)6, null);
                Intrinsics.checkNotNull((Object)element);
                Element element2 = element.setName("properties");
                string = JDOMUtil.writeElement((Element)element2);
            }
            catch (Exception e) {
                LOG.warnInProduction((Throwable)e);
                continue;
            }
            String string3 = string;
            Intrinsics.checkNotNull((Object)string3);
            String newXmlTag = string3;
            LibraryPropertiesEntityModifications.modifyLibraryPropertiesEntity((MutableEntityStorage)builder, (LibraryPropertiesEntity)entity, arg_0 -> JarRepositoryLibraryBindUtils.updateLibrariesRepositoryId$lambda$0$0(newXmlTag, arg_0));
        }
    }

    public static final void updateLibrariesRepositoryId(@NotNull MutableEntityStorage builder, @NotNull RemoteRepositoryDescription fromJarRepository, @Nullable RemoteRepositoryDescription toJarRepositoryId) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)fromJarRepository, (String)"fromJarRepository");
        RemoteRepositoryDescription remoteRepositoryDescription = toJarRepositoryId;
        JarRepositoryLibraryBindUtils.updateLibrariesRepositoryId(builder, SetsKt.setOf((Object)fromJarRepository.getId()), remoteRepositoryDescription != null ? remoteRepositoryDescription.getId() : null);
    }

    private static final List<LibraryPropertiesEntity> getUsagesInLibraryProperties(EntityStorage storage, Set<String> jarRepositoryIds) {
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)storage.entities(LibraryEntity.class), arg_0 -> JarRepositoryLibraryBindUtils.getUsagesInLibraryProperties$lambda$0(jarRepositoryIds, arg_0)));
    }

    private static final RepositoryLibraryProperties deserializeRepositoryLibraryProperties(String xmlTag) {
        Element element = JDOMUtil.load((CharSequence)xmlTag);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
        Element element$iv = element;
        boolean $i$f$deserialize = false;
        return (RepositoryLibraryProperties)XmlSerializer.getJdomSerializer().deserialize((Object)element$iv, RepositoryLibraryProperties.class, (DomAdapter)JdomAdapter.INSTANCE);
    }

    private static final Unit updateLibrariesRepositoryId$lambda$0$0(String $newXmlTag, LibraryPropertiesEntityBuilder $this$modifyLibraryPropertiesEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyLibraryPropertiesEntity, (String)"$this$modifyLibraryPropertiesEntity");
        $this$modifyLibraryPropertiesEntity.setPropertiesXmlTag($newXmlTag);
        return Unit.INSTANCE;
    }

    private static final LibraryPropertiesEntity getUsagesInLibraryProperties$lambda$0(Set $jarRepositoryIds, LibraryEntity libraryEntity) {
        Intrinsics.checkNotNullParameter((Object)libraryEntity, (String)"libraryEntity");
        LibraryPropertiesEntity libraryPropertiesEntity = Library_extensionsKt.getLibraryProperties((LibraryEntity)libraryEntity);
        if (libraryPropertiesEntity == null) {
            return null;
        }
        LibraryPropertiesEntity propertiesEntity = libraryPropertiesEntity;
        LibraryTypeId libraryTypeId = libraryEntity.getTypeId();
        if (!Intrinsics.areEqual((Object)RepositoryLibraryType.REPOSITORY_LIBRARY_KIND.getKindId(), (Object)(libraryTypeId != null ? libraryTypeId.getName() : null))) {
            return null;
        }
        String string = propertiesEntity.getPropertiesXmlTag();
        if (string == null) {
            return null;
        }
        String propertiesXmlTag = string;
        RepositoryLibraryProperties properties = JarRepositoryLibraryBindUtils.deserializeRepositoryLibraryProperties(propertiesXmlTag);
        if (!$jarRepositoryIds.contains(properties.getJarRepositoryId())) {
            return null;
        }
        return propertiesEntity;
    }

    static {
        Logger logger = Logger.getInstance((String)"com.intellij.jarRepository.settings.JarRepositoryLibraryBindUtils");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

