/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository.settings;

import com.google.common.base.Strings;
import com.intellij.CommonBundle;
import com.intellij.DynamicBundle;
import com.intellij.ide.JavaUiBundle;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryLibrarySettings;
import com.intellij.jarRepository.settings.DependencyExclusionEditor;
import com.intellij.jarRepository.settings.VersionItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.aether.ArtifactDependencyNode;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.propertiesEditor.RepositoryLibraryPropertiesModel;

public final class RepositoryLibraryPropertiesEditor {
    private static final Logger LOG = Logger.getInstance(RepositoryLibraryPropertiesEditor.class);
    @NotNull
    private final Project project;
    State currentState;
    List<String> versions;
    private final RepositoryLibraryPropertiesModel initialModel;
    private final RepositoryLibraryPropertiesModel model;
    private final RepositoryLibraryDescription repositoryLibraryDescription;
    private ComboBox<VersionItem> versionSelector;
    private JPanel mainPanel;
    private JButton myReloadButton;
    private JBCheckBox downloadSourcesCheckBox;
    private JBCheckBox downloadJavaDocsCheckBox;
    private JBCheckBox downloadAnnotationsCheckBox;
    private JBLabel mavenCoordinates;
    private final ThreeStateCheckBox myIncludeTransitiveDepsCheckBox;
    private JPanel myPropertiesPanel;
    private JPanel myTransitiveDependenciesPanel;
    private ComboBox<RemoteRepositoryDescription> myRemoteRepositoryComboBox;
    private JPanel myRemoteRepositoryOptionsPanel;
    @NotNull
    private final ModelChangeListener onChangeListener;
    private final ActionLink myManageDependenciesLink;

    public RepositoryLibraryPropertiesEditor(@Nullable Project project2, RepositoryLibraryPropertiesModel model, RepositoryLibraryDescription description, boolean globalLibrary) {
        this(project2, model, description, true, new ModelChangeListener(){

            @Override
            public void onChange(@NotNull RepositoryLibraryPropertiesEditor editor) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/jarRepository/settings/RepositoryLibraryPropertiesEditor$1", "onChange"));
            }
        }, globalLibrary);
    }

    public RepositoryLibraryPropertiesEditor(@Nullable Project project2, final RepositoryLibraryPropertiesModel model, RepositoryLibraryDescription description, boolean allowExcludingTransitiveDependencies, final @NotNull ModelChangeListener onChangeListener, boolean globalLibrary) {
        if (onChangeListener == null) {
            RepositoryLibraryPropertiesEditor.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.initialModel = model.clone();
        this.model = model;
        this.project = project2 == null ? ProjectManager.getInstance().getDefaultProject() : project2;
        this.repositoryLibraryDescription = description;
        this.mavenCoordinates.setCopyable(true);
        this.myIncludeTransitiveDepsCheckBox = new ThreeStateCheckBox(UIUtil.replaceMnemonicAmpersand((String)JavaUiBundle.message("repository.library.properties.include.transitive.dependencies", new Object[0])));
        this.myIncludeTransitiveDepsCheckBox.setThirdStateEnabled(false);
        this.myTransitiveDependenciesPanel.add((Component)this.myIncludeTransitiveDepsCheckBox);
        this.myManageDependenciesLink = new ActionLink(CommonBundle.message((String)"action.text.configure.ellipsis", (Object[])new Object[0]), e -> this.configureTransitiveDependencies());
        this.myManageDependenciesLink.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        this.myTransitiveDependenciesPanel.add((Component)this.myManageDependenciesLink);
        this.myTransitiveDependenciesPanel.setVisible(allowExcludingTransitiveDependencies);
        if (globalLibrary) {
            this.myRemoteRepositoryOptionsPanel.setVisible(false);
        } else {
            RepositoryLibrarySettings intSettings = RepositoryLibrarySettings.getInstanceOrDefaults(project2);
            this.myRemoteRepositoryOptionsPanel.setVisible(intSettings.isBindJarRepositoryUiSettingsDisplayed());
        }
        this.myRemoteRepositoryComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)JavaUiBundle.message("repository.library.bind.repository.not.selected", new Object[0]), RemoteRepositoryDescription::getUrl));
        this.myRemoteRepositoryComboBox.setModel(model.getRemoteRepositoryModel());
        this.myRemoteRepositoryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoryLibraryPropertiesEditor.this.reloadVersionsAsync();
            }
        });
        this.myReloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoryLibraryPropertiesEditor.this.reloadVersionsAsync();
            }
        });
        this.onChangeListener = new ModelChangeListener(){

            @Override
            public void onChange(@NotNull RepositoryLibraryPropertiesEditor editor) {
                if (editor == null) {
                    4.$$$reportNull$$$0(0);
                }
                onChangeListener.onChange(editor);
                RepositoryLibraryPropertiesEditor.this.mavenCoordinates.setText(RepositoryLibraryPropertiesEditor.this.repositoryLibraryDescription.getMavenCoordinates(model.getVersion()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/jarRepository/settings/RepositoryLibraryPropertiesEditor$4", "onChange"));
            }
        };
        this.versionSelector.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", VersionItem::getDisplayName));
        this.updateManageDependenciesLink();
        this.reloadVersionsAsync();
    }

    private void configureTransitiveDependencies() {
        String selectedVersion = this.getSelectedVersion();
        LOG.assertTrue(selectedVersion != null);
        ArtifactDependencyNode root = JarRepositoryManager.loadDependenciesTree(this.repositoryLibraryDescription, selectedVersion, this.project);
        if (root == null) {
            return;
        }
        Set<String> dependencies = new DependencyExclusionEditor(root, this.mainPanel).selectExcludedDependencies(this.model.getExcludedDependencies());
        if (dependencies != null) {
            this.model.setExcludedDependencies(dependencies);
            this.updateIncludeTransitiveDepsCheckBoxState();
            this.onChangeListener.onChange(this);
        }
    }

    private static VersionItem toVersionItem(String version) {
        if (Strings.isNullOrEmpty((String)version)) {
            return null;
        }
        if (version.equals("RELEASE")) {
            return VersionItem.LatestRelease.INSTANCE;
        }
        if (version.equals("LATEST")) {
            return VersionItem.LatestVersion.INSTANCE;
        }
        return new VersionItem.ExactVersion(version);
    }

    private void setState(State state) {
        this.currentState = state;
        ((CardLayout)this.myPropertiesPanel.getLayout()).show(this.myPropertiesPanel, state.name());
        this.onChangeListener.onChange(this);
    }

    private void reloadVersionsAsync() {
        this.setState(State.Loading);
        RemoteRepositoryDescription selectedRemoteRepository = this.model.getRemoteRepository();
        Promise<Collection<String>> promise2 = selectedRemoteRepository != null ? JarRepositoryManager.getAvailableVersions(this.project, this.repositoryLibraryDescription, List.of(selectedRemoteRepository)) : JarRepositoryManager.getAvailableVersions(this.project, this.repositoryLibraryDescription);
        promise2.onSuccess(result -> this.versionsLoaded(new ArrayList<String>((Collection<String>)result)));
    }

    private void initVersionsPanel() {
        CollectionComboBoxModel versionSelectorModel = new CollectionComboBoxModel();
        versionSelectorModel.add((Object)VersionItem.LatestRelease.INSTANCE);
        versionSelectorModel.add((Object)VersionItem.LatestVersion.INSTANCE);
        versionSelectorModel.add(ContainerUtil.map(this.versions, VersionItem.ExactVersion::new));
        this.versionSelector.setModel((ComboBoxModel)versionSelectorModel);
        this.versionSelector.setSelectedItem((Object)RepositoryLibraryPropertiesEditor.toVersionItem(this.model.getVersion()));
        this.setState(State.Loaded);
        this.versionSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RepositoryLibraryPropertiesEditor.this.model.setVersion(RepositoryLibraryPropertiesEditor.this.getSelectedVersion());
                RepositoryLibraryPropertiesEditor.this.onChangeListener.onChange(RepositoryLibraryPropertiesEditor.this);
                RepositoryLibraryPropertiesEditor.this.updateManageDependenciesLink();
            }
        });
        this.downloadSourcesCheckBox.setSelected(this.model.isDownloadSources());
        this.downloadSourcesCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RepositoryLibraryPropertiesEditor.this.model.setDownloadSources(RepositoryLibraryPropertiesEditor.this.downloadSourcesCheckBox.isSelected());
                RepositoryLibraryPropertiesEditor.this.onChangeListener.onChange(RepositoryLibraryPropertiesEditor.this);
            }
        });
        this.downloadJavaDocsCheckBox.setSelected(this.model.isDownloadJavaDocs());
        this.downloadJavaDocsCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RepositoryLibraryPropertiesEditor.this.model.setDownloadJavaDocs(RepositoryLibraryPropertiesEditor.this.downloadJavaDocsCheckBox.isSelected());
                RepositoryLibraryPropertiesEditor.this.onChangeListener.onChange(RepositoryLibraryPropertiesEditor.this);
            }
        });
        this.downloadAnnotationsCheckBox.setSelected(this.model.isDownloadAnnotations());
        this.downloadAnnotationsCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RepositoryLibraryPropertiesEditor.this.model.setDownloadAnnotations(RepositoryLibraryPropertiesEditor.this.downloadAnnotationsCheckBox.isSelected());
                RepositoryLibraryPropertiesEditor.this.onChangeListener.onChange(RepositoryLibraryPropertiesEditor.this);
            }
        });
        this.updateIncludeTransitiveDepsCheckBoxState();
        this.myIncludeTransitiveDepsCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RepositoryLibraryPropertiesEditor.this.updateManageDependenciesLink();
                ThreeStateCheckBox.State state = RepositoryLibraryPropertiesEditor.this.myIncludeTransitiveDepsCheckBox.getState();
                if (state != ThreeStateCheckBox.State.DONT_CARE) {
                    RepositoryLibraryPropertiesEditor.this.model.setExcludedDependencies(Collections.emptyList());
                }
                RepositoryLibraryPropertiesEditor.this.model.setIncludeTransitiveDependencies(state != ThreeStateCheckBox.State.NOT_SELECTED);
                RepositoryLibraryPropertiesEditor.this.onChangeListener.onChange(RepositoryLibraryPropertiesEditor.this);
            }
        });
        this.updateManageDependenciesLink();
    }

    private void updateIncludeTransitiveDepsCheckBoxState() {
        this.myIncludeTransitiveDepsCheckBox.setState(!this.model.isIncludeTransitiveDependencies() ? ThreeStateCheckBox.State.NOT_SELECTED : (this.model.getExcludedDependencies().isEmpty() ? ThreeStateCheckBox.State.SELECTED : ThreeStateCheckBox.State.DONT_CARE));
    }

    private void updateManageDependenciesLink() {
        boolean enable = this.myIncludeTransitiveDepsCheckBox.getState() != ThreeStateCheckBox.State.NOT_SELECTED && this.getSelectedVersion() != null;
        this.myManageDependenciesLink.setEnabled(enable);
    }

    private void versionsLoaded(@NotNull List<String> versions) {
        if (versions == null) {
            RepositoryLibraryPropertiesEditor.$$$reportNull$$$0(1);
        }
        this.versions = versions;
        if (versions.isEmpty()) {
            this.versionsFailedToLoad();
            return;
        }
        ApplicationManager.getApplication().invokeLater(this::initVersionsPanel, ModalityState.any());
    }

    private void versionsFailedToLoad() {
        ApplicationManager.getApplication().invokeLater(() -> this.setState(State.FailedToLoad), ModalityState.any());
    }

    @Nullable
    public String getSelectedVersion() {
        VersionItem selectedItem = (VersionItem)this.versionSelector.getSelectedItem();
        return selectedItem != null ? selectedItem.getVersionId() : null;
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public boolean isValid() {
        return this.currentState == State.Loaded;
    }

    public boolean hasChanges() {
        return !this.model.equals(this.initialModel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChangeListener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versions";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jarRepository/settings/RepositoryLibraryPropertiesEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "versionsLoaded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JPanel jPanel;
        JButton jButton;
        JBCheckBox jBCheckBox;
        JPanel jPanel2;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        ComboBox comboBox2;
        JPanel jPanel3;
        JBLabel jBLabel;
        JPanel jPanel4;
        this.mainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.setMinimumSize(new Dimension(400, 128));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/JavaUiBundle", RepositoryLibraryPropertiesEditor.class).getString("label.maven"));
        jPanel5.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mavenCoordinates = jBLabel = new JBLabel();
        jBLabel.setOpaque(false);
        jBLabel.setRequestFocusEnabled(true);
        jBLabel.setText("");
        jPanel5.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myPropertiesPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new CardLayout(0, 0));
        jPanel4.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, "Loaded");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel7.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/JavaUiBundle", RepositoryLibraryPropertiesEditor.class).getString("label.version"));
        jPanel7.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.versionSelector = comboBox2 = new ComboBox();
        jPanel7.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel6.add((Component)spacer4, new GridConstraints(2, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel8, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.downloadSourcesCheckBox = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setLabel(DynamicBundle.getBundle((String)"messages/JavaUiBundle", RepositoryLibraryPropertiesEditor.class).getString("download.sources"));
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/JavaUiBundle", RepositoryLibraryPropertiesEditor.class).getString("checkbox.download.sources"));
        jPanel8.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel8.add((Component)spacer5, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.downloadJavaDocsCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setLabel(DynamicBundle.getBundle((String)"messages/JavaUiBundle", RepositoryLibraryPropertiesEditor.class).getString("download.javadocs"));
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/JavaUiBundle", RepositoryLibraryPropertiesEditor.class).getString("checkbox.download.javadocs2"));
        jPanel8.add((Component)jBCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTransitiveDependenciesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jPanel8.add((Component)jPanel2, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.downloadAnnotationsCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/JavaUiBundle", RepositoryLibraryPropertiesEditor.class).getString("checkbox.download.annotations"));
        jPanel8.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel9, "Loading");
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setInheritsPopupMenu(true);
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/JavaUiBundle", RepositoryLibraryPropertiesEditor.class).getString("label.loading.available.versions"));
        jPanel9.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel9.add((Component)spacer6, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel9.add((Component)spacer7, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel10, "FailedToLoad");
        JBLabel jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, DynamicBundle.getBundle((String)"messages/JavaUiBundle", RepositoryLibraryPropertiesEditor.class).getString("label.failed.to.load.versions"));
        jPanel10.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel10.add((Component)spacer8, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myReloadButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/JavaUiBundle", RepositoryLibraryPropertiesEditor.class).getString("button.reload"));
        jPanel10.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer9 = new Spacer();
        jPanel10.add((Component)spacer9, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myRemoteRepositoryOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myRemoteRepositoryComboBox = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(0, 0, 1, 1, 0, 1, 2, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel6.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel6, DynamicBundle.getBundle((String)"messages/JavaUiBundle", RepositoryLibraryPropertiesEditor.class).getString("label.bind.remote.repository"));
        jPanel.add((Component)jBLabel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jBLabel4.setLabelFor((Component)comboBox2);
        jBLabel6.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static interface ModelChangeListener {
        public void onChange(@NotNull RepositoryLibraryPropertiesEditor var1);
    }

    private static enum State {
        Loading,
        FailedToLoad,
        Loaded;

    }
}

