/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.actions.ImportModuleAction;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.autolink.ExternalSystemUnlinkedProjectAware;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.wizard.AbstractExternalProjectImportProvider;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.function.Predicate;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;

public final class AttachExternalProjectAction
extends DumbAwareAction {
    public AttachExternalProjectAction() {
        this.getTemplatePresentation().setText(JavaUiBundle.messagePointer("action.attach.external.project.text", "External"));
        this.getTemplatePresentation().setDescription(JavaUiBundle.messagePointer("action.attach.external.project.description", "external"));
        this.getTemplatePresentation().setIcon(AllIcons.General.Add);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AttachExternalProjectAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        ProjectSystemId externalSystemId = (ProjectSystemId)e.getData(ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID);
        if (externalSystemId != null) {
            String name = externalSystemId.getReadableName();
            presentation.setText(JavaUiBundle.messagePointer("action.attach.external.project.text", name));
            presentation.setDescription(JavaUiBundle.messagePointer("action.attach.external.project.description", name));
        }
        presentation.setIcon(AllIcons.General.Add);
        presentation.setEnabledAndVisible(externalSystemId != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AttachExternalProjectAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ProjectSystemId externalSystemId;
        if (e == null) {
            AttachExternalProjectAction.$$$reportNull$$$0(2);
        }
        if ((externalSystemId = (ProjectSystemId)e.getData(ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID)) == null) {
            return;
        }
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        if (manager == null) {
            return;
        }
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        ExternalSystemActionsCollector.trigger((Project)project2, (ProjectSystemId)externalSystemId, (AnAction)this, (AnActionEvent)e);
        ProjectImportProvider projectImportProvider = (ProjectImportProvider)ProjectImportProvider.PROJECT_IMPORT_PROVIDER.findFirstSafe(it -> it instanceof AbstractExternalProjectImportProvider && externalSystemId.equals((Object)((AbstractExternalProjectImportProvider)it).getExternalSystemId()));
        if (projectImportProvider == null) {
            return;
        }
        ImportModuleAction.doImport(project2, (Function0<? extends AbstractProjectWizard>)((Function0)() -> ImportModuleAction.selectFileAndCreateWizard(project2, null, AttachExternalProjectAction.getFileChooserDescriptor(manager, project2, externalSystemId), AttachExternalProjectAction.getSelectedFileValidator(project2, externalSystemId), projectImportProvider)));
    }

    private static FileChooserDescriptor getFileChooserDescriptor(@NotNull ExternalSystemManager<?, ?, ?, ?, ?> manager, @NotNull Project project2, @NotNull ProjectSystemId externalSystemId) {
        ExternalSystemUnlinkedProjectAware unlinkedProjectAware;
        if (manager == null) {
            AttachExternalProjectAction.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            AttachExternalProjectAction.$$$reportNull$$$0(4);
        }
        if (externalSystemId == null) {
            AttachExternalProjectAction.$$$reportNull$$$0(5);
        }
        if ((unlinkedProjectAware = ExternalSystemUnlinkedProjectAware.getInstance((ProjectSystemId)externalSystemId)) == null) {
            return manager.getExternalProjectDescriptor();
        }
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor().withFileFilter(file -> unlinkedProjectAware.isBuildFile(project2, file));
        String[] extensions = unlinkedProjectAware.buildFileExtensions();
        return extensions.length == 0 ? descriptor : descriptor.withExtensionFilter(IdeCoreBundle.message((String)"file.chooser.files.label", (Object[])new Object[]{unlinkedProjectAware.getSystemId().getReadableName()}), extensions);
    }

    private static Predicate<VirtualFile> getSelectedFileValidator(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId) {
        ExternalSystemUnlinkedProjectAware unlinkedProjectAware;
        if (project2 == null) {
            AttachExternalProjectAction.$$$reportNull$$$0(6);
        }
        if (externalSystemId == null) {
            AttachExternalProjectAction.$$$reportNull$$$0(7);
        }
        if ((unlinkedProjectAware = ExternalSystemUnlinkedProjectAware.getInstance((ProjectSystemId)externalSystemId)) == null) {
            return __ -> true;
        }
        Predicate<VirtualFile> isSelectedFile = virtualFile -> virtualFile.isDirectory() ? ContainerUtil.exists((Object[])virtualFile.getChildren(), it -> unlinkedProjectAware.isBuildFile(project2, it)) : unlinkedProjectAware.isBuildFile(project2, virtualFile);
        return virtualFile -> {
            if (!isSelectedFile.test((VirtualFile)virtualFile)) {
                String name = externalSystemId.getReadableName();
                String projectPath = UiUtils.getPresentablePath((String)virtualFile.getPath());
                String message = virtualFile.isDirectory() ? JavaUiBundle.message("action.attach.external.project.warning.message.directory", projectPath, name) : JavaUiBundle.message("action.attach.external.project.warning.message.file", projectPath, name);
                String title = JavaUiBundle.message("action.attach.external.project.warning.title", name);
                Messages.showWarningDialog((Project)project2, (String)message, (String)title);
                return false;
            }
            return true;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/action/AttachExternalProjectAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/action/AttachExternalProjectAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileChooserDescriptor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedFileValidator";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

