/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.wizard;

import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.internal.InternalExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.IdeUIModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.settings.AbstractImportFromExternalSystemControl;
import com.intellij.openapi.externalSystem.service.ui.ExternalProjectDataSelectorDialog;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.util.SmartList;
import com.intellij.workspaceModel.ide.ProjectRootEntityKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalProjectImportBuilder<C extends AbstractImportFromExternalSystemControl>
extends ProjectImportBuilder<DataNode<ProjectData>> {
    private static final Logger LOG = Logger.getInstance(AbstractExternalProjectImportBuilder.class);
    @NotNull
    private final ProjectDataManager myProjectDataManager;
    @NotNull
    private final NotNullLazyValue<C> myControlValue;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    private DataNode<ProjectData> myExternalProjectNode;

    public AbstractExternalProjectImportBuilder(@NotNull ProjectDataManager projectDataManager, @NotNull NotNullFactory<? extends C> controlFactory, @NotNull ProjectSystemId externalSystemId) {
        if (projectDataManager == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(0);
        }
        if (controlFactory == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(1);
        }
        if (externalSystemId == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(2);
        }
        this.myProjectDataManager = projectDataManager;
        this.myControlValue = NotNullLazyValue.createValue(controlFactory);
        this.myExternalSystemId = externalSystemId;
    }

    @Override
    public List<DataNode<ProjectData>> getList() {
        return Collections.singletonList(this.myExternalProjectNode);
    }

    @Override
    public boolean isMarked(DataNode<ProjectData> element) {
        return true;
    }

    @Override
    public void setOpenProjectSettingsAfter(boolean on) {
    }

    @NotNull
    public C getControl(@Nullable Project currentProject) {
        C control = this.getControl();
        ((AbstractImportFromExternalSystemControl)((Object)control)).setCurrentProject(currentProject);
        C c = control;
        if (c == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(3);
        }
        return c;
    }

    public void prepare(@NotNull WizardContext context) {
        if (context == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(4);
        }
        if (context.getProjectJdk() == null) {
            context.setProjectJdk(this.resolveProjectJdk(context));
        }
        C control = this.getControl();
        ((AbstractImportFromExternalSystemControl)((Object)control)).setShowProjectFormatPanel(context.isCreatingNewProject());
        ((AbstractImportFromExternalSystemControl)((Object)control)).reset(context, null);
        String pathToUse = this.getFileToImport();
        ((AbstractImportFromExternalSystemControl)((Object)control)).setLinkedProjectPath(pathToUse);
        this.doPrepare(context);
    }

    @Nullable
    protected Sdk resolveProjectJdk(@NotNull WizardContext context) {
        if (context == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(5);
        }
        Project project2 = context.getProject() != null ? context.getProject() : ProjectManager.getInstance().getDefaultProject();
        Pair sdkPair = ExternalSystemJdkUtil.getAvailableJdk((Project)project2);
        if (!"#JAVA_INTERNAL".equals(sdkPair.first)) {
            return (Sdk)sdkPair.second;
        }
        return null;
    }

    protected abstract void doPrepare(@NotNull WizardContext var1);

    @Override
    public List<Module> commit(Project project2, ModifiableModuleModel model, ModulesProvider modulesProvider, ModifiableArtifactModel artifactModel) {
        project2.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)Boolean.TRUE);
        DataNode<ProjectData> externalProjectNode = this.getExternalProjectNode();
        if (externalProjectNode != null) {
            this.beforeCommit(externalProjectNode, project2);
        }
        boolean isFromUI = model != null;
        SmartList modules = new SmartList();
        final IdentityHashMap moduleMap = new IdentityHashMap();
        IdeUIModifiableModelsProvider modelsProvider = isFromUI ? new IdeUIModifiableModelsProvider(this, project2, model, (ModulesConfigurator)modulesProvider, artifactModel, (List)modules){
            final /* synthetic */ List val$modules;
            {
                this.val$modules = list2;
                super(project2, model, modulesConfigurator, modifiableArtifactModel);
            }

            @Override
            protected ModifiableRootModel doGetModifiableRootModel(Module module) {
                ModifiableRootModel modifiableRootModel = super.doGetModifiableRootModel(module);
                moduleMap.put(modifiableRootModel, module);
                return modifiableRootModel;
            }

            @Override
            public void commit() {
                super.commit();
                for (Map.Entry moduleEntry : moduleMap.entrySet()) {
                    this.val$modules.add((Module)moduleEntry.getValue());
                }
            }
        } : new IdeModifiableModelsProviderImpl(this, project2, (List)modules){
            final /* synthetic */ List val$modules;
            {
                this.val$modules = list2;
                super(arg0);
            }

            @NotNull
            protected ModifiableRootModel doGetModifiableRootModel(@NotNull Module module) {
                if (module == null) {
                    2.$$$reportNull$$$0(0);
                }
                ModifiableRootModel modifiableRootModel = super.doGetModifiableRootModel(module);
                moduleMap.put(modifiableRootModel, module);
                ModifiableRootModel modifiableRootModel2 = modifiableRootModel;
                if (modifiableRootModel2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return modifiableRootModel2;
            }

            public void commit() {
                super.commit();
                for (Map.Entry moduleEntry : moduleMap.entrySet()) {
                    if (((ModifiableRootModel)moduleEntry.getKey()).isWritable()) continue;
                    this.val$modules.add((Module)moduleEntry.getValue());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doGetModifiableRootModel";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doGetModifiableRootModel";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)this.myExternalSystemId);
        ExternalProjectSettings projectSettings = this.getCurrentExternalProjectSettings();
        HashSet<ExternalProjectSettings> projects = new HashSet<ExternalProjectSettings>(systemSettings.getLinkedProjectsSettings());
        projects.remove(projectSettings);
        projects.add(projectSettings);
        systemSettings.copyFrom(((AbstractImportFromExternalSystemControl)((Object)this.getControl())).getSystemSettings());
        systemSettings.setLinkedProjectsSettings(projects);
        if (externalProjectNode != null) {
            if (systemSettings.showSelectiveImportDialogOnInitialImport() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
                ExternalProjectDataSelectorDialog dialog = new ExternalProjectDataSelectorDialog(project2, (ExternalProjectInfo)new InternalExternalProjectInfo(this.myExternalSystemId, projectSettings.getExternalProjectPath(), externalProjectNode));
                if (dialog.hasMultipleDataToSelect()) {
                    dialog.showAndGet();
                } else {
                    Disposer.dispose((Disposable)dialog.getDisposable());
                }
            }
            if (!project2.isInitialized()) {
                StartupManager.getInstance((Project)project2).runWhenProjectIsInitialized(() -> this.lambda$commit$0(project2, externalProjectNode, isFromUI, (List)modules, (IdeModifiableModelsProvider)modelsProvider, projectSettings));
            } else {
                this.finishImport(project2, externalProjectNode, isFromUI, (List<Module>)modules, (IdeModifiableModelsProvider)modelsProvider, projectSettings);
            }
        }
        return modules;
    }

    protected void finishImport(Project project2, DataNode<ProjectData> externalProjectNode, boolean isFromUI, List<Module> modules, IdeModifiableModelsProvider modelsProvider, ExternalProjectSettings projectSettings) {
        this.myExternalProjectNode = null;
        ProjectRootEntityKt.registerProjectRootBlocking((Project)project2, (Path)Paths.get(projectSettings.getExternalProjectPath(), new String[0]));
        Runnable resolveDependenciesTask = () -> ExternalSystemUtil.refreshProject((String)projectSettings.getExternalProjectPath(), (ImportSpecBuilder)new ImportSpecBuilder(project2, this.myExternalSystemId).callback(this.createFinalImportCallback(project2, projectSettings)));
        if (!isFromUI) {
            resolveDependenciesTask.run();
        } else {
            ExternalSystemUtil.invokeLater((Project)project2, (ModalityState)ModalityState.nonModal(), () -> {
                Module[] committedModules = ModuleManager.getInstance((Project)project2).getModules();
                if (Arrays.asList(committedModules).containsAll(modules)) {
                    resolveDependenciesTask.run();
                }
            });
        }
    }

    protected ExternalProjectRefreshCallback createFinalImportCallback(final @NotNull Project project2, @NotNull ExternalProjectSettings projectSettings) {
        if (project2 == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(6);
        }
        if (projectSettings == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(7);
        }
        return new ExternalProjectRefreshCallback(){

            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                if (externalProject == null) {
                    return;
                }
                ProjectDataManager.getInstance().importData(externalProject, project2);
            }
        };
    }

    @NotNull
    private ExternalProjectSettings getCurrentExternalProjectSettings() {
        ExternalProjectSettings result = ((AbstractImportFromExternalSystemControl)((Object)this.getControl())).getProjectSettings().clone();
        File externalProjectConfigFile = this.getExternalProjectConfigToUse(new File(result.getExternalProjectPath()));
        String linkedProjectPath = FileUtil.toCanonicalPath((String)externalProjectConfigFile.getPath());
        assert (linkedProjectPath != null);
        result.setExternalProjectPath(linkedProjectPath);
        ExternalProjectSettings externalProjectSettings = result;
        if (externalProjectSettings == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(8);
        }
        return externalProjectSettings;
    }

    protected abstract void beforeCommit(@NotNull DataNode<ProjectData> var1, @NotNull Project var2);

    @Nullable
    private File getProjectFile() {
        String path = ((AbstractImportFromExternalSystemControl)((Object)this.getControl())).getProjectSettings().getExternalProjectPath();
        return path == null ? null : new File(path);
    }

    public void ensureProjectIsDefined(@NotNull WizardContext wizardContext) throws ConfigurationException {
        if (wizardContext == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(9);
        }
        String externalSystemName = this.myExternalSystemId.getReadableName();
        File projectFile = this.getProjectFile();
        if (projectFile == null) {
            throw new ConfigurationException(JavaUiBundle.message("error.project.undefined", new Object[0]));
        }
        projectFile = this.getExternalProjectConfigToUse(projectFile);
        final Ref error = new Ref();
        ExternalProjectRefreshCallback callback = new ExternalProjectRefreshCallback(){

            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                AbstractExternalProjectImportBuilder.this.myExternalProjectNode = externalProject;
            }

            public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
                if (errorMessage == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (!StringUtil.isEmpty((String)errorDetails)) {
                    LOG.warn(errorDetails);
                }
                error.set((Object)new ConfigurationException(JavaUiBundle.message("error.resolve.with.log_link", errorMessage, PathManager.getLogPath()), JavaUiBundle.message("error.resolve.generic", new Object[0])));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder$4", "onFailure"));
            }
        };
        Project project2 = this.getProject(wizardContext);
        File finalProjectFile = projectFile;
        String externalProjectPath = FileUtil.toCanonicalPath((String)finalProjectFile.getAbsolutePath());
        Ref exRef = new Ref();
        this.executeAndRestoreDefaultProjectSettings(project2, () -> {
            try {
                ExternalSystemUtil.refreshProject((String)externalProjectPath, (ImportSpecBuilder)new ImportSpecBuilder(project2, this.myExternalSystemId).use(ProgressExecutionMode.MODAL_SYNC).usePreviewMode().callback(callback));
            }
            catch (IllegalArgumentException e) {
                exRef.set((Object)new ConfigurationException(e.getMessage(), JavaUiBundle.message("error.cannot.parse.project", externalSystemName)));
            }
        });
        ConfigurationException ex = (ConfigurationException)((Object)exRef.get());
        if (ex != null) {
            throw ex;
        }
        if (this.myExternalProjectNode == null) {
            ConfigurationException exception = (ConfigurationException)((Object)error.get());
            if (exception != null) {
                throw exception;
            }
        } else {
            this.applyProjectSettings(wizardContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAndRestoreDefaultProjectSettings(@NotNull Project project2, @NotNull Runnable task2) {
        if (project2 == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(10);
        }
        if (task2 == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(11);
        }
        AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)this.myExternalSystemId);
        Object systemStateToRestore = null;
        if (systemSettings instanceof PersistentStateComponent) {
            systemStateToRestore = ((PersistentStateComponent)systemSettings).getState();
        }
        systemSettings.copyFrom(((AbstractImportFromExternalSystemControl)((Object)this.getControl())).getSystemSettings());
        Collection projectSettingsToRestore = systemSettings.getLinkedProjectsSettings();
        HashSet<ExternalProjectSettings> projects = new HashSet<ExternalProjectSettings>(systemSettings.getLinkedProjectsSettings());
        projects.add(this.getCurrentExternalProjectSettings());
        systemSettings.setLinkedProjectsSettings(projects);
        try {
            task2.run();
        }
        finally {
            if (systemStateToRestore != null) {
                ((PersistentStateComponent)systemSettings).loadState(systemStateToRestore);
            } else {
                systemSettings.setLinkedProjectsSettings(projectSettingsToRestore);
            }
        }
    }

    @NotNull
    protected abstract File getExternalProjectConfigToUse(@NotNull File var1);

    @Nullable
    public DataNode<ProjectData> getExternalProjectNode() {
        return this.myExternalProjectNode;
    }

    public void applyProjectSettings(@NotNull WizardContext context) {
        if (context == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(12);
        }
        if (this.myExternalProjectNode == null) {
            assert (false);
            return;
        }
        context.setProjectName(((ProjectData)this.myExternalProjectNode.getData()).getInternalName());
        context.setProjectFileDirectory(((ProjectData)this.myExternalProjectNode.getData()).getIdeProjectFileDirectoryPath());
        this.applyExtraSettings(context);
    }

    protected abstract void applyExtraSettings(@NotNull WizardContext var1);

    @NotNull
    public Project getProject(@NotNull WizardContext wizardContext) {
        Project result;
        if (wizardContext == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(13);
        }
        if ((result = wizardContext.getProject()) == null) {
            result = ProjectManager.getInstance().getDefaultProject();
        }
        Project project2 = result;
        if (project2 == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(14);
        }
        return project2;
    }

    @Nullable
    public Project createProject(String name, String path) {
        Project project2 = super.createProject(name, path);
        if (project2 != null) {
            project2.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, (Object)Boolean.TRUE);
        }
        return project2;
    }

    @NotNull
    private C getControl() {
        AbstractImportFromExternalSystemControl abstractImportFromExternalSystemControl = (AbstractImportFromExternalSystemControl)((Object)this.myControlValue.getValue());
        if (abstractImportFromExternalSystemControl == null) {
            AbstractExternalProjectImportBuilder.$$$reportNull$$$0(15);
        }
        return (C)((Object)abstractImportFromExternalSystemControl);
    }

    private /* synthetic */ void lambda$commit$0(Project project2, DataNode externalProjectNode, boolean isFromUI, List modules, IdeModifiableModelsProvider modelsProvider, ExternalProjectSettings projectSettings) {
        this.finishImport(project2, (DataNode<ProjectData>)externalProjectNode, isFromUI, modules, modelsProvider, projectSettings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDataManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 3: 
            case 8: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder";
                break;
            }
            case 4: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSettings";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizardContext";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalProjectImportBuilder";
                break;
            }
            case 3: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getControl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentExternalProjectSettings";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 8: 
            case 14: 
            case 15: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjectJdk";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFinalImportCallback";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "ensureProjectIsDefined";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "executeAndRestoreDefaultProjectSettings";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "applyProjectSettings";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getProject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 14, 15 -> new IllegalStateException(string);
        };
    }
}

