/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.ui;

import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.plugins.newui.TwoLineProgressIndicator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.SdkEditorAdditionalOptionsProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.projectRoots.ui.PathEditor;
import com.intellij.openapi.projectRoots.ui.SdkPathEditor;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ui.OrderRootTypeUIFactory;
import com.intellij.openapi.roots.ui.configuration.SdkPopupFactory;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownloadTracker;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.status.InlineProgressIndicator;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkEditor
implements Configurable,
Place.Navigator {
    private static final Logger LOG = Logger.getInstance(SdkEditor.class);
    private static final String SDK_TAB = "sdkTab";
    @NotNull
    private final Sdk mySdk;
    private final Map<OrderRootType, SdkPathEditor> myPathEditors;
    private TextFieldWithBrowseButton myHomeComponent;
    private final Map<SdkType, List<AdditionalDataConfigurable>> myAdditionalDataConfigurables;
    private final Map<AdditionalDataConfigurable, JComponent> myAdditionalDataComponents;
    private JPanel myAdditionalDataPanel;
    private JPanel myDownloadingPanel;
    private InlineProgressIndicator myDownloadProgressIndicator;
    private final SdkModificator myEditedSdkModificator;
    private JPanel myMainPanel;
    private TabbedPaneWrapper myTabbedPane;
    private final Project myProject;
    private final ProjectSdksModel mySdkModel;
    private JLabel myHomeFieldLabel;
    private String myVersionString;
    private String myInitialName;
    private String myModifiedName;
    private String myInitialPath;
    private boolean myIsDownloading;
    private final History myHistory;
    private final Disposable myDisposable;
    private boolean myIsDisposed;
    private final Consumer<Boolean> myResetCallback;

    public SdkEditor(@NotNull Project project2, @NotNull ProjectSdksModel sdkModel, @NotNull History history, @NotNull Sdk sdk) {
        if (project2 == null) {
            SdkEditor.$$$reportNull$$$0(0);
        }
        if (sdkModel == null) {
            SdkEditor.$$$reportNull$$$0(1);
        }
        if (history == null) {
            SdkEditor.$$$reportNull$$$0(2);
        }
        if (sdk == null) {
            SdkEditor.$$$reportNull$$$0(3);
        }
        this.myPathEditors = new HashMap<OrderRootType, SdkPathEditor>();
        this.myAdditionalDataConfigurables = new HashMap<SdkType, List<AdditionalDataConfigurable>>();
        this.myAdditionalDataComponents = new HashMap<AdditionalDataConfigurable, JComponent>();
        this.myEditedSdkModificator = new EditedSdkModificator();
        this.myIsDownloading = false;
        this.myDisposable = Disposer.newDisposable();
        this.myIsDisposed = false;
        this.myResetCallback = __ -> {
            if (!this.myIsDisposed) {
                this.reset();
            }
        };
        this.myProject = project2;
        this.mySdkModel = sdkModel;
        this.myHistory = history;
        this.mySdk = sdk;
        this.myModifiedName = this.myInitialName = this.mySdk.getName();
        this.myInitialPath = this.mySdk.getHomePath();
        this.createMainPanel();
        for (AdditionalDataConfigurable additionalDataConfigurable : this.getAdditionalDataConfigurable()) {
            additionalDataConfigurable.setSdk(sdk);
        }
        this.reset();
    }

    public String getDisplayName() {
        return JavaUiBundle.message("sdk.configure.editor.title", new Object[0]);
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    private void createMainPanel() {
        this.myMainPanel = new JPanel(new GridBagLayout());
        this.myTabbedPane = new TabbedPaneWrapper(this.myDisposable);
        for (OrderRootType type : OrderRootType.getAllTypes()) {
            SdkPathEditor pathEditor;
            if (!this.showTabForType(type) || (pathEditor = ((OrderRootTypeUIFactory)OrderRootTypeUIFactory.FACTORY.getByKey((Object)type)).createPathEditor(this.mySdk)) == null) continue;
            pathEditor.setAddBaseDir(this.mySdk.getHomeDirectory());
            this.myTabbedPane.addTab(pathEditor.getDisplayName(), pathEditor.createComponent());
            this.myPathEditors.put(type, pathEditor);
        }
        this.myTabbedPane.addChangeListener(e -> this.myHistory.pushQueryPlace());
        this.myHomeComponent = this.createHomeComponent();
        final JTextField textField = this.myHomeComponent.getTextField();
        textField.setEditable(false);
        textField.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) == 0L || !textField.isShowing()) {
                    return;
                }
                SdkEditor.this.checkHomePathValidity();
            }
        });
        this.myHomeFieldLabel = new JLabel(this.getHomeFieldLabelValue());
        this.myHomeFieldLabel.setLabelFor(this.myHomeComponent.getTextField());
        this.myMainPanel.add((Component)this.myHomeFieldLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insets((int)2, (int)10, (int)2, (int)2), 0, 0));
        this.myMainPanel.add((Component)this.myHomeComponent, new GridBagConstraints(1, -1, 2, 1, 1.0, 0.0, 10, 2, (Insets)JBUI.insets((int)2, (int)2, (int)2, (int)10), 0, 0));
        this.myAdditionalDataPanel = new JPanel(new BorderLayout());
        this.myMainPanel.add((Component)this.myAdditionalDataPanel, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 10, 1, (Insets)JBUI.insets((int)2, (int)10, (int)0, (int)10), 0, 0));
        this.myMainPanel.add((Component)this.myTabbedPane.getComponent(), new GridBagConstraints(0, -1, 3, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.insetsTop((int)2), 0, 0));
        this.myDownloadingPanel = new JPanel(new BorderLayout());
        this.myDownloadProgressIndicator = new TwoLineProgressIndicator(true);
        this.myDownloadProgressIndicator.setIndeterminate(true);
        this.myDownloadingPanel.add((Component)this.myDownloadProgressIndicator.getComponent(), "North");
        this.myDownloadProgressIndicator.getComponent().setMaximumSize((Dimension)JBUI.size((int)300, (int)200));
        this.myMainPanel.add((Component)this.myDownloadingPanel, new GridBagConstraints(0, -1, 2, 1, 0.0, 1.0, 15, 1, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
    }

    protected TextFieldWithBrowseButton createHomeComponent() {
        TextFieldWithBrowseButton myField = new TextFieldWithBrowseButton(e -> this.doSelectHomePath());
        if (this.mySdk.getSdkType().equals((Object)JavaSdk.getInstance())) {
            myField.setButtonEnabled(false);
            myField.setButtonVisible(false);
        }
        return myField;
    }

    protected boolean showTabForType(@NotNull OrderRootType type) {
        if (type == null) {
            SdkEditor.$$$reportNull$$$0(4);
        }
        return ((SdkType)this.mySdk.getSdkType()).isRootTypeApplicable(type);
    }

    @NlsContexts.Label
    private String getHomeFieldLabelValue() {
        return ((SdkType)this.mySdk.getSdkType()).getHomeFieldLabel();
    }

    public boolean isModified() {
        boolean isModified;
        boolean bl = isModified = !Objects.equals(this.myModifiedName, this.myInitialName);
        if (this.myIsDownloading) {
            return isModified;
        }
        isModified = isModified || !Objects.equals(FileUtil.toSystemIndependentName((String)this.getHomeValue()), FileUtil.toSystemIndependentName((String)this.myInitialPath));
        for (PathEditor pathEditor : this.myPathEditors.values()) {
            isModified = isModified || pathEditor.isModified();
        }
        for (AdditionalDataConfigurable additionalDataConfigurable : this.getAdditionalDataConfigurable()) {
            isModified = isModified || additionalDataConfigurable.isModified();
        }
        return isModified;
    }

    public void setNewSdkName(String name) {
        this.myModifiedName = name;
    }

    @NlsSafe
    public String getActualSdkName() {
        return this.myModifiedName;
    }

    public void apply() throws ConfigurationException {
        if (this.myIsDownloading) {
            return;
        }
        if (!Objects.equals(this.myInitialName, this.myModifiedName) && this.myModifiedName.isEmpty()) {
            throw new ConfigurationException(ProjectBundle.message((String)"sdk.list.name.required.error", (Object[])new Object[0]));
        }
        this.myInitialName = this.myModifiedName;
        this.myInitialPath = this.mySdk.getHomePath();
        SdkModificator sdkModificator = this.mySdk.getSdkModificator();
        sdkModificator.setName(this.myModifiedName);
        sdkModificator.setHomePath(FileUtil.toSystemIndependentName((String)this.getHomeValue()));
        for (SdkPathEditor pathEditor : this.myPathEditors.values()) {
            pathEditor.apply(sdkModificator);
        }
        ApplicationManager.getApplication().runWriteAction(() -> ((SdkModificator)sdkModificator).commitChanges());
        for (AdditionalDataConfigurable configurable : this.getAdditionalDataConfigurable()) {
            if (configurable == null) continue;
            configurable.apply();
        }
    }

    public void reset() {
        this.myIsDownloading = SdkDownloadTracker.getInstance().tryRegisterDownloadingListener(this.mySdk, this.myDisposable, (ProgressIndicator)this.myDownloadProgressIndicator, this.myResetCallback);
        if (!this.myIsDownloading) {
            SdkModificator sdkModificator = this.mySdk.getSdkModificator();
            for (OrderRootType type : this.myPathEditors.keySet()) {
                this.myPathEditors.get(type).reset(sdkModificator);
            }
            ApplicationManager.getApplication().runWriteAction(() -> ((SdkModificator)sdkModificator).commitChanges());
        }
        this.setHomePathValue(FileUtil.toSystemDependentName((String)((String)ObjectUtils.notNull((Object)this.mySdk.getHomePath(), (Object)""))));
        this.myVersionString = null;
        this.myHomeFieldLabel.setText(this.getHomeFieldLabelValue());
        this.myTabbedPane.getComponent().setVisible(!this.myIsDownloading);
        this.myAdditionalDataPanel.setVisible(!this.myIsDownloading);
        this.myDownloadingPanel.setVisible(this.myIsDownloading);
        this.myHomeComponent.setEnabled(!this.myIsDownloading);
        if (!this.myIsDownloading) {
            this.updateAdditionalDataComponent();
            for (AdditionalDataConfigurable configurable : this.getAdditionalDataConfigurable()) {
                configurable.reset();
            }
            for (int i = 0; i < this.myTabbedPane.getTabCount(); ++i) {
                this.myTabbedPane.setEnabledAt(i, true);
            }
        }
    }

    public void disposeUIResources() {
        this.myIsDisposed = true;
        for (SdkType sdkType : this.myAdditionalDataConfigurables.keySet()) {
            for (AdditionalDataConfigurable configurable : this.myAdditionalDataConfigurables.get(sdkType)) {
                configurable.disposeUIResources();
            }
        }
        this.myAdditionalDataConfigurables.clear();
        this.myAdditionalDataComponents.clear();
        Disposer.dispose((Disposable)this.myDisposable);
    }

    private String getHomeValue() {
        return this.myHomeComponent.getText().trim();
    }

    private void clearAllPaths() {
        for (PathEditor pathEditor : this.myPathEditors.values()) {
            pathEditor.clearList();
        }
    }

    private void setHomePathValue(@NlsSafe String absolutePath) {
        this.myHomeComponent.setText(absolutePath);
        this.myHomeComponent.getTextField().setForeground(UIUtil.getFieldForegroundColor());
        if (this.myHomeComponent.isShowing()) {
            this.checkHomePathValidity();
        }
    }

    private void checkHomePathValidity() {
        JTextField textField = this.myHomeComponent.getTextField();
        if (textField.getText().isEmpty() && !this.mySdk.getSdkType().isLocalSdk(this.mySdk)) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Path homeDir = Path.of(textField.getText(), new String[0]);
            boolean homeMustBeDirectory = ((SdkType)this.mySdk.getSdkType()).getHomeChooserDescriptor().isChooseFolders();
            boolean isValid = homeMustBeDirectory ? Files.isDirectory(homeDir, new LinkOption[0]) : Files.isRegularFile(homeDir, new LinkOption[0]);
            ApplicationManager.getApplication().invokeLater(() -> textField.setForeground(isValid ? UIUtil.getFieldForegroundColor() : PathEditor.INVALID_COLOR), ModalityState.stateForComponent((Component)this.myHomeComponent));
        });
    }

    private void doSelectHomePath() {
        SdkType sdkType = (SdkType)this.mySdk.getSdkType();
        if (SdkConfigurationUtil.selectSdkHomeForTests((SdkType)sdkType, path -> this.doSetHomePath((String)path, sdkType))) {
            return;
        }
        SdkPopupFactory.newBuilder().withSdkType((SdkTypeId)sdkType).withSdkFilter(sdk -> {
            if (sdk.getName().equals(this.myInitialName)) {
                return false;
            }
            if (sdk.getName().equals(this.myModifiedName)) {
                return false;
            }
            return !FileUtil.pathsEqual((String)sdk.getHomePath(), (String)this.mySdk.getHomePath());
        }).onSdkSelected(sdk -> {
            SdkDownloadTracker tracker = SdkDownloadTracker.getInstance();
            if (tracker.isDownloading(sdk)) {
                tracker.registerEditableSdk(sdk, this.mySdk);
                Map.Entry originalSdkEntry = (Map.Entry)ContainerUtil.find(this.mySdkModel.getProjectSdks().entrySet(), p -> ((Sdk)p.getValue()).equals((Object)this.mySdk));
                if (originalSdkEntry != null) {
                    tracker.registerEditableSdk(sdk, (Sdk)originalSdkEntry.getKey());
                }
                this.reset();
            } else {
                this.doSetHomePath(sdk.getHomePath(), sdkType);
            }
        }).withOwnProjectSdksModel(new ProjectSdksModel(this){

            protected boolean forceAddActionToSelectFromDisk(@NotNull SdkType type) {
                if (type == null) {
                    2.$$$reportNull$$$0(0);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/projectRoots/ui/SdkEditor$2", "forceAddActionToSelectFromDisk"));
            }
        }).buildPopup().showUnderneathToTheRightOf((Component)this.myHomeComponent);
    }

    private void doSetHomePath(String homePath, SdkType sdkType) {
        if (homePath == null) {
            return;
        }
        this.setHomePathValue(homePath.replace('/', File.separatorChar));
        try {
            Sdk dummySdk = this.mySdk.clone();
            SdkModificator sdkModificator = dummySdk.getSdkModificator();
            sdkModificator.setHomePath(homePath);
            sdkModificator.removeAllRoots();
            sdkModificator.commitChanges();
            sdkType.setupSdkPaths(dummySdk, (SdkModel)this.mySdkModel);
            this.clearAllPaths();
            this.myVersionString = dummySdk.getVersionString();
            if (this.myVersionString == null) {
                Messages.showMessageDialog((String)ProjectBundle.message((String)"sdk.java.corrupt.error", (Object[])new Object[]{homePath}), (String)ProjectBundle.message((String)"sdk.java.corrupt.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            }
            sdkModificator = dummySdk.getSdkModificator();
            for (OrderRootType type : this.myPathEditors.keySet()) {
                SdkPathEditor pathEditor = this.myPathEditors.get(type);
                pathEditor.setAddBaseDir(dummySdk.getHomeDirectory());
                pathEditor.addPaths(sdkModificator.getRoots(type));
            }
            this.mySdkModel.getMulticaster().sdkHomeSelected(dummySdk, homePath);
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
        }
    }

    private void updateAdditionalDataComponent() {
        this.myAdditionalDataPanel.removeAll();
        for (AdditionalDataConfigurable configurable : this.getAdditionalDataConfigurable()) {
            JComponent component = this.myAdditionalDataComponents.get(configurable);
            if (component == null) {
                component = configurable.createComponent();
                this.myAdditionalDataComponents.put(configurable, component);
            }
            if (component == null) continue;
            if (configurable.getTabName() != null) {
                for (int i = 0; i < this.myTabbedPane.getTabCount(); ++i) {
                    if (!configurable.getTabName().equals(this.myTabbedPane.getTitleAt(i))) continue;
                    this.myTabbedPane.removeTabAt(i);
                }
                this.myTabbedPane.addTab(configurable.getTabName(), component);
                continue;
            }
            this.myAdditionalDataPanel.add((Component)component, "Center");
        }
    }

    @NotNull
    private List<AdditionalDataConfigurable> getAdditionalDataConfigurable() {
        return this.initAdditionalDataConfigurable(this.mySdk);
    }

    @NotNull
    private List<AdditionalDataConfigurable> initAdditionalDataConfigurable(Sdk sdk) {
        SdkType sdkType = (SdkType)sdk.getSdkType();
        List<AdditionalDataConfigurable> configurables = this.myAdditionalDataConfigurables.get(sdkType);
        if (configurables == null) {
            configurables = new ArrayList<AdditionalDataConfigurable>();
            this.myAdditionalDataConfigurables.put(sdkType, configurables);
            AdditionalDataConfigurable sdkConfigurable = sdkType.createAdditionalDataConfigurable((SdkModel)this.mySdkModel, this.myEditedSdkModificator);
            if (sdkConfigurable != null) {
                configurables.add(sdkConfigurable);
            }
            for (SdkEditorAdditionalOptionsProvider factory : SdkEditorAdditionalOptionsProvider.getSdkOptionsFactory(this.mySdk.getSdkType())) {
                AdditionalDataConfigurable options = factory.createOptions(this.myProject, this.mySdk);
                if (options == null) continue;
                configurables.add(options);
            }
        }
        List<AdditionalDataConfigurable> list2 = configurables;
        if (list2 == null) {
            SdkEditor.$$$reportNull$$$0(5);
        }
        return list2;
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        if (place == null) {
            return ActionCallback.DONE;
        }
        this.myTabbedPane.setSelectedTitle((String)place.getPath(SDK_TAB));
        return ActionCallback.DONE;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            SdkEditor.$$$reportNull$$$0(6);
        }
        place.putPath(SDK_TAB, (Object)this.myTabbedPane.getSelectedTitle());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "history";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/ui/SdkEditor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/ui/SdkEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "initAdditionalDataConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showTabForType";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "queryPlace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private class EditedSdkModificator
    implements SdkModificator {
        private EditedSdkModificator() {
        }

        @NotNull
        public String getName() {
            String string = SdkEditor.this.mySdk.getName();
            if (string == null) {
                EditedSdkModificator.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void setName(@NotNull String name) {
            if (name == null) {
                EditedSdkModificator.$$$reportNull$$$0(1);
            }
            ((ProjectJdkImpl)SdkEditor.this.mySdk).setName(name);
        }

        public String getHomePath() {
            return SdkEditor.this.getHomeValue();
        }

        public void setHomePath(String path) {
            SdkEditor.this.doSetHomePath(path, (SdkType)SdkEditor.this.mySdk.getSdkType());
        }

        public String getVersionString() {
            return SdkEditor.this.myVersionString != null ? SdkEditor.this.myVersionString : SdkEditor.this.mySdk.getVersionString();
        }

        public void setVersionString(String versionString) {
            throw new UnsupportedOperationException();
        }

        public SdkAdditionalData getSdkAdditionalData() {
            return SdkEditor.this.mySdk.getSdkAdditionalData();
        }

        public void setSdkAdditionalData(SdkAdditionalData data) {
            throw new UnsupportedOperationException();
        }

        public VirtualFile @NotNull [] getRoots(@NotNull OrderRootType rootType) {
            PathEditor editor;
            if (rootType == null) {
                EditedSdkModificator.$$$reportNull$$$0(2);
            }
            if ((editor = (PathEditor)SdkEditor.this.myPathEditors.get(rootType)) == null) {
                throw new IllegalStateException("no editor for root type " + String.valueOf(rootType));
            }
            VirtualFile[] virtualFileArray = editor.getRoots();
            if (virtualFileArray == null) {
                EditedSdkModificator.$$$reportNull$$$0(3);
            }
            return virtualFileArray;
        }

        public void addRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
            if (root == null) {
                EditedSdkModificator.$$$reportNull$$$0(4);
            }
            if (rootType == null) {
                EditedSdkModificator.$$$reportNull$$$0(5);
            }
            SdkEditor.this.myPathEditors.get(rootType).addPaths(new VirtualFile[]{root});
        }

        public void removeRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
            if (root == null) {
                EditedSdkModificator.$$$reportNull$$$0(6);
            }
            if (rootType == null) {
                EditedSdkModificator.$$$reportNull$$$0(7);
            }
            SdkEditor.this.myPathEditors.get(rootType).removePaths(new VirtualFile[]{root});
        }

        public void removeRoots(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                EditedSdkModificator.$$$reportNull$$$0(8);
            }
            SdkEditor.this.myPathEditors.get(rootType).clearList();
        }

        public void removeAllRoots() {
            for (PathEditor pathEditor : SdkEditor.this.myPathEditors.values()) {
                pathEditor.clearList();
            }
        }

        public void commitChanges() {
        }

        public boolean isWritable() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 4, 5, 6, 7, 8 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/projectRoots/ui/SdkEditor$EditedSdkModificator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 5: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootType";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/projectRoots/ui/SdkEditor$EditedSdkModificator";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getRoots";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addRoot";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "removeRoot";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "removeRoots";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
            };
        }
    }
}

