/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.compiler.actions.ArtifactAwareProjectSettingsService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.CommonContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.SdkPopupFactory;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.workspaceModel.ide.legacyBridge.LibraryBridgesKt;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridges;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeaProjectSettingsService
extends ProjectSettingsService
implements ArtifactAwareProjectSettingsService {
    private final Project myProject;
    private Sdk myDeprecatedChosenSdk = null;

    public IdeaProjectSettingsService(Project project2) {
        this.myProject = project2;
    }

    public void openProjectSettings() {
        ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(this.myProject);
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)config, () -> config.selectProjectGeneralSettings(true));
    }

    public void openGlobalLibraries() {
        ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(this.myProject);
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)config, () -> config.selectGlobalLibraries(true));
    }

    public void openLibrary(@NotNull Library library) {
        if (library == null) {
            IdeaProjectSettingsService.$$$reportNull$$$0(0);
        }
        ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(this.myProject);
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)config, () -> config.selectProjectOrGlobalLibrary(library, true));
    }

    public boolean canOpenModuleSettings() {
        return true;
    }

    public void openModuleSettings(Module module) {
        ModulesConfigurator.showDialog(this.myProject, module.getName(), null);
    }

    public boolean canOpenModuleLibrarySettings() {
        return true;
    }

    public void openModuleLibrarySettings(Module module) {
        ModulesConfigurator.showDialog(this.myProject, module.getName(), ClasspathEditor.getName());
    }

    public boolean canOpenContentEntriesSettings() {
        return true;
    }

    public void openContentEntriesSettings(Module module) {
        ModulesConfigurator.showDialog(this.myProject, module.getName(), CommonContentEntriesEditor.getName());
    }

    public boolean canOpenModuleDependenciesSettings() {
        return true;
    }

    public void openModuleDependenciesSettings(@NotNull Module module, @Nullable OrderEntry orderEntry) {
        if (module == null) {
            IdeaProjectSettingsService.$$$reportNull$$$0(1);
        }
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)ProjectStructureConfigurable.getInstance(this.myProject), () -> ProjectStructureConfigurable.getInstance(this.myProject).selectOrderEntry(module, orderEntry));
    }

    public boolean canOpenLibraryOrSdkSettings(OrderEntry orderEntry) {
        return true;
    }

    public boolean canOpenLibrarySettings(LibraryEntity library) {
        Module module;
        ImmutableEntityStorage snapshot = WorkspaceModel.getInstance((Project)this.myProject).getCurrentSnapshot();
        ModuleEntity moduleEntity = (ModuleEntity)SequencesKt.firstOrNull((Sequence)snapshot.referrers((SymbolicEntityId)library.getSymbolicId(), ModuleEntity.class));
        if (moduleEntity != null && (module = ModuleBridges.findModule((ModuleEntity)moduleEntity, (EntityStorage)snapshot)) != null) {
            return IdeaProjectSettingsService.getLibrarySettingsConfigurable(library, module.getProject(), snapshot) != null;
        }
        return false;
    }

    public void openLibraryOrSdkSettings(@NotNull OrderEntry orderEntry) {
        if (orderEntry == null) {
            IdeaProjectSettingsService.$$$reportNull$$$0(2);
        }
        ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(this.myProject);
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)config, () -> {
            if (orderEntry instanceof JdkOrderEntry) {
                config.select(((JdkOrderEntry)orderEntry).getJdk(), true);
            } else {
                config.select((LibraryOrderEntry)orderEntry, true);
            }
        });
    }

    public boolean processModulesMoved(Module[] modules, @Nullable String targetGroupName) {
        ModuleStructureConfigurable rootConfigurable = ProjectStructureConfigurable.getInstance(this.myProject).getModulesConfig();
        if (rootConfigurable.updateProjectTree(modules)) {
            if (targetGroupName != null) {
                rootConfigurable.selectNodeInTree(targetGroupName);
            } else {
                rootConfigurable.selectNodeInTree(modules[0].getName());
            }
            return true;
        }
        return false;
    }

    public void showModuleConfigurationDialog(String moduleToSelect, String editorNameToSelect) {
        ModulesConfigurator.showDialog(this.myProject, moduleToSelect, editorNameToSelect);
    }

    @Deprecated(forRemoval=true)
    public Sdk chooseAndSetSdk() {
        Logger.getInstance(((Object)((Object)this)).getClass()).error("Call to the deprecated ProjectSettingsService#chooseAndSetSdk method. Please use new API instead");
        if (this.myDeprecatedChosenSdk != null) {
            Sdk chosenSdk = this.myDeprecatedChosenSdk;
            this.myDeprecatedChosenSdk = null;
            return chosenSdk;
        }
        SdkPopupFactory.newBuilder().withProject(this.myProject).withSdkType((SdkTypeId)JavaSdk.getInstance()).updateProjectSdkFromSelection().onSdkSelected(sdk -> {
            this.myDeprecatedChosenSdk = sdk;
        }).buildPopup().showInFocusCenter();
        return null;
    }

    public void openArtifactSettings(@Nullable Artifact artifact) {
        ModulesConfigurator.showArtifactSettings(this.myProject, artifact);
    }

    @Nullable
    private static Configurable getLibrarySettingsConfigurable(LibraryEntity libraryEntity, Project project2, ImmutableEntityStorage storage) {
        Library lib = LibraryBridgesKt.findLibraryBridge((LibraryEntity)libraryEntity, (EntityStorage)storage);
        if (lib == null) {
            return null;
        }
        return IdeaProjectSettingsService.getLibrarySettingsConfigurable((Library)lib, (Project)project2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/IdeaProjectSettingsService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "openLibrary";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "openModuleDependenciesSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "openLibraryOrSdkSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

