/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.icons.AllIcons;
import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ContentRootPanel;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.roots.IconActionComponent;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class JavaResourceRootEditHandlerBase
extends ModuleSourceRootEditHandler<JavaResourceRootProperties> {
    public JavaResourceRootEditHandlerBase(JpsModuleSourceRootType<JavaResourceRootProperties> rootType) {
        super(rootType);
    }

    @Nullable
    public Icon getFolderUnderRootIcon() {
        return null;
    }

    @Nullable
    public CustomShortcutSet getMarkRootShortcutSet() {
        return null;
    }

    @NotNull
    public Icon getRootIcon(@NotNull JavaResourceRootProperties properties) {
        if (properties == null) {
            JavaResourceRootEditHandlerBase.$$$reportNull$$$0(0);
        }
        Icon icon = properties.isForGeneratedSources() ? this.getGeneratedRootIcon() : this.getRootIcon();
        if (icon == null) {
            JavaResourceRootEditHandlerBase.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    protected Icon getGeneratedRootIcon() {
        Icon icon = this.getRootIcon();
        if (icon == null) {
            JavaResourceRootEditHandlerBase.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @Nullable
    public String getPropertiesString(@NotNull JavaResourceRootProperties properties) {
        String relativeOutputPath;
        if (properties == null) {
            JavaResourceRootEditHandlerBase.$$$reportNull$$$0(3);
        }
        StringBuilder buffer = new StringBuilder();
        if (properties.isForGeneratedSources()) {
            buffer.append(" [generated]");
        }
        if (!(relativeOutputPath = properties.getRelativeOutputPath()).isEmpty()) {
            buffer.append(" (").append(relativeOutputPath).append(")");
        }
        return !buffer.isEmpty() ? buffer.toString() : null;
    }

    @Nullable
    public JComponent createPropertiesEditor(@NotNull SourceFolder folder, @NotNull JComponent parentComponent, @NotNull ContentRootPanel.ActionCallback callback) {
        if (folder == null) {
            JavaResourceRootEditHandlerBase.$$$reportNull$$$0(4);
        }
        if (parentComponent == null) {
            JavaResourceRootEditHandlerBase.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            JavaResourceRootEditHandlerBase.$$$reportNull$$$0(6);
        }
        IconActionComponent iconComponent = new IconActionComponent(AllIcons.General.Inline_edit, AllIcons.General.Inline_edit_hovered, ProjectBundle.message((String)"module.paths.edit.properties.tooltip", (Object[])new Object[0]), () -> {
            JavaResourceRootProperties properties = (JavaResourceRootProperties)folder.getJpsElement().getProperties(JavaModuleSourceRootTypes.RESOURCES);
            assert (properties != null);
            ResourceRootPropertiesDialog dialog = new ResourceRootPropertiesDialog(parentComponent, properties);
            if (dialog.showAndGet()) {
                callback.onSourceRootPropertiesChanged(folder);
            }
        });
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setOpaque(false);
        panel2.add((Component)iconComponent, "Center");
        panel2.add(Box.createHorizontalStrut(3), "East");
        return panel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/JavaResourceRootEditHandlerBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/JavaResourceRootEditHandlerBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratedRootIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootIcon";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPropertiesString";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPropertiesEditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static final class ResourceRootPropertiesDialog
    extends DialogWrapper {
        private final JTextField myRelativeOutputPathField;
        private final JCheckBox myIsGeneratedCheckBox;
        private final JPanel myMainPanel;
        @NotNull
        private final JavaResourceRootProperties myProperties;

        private ResourceRootPropertiesDialog(@NotNull JComponent parentComponent, @NotNull JavaResourceRootProperties properties) {
            if (parentComponent == null) {
                ResourceRootPropertiesDialog.$$$reportNull$$$0(0);
            }
            if (properties == null) {
                ResourceRootPropertiesDialog.$$$reportNull$$$0(1);
            }
            super((Component)parentComponent, true);
            this.myProperties = properties;
            this.setTitle(ProjectBundle.message((String)"module.paths.edit.properties.title", (Object[])new Object[0]));
            this.myRelativeOutputPathField = new JTextField();
            this.myIsGeneratedCheckBox = new JCheckBox(JavaUiBundle.message("checkbox.for.generated.resources", new Object[0]));
            this.myMainPanel = FormBuilder.createFormBuilder().addLabeledComponent(JavaUiBundle.message("label.relative.output.path", new Object[0]), (JComponent)this.myRelativeOutputPathField).addComponent((JComponent)this.myIsGeneratedCheckBox).getPanel();
            this.myRelativeOutputPathField.setText(this.myProperties.getRelativeOutputPath());
            this.myRelativeOutputPathField.setColumns(25);
            this.myIsGeneratedCheckBox.setSelected(this.myProperties.isForGeneratedSources());
            this.init();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myRelativeOutputPathField;
        }

        protected void doOKAction() {
            this.myProperties.setRelativeOutputPath(ResourceRootPropertiesDialog.normalizePath(this.myRelativeOutputPathField.getText()));
            this.myProperties.setForGeneratedSources(this.myIsGeneratedCheckBox.isSelected());
            super.doOKAction();
        }

        @NotNull
        private static String normalizePath(String path) {
            String string = StringUtil.trimEnd((String)StringUtil.trimStart((String)FileUtil.toSystemIndependentName((String)path.trim()), (String)"/"), (String)"/");
            if (string == null) {
                ResourceRootPropertiesDialog.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myMainPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentComponent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/JavaResourceRootEditHandlerBase$ResourceRootPropertiesDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/JavaResourceRootEditHandlerBase$ResourceRootPropertiesDialog";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "normalizePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

