/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.codeInsight.multiverse.CodeInsightContexts;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetModel;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.facet.impl.ui.FacetEditorImpl;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.actions.ImportModuleAction;
import com.intellij.ide.projectWizard.NewProjectWizard;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.ui.configuration.HeaderHidingTabbedModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleManagerBridgeImpl;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModulesConfigurator
implements ModulesProvider,
ModuleEditor.ChangeListener {
    private static final Logger LOG = Logger.getInstance(ModulesConfigurator.class);
    private final Project myProject;
    private final ProjectStructureConfigurable myProjectStructureConfigurable;
    private final Map<Module, ModuleEditor> myModuleEditors = new TreeMap<Module, ModuleEditor>((o1, o2) -> {
        String n2;
        String n1 = o1.getName();
        int result = n1.compareToIgnoreCase(n2 = o2.getName());
        if (result != 0) {
            return result;
        }
        return n1.compareTo(n2);
    });
    private boolean myModified = false;
    private ModifiableModuleModel myModuleModel;
    private boolean myModuleModelCommitted = false;
    private ProjectFacetsConfigurator myFacetsConfigurator;
    private MutableEntityStorage myMutableEntityStorage;
    private StructureConfigurableContext myContext;
    private final List<ModuleEditor.ChangeListener> myAllModulesChangeListeners = new ArrayList<ModuleEditor.ChangeListener>();

    @Deprecated(forRemoval=true)
    public ModulesConfigurator(Project project2) {
        this(project2, ProjectStructureConfigurable.getInstance(project2));
    }

    public ModulesConfigurator(Project project2, ProjectStructureConfigurable projectStructureConfigurable) {
        this.myProject = project2;
        this.myProjectStructureConfigurable = projectStructureConfigurable;
        this.initModuleModel();
    }

    private void initModuleModel() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        if (moduleManager instanceof ModuleManagerBridgeImpl) {
            this.myMutableEntityStorage = MutableEntityStorage.from((ImmutableEntityStorage)WorkspaceModel.getInstance((Project)this.myProject).getCurrentSnapshot());
            this.myModuleModel = ((ModuleManagerBridgeImpl)moduleManager).getModifiableModel(this.myMutableEntityStorage);
        } else {
            this.myModuleModel = moduleManager.getModifiableModel();
            this.myMutableEntityStorage = null;
        }
    }

    @Nullable
    public MutableEntityStorage getWorkspaceEntityStorageBuilder() {
        return this.myMutableEntityStorage;
    }

    public void setContext(StructureConfigurableContext context) {
        this.myContext = context;
        this.myFacetsConfigurator = this.createFacetsConfigurator();
    }

    public ProjectStructureConfigurable getProjectStructureConfigurable() {
        return this.myProjectStructureConfigurable;
    }

    public ProjectFacetsConfigurator getFacetsConfigurator() {
        return this.myFacetsConfigurator;
    }

    public void disposeUIResources() {
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
                Disposer.dispose((Disposable)moduleEditor);
            }
            this.myModuleEditors.clear();
            if (this.myModuleModel != null) {
                this.myModuleModel.dispose();
            }
            this.myMutableEntityStorage = null;
            if (this.myFacetsConfigurator != null) {
                this.myFacetsConfigurator.disposeEditors();
            }
            this.myModuleModel = null;
        });
    }

    public Module @NotNull [] getModules() {
        Module[] moduleArray = this.myModuleModel.getModules();
        if (moduleArray == null) {
            ModulesConfigurator.$$$reportNull$$$0(0);
        }
        return moduleArray;
    }

    @Nullable
    public Module getModule(@NotNull String name) {
        if (name == null) {
            ModulesConfigurator.$$$reportNull$$$0(1);
        }
        if (this.myModuleModel == null) {
            return null;
        }
        Module moduleByName = this.myModuleModel.findModuleByName(name);
        if (moduleByName != null) {
            return moduleByName;
        }
        return this.myModuleModel.getModuleToBeRenamed(name);
    }

    @Nullable
    public ModuleEditor getModuleEditor(Module module) {
        return this.myModuleEditors.get(module);
    }

    public ModuleRootModel getRootModel(@NotNull Module module) {
        if (module == null) {
            ModulesConfigurator.$$$reportNull$$$0(2);
        }
        return this.getOrCreateModuleEditor(module).getRootModel();
    }

    @NotNull
    public ModuleEditor getOrCreateModuleEditor(@NotNull Module module) {
        String moduleName;
        if (module == null) {
            ModulesConfigurator.$$$reportNull$$$0(3);
        }
        LOG.assertTrue(this.getModule(moduleName = module.getName()) != null, (Object)("Module " + moduleName + " has been deleted"));
        ModuleEditor editor = this.getModuleEditor(module);
        if (editor == null) {
            editor = this.doCreateModuleEditor(module);
        }
        ModuleEditor moduleEditor = editor;
        if (moduleEditor == null) {
            ModulesConfigurator.$$$reportNull$$$0(4);
        }
        return moduleEditor;
    }

    @NotNull
    private ModuleEditor doCreateModuleEditor(@NotNull Module module) {
        if (module == null) {
            ModulesConfigurator.$$$reportNull$$$0(5);
        }
        HeaderHidingTabbedModuleEditor moduleEditor = new HeaderHidingTabbedModuleEditor(this.myProject, this, module){

            @Override
            public ProjectFacetsConfigurator getFacetsConfigurator() {
                return ModulesConfigurator.this.myFacetsConfigurator;
            }
        };
        this.myModuleEditors.put(moduleEditor.getModule(), moduleEditor);
        moduleEditor.addChangeListener(this);
        HeaderHidingTabbedModuleEditor headerHidingTabbedModuleEditor = moduleEditor;
        if (headerHidingTabbedModuleEditor == null) {
            ModulesConfigurator.$$$reportNull$$$0(6);
        }
        return headerHidingTabbedModuleEditor;
    }

    @NotNull
    public FacetModel getFacetModel(@NotNull Module module) {
        if (module == null) {
            ModulesConfigurator.$$$reportNull$$$0(7);
        }
        ModifiableFacetModel modifiableFacetModel = this.myFacetsConfigurator.getOrCreateModifiableModel(module);
        if (modifiableFacetModel == null) {
            ModulesConfigurator.$$$reportNull$$$0(8);
        }
        return modifiableFacetModel;
    }

    public void resetModuleEditors() {
        this.initModuleModel();
        ApplicationManager.getApplication().runWriteAction(() -> {
            Module[] modules;
            if (!this.myModuleEditors.isEmpty()) {
                LOG.error("module editors was not disposed");
                this.myModuleEditors.clear();
            }
            for (Module module : modules = this.myModuleModel.getModules()) {
                this.getOrCreateModuleEditor(module);
            }
        });
        this.myFacetsConfigurator.resetEditors();
        this.myModified = false;
    }

    @Override
    public void moduleStateChanged(ModifiableRootModel moduleRootModel) {
        for (ModuleEditor.ChangeListener listener : this.myAllModulesChangeListeners) {
            listener.moduleStateChanged(moduleRootModel);
        }
        this.myContext.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(this.myContext, moduleRootModel.getModule()));
    }

    public void addAllModuleChangeListener(ModuleEditor.ChangeListener listener) {
        this.myAllModulesChangeListeners.add(listener);
    }

    public void apply() throws ConfigurationException {
        this.validateContentAndSourceRoots();
        this.validateModuleEditors();
        Map<Sdk, Sdk> modifiedToOriginalMap = this.createSdkMapping();
        ApplicationManager.getApplication().runWriteAction(() -> {
            List<ModifiableRootModel> models = this.applyModuleEditors(modifiedToOriginalMap);
            this.commitChanges(models);
            return null;
        });
        this.myModified = false;
    }

    private void validateContentAndSourceRoots() throws ConfigurationException {
        HashMap<VirtualFile, String> contentRootToModuleNameMap = new HashMap<VirtualFile, String>();
        HashMap<VirtualFile, VirtualFile> srcRootsToContentRootMap = new HashMap<VirtualFile, VirtualFile>();
        for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
            this.validateModuleRoots(moduleEditor, contentRootToModuleNameMap, srcRootsToContentRootMap);
        }
        ModulesConfigurator.validateSourceRootsAcrossModules(srcRootsToContentRootMap, contentRootToModuleNameMap);
    }

    private void validateModuleRoots(@NotNull ModuleEditor moduleEditor, @NotNull Map<VirtualFile, String> contentRootToModuleNameMap, @NotNull Map<VirtualFile, VirtualFile> srcRootsToContentRootMap) throws ConfigurationException {
        boolean duplicatesAreAllowed;
        if (moduleEditor == null) {
            ModulesConfigurator.$$$reportNull$$$0(9);
        }
        if (contentRootToModuleNameMap == null) {
            ModulesConfigurator.$$$reportNull$$$0(10);
        }
        if (srcRootsToContentRootMap == null) {
            ModulesConfigurator.$$$reportNull$$$0(11);
        }
        if (duplicatesAreAllowed = CodeInsightContexts.isSharedSourceSupportEnabled((Project)this.myProject)) {
            return;
        }
        ModuleRootModel rootModel = moduleEditor.getRootModel();
        ContentEntry[] contents = rootModel.getContentEntries();
        String moduleName = moduleEditor.getName();
        HashSet<VirtualFile> sourceRoots = new HashSet<VirtualFile>();
        for (ContentEntry content : contents) {
            for (VirtualFile root : content.getSourceFolderFiles()) {
                if (sourceRoots.add(root)) continue;
                throw new ConfigurationException(JavaUiBundle.message("module.paths.validation.duplicate.source.root.in.same.module.error", root.getPresentableUrl(), moduleName));
            }
        }
        for (ContentEntry contentEntry : contents) {
            VirtualFile contentRoot = contentEntry.getFile();
            if (contentRoot == null) continue;
            String previousName = contentRootToModuleNameMap.put(contentRoot, moduleName);
            if (previousName != null && !previousName.equals(moduleName)) {
                throw new ConfigurationException(JavaUiBundle.message("module.paths.validation.duplicate.content.error", contentRoot.getPresentableUrl(), previousName, moduleName));
            }
            for (VirtualFile srcRoot : contentEntry.getSourceFolderFiles()) {
                VirtualFile anotherContentRoot = srcRootsToContentRootMap.put(srcRoot, contentRoot);
                if (anotherContentRoot == null) continue;
                ModulesConfigurator.throwDuplicateSourceRootError(srcRoot, contentRoot, anotherContentRoot, contentRootToModuleNameMap);
            }
        }
    }

    private static void throwDuplicateSourceRootError(@NotNull VirtualFile srcRoot, @NotNull VirtualFile contentRoot, @NotNull VirtualFile anotherContentRoot, @NotNull Map<VirtualFile, String> contentRootToModuleNameMap) throws ConfigurationException {
        String correctModule;
        String problematicModule;
        if (srcRoot == null) {
            ModulesConfigurator.$$$reportNull$$$0(12);
        }
        if (contentRoot == null) {
            ModulesConfigurator.$$$reportNull$$$0(13);
        }
        if (anotherContentRoot == null) {
            ModulesConfigurator.$$$reportNull$$$0(14);
        }
        if (contentRootToModuleNameMap == null) {
            ModulesConfigurator.$$$reportNull$$$0(15);
        }
        if (VfsUtilCore.isAncestor((VirtualFile)anotherContentRoot, (VirtualFile)contentRoot, (boolean)true)) {
            problematicModule = contentRootToModuleNameMap.get(anotherContentRoot);
            correctModule = contentRootToModuleNameMap.get(contentRoot);
        } else {
            problematicModule = contentRootToModuleNameMap.get(contentRoot);
            correctModule = contentRootToModuleNameMap.get(anotherContentRoot);
        }
        throw new ConfigurationException(JavaUiBundle.message("module.paths.validation.duplicate.source.root.error", problematicModule, srcRoot.getPresentableUrl(), correctModule));
    }

    private static void validateSourceRootsAcrossModules(@NotNull Map<VirtualFile, VirtualFile> srcRootsToContentRootMap, @NotNull Map<VirtualFile, String> contentRootToModuleNameMap) throws ConfigurationException {
        if (srcRootsToContentRootMap == null) {
            ModulesConfigurator.$$$reportNull$$$0(16);
        }
        if (contentRootToModuleNameMap == null) {
            ModulesConfigurator.$$$reportNull$$$0(17);
        }
        for (Map.Entry<VirtualFile, VirtualFile> entry : srcRootsToContentRootMap.entrySet()) {
            VirtualFile srcRoot = entry.getKey();
            VirtualFile correspondingContent = entry.getValue();
            String expectedModuleName = contentRootToModuleNameMap.get(correspondingContent);
            for (VirtualFile candidateContent = srcRoot; candidateContent != null && !candidateContent.equals(correspondingContent); candidateContent = candidateContent.getParent()) {
                String moduleName = contentRootToModuleNameMap.get(candidateContent);
                if (moduleName == null || moduleName.equals(expectedModuleName)) continue;
                throw new ConfigurationException(JavaUiBundle.message("module.paths.validation.source.root.belongs.to.another.module.error", srcRoot.getPresentableUrl(), expectedModuleName, moduleName));
            }
        }
    }

    private void validateModuleEditors() throws ConfigurationException {
        for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
            moduleEditor.canApply();
        }
    }

    @NotNull
    private Map<Sdk, Sdk> createSdkMapping() {
        HashMap<Sdk, Sdk> modifiedToOriginalMap = new HashMap<Sdk, Sdk>();
        ProjectSdksModel projectJdksModel = this.myProjectStructureConfigurable.getProjectJdksModel();
        for (Map.Entry entry : projectJdksModel.getProjectSdks().entrySet()) {
            modifiedToOriginalMap.put((Sdk)entry.getValue(), (Sdk)entry.getKey());
        }
        HashMap<Sdk, Sdk> hashMap = modifiedToOriginalMap;
        if (hashMap == null) {
            ModulesConfigurator.$$$reportNull$$$0(18);
        }
        return hashMap;
    }

    @NotNull
    private List<ModifiableRootModel> applyModuleEditors(@NotNull Map<Sdk, Sdk> modifiedToOriginalMap) throws ConfigurationException {
        if (modifiedToOriginalMap == null) {
            ModulesConfigurator.$$$reportNull$$$0(19);
        }
        ArrayList<ModifiableRootModel> models = new ArrayList<ModifiableRootModel>(this.myModuleEditors.size());
        for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
            ModifiableRootModel model = moduleEditor.apply();
            if (model == null) continue;
            ModulesConfigurator.updateModelSdk(model, modifiedToOriginalMap);
            models.add(model);
        }
        this.myFacetsConfigurator.applyEditors();
        ArrayList<ModifiableRootModel> arrayList = models;
        if (arrayList == null) {
            ModulesConfigurator.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    private static void updateModelSdk(@NotNull ModifiableRootModel model, @NotNull Map<Sdk, Sdk> modifiedToOriginalMap) {
        Sdk original;
        Sdk modelSdk;
        if (model == null) {
            ModulesConfigurator.$$$reportNull$$$0(21);
        }
        if (modifiedToOriginalMap == null) {
            ModulesConfigurator.$$$reportNull$$$0(22);
        }
        if (!model.isSdkInherited() && (modelSdk = model.getSdk()) != null && (original = modifiedToOriginalMap.get(modelSdk)) != null) {
            model.setSdk(original);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitChanges(@NotNull List<ModifiableRootModel> models) {
        if (models == null) {
            ModulesConfigurator.$$$reportNull$$$0(23);
        }
        try {
            for (ModuleEditor editor : this.myModuleEditors.values()) {
                editor.resetModifiableModel();
            }
            ModifiableModelCommitter.multiCommit(models, (ModifiableModuleModel)this.myModuleModel);
            this.myModuleModelCommitted = true;
            this.myFacetsConfigurator.commitFacets();
        }
        finally {
            this.cleanupAfterCommit();
        }
    }

    private void cleanupAfterCommit() {
        this.myProjectStructureConfigurable.getModulesConfig().getFacetEditorFacade().clearMaps(false);
        this.myFacetsConfigurator = this.createFacetsConfigurator();
        this.initModuleModel();
        this.myModuleModelCommitted = false;
    }

    private ProjectFacetsConfigurator createFacetsConfigurator() {
        return new ProjectFacetsConfigurator(this.myContext, this.myFacetsConfigurator);
    }

    public void setModified(boolean modified) {
        this.myModified = modified;
    }

    public ModifiableModuleModel getModuleModel() {
        return this.myModuleModel;
    }

    public boolean isModuleModelCommitted() {
        return this.myModuleModelCommitted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private List<Module> addModule(Producer<@Nullable AbstractProjectWizard> createWizardAction) {
        AbstractProjectWizard wizard2 = (AbstractProjectWizard)((Object)createWizardAction.produce());
        if (null == wizard2) {
            return null;
        }
        try {
            List<Module> list2 = this.doAddModule(wizard2);
            return list2;
        }
        finally {
            Disposer.dispose((Disposable)wizard2.getDisposable());
        }
    }

    @Nullable
    private List<Module> doAddModule(@NotNull AbstractProjectWizard wizard2) {
        List<Module> modules;
        ProjectBuilder builder;
        if (wizard2 == null) {
            ModulesConfigurator.$$$reportNull$$$0(24);
        }
        if (null == (builder = this.runWizard(wizard2))) {
            return null;
        }
        if (builder instanceof ProjectImportBuilder) {
            ModifiableArtifactModel artifactModel = this.myProjectStructureConfigurable.getArtifactsStructureConfigurable().getModifiableArtifactModel();
            modules = ((ProjectImportBuilder)builder).commit(this.myProject, this.myModuleModel, this, artifactModel);
        } else {
            modules = builder.commit(this.myProject, this.myModuleModel, (ModulesProvider)this);
        }
        if (null != modules && !modules.isEmpty()) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                for (Module module : modules) {
                    if (module == null || this.getModule(module.getName()) == null) continue;
                    this.getOrCreateModuleEditor(module);
                }
            });
        }
        return modules;
    }

    @Nullable
    public List<Module> addImportModule(Component parent) {
        if (this.myProject.isDefault()) {
            return null;
        }
        return this.addModule((Producer<AbstractProjectWizard>)((Producer)() -> this.createImportModuleWizard(parent)));
    }

    @Nullable
    public List<Module> addNewModule(@Nullable String defaultPath) {
        if (this.myProject.isDefault()) {
            return null;
        }
        return this.addModule((Producer<AbstractProjectWizard>)((Producer)() -> this.createNewModuleWizard(defaultPath)));
    }

    private Module createModule(ModuleBuilder builder) {
        try {
            return (Module)ApplicationManager.getApplication().runWriteAction(() -> builder.createModule(this.myModuleModel));
        }
        catch (Exception e) {
            LOG.error(JavaUiBundle.message("module.add.error.message", e.getMessage()), (Throwable)e);
            Messages.showErrorDialog((String)JavaUiBundle.message("module.add.error.message", e.getMessage()), (String)JavaUiBundle.message("module.add.error.title", new Object[0]));
            return null;
        }
    }

    @Nullable
    public Module addModule(ModuleBuilder moduleBuilder) {
        Module module = this.createModule(moduleBuilder);
        if (module != null) {
            ApplicationManager.getApplication().runWriteAction(() -> this.getOrCreateModuleEditor(module));
            this.processModuleCountChanged();
        }
        return module;
    }

    @Nullable
    private ProjectBuilder runWizard(@Nullable AbstractProjectWizard wizard2) {
        if (wizard2 == null) {
            return null;
        }
        if (wizard2.getStepCount() == 0) {
            ProjectBuilder builder = wizard2.getProjectBuilder();
            if (!builder.validate(this.myProject, this.myProject)) {
                builder = null;
            }
            return builder;
        }
        if (!wizard2.showAndGet()) {
            return null;
        }
        return wizard2.getBuilder(this.myProject);
    }

    @Nullable
    private AbstractProjectWizard createImportModuleWizard(Component dialogParent) {
        return ImportModuleAction.selectFileAndCreateWizard(this.myProject, dialogParent);
    }

    @NotNull
    private AbstractProjectWizard createNewModuleWizard(@Nullable String defaultPath) {
        NewProjectWizardFactory wizardFactory = (NewProjectWizardFactory)ApplicationManager.getApplication().getService(NewProjectWizardFactory.class);
        NewProjectWizard newProjectWizard = wizardFactory.create(this.myProject, this, defaultPath);
        if (newProjectWizard == null) {
            ModulesConfigurator.$$$reportNull$$$0(25);
        }
        return newProjectWizard;
    }

    public void deleteModules(@NotNull List<? extends ModuleEditor> selectedEditors) {
        if (selectedEditors == null) {
            ModulesConfigurator.$$$reportNull$$$0(26);
        }
        WriteAction.run(() -> {
            for (ModuleEditor editor : selectedEditors) {
                this.myModuleEditors.remove(editor.getModule());
                Module moduleToRemove = editor.getModule();
                ArrayList modifiableRootModels = new ArrayList();
                for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
                    ModifiableRootModel modifiableRootModel = moduleEditor.getModifiableRootModelProxy();
                    ContainerUtil.addIfNotNull(modifiableRootModels, (Object)modifiableRootModel);
                }
                ModuleDeleteProvider.removeModule((Module)moduleToRemove, modifiableRootModels, (ModifiableModuleModel)this.myModuleModel);
                Disposer.dispose((Disposable)editor);
            }
        });
        this.processModuleCountChanged();
    }

    public boolean canDeleteModules(@NotNull List<? extends ModuleEditor> selectedEditors) {
        if (selectedEditors == null) {
            ModulesConfigurator.$$$reportNull$$$0(27);
        }
        String question = this.myModuleEditors.size() == selectedEditors.size() ? JavaUiBundle.message("module.remove.last.confirmation", selectedEditors.size()) : JavaUiBundle.message("module.remove.confirmation", selectedEditors.get(0).getModule().getName(), selectedEditors.size());
        int result = Messages.showYesNoDialog((Project)this.myProject, (String)question, (String)JavaUiBundle.message("module.remove.confirmation.title", selectedEditors.size()), (Icon)Messages.getQuestionIcon());
        return result == 0;
    }

    private void processModuleCountChanged() {
        for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
            moduleEditor.moduleCountChanged();
        }
    }

    public void processModuleCompilerOutputChanged(String baseUrl) {
        for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
            moduleEditor.updateCompilerOutputPathChanged(baseUrl, moduleEditor.getName());
        }
    }

    public boolean isModified() {
        if (this.myModuleModel.isChanged()) {
            return true;
        }
        for (ModuleEditor moduleEditor : this.myModuleEditors.values()) {
            if (!moduleEditor.isModified()) continue;
            return true;
        }
        return this.myModified || this.myFacetsConfigurator.isModified();
    }

    public static boolean showArtifactSettings(@NotNull Project project2, @Nullable Artifact artifact) {
        if (project2 == null) {
            ModulesConfigurator.$$$reportNull$$$0(28);
        }
        ProjectStructureConfigurable configurable = ProjectStructureConfigurable.getInstance(project2);
        return ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)configurable, () -> configurable.select(artifact, true));
    }

    public static boolean showFacetSettingsDialog(@NotNull Facet<?> facet, @Nullable String tabNameToSelect) {
        if (facet == null) {
            ModulesConfigurator.$$$reportNull$$$0(29);
        }
        Project project2 = facet.getModule().getProject();
        ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(project2);
        return ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)config, () -> {
            ModuleStructureConfigurable modulesConfig = config.getModulesConfig();
            config.select(facet, true).doWhenDone(() -> {
                if (tabNameToSelect != null) {
                    FacetEditorImpl facetEditor = modulesConfig.getFacetConfigurator().getOrCreateEditor(facet);
                    facetEditor.setSelectedTabName(tabNameToSelect);
                }
            });
        });
    }

    public static boolean showDialog(@NotNull Project project2, @Nullable String moduleToSelect, @Nullable String editorNameToSelect) {
        if (project2 == null) {
            ModulesConfigurator.$$$reportNull$$$0(30);
        }
        ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance(project2);
        return ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)config, () -> config.select(moduleToSelect, editorNameToSelect, true));
    }

    public void moduleRenamed(@NotNull Module module, String oldName, @NotNull String name) {
        ModuleEditor moduleEditor;
        if (module == null) {
            ModulesConfigurator.$$$reportNull$$$0(31);
        }
        if (name == null) {
            ModulesConfigurator.$$$reportNull$$$0(32);
        }
        if ((moduleEditor = this.myModuleEditors.get(module)) != null) {
            moduleEditor.setModuleName(name);
            moduleEditor.updateCompilerOutputPathChanged(this.myProjectStructureConfigurable.getProjectConfig().getCompilerOutputUrl(), name);
            this.myContext.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(this.myContext, module));
        }
    }

    public StructureConfigurableContext getContext() {
        return this.myContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 7, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 21, 22, 23, 24, 26, 27, 28, 29, 30, 31, 32 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/ModulesConfigurator";
                break;
            }
            case 1: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleEditor";
                break;
            }
            case 10: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRootToModuleNameMap";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcRootsToContentRootMap";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcRoot";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anotherContentRoot";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiedToOriginalMap";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedEditors";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ModulesConfigurator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateModuleEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateModuleEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetModel";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createSdkMapping";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "applyModuleEditors";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewModuleWizard";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getModule";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRootModel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateModuleEditor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doCreateModuleEditor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFacetModel";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "validateModuleRoots";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "throwDuplicateSourceRootError";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "validateSourceRootsAcrossModules";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "applyModuleEditors";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateModelSdk";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "commitChanges";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "doAddModule";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "deleteModules";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteModules";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "showArtifactSettings";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "showFacetSettingsDialog";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "moduleRenamed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 7, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 21, 22, 23, 24, 26, 27, 28, 29, 30, 31, 32 -> new IllegalArgumentException(string);
        };
    }

    @ApiStatus.Internal
    public static interface NewProjectWizardFactory {
        @NotNull
        public NewProjectWizard create(@Nullable Project var1, @NotNull ModulesProvider var2, @Nullable String var3);
    }

    static final class NewProjectWizardFactoryImpl
    implements NewProjectWizardFactory {
        NewProjectWizardFactoryImpl() {
        }

        @Override
        @NotNull
        public NewProjectWizard create(@Nullable Project project2, @NotNull ModulesProvider modulesProvider, @Nullable String defaultPath) {
            if (modulesProvider == null) {
                NewProjectWizardFactoryImpl.$$$reportNull$$$0(0);
            }
            return new NewProjectWizard(project2, modulesProvider, defaultPath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesProvider", "com/intellij/openapi/roots/ui/configuration/ModulesConfigurator$NewProjectWizardFactoryImpl", "create"));
        }
    }
}

