/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.roots.ui.configuration.AnnotationsEditor;
import com.intellij.openapi.roots.ui.configuration.BuildElementsEditor;
import com.intellij.openapi.roots.ui.configuration.JavadocEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.openapi.roots.ui.configuration.OutputEditorUi;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class OutputEditor
extends ModuleElementsEditor {
    private final BuildElementsEditor myCompilerOutputEditor;
    private final JavadocEditor myJavadocEditor;
    private final AnnotationsEditor myAnnotationsEditor;
    private final List<ModuleElementsEditor> myEditors;

    public OutputEditor(ModuleConfigurationState state) {
        super(state);
        this.myCompilerOutputEditor = new BuildElementsEditor(state);
        this.myJavadocEditor = new JavadocEditor(state);
        this.myAnnotationsEditor = new AnnotationsEditor(state);
        this.myEditors = Arrays.asList(new ModuleElementsEditor[]{this.myCompilerOutputEditor, this.myJavadocEditor, this.myAnnotationsEditor});
        this.myEditors.forEach(editor -> editor.addListener(() -> ((OutputEditor)this).fireConfigurationChanged()));
    }

    protected JComponent createComponentImpl() {
        DialogPanel panel2 = new OutputEditorUi().createPanel(this.myCompilerOutputEditor, this.myJavadocEditor, this.myAnnotationsEditor);
        return ScrollPaneFactory.createScrollPane((Component)panel2);
    }

    public void saveData() {
        super.saveData();
        this.myEditors.forEach(ModuleConfigurationEditor::saveData);
    }

    @NlsContexts.ConfigurableName
    public String getDisplayName() {
        return OutputEditor.getName();
    }

    public void moduleStateChanged() {
        super.moduleStateChanged();
        this.myEditors.forEach(ModuleConfigurationEditor::moduleStateChanged);
    }

    public void moduleCompileOutputChanged(String baseUrl, String moduleName) {
        super.moduleCompileOutputChanged(baseUrl, moduleName);
        this.myEditors.forEach(editor -> editor.moduleCompileOutputChanged(baseUrl, moduleName));
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "projectStructure.modules.paths";
    }

    @NlsContexts.ConfigurableName
    public static String getName() {
        return JavaUiBundle.message("project.roots.path.tab.title", new Object[0]);
    }
}

