/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.JdkComboBox;
import com.intellij.openapi.roots.ui.configuration.ProjectJdkConfigurableUi;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzer;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectJdkConfigurable
implements UnnamedConfigurable {
    private static final Logger LOG = Logger.getInstance(ProjectJdkConfigurable.class);
    private JdkComboBox myCbProjectJdk;
    private JPanel myJdkPanel;
    private final Project myProject;
    private final ProjectStructureConfigurable myProjectStructureConfigurable;
    private final ProjectSdksModel myJdksModel;
    private final SdkModel.Listener myListener = new SdkModel.Listener(){

        public void sdkAdded(@NotNull Sdk sdk) {
            if (sdk == null) {
                1.$$$reportNull$$$0(0);
            }
            ProjectJdkConfigurable.this.reloadModel();
        }

        public void beforeSdkRemove(@NotNull Sdk sdk) {
            if (sdk == null) {
                1.$$$reportNull$$$0(1);
            }
            ProjectJdkConfigurable.this.reloadModel();
        }

        public void sdkChanged(@NotNull Sdk sdk, String previousName) {
            if (sdk == null) {
                1.$$$reportNull$$$0(2);
            }
            ProjectJdkConfigurable.this.reloadModel();
        }

        public void sdkHomeSelected(@NotNull Sdk sdk, @NotNull String newSdkHome) {
            if (sdk == null) {
                1.$$$reportNull$$$0(3);
            }
            if (newSdkHome == null) {
                1.$$$reportNull$$$0(4);
            }
            ProjectJdkConfigurable.this.reloadModel();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newSdkHome";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ProjectJdkConfigurable$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sdkAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeSdkRemove";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sdkChanged";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sdkHomeSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private boolean myFreeze = false;

    public ProjectJdkConfigurable(ProjectStructureConfigurable projectStructureConfigurable, ProjectSdksModel jdksModel) {
        this.myProject = projectStructureConfigurable.getProject();
        this.myProjectStructureConfigurable = projectStructureConfigurable;
        this.myJdksModel = jdksModel;
        this.myJdksModel.addListener(this.myListener);
    }

    @Nullable
    public Sdk getSelectedProjectJdk() {
        return this.myCbProjectJdk != null ? this.myJdksModel.findSdk(this.myCbProjectJdk.getSelectedJdk()) : null;
    }

    @NotNull
    public JComponent createComponent() {
        if (this.myJdkPanel == null) {
            ProjectJdkConfigurableUi ui = new ProjectJdkConfigurableUi();
            this.myJdkPanel = ui.panel(this.myProject, this.myJdksModel);
            this.myCbProjectJdk = ui.getJdkComboBox();
            this.myCbProjectJdk.showNoneSdkItem();
            this.myCbProjectJdk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ProjectJdkConfigurable.this.myFreeze) {
                        return;
                    }
                    if (ProjectJdkConfigurable.this.myCbProjectJdk != null) {
                        ProjectJdkConfigurable.this.myJdksModel.setProjectSdk(ProjectJdkConfigurable.this.myCbProjectJdk.getSelectedJdk());
                    }
                    ProjectJdkConfigurable.this.clearCaches();
                }
            });
            JButton editButton = ui.getEditButton();
            this.myCbProjectJdk.setEditButton(editButton, this.myProject, () -> ((ProjectSdksModel)this.myJdksModel).getProjectSdk());
        }
        JPanel jPanel = this.myJdkPanel;
        if (jPanel == null) {
            ProjectJdkConfigurable.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    private void reloadModel() {
        this.myFreeze = true;
        Sdk projectJdk = this.myJdksModel.getProjectSdk();
        if (this.myCbProjectJdk != null) {
            String sdkName;
            this.myCbProjectJdk.reloadModel();
            String string = sdkName = projectJdk == null ? ProjectRootManager.getInstance((Project)this.myProject).getProjectSdkName() : projectJdk.getName();
            if (sdkName != null) {
                Sdk jdk = this.myJdksModel.findSdk(sdkName);
                if (jdk != null) {
                    this.myCbProjectJdk.setSelectedJdk(jdk);
                } else {
                    this.myCbProjectJdk.setInvalidJdk(sdkName);
                    this.clearCaches();
                }
            } else {
                this.myCbProjectJdk.setSelectedJdk(null);
            }
        } else {
            LOG.error("'createComponent' wasn't called before 'reset' for " + this.toString());
        }
        this.myFreeze = false;
    }

    private void clearCaches() {
        ModuleStructureConfigurable rootConfigurable = this.myProjectStructureConfigurable.getModulesConfig();
        Object[] modules = rootConfigurable.getModules();
        if (modules.length == 0) {
            return;
        }
        StructureConfigurableContext context = rootConfigurable.getContext();
        ProjectStructureDaemonAnalyzer analyzer = context.getDaemonAnalyzer();
        analyzer.queueUpdates(ContainerUtil.map((Object[])modules, module -> new ModuleProjectStructureElement(context, (Module)module)));
    }

    public boolean isModified() {
        Sdk projectJdk = ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
        return !Comparing.equal((Object)projectJdk, (Object)this.getSelectedProjectJdk());
    }

    public void apply() {
        ProjectRootManager.getInstance((Project)this.myProject).setProjectSdk(this.getSelectedProjectJdk());
    }

    public void reset() {
        this.reloadModel();
        if (this.myCbProjectJdk != null) {
            String sdkName = ProjectRootManager.getInstance((Project)this.myProject).getProjectSdkName();
            if (sdkName != null) {
                Sdk jdk = this.myJdksModel.findSdk(sdkName);
                if (jdk != null) {
                    this.myCbProjectJdk.setSelectedJdk(jdk);
                } else {
                    this.myCbProjectJdk.setInvalidJdk(sdkName);
                }
            } else {
                this.myCbProjectJdk.setSelectedJdk(null);
            }
        }
    }

    public void disposeUIResources() {
        this.myJdksModel.removeListener(this.myListener);
        this.myJdkPanel = null;
        this.myCbProjectJdk = null;
    }

    void addChangeListener(ActionListener listener) {
        this.myCbProjectJdk.addActionListener(listener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/ProjectJdkConfigurable", "createComponent"));
    }
}

