/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.roots.ui.configuration.ErrorPaneConfigurable;
import com.intellij.openapi.roots.ui.configuration.SidePanelCountLabel;
import com.intellij.openapi.roots.ui.configuration.SidePanelSeparator;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.AbstractExpandableItemsHandler;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.Gray;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SidePanel
extends JPanel {
    private final JList<SidePanelItem> myList;
    private final DefaultListModel<SidePanelItem> myModel;
    private final Place.Navigator myNavigator;
    private final Int2ObjectMap<@Nls String> myIndex2Separator = new Int2ObjectOpenHashMap();

    public SidePanel(Place.Navigator navigator) {
        this.myNavigator = navigator;
        this.setLayout(new BorderLayout());
        this.myModel = new DefaultListModel();
        this.myList = new JBList(this.myModel);
        this.myList.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        this.myList.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        ListItemDescriptor<SidePanelItem> descriptor = new ListItemDescriptor<SidePanelItem>(){

            public String getTextFor(SidePanelItem value) {
                return value.myText;
            }

            public String getTooltipFor(SidePanelItem value) {
                return null;
            }

            public Icon getIconFor(SidePanelItem value) {
                return JBUIScale.scaleIcon((JBScalableIcon)EmptyIcon.create((int)16, (int)20));
            }

            public boolean hasSeparatorAboveOf(SidePanelItem value) {
                return SidePanel.this.getSeparatorAbove(value) != null;
            }

            public String getCaptionAboveOf(SidePanelItem value) {
                return SidePanel.this.getSeparatorAbove(value);
            }
        };
        this.myList.setCellRenderer((ListCellRenderer<SidePanelItem>)new GroupedItemsListRenderer<SidePanelItem>((ListItemDescriptor)descriptor, (ListItemDescriptor)descriptor){
            JPanel myExtraPanel;
            SidePanelCountLabel myCountLabel;
            final CellRendererPane myValidationParent;
            final /* synthetic */ ListItemDescriptor val$descriptor;
            {
                this.val$descriptor = listItemDescriptor;
                super(arg0);
                this.myValidationParent = new CellRendererPane();
                this.mySeparatorComponent.setCaptionCentered(false);
                SidePanel.this.myList.add(this.myValidationParent);
            }

            protected SeparatorWithText createSeparator() {
                return new SidePanelSeparator();
            }

            protected void layout() {
                this.myRendererComponent.add((Component)this.mySeparatorComponent, (Object)"North");
                this.myExtraPanel.add((Component)this.getItemComponent(), "Center");
                this.myExtraPanel.add((Component)this.myCountLabel, "East");
                this.myRendererComponent.add((Component)this.myExtraPanel, (Object)"Center");
            }

            public Component getListCellRendererComponent(JList<? extends SidePanelItem> list2, SidePanelItem value, int index, boolean isSelected, boolean cellHasFocus) {
                int errorsCount;
                ErrorPaneConfigurable errorPane;
                this.layout();
                this.myCountLabel.setText("");
                Component component = super.getListCellRendererComponent(list2, (Object)value, index, isSelected, cellHasFocus);
                if ("Problems".equals(this.val$descriptor.getTextFor((Object)value)) && (errorPane = (ErrorPaneConfigurable)value.myPlace.getPath("category")) != null && (errorsCount = errorPane.getErrorsCount()) > 0) {
                    this.myCountLabel.setSelected(isSelected);
                    this.myCountLabel.setText(errorsCount > 100 ? "100+" : String.valueOf(errorsCount));
                }
                if (ClientProperty.isTrue(list2, (Object)ExpandableItemsHandler.EXPANDED_RENDERER)) {
                    Rectangle bounds = list2.getCellBounds(index, index);
                    bounds.setSize((int)component.getPreferredSize().getWidth(), (int)bounds.getHeight());
                    AbstractExpandableItemsHandler.setRelativeBounds((Component)component, (Rectangle)bounds, (Component)this.myExtraPanel, (Container)this.myValidationParent);
                    this.myExtraPanel.setSize((int)this.myExtraPanel.getPreferredSize().getWidth(), this.myExtraPanel.getHeight());
                    this.myExtraPanel.putClientProperty(ExpandableItemsHandler.USE_RENDERER_BOUNDS, true);
                    return this.myExtraPanel;
                }
                return component;
            }

            protected JComponent createItemComponent() {
                this.myExtraPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
                this.myCountLabel = new SidePanelCountLabel();
                JComponent component = super.createItemComponent();
                this.myTextLabel.setForeground((Color)Gray._240);
                this.myTextLabel.setOpaque(true);
                return component;
            }

            protected Color getBackground() {
                return UIUtil.SIDE_PANEL_BACKGROUND;
            }
        });
        this.add((Component)ScrollPaneFactory.createScrollPane(this.myList, (boolean)true), "Center");
        this.myList.setSelectionMode(0);
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                SidePanelItem value = SidePanel.this.myList.getSelectedValue();
                if (value != null) {
                    SidePanel.this.myNavigator.navigateTo(value.myPlace, false);
                }
            }
        });
    }

    public JList getList() {
        return this.myList;
    }

    public void addPlace(Place place, @NotNull Presentation presentation) {
        if (presentation == null) {
            SidePanel.$$$reportNull$$$0(0);
        }
        this.myModel.addElement(new SidePanelItem(place, presentation.getText()));
        this.revalidate();
        this.repaint();
    }

    public void addSeparator(@Nls String text) {
        this.myIndex2Separator.put(this.myModel.size(), (Object)text);
    }

    @NlsContexts.Separator
    @Nullable
    private String getSeparatorAbove(SidePanelItem item) {
        return (String)this.myIndex2Separator.get(this.myModel.indexOf(item));
    }

    public void select(Place place) {
        for (int i = 0; i < this.myModel.getSize(); ++i) {
            SidePanelItem item = this.myModel.getElementAt(i);
            if (!place.equals((Object)item.myPlace)) continue;
            this.myList.setSelectedValue(item, true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/roots/ui/configuration/SidePanel", "addPlace"));
    }

    private static class SidePanelItem {
        private final Place myPlace;
        @Nls
        private final String myText;

        SidePanelItem(Place place, @Nls String text) {
            this.myPlace = place;
            this.myText = text;
        }

        public String toString() {
            return this.myText;
        }
    }
}

