/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.actions;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouperKt;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.PathUtilRt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/actions/ChangeModuleNamesAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "intellij.java.ui"})
@SourceDebugExtension(value={"SMAP\nChangeModuleNamesAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeModuleNamesAction.kt\ncom/intellij/openapi/roots/ui/configuration/actions/ChangeModuleNamesAction\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,72:1\n13471#2,3:73\n13225#2,2:76\n14060#2,2:78\n*S KotlinDebug\n*F\n+ 1 ChangeModuleNamesAction.kt\ncom/intellij/openapi/roots/ui/configuration/actions/ChangeModuleNamesAction\n*L\n37#1:73,3\n39#1:76,2\n65#1:78,2\n*E\n"})
public final class ChangeModuleNamesAction
extends DumbAwareAction {
    public ChangeModuleNamesAction() {
        super(JavaUiBundle.message("action.text.change.module.names", new Object[0]), JavaUiBundle.message("action.description.change.module.names", new Object[0]), null);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        e.getPresentation().setVisible(project2 != null && ModuleGrouperKt.isQualifiedModuleNamesEnabled((Project)project2) && e.getData(LangDataKeys.MODIFIABLE_MODULE_MODEL) != null);
        Module[] modules = (Module[])e.getData(LangDataKeys.MODULE_CONTEXT_ARRAY);
        e.getPresentation().setEnabled(modules != null && modules.length > 1);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        boolean bl;
        String commonPrefix;
        ModifiableModuleModel model;
        Module[] modules;
        block6: {
            int n;
            void $this$fold$iv;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Module[] moduleArray = (Module[])e.getData(LangDataKeys.MODULE_CONTEXT_ARRAY);
            if (moduleArray == null) {
                return;
            }
            modules = moduleArray;
            ModifiableModuleModel modifiableModuleModel = (ModifiableModuleModel)e.getData(LangDataKeys.MODIFIABLE_MODULE_MODEL);
            if (modifiableModuleModel == null) {
                return;
            }
            model = modifiableModuleModel;
            Module[] moduleArray2 = modules;
            Module module = modules[0];
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"get(...)");
            String initial$iv = ChangeModuleNamesAction.actionPerformed$getGroupName(model, module);
            boolean $i$f$fold = false;
            String accumulator$iv2 = initial$iv;
            int n2 = ((void)$this$fold$iv).length;
            for (n = 0; n < n2; ++n) {
                void m;
                void element$iv;
                void var12_19 = element$iv = $this$fold$iv[n];
                String prefix = accumulator$iv2;
                boolean bl2 = false;
                CharSequence charSequence = prefix;
                Intrinsics.checkNotNull((Object)m);
                accumulator$iv2 = StringsKt.commonPrefixWith$default((CharSequence)charSequence, (CharSequence)ChangeModuleNamesAction.actionPerformed$getGroupName(model, (Module)m), (boolean)false, (int)2, null);
            }
            commonPrefix = StringsKt.substringBeforeLast((String)accumulator$iv2, (char)'.', (String)"");
            Module[] $this$any$iv = modules;
            boolean $i$f$any = false;
            n = $this$any$iv.length;
            for (int accumulator$iv2 = 0; accumulator$iv2 < n; ++accumulator$iv2) {
                Module element$iv;
                Module it = element$iv = $this$any$iv[accumulator$iv2];
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)model.getActualName(it), (Object)commonPrefix)) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        boolean isPrefixEqualToModuleName = bl;
        InputValidatorEx validator2 = new InputValidatorEx(isPrefixEqualToModuleName){
            final /* synthetic */ boolean $isPrefixEqualToModuleName;
            {
                this.$isPrefixEqualToModuleName = $isPrefixEqualToModuleName;
            }

            public String getErrorText(String inputString) {
                Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
                if (((CharSequence)inputString).length() > 0) {
                    boolean bl;
                    block7: {
                        char[] cArray = new char[]{'.'};
                        Iterable $this$any$iv = StringsKt.split$default((CharSequence)inputString, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                String it = (String)element$iv;
                                boolean bl2 = false;
                                boolean bl3 = ((CharSequence)it).length() == 0;
                                if (!bl3) continue;
                                bl = true;
                                break block7;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        return JavaUiBundle.message("error.message.module.name.prefix.contains.empty.string", new Object[0]);
                    }
                }
                if (this.$isPrefixEqualToModuleName && ((CharSequence)inputString).length() == 0) {
                    return JavaUiBundle.message("error.message.module.name.cannot.be.empty", new Object[0]);
                }
                if (!PathUtilRt.isValidFileName((String)(inputString + ".iml"), (boolean)true)) {
                    return JavaUiBundle.message("error.message.module.name.prefix.contains.invalid.chars", new Object[0]);
                }
                return null;
            }

            public boolean canClose(String inputString) {
                Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
                return this.getErrorText(inputString) == null;
            }
        };
        Object[] accumulator$iv2 = new Object[]{modules.length};
        String newPrefix = Messages.showInputDialog((Project)e.getProject(), (String)JavaUiBundle.message("dialog.text.enter.common.prefix", accumulator$iv2), (String)JavaUiBundle.message("dialog.title.change.module.names", new Object[0]), null, (String)commonPrefix, (InputValidator)((InputValidator)validator2), (TextRange)TextRange.allOf((String)commonPrefix), (String)JavaUiBundle.message("dialog.text.enter.common.prefix.comment", new Object[0]));
        if (newPrefix == null) {
            return;
        }
        Object prefixToRemove = ((CharSequence)commonPrefix).length() == 0 ? "" : commonPrefix + ".";
        String prefixToPrepend = ((CharSequence)newPrefix).length() == 0 || StringsKt.endsWith$default((CharSequence)newPrefix, (char)'.', (boolean)false, (int)2, null) ? newPrefix : newPrefix + ".";
        Module[] $this$forEach$iv = modules;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String oldName;
            Module element$iv;
            Module it = element$iv = $this$forEach$iv[i];
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue((Object)model.getActualName(it), (String)"getActualName(...)");
            String newName = Intrinsics.areEqual((Object)oldName, (Object)commonPrefix) ? newPrefix : prefixToPrepend + StringsKt.removePrefix((String)oldName, (CharSequence)((CharSequence)prefixToRemove));
            model.renameModule(it, newName);
        }
        ProjectSettingsService.getInstance((Project)e.getProject()).processModulesMoved(modules, null);
    }

    private static final String actionPerformed$getGroupName(ModifiableModuleModel model, Module module) {
        String string = model.getActualName(module);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getActualName(...)");
        return StringsKt.substringBeforeLast$default((String)string, (char)'.', null, (int)2, null) + ".";
    }
}

