/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactConfigurableBase;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContextImpl;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.ui.SimpleListCellRenderer;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class ArtifactConfigurable
extends ArtifactConfigurableBase {
    public ArtifactConfigurable(Artifact originalArtifact, ArtifactsStructureConfigurableContextImpl artifactsStructureContext, Runnable updateTree) {
        super(originalArtifact, artifactsStructureContext, updateTree, true);
    }

    public void setDisplayName(String name) {
        ModifiableArtifactModel modifiableArtifactModel;
        String oldName = this.getArtifact().getName();
        if (name != null && !name.equals(oldName) && !this.isUpdatingNameFieldFromDisplayName() && (modifiableArtifactModel = this.myArtifactsStructureContext.getOrCreateModifiableArtifactModel()).findArtifact(name) == null) {
            modifiableArtifactModel.getOrCreateModifiableArtifact(this.myOriginalArtifact).setName(name);
            this.getEditor().updateOutputPath(oldName, name);
        }
    }

    public JComponent createOptionsPanel() {
        return this.getEditor().createMainComponent();
    }

    protected JComponent createTopRightComponent() {
        final ComboBox artifactTypeBox = new ComboBox();
        for (ArtifactType type : ArtifactType.getAllTypes()) {
            artifactTypeBox.addItem((Object)type);
        }
        artifactTypeBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> {
            label.setIcon(value.getIcon());
            label.setText(value.getPresentableName());
        }));
        artifactTypeBox.setSelectedItem((Object)this.getArtifact().getArtifactType());
        artifactTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArtifactType selected = (ArtifactType)artifactTypeBox.getSelectedItem();
                if (selected != null && !Comparing.equal((Object)selected, (Object)ArtifactConfigurable.this.getArtifact().getArtifactType())) {
                    ArtifactConfigurable.this.getEditor().setArtifactType(selected);
                }
            }
        });
        JPanel panel2 = new JPanel(new FlowLayout());
        JLabel artifactTypeBoxLabel = new JLabel(JavaUiBundle.message("label.artifact.configurable.type", new Object[0]));
        artifactTypeBoxLabel.setLabelFor((Component)artifactTypeBox);
        panel2.add(artifactTypeBoxLabel);
        panel2.add((Component)artifactTypeBox);
        return panel2;
    }

    public boolean isModified() {
        return this.getEditor().isModified();
    }

    public void apply() throws ConfigurationException {
        this.getEditor().apply();
    }

    public String getHelpTopic() {
        return this.getEditor().getHelpTopic();
    }

    private ArtifactEditorImpl getEditor() {
        return this.myArtifactsStructureContext.getOrCreateEditor(this.myOriginalArtifact);
    }
}

