/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.actions;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeSelection;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingNodeSource;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class HideContentAction
extends DumbAwareAction {
    private final ArtifactEditorEx myArtifactEditor;

    public HideContentAction(ArtifactEditorEx artifactEditor) {
        super(JavaUiBundle.message("action.text.hide.content", new Object[0]));
        this.myArtifactEditor = artifactEditor;
    }

    public void update(@NotNull AnActionEvent e) {
        Collection<PackagingNodeSource> sources;
        LayoutTreeSelection selection;
        PackagingElementNode<?> node;
        if (e == null) {
            HideContentAction.$$$reportNull$$$0(0);
        }
        if ((node = (selection = this.myArtifactEditor.getLayoutTreeComponent().getSelection()).getNodeIfSingle()) != null && !(sources = node.getNodeSources()).isEmpty()) {
            String name = sources.iterator().next().getPresentableName();
            e.getPresentation().setVisible(true);
            e.getPresentation().setText(JavaUiBundle.message("action.hide.content.text", name, sources.size()));
            return;
        }
        e.getPresentation().setVisible(false);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            HideContentAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        LayoutTreeSelection selection;
        PackagingElementNode<?> node;
        if (e == null) {
            HideContentAction.$$$reportNull$$$0(2);
        }
        if ((node = (selection = this.myArtifactEditor.getLayoutTreeComponent().getSelection()).getNodeIfSingle()) == null) {
            return;
        }
        Collection<PackagingNodeSource> sources = node.getNodeSources();
        for (PackagingNodeSource source : sources) {
            this.myArtifactEditor.getSubstitutionParameters().doNotSubstitute(source.getSourceElement());
            this.myArtifactEditor.getLayoutTreeComponent().getLayoutTree().addSubtreeToUpdate(source.getSourceParentNode());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/artifacts/actions/HideContentAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/actions/HideContentAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

