/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.actions;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeComponent;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.CompositePackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.openapi.util.NlsActions;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MovePackagingElementAction
extends DumbAwareAction {
    private final LayoutTreeComponent myLayoutTreeComponent;
    private final int myDirection;

    public MovePackagingElementAction(LayoutTreeComponent layoutTreeComponent, @Nullable @NlsActions.ActionText String text, @Nullable @NlsActions.ActionDescription String description, @Nullable Icon icon, int direction) {
        super(text, description, icon);
        this.myLayoutTreeComponent = layoutTreeComponent;
        this.myDirection = direction;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MovePackagingElementAction.$$$reportNull$$$0(0);
        }
        boolean b = this.isEnabled();
        e.getPresentation().setEnabled(b);
        e.getPresentation().setText(JavaUiBundle.message("action.text.0.disabled.if.elements.are.sorted", this.getTemplatePresentation().getText()));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            MovePackagingElementAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    private boolean isEnabled() {
        if (this.myLayoutTreeComponent.isSortElements()) {
            return false;
        }
        PackagingElementNode<?> node = this.myLayoutTreeComponent.getSelection().getNodeIfSingle();
        if (node == null) {
            return false;
        }
        CompositePackagingElementNode parent = node.getParentNode();
        if (parent == null) {
            return false;
        }
        Object element = node.getElementIfSingle();
        CompositePackagingElement parentElement = (CompositePackagingElement)parent.getElementIfSingle();
        if (parentElement == null || element == null) {
            return false;
        }
        List children = parentElement.getChildren();
        int index = children.indexOf(element);
        return index != -1 && 0 <= index + this.myDirection && index + this.myDirection < children.size();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PackagingElementNode<?> node;
        if (e == null) {
            MovePackagingElementAction.$$$reportNull$$$0(2);
        }
        if ((node = this.myLayoutTreeComponent.getSelection().getNodeIfSingle()) == null) {
            return;
        }
        CompositePackagingElementNode parent = node.getParentNode();
        if (parent == null) {
            return;
        }
        Object element = node.getElementIfSingle();
        CompositePackagingElement parentElement = (CompositePackagingElement)parent.getElementIfSingle();
        if (parentElement == null || element == null) {
            return;
        }
        if (!this.myLayoutTreeComponent.checkCanModifyChildren((PackagingElement<?>)parentElement, parent, (Collection<? extends PackagingElementNode<?>>)Collections.singletonList(node))) {
            return;
        }
        ArrayList toSelect = new ArrayList();
        this.myLayoutTreeComponent.editLayout(() -> {
            int index = parentElement.getChildren().indexOf(element);
            PackagingElement moved = parentElement.moveChild(index, this.myDirection);
            if (moved != null) {
                toSelect.add(moved);
            }
        });
        if (!toSelect.isEmpty()) {
            this.myLayoutTreeComponent.updateAndSelect(parent, toSelect);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/artifacts/actions/MovePackagingElementAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/actions/MovePackagingElementAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

