/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.classpath.AddItemPopupAction;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathElementChooser;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathTableItem;
import com.intellij.openapi.roots.ui.configuration.classpath.CreateModuleLibraryChooser;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.util.PlatformIcons;

class AddNewModuleLibraryAction
extends AddItemPopupAction<Library> {
    private static final Logger LOG = Logger.getInstance(AddNewModuleLibraryAction.class);
    private final StructureConfigurableContext myContext;

    AddNewModuleLibraryAction(ClasspathPanel classpathPanel, int actionIndex, StructureConfigurableContext context) {
        super(classpathPanel, actionIndex, JavaUiBundle.message("classpath.add.simple.module.library.action", new Object[0]), PlatformIcons.JAR_ICON);
        this.myContext = context;
    }

    @Override
    protected ClasspathTableItem<?> createTableItem(Library item) {
        OrderEntry[] entries;
        for (OrderEntry entry : entries = this.myClasspathPanel.getRootModel().getOrderEntries()) {
            LibraryOrderEntry libraryOrderEntry;
            if (!(entry instanceof LibraryOrderEntry) || !item.equals((Object)(libraryOrderEntry = (LibraryOrderEntry)entry).getLibrary())) continue;
            return ClasspathTableItem.createLibItem(libraryOrderEntry, this.myContext);
        }
        LOG.error("Unknown library " + String.valueOf(item));
        return null;
    }

    @Override
    protected ClasspathElementChooser<Library> createChooser() {
        LibraryTable.ModifiableModel moduleLibraryModel = this.myClasspathPanel.getRootModel().getModuleLibraryTable().getModifiableModel();
        return new CreateModuleLibraryChooser(this.myClasspathPanel, moduleLibraryModel);
    }
}

