/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryTypeServiceImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ChangeLibraryLevelDialog;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

public abstract class ChangeLibraryLevelActionBase
extends AnAction {
    private static final Logger LOG = Logger.getInstance(ChangeLibraryLevelActionBase.class);
    protected final Project myProject;
    protected final String myTargetTableLevel;
    protected final boolean myCopy;

    public ChangeLibraryLevelActionBase(@NotNull Project project2, @NotNull String targetTableName, @NotNull String targetTableLevel, boolean copy) {
        if (project2 == null) {
            ChangeLibraryLevelActionBase.$$$reportNull$$$0(0);
        }
        if (targetTableName == null) {
            ChangeLibraryLevelActionBase.$$$reportNull$$$0(1);
        }
        if (targetTableLevel == null) {
            ChangeLibraryLevelActionBase.$$$reportNull$$$0(2);
        }
        this.myProject = project2;
        this.myTargetTableLevel = targetTableLevel;
        this.myCopy = copy;
        this.getTemplatePresentation().setText(JavaUiBundle.message(this.myCopy ? "action.text.library.0.to.1.copy" : "action.text.library.0.to.1.move", targetTableName));
    }

    protected abstract LibraryTableModifiableModelProvider getModifiableTableModelProvider();

    protected abstract JComponent getParentComponent();

    @Nullable
    protected Library doCopy(LibraryEx library) {
        LibraryProperties libraryProperties;
        VirtualFile baseDir = this.getBaseDir();
        String libPath = baseDir != null ? baseDir.getPath() + "/lib" : "";
        VirtualFile[] classesRoots = library.getFiles(OrderRootType.CLASSES);
        boolean allowEmptyName = this.isConvertingToModuleLibrary() && classesRoots.length == 1;
        String libraryName = allowEmptyName ? "" : StringUtil.notNullize((String)library.getName(), (String)LibraryTypeServiceImpl.suggestLibraryName((VirtualFile[])classesRoots));
        LibraryTableModifiableModelProvider provider = this.getModifiableTableModelProvider();
        ChangeLibraryLevelDialog dialog = new ChangeLibraryLevelDialog(this.getParentComponent(), this.myProject, this.myCopy, libraryName, libPath, allowEmptyName, provider);
        if (!dialog.showAndGet()) {
            return null;
        }
        LinkedHashSet<File> fileToCopy = new LinkedHashSet<File>();
        HashMap<String, String> copiedFiles = new HashMap<String, String>();
        String targetDirectoryPath = dialog.getDirectoryForFilesPath();
        if (targetDirectoryPath != null) {
            for (OrderRootType type : OrderRootType.getAllTypes()) {
                for (VirtualFile root : library.getFiles(type)) {
                    if (!root.isInLocalFileSystem() && !(root.getFileSystem() instanceof ArchiveFileSystem)) continue;
                    fileToCopy.add(VfsUtilCore.virtualToIoFile((VirtualFile)VfsUtil.getLocalFile((VirtualFile)root)));
                }
            }
            if (!this.copyOrMoveFiles(fileToCopy, targetDirectoryPath, copiedFiles)) {
                return null;
            }
        }
        Library copied = provider.getModifiableModel().createLibrary(StringUtil.nullize((String)dialog.getLibraryName()), library.getKind());
        LibraryEx.ModifiableModelEx model = (LibraryEx.ModifiableModelEx)copied.getModifiableModel();
        LibraryEditingUtil.copyLibrary(library, copiedFiles, model);
        if (this.isConvertingToApplicationLibrary() && (libraryProperties = model.getProperties()) instanceof RepositoryLibraryProperties) {
            RepositoryLibraryProperties repositoryLibraryProperties = (RepositoryLibraryProperties)libraryProperties;
            model.setProperties((LibraryProperties)repositoryLibraryProperties.cloneAndChange(properties -> {
                properties.disableVerification();
                properties.unbindRemoteRepository();
            }));
        }
        WriteAction.run(() -> model.commit());
        return copied;
    }

    private boolean copyOrMoveFiles(final Set<File> filesToProcess, final @NotNull String targetDirPath, final Map<String, String> copiedFiles) {
        if (targetDirPath == null) {
            ChangeLibraryLevelActionBase.$$$reportNull$$$0(3);
        }
        final Ref finished = Ref.create((Object)false);
        new Task.Modal(this.myProject, JavaUiBundle.message("progress.title.0.library.files", this.myCopy ? "Copying" : "Moving"), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                File targetDir = new File(FileUtil.toSystemDependentName((String)targetDirPath));
                for (File from : filesToProcess) {
                    indicator.checkCanceled();
                    File to = FileUtil.findSequentNonexistentFile((File)targetDir, (String)FileUtilRt.getNameWithoutExtension((String)from.getName()), (String)FileUtilRt.getExtension((String)from.getName()));
                    try {
                        if (from.isDirectory()) {
                            if (ChangeLibraryLevelActionBase.this.myCopy) {
                                FileUtil.copyDir((File)from, (File)to);
                            } else {
                                FileUtil.moveDirWithContent((File)from, (File)to);
                            }
                        } else if (ChangeLibraryLevelActionBase.this.myCopy) {
                            FileUtil.copy((File)from, (File)to);
                        } else {
                            FileUtil.rename((File)from, (File)to);
                        }
                    }
                    catch (IOException e) {
                        String message = JavaUiBundle.message(ChangeLibraryLevelActionBase.this.myCopy ? "dialog.message.cannot.file.copy" : "dialog.message.cannot.file.move", from.getAbsolutePath(), e.getMessage());
                        String title = JavaUiBundle.message(ChangeLibraryLevelActionBase.this.myCopy ? "dialog.title.cannot.change.library.0.copy" : "dialog.title.cannot.change.library.0.move", new Object[0]);
                        Messages.showErrorDialog((Project)ChangeLibraryLevelActionBase.this.myProject, (String)message, (String)title);
                        LOG.info((Throwable)e);
                        return;
                    }
                    copiedFiles.put(FileUtil.toSystemIndependentName((String)from.getAbsolutePath()), FileUtil.toSystemIndependentName((String)to.getAbsolutePath()));
                }
                finished.set((Object)true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/roots/ui/configuration/classpath/ChangeLibraryLevelActionBase$1", "run"));
            }
        }.queue();
        if (!((Boolean)finished.get()).booleanValue()) {
            return false;
        }
        WriteAction.run(() -> {
            for (Map.Entry entry : copiedFiles.entrySet()) {
                VirtualFile parent;
                String fromPath = (String)entry.getKey();
                String toPath = (String)entry.getValue();
                LocalFileSystem.getInstance().refreshAndFindFileByPath(toPath);
                if (this.myCopy || (parent = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(fromPath).getParentFile())) == null) continue;
                parent.refresh(false, false);
            }
        });
        return true;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ChangeLibraryLevelActionBase.$$$reportNull$$$0(4);
        }
        Presentation presentation = e.getPresentation();
        boolean enabled = this.isEnabled();
        presentation.setEnabledAndVisible(enabled);
    }

    @Nullable
    protected VirtualFile getBaseDir() {
        return this.myProject.getBaseDir();
    }

    protected boolean isConvertingToModuleLibrary() {
        return this.myTargetTableLevel.equals("module");
    }

    private boolean isConvertingToApplicationLibrary() {
        return this.myTargetTableLevel.equals("application");
    }

    protected abstract boolean isEnabled();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetTableName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetTableLevel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/classpath/ChangeLibraryLevelActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "copyOrMoveFiles";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

