/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanelImpl;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import java.lang.reflect.Proxy;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class InlineModuleDependencyAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(InlineModuleDependencyAction.class);
    private final ClasspathPanelImpl myClasspathPanel;

    public InlineModuleDependencyAction(ClasspathPanelImpl classpathPanel) {
        super(JavaUiBundle.message("action.text.inline.module.dependency", new Object[0]), JavaUiBundle.message("action.description.inline.module.dependency", new Object[0]), null);
        this.myClasspathPanel = classpathPanel;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            InlineModuleDependencyAction.$$$reportNull$$$0(0);
        }
        OrderEntry selectedEntry = this.myClasspathPanel.getSelectedEntry();
        InlineModuleDependencyAction.inlineEntry(this.myClasspathPanel, selectedEntry, depEntry -> depEntry instanceof LibraryOrderEntry || depEntry instanceof ModuleOrderEntry);
    }

    static void inlineEntry(ClasspathPanel classpathPanel, OrderEntry entry, Predicate<? super OrderEntry> dependencyEntryFilter) {
        if (!(entry instanceof ModuleOrderEntry)) {
            return;
        }
        ModuleOrderEntry entryToInline = (ModuleOrderEntry)entry;
        Module module = entryToInline.getModule();
        if (module == null) {
            return;
        }
        ModifiableRootModel model = classpathPanel.getRootModel();
        int toInlineIndex = InlineModuleDependencyAction.findModuleEntryIndex(model, module);
        if (toInlineIndex == -1) {
            return;
        }
        model.removeOrderEntry((OrderEntry)entryToInline);
        ModifiableRootModel modelImpl = Proxy.isProxyClass(model.getClass()) ? (ModifiableRootModel)((ModuleEditor.ProxyDelegateAccessor)((Object)Proxy.getInvocationHandler(model))).getDelegate() : model;
        int addedCount = 0;
        ModuleRootModel otherModel = classpathPanel.getModuleConfigurationState().getModulesProvider().getRootModel(module);
        ProjectRootManagerImpl rootManager = ProjectRootManagerImpl.getInstanceImpl((Project)classpathPanel.getProject());
        VirtualFilePointerManager virtualFilePointerManager = VirtualFilePointerManager.getInstance();
        for (OrderEntry depEntry : otherModel.getOrderEntries()) {
            if (!dependencyEntryFilter.test((OrderEntry)depEntry)) continue;
            LOG.assertTrue(depEntry instanceof ClonableOrderEntry, (Object)depEntry);
            ExportableOrderEntry entryToCopy = (ExportableOrderEntry)depEntry;
            model.addOrderEntry(((ClonableOrderEntry)depEntry).cloneEntry(modelImpl, rootManager, virtualFilePointerManager));
            ExportableOrderEntry cloned = (ExportableOrderEntry)ArrayUtil.getLastElement((Object[])model.getOrderEntries());
            cloned.setExported(entryToInline.isExported() && entryToCopy.isExported());
            cloned.setScope(OrderEntryUtil.intersectScopes((DependencyScope)entryToInline.getScope(), (DependencyScope)entryToCopy.getScope()));
            ++addedCount;
        }
        OrderEntry[] oldEntries = model.getOrderEntries();
        OrderEntry[] newEntries = new OrderEntry[oldEntries.length];
        System.arraycopy(oldEntries, 0, newEntries, 0, toInlineIndex);
        System.arraycopy(oldEntries, oldEntries.length - addedCount, newEntries, toInlineIndex, addedCount);
        System.arraycopy(oldEntries, toInlineIndex, newEntries, toInlineIndex + addedCount, oldEntries.length - toInlineIndex - addedCount);
        model.rearrangeOrderEntries(newEntries);
        StructureConfigurableContext context = ProjectStructureConfigurable.getInstance(classpathPanel.getProject()).getContext();
        context.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(context, module));
    }

    private static int findModuleEntryIndex(ModifiableRootModel model, Module module) {
        OrderEntry[] entries = model.getOrderEntries();
        for (int i = 0; i < entries.length; ++i) {
            OrderEntry entry = entries[i];
            if (!(entry instanceof ModuleOrderEntry) || !module.equals((Object)((ModuleOrderEntry)entry).getModule())) continue;
            return i;
        }
        return -1;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            InlineModuleDependencyAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(this.isEnabled());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            InlineModuleDependencyAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private boolean isEnabled() {
        OrderEntry entry = this.myClasspathPanel.getSelectedEntry();
        if (!(entry instanceof ModuleOrderEntry)) {
            return false;
        }
        Module module = ((ModuleOrderEntry)entry).getModule();
        if (module == null) {
            return false;
        }
        ModuleRootModel model = this.myClasspathPanel.getModuleConfigurationState().getModulesProvider().getRootModel(module);
        return model.getSourceRootUrls().length == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/classpath/InlineModuleDependencyAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/classpath/InlineModuleDependencyAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

