/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathElementChooser;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.CreateNewLibraryAction;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.CreateNewLibraryDialog;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

class NewLibraryChooser
implements ClasspathElementChooser<Library> {
    private final ModifiableRootModel myRootModel;
    private final StructureConfigurableContext myContext;
    private final JComponent myParentComponent;
    private final Project myProject;
    private final LibraryType myLibraryType;

    NewLibraryChooser(Project project2, ModifiableRootModel rootModel, LibraryType libraryType, StructureConfigurableContext context, JComponent parentComponent) {
        this.myRootModel = rootModel;
        this.myLibraryType = libraryType;
        this.myContext = context;
        this.myParentComponent = parentComponent;
        this.myProject = project2;
    }

    @Override
    @NotNull
    public @Unmodifiable List<Library> chooseElements() {
        List list2 = ContainerUtil.createMaybeSingletonList((Object)this.createLibrary());
        if (list2 == null) {
            NewLibraryChooser.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @Nullable
    public Library createLibrary() {
        NewLibraryConfiguration configuration = CreateNewLibraryAction.createNewLibraryConfiguration(this.myLibraryType, this.myParentComponent, this.myProject);
        if (configuration == null) {
            return null;
        }
        NewLibraryEditor libraryEditor = new NewLibraryEditor(configuration.getLibraryType(), configuration.getProperties());
        libraryEditor.setName(configuration.getDefaultLibraryName());
        configuration.addRoots((LibraryEditor)libraryEditor);
        LibraryTablesRegistrar registrar = LibraryTablesRegistrar.getInstance();
        List<LibraryTable> tables = Arrays.asList(this.myRootModel.getModuleLibraryTable(), registrar.getLibraryTable(this.myProject), registrar.getLibraryTable());
        CreateNewLibraryDialog dialog = new CreateNewLibraryDialog(this.myParentComponent, this.myContext, libraryEditor, tables, 1);
        Module contextModule = (Module)LangDataKeys.MODULE_CONTEXT.getData(DataManager.getInstance().getDataContext((Component)this.myParentComponent));
        dialog.setContextModule(contextModule);
        if (dialog.showAndGet()) {
            return dialog.createLibrary();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/classpath/NewLibraryChooser", "chooseElements"));
    }
}

