/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraries;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.ModuleLibraryTableBase;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ParameterizedRunnable;
import com.intellij.util.PlatformIcons;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LibraryEditingUtil {
    private static final Logger LOG = Logger.getInstance(LibraryEditingUtil.class);

    private LibraryEditingUtil() {
    }

    public static boolean libraryAlreadyExists(LibraryTable.ModifiableModel table, String libraryName) {
        Iterator it = table.getLibraryIterator();
        while (it.hasNext()) {
            Library library = (Library)it.next();
            String libName = table instanceof LibrariesModifiableModel ? ((LibrariesModifiableModel)table).getLibraryEditor(library).getName() : library.getName();
            if (!libraryName.equals(libName)) continue;
            return true;
        }
        return false;
    }

    public static String suggestNewLibraryName(LibraryTable.ModifiableModel table, String baseName) {
        return UniqueNameGenerator.generateUniqueNameOneBased((String)baseName, n -> !LibraryEditingUtil.libraryAlreadyExists(table, n));
    }

    public static Predicate<Library> getNotAddedSuitableLibrariesCondition(ModuleRootModel rootModel, FacetsProvider facetsProvider) {
        OrderEntry[] orderEntries = rootModel.getOrderEntries();
        HashSet<Library> result = new HashSet<Library>(orderEntries.length);
        for (OrderEntry orderEntry : orderEntries) {
            Library library2;
            if (!(orderEntry instanceof LibraryOrderEntry) || !orderEntry.isValid() || (library2 = ((LibraryOrderEntry)orderEntry).getLibrary()) == null) continue;
            if (library2 instanceof LibraryEx) {
                Library source = ((LibraryEx)library2).getSource();
                result.add(source != null ? source : library2);
                continue;
            }
            result.add(library2);
        }
        return library -> {
            LibraryType type;
            PersistentLibraryKind kind;
            Library source;
            if (result.contains(library)) {
                return false;
            }
            if (library instanceof LibraryEx && (source = ((LibraryEx)library).getSource()) != null && result.contains(source)) {
                return false;
            }
            return !(library instanceof LibraryEx) || (kind = ((LibraryEx)library).getKind()) == null || (type = LibraryType.findByKind((LibraryKind)kind)).isSuitableModule(rootModel.getModule(), facetsProvider);
        };
    }

    public static void copyLibrary(LibraryEx from, Map<String, String> rootMapping, LibraryEx.ModifiableModelEx target) {
        target.setProperties(from.getProperties());
        for (OrderRootType type : OrderRootType.getAllTypes()) {
            String[] urls;
            for (String url : urls = from.getUrls(type)) {
                String targetUrl;
                String pathInJar;
                String localPath;
                String protocol = VirtualFileManager.extractProtocol((String)url);
                if (protocol == null) continue;
                String fullPath = VirtualFileManager.extractPath((String)url);
                int sep = fullPath.indexOf("!/");
                if (sep != -1) {
                    localPath = fullPath.substring(0, sep);
                    pathInJar = fullPath.substring(sep);
                } else {
                    localPath = fullPath;
                    pathInJar = "";
                }
                String targetPath = rootMapping.get(localPath);
                String string = targetUrl = targetPath != null ? VirtualFileManager.constructUrl((String)protocol, (String)(targetPath + pathInJar)) : url;
                if (from.isJarDirectory(url, type)) {
                    target.addJarDirectory(targetUrl, false, type);
                    continue;
                }
                target.addRoot(targetUrl, type);
            }
        }
    }

    public static LibraryTablePresentation getLibraryTablePresentation(@NotNull Project project2, @NotNull String level) {
        if (project2 == null) {
            LibraryEditingUtil.$$$reportNull$$$0(0);
        }
        if (level == null) {
            LibraryEditingUtil.$$$reportNull$$$0(1);
        }
        if (level.equals("module")) {
            return ModuleLibraryTableBase.MODULE_LIBRARY_TABLE_PRESENTATION;
        }
        LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(level, project2);
        LOG.assertTrue(table != null, (Object)level);
        return table.getPresentation();
    }

    public static List<TypeForNewLibrary> getSuitableTypes(ClasspathPanel classpathPanel) {
        ArrayList<TypeForNewLibrary> suitableTypes = new ArrayList<TypeForNewLibrary>();
        suitableTypes.add(new TypeForNewLibrary(null, JavaUiBundle.message("create.default.library.type.action.name", new Object[0])));
        Module module = classpathPanel.getRootModel().getModule();
        for (LibraryType libraryType : (LibraryType[])LibraryType.EP_NAME.getExtensions()) {
            String createActionName = libraryType.getCreateActionName();
            if (createActionName == null || !libraryType.isSuitableModule(module, classpathPanel.getModuleConfigurationState().getFacetsProvider())) continue;
            suitableTypes.add(new TypeForNewLibrary(libraryType, createActionName));
        }
        return suitableTypes;
    }

    public static boolean hasSuitableTypes(ClasspathPanel panel2) {
        return LibraryEditingUtil.getSuitableTypes(panel2).size() > 1;
    }

    public static BaseListPopupStep<TypeForNewLibrary> createChooseTypeStep(ClasspathPanel classpathPanel, final ParameterizedRunnable<? super LibraryType> action) {
        return new BaseListPopupStep<TypeForNewLibrary>(JavaUiBundle.message("popup.title.select.library.type", new Object[0]), LibraryEditingUtil.getSuitableTypes(classpathPanel)){

            @NotNull
            public String getTextFor(TypeForNewLibrary value) {
                String string = value.getCreateActionName();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public Icon getIconFor(TypeForNewLibrary aValue) {
                return aValue.getIcon();
            }

            public PopupStep<?> onChosen(TypeForNewLibrary selectedValue, boolean finalChoice) {
                return this.doFinalStep(() -> action.run(selectedValue.getType()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/libraries/LibraryEditingUtil$1", "getTextFor"));
            }
        };
    }

    public static List<Module> getSuitableModules(@NotNull ModuleStructureConfigurable rootConfigurable, @Nullable LibraryKind kind, @Nullable Library library) {
        if (rootConfigurable == null) {
            LibraryEditingUtil.$$$reportNull$$$0(2);
        }
        ArrayList<Module> modules = new ArrayList<Module>();
        LibraryType type = kind == null ? null : LibraryType.findByKind((LibraryKind)kind);
        for (Module module : rootConfigurable.getModules()) {
            ModuleRootModel rootModel;
            if (type != null && !type.isSuitableModule(module, (FacetsProvider)rootConfigurable.getFacetConfigurator()) || library != null && !LibraryEditingUtil.getNotAddedSuitableLibrariesCondition(rootModel = rootConfigurable.getContext().getModulesConfigurator().getRootModel(module), rootConfigurable.getFacetConfigurator()).test(library)) continue;
            modules.add(module);
        }
        return modules;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootConfigurable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraries/LibraryEditingUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLibraryTablePresentation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuitableModules";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class TypeForNewLibrary {
        private final LibraryType<?> myType;
        private final @NlsContexts.Label String myCreateActionName;

        private TypeForNewLibrary(@Nullable LibraryType<?> type, @NlsContexts.Label String createActionName) {
            this.myType = type;
            this.myCreateActionName = createActionName;
        }

        public String getCreateActionName() {
            return this.myCreateActionName;
        }

        public Icon getIcon() {
            Icon icon = this.myType != null ? this.myType.getIcon(null) : null;
            return icon != null ? icon : PlatformIcons.LIBRARY_ICON;
        }

        public LibraryType<?> getType() {
            return this.myType;
        }
    }
}

