/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.icons.AllIcons;
import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.ui.SdkPathEditor;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.ui.OrderRootTypeUIFactory;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.JavadocQuarantineStatusCleaner;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.IconUtil;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class JavadocOrderRootTypeUIFactory
implements OrderRootTypeUIFactory {
    public SdkPathEditor createPathEditor(Sdk sdk) {
        return new JavadocPathsEditor(sdk, FileChooserDescriptorFactory.createMultipleJavaPathDescriptor());
    }

    public Icon getIcon() {
        return AllIcons.Nodes.JavaDocFolder;
    }

    public String getNodeText() {
        return JavaUiBundle.message("library.javadocs.node", new Object[0]);
    }

    private static class JavadocPathsEditor
    extends SdkPathEditor {
        private final Sdk mySdk;

        JavadocPathsEditor(Sdk sdk, FileChooserDescriptor descriptor) {
            super(JavaUiBundle.message("sdk.configure.javadoc.tab", new Object[0]), JavadocOrderRootType.getInstance(), descriptor);
            this.mySdk = sdk;
        }

        protected void addToolbarButtons(ToolbarDecorator toolbarDecorator) {
            DumbAwareAction specifyUrlButton = new DumbAwareAction(JavaUiBundle.messagePointer("sdk.paths.specify.url.button", new Object[0]), IconUtil.getAddLinkIcon()){

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    e.getPresentation().setEnabled(myEnabled);
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.onSpecifyUrlButtonClicked();
                }

                @NotNull
                public ActionUpdateThread getActionUpdateThread() {
                    ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                    if (actionUpdateThread == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return actionUpdateThread;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "e";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/JavadocOrderRootTypeUIFactory$JavadocPathsEditor$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/JavadocOrderRootTypeUIFactory$JavadocPathsEditor$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getActionUpdateThread";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "update";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "actionPerformed";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 2 -> new IllegalStateException(string);
                    };
                }
            };
            specifyUrlButton.setShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"alt S"}));
            toolbarDecorator.addExtraAction((AnAction)specifyUrlButton);
        }

        private void onSpecifyUrlButtonClicked() {
            String defaultDocsUrl = this.mySdk == null ? "" : StringUtil.notNullize((String)((SdkType)this.mySdk.getSdkType()).getDefaultDocumentationUrl(this.mySdk));
            VirtualFile virtualFile = Util.showSpecifyJavadocUrlDialog((JComponent)this.myPanel, (String)defaultDocsUrl);
            if (virtualFile != null) {
                this.addElement(virtualFile);
                this.setModified(true);
                this.requestDefaultFocus();
                this.setSelectedRoots(new VirtualFile[]{virtualFile});
            }
        }

        protected VirtualFile[] adjustAddedFileSet(Component component, VirtualFile[] files) {
            JavadocQuarantineStatusCleaner.cleanIfNeeded(files);
            for (int i = 0; i < files.length; ++i) {
                VirtualFile file = files[i];
                VirtualFile docRoot = null;
                if (file.getName().equalsIgnoreCase("docs")) {
                    docRoot = file.findChild("api");
                } else if (file.getFileSystem() instanceof ArchiveFileSystem && file.getParent() == null) {
                    docRoot = file.findFileByRelativePath("docs/api");
                }
                if (docRoot == null) continue;
                files[i] = docRoot;
            }
            return files;
        }
    }
}

