/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRootTypePresentation;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.DefaultLibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExcludedRootElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ItemElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryRootsComponent;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.OrderRootTypeElement;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

class LibraryTreeStructure
extends AbstractTreeStructure {
    private final NodeDescriptor myRootElementDescriptor;
    private final LibraryRootsComponent myParentEditor;
    private final LibraryRootsComponentDescriptor myComponentDescriptor;

    LibraryTreeStructure(LibraryRootsComponent parentElement, LibraryRootsComponentDescriptor componentDescriptor) {
        this.myParentEditor = parentElement;
        this.myComponentDescriptor = componentDescriptor;
        this.myRootElementDescriptor = new NodeDescriptor(this, null, null){

            public boolean update() {
                this.myName = JavaUiBundle.message("library.root.node", new Object[0]);
                return false;
            }

            public Object getElement() {
                return this;
            }
        };
    }

    @NotNull
    public Object getRootElement() {
        NodeDescriptor nodeDescriptor = this.myRootElementDescriptor;
        if (nodeDescriptor == null) {
            LibraryTreeStructure.$$$reportNull$$$0(0);
        }
        return nodeDescriptor;
    }

    public Object @NotNull [] getChildElements(@NotNull Object element) {
        if (element == null) {
            LibraryTreeStructure.$$$reportNull$$$0(1);
        }
        LibraryEditor libraryEditor = this.myParentEditor.getLibraryEditor();
        if (element == this.myRootElementDescriptor) {
            ArrayList<OrderRootTypeElement> elements = new ArrayList<OrderRootTypeElement>(3);
            for (OrderRootType type : this.myComponentDescriptor.getRootTypes()) {
                String[] urls = libraryEditor.getUrls(type);
                if (urls.length <= 0) continue;
                OrderRootTypePresentation presentation = this.myComponentDescriptor.getRootTypePresentation(type);
                if (presentation == null) {
                    presentation = DefaultLibraryRootsComponentDescriptor.getDefaultPresentation(type);
                }
                elements.add(new OrderRootTypeElement(this.myRootElementDescriptor, type, presentation.getNodeText(), presentation.getIcon()));
            }
            Object[] objectArray = elements.toArray();
            if (objectArray == null) {
                LibraryTreeStructure.$$$reportNull$$$0(2);
            }
            return objectArray;
        }
        if (element instanceof OrderRootTypeElement) {
            OrderRootTypeElement rootTypeElement = (OrderRootTypeElement)((Object)element);
            OrderRootType orderRootType = rootTypeElement.getOrderRootType();
            String[] urls = (String[])libraryEditor.getUrls(orderRootType).clone();
            Arrays.sort(urls, LibraryRootsComponent.ourUrlComparator);
            ArrayList<ItemElement> items = new ArrayList<ItemElement>(urls.length);
            for (String url : urls) {
                items.add(new ItemElement(rootTypeElement, url, orderRootType, libraryEditor.isJarDirectory(url, orderRootType), libraryEditor.isValid(url, orderRootType)));
            }
            Object[] objectArray = items.toArray();
            if (objectArray == null) {
                LibraryTreeStructure.$$$reportNull$$$0(3);
            }
            return objectArray;
        }
        if (element instanceof ItemElement) {
            ItemElement itemElement = (ItemElement)((Object)element);
            ArrayList<String> excludedUrls = new ArrayList<String>();
            for (String excludedUrl : libraryEditor.getExcludedRootUrls()) {
                if (!VfsUtilCore.isEqualOrAncestor((String)itemElement.getUrl(), (String)excludedUrl)) continue;
                excludedUrls.add(excludedUrl);
            }
            ExcludedRootElement[] items = new ExcludedRootElement[excludedUrls.size()];
            excludedUrls.sort(LibraryRootsComponent.ourUrlComparator);
            for (int i = 0; i < excludedUrls.size(); ++i) {
                items[i] = new ExcludedRootElement(itemElement, itemElement.getUrl(), (String)excludedUrls.get(i));
            }
            if (items == null) {
                LibraryTreeStructure.$$$reportNull$$$0(4);
            }
            return items;
        }
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            LibraryTreeStructure.$$$reportNull$$$0(5);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    public void commit() {
    }

    public boolean hasSomethingToCommit() {
        return false;
    }

    public Object getParentElement(@NotNull Object element) {
        if (element == null) {
            LibraryTreeStructure.$$$reportNull$$$0(6);
        }
        return ((NodeDescriptor)element).getParentDescriptor();
    }

    @NotNull
    public NodeDescriptor createDescriptor(@NotNull Object element, NodeDescriptor parentDescriptor) {
        if (element == null) {
            LibraryTreeStructure.$$$reportNull$$$0(7);
        }
        NodeDescriptor nodeDescriptor = (NodeDescriptor)element;
        if (nodeDescriptor == null) {
            LibraryTreeStructure.$$$reportNull$$$0(8);
        }
        return nodeDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryTreeStructure";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryTreeStructure";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildElements";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChildElements";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getParentElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

