/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.facet.Facet;
import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.facet.impl.invalid.InvalidFacet;
import com.intellij.facet.impl.ui.FacetEditorImpl;
import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.FacetProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.util.NlsSafe;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class FacetConfigurable
extends ProjectStructureElementConfigurable<Facet> {
    private final Facet myFacet;
    private final ModulesConfigurator myModulesConfigurator;
    @NlsSafe
    private String myFacetName;
    private final FacetProjectStructureElement myProjectStructureElement;
    private final Map<Facet, FacetConfigurable> myFacetConfigurables;

    public FacetConfigurable(Map<Facet, FacetConfigurable> facetConfigurables, Facet facet, StructureConfigurableContext context, Runnable updateTree) {
        super(!facet.getType().isOnlyOneFacetAllowed() && !(facet instanceof InvalidFacet), updateTree);
        this.myFacet = facet;
        this.myModulesConfigurator = context.getModulesConfigurator();
        this.myFacetName = this.myFacet.getName();
        this.myProjectStructureElement = new FacetProjectStructureElement(context, facet);
        this.myFacetConfigurables = facetConfigurables;
    }

    public void setDisplayName(String name) {
        Module module = this.myFacet.getModule();
        boolean facetNameExists = this.myFacetConfigurables.keySet().stream().filter(facet -> facet.getModule() == module && facet.getTypeId() == this.myFacet.getTypeId()).map(facet -> this.myFacetConfigurables.get(facet)).anyMatch(facetConfigurable -> name.equals(facetConfigurable.getDisplayName()));
        if (!facetNameExists) {
            this.getFacetsConfigurator().getOrCreateModifiableModel(module).rename(this.myFacet, name);
            this.myFacetName = name;
        }
    }

    @Override
    public ProjectStructureElement getProjectStructureElement() {
        return this.myProjectStructureElement;
    }

    private ProjectFacetsConfigurator getFacetsConfigurator() {
        return this.myModulesConfigurator.getFacetsConfigurator();
    }

    public Facet getEditableObject() {
        return this.myFacet;
    }

    public String getBannerSlogan() {
        return JavaUiBundle.message("facet.banner.text", this.myFacetName);
    }

    public JComponent createOptionsPanel() {
        return this.getEditor().getComponent();
    }

    public FacetEditorImpl getEditor() {
        return this.getFacetsConfigurator().getOrCreateEditor(this.myFacet);
    }

    @Nls
    public String getDisplayName() {
        return this.myFacetName;
    }

    @Nullable
    public Icon getIcon(boolean open) {
        return this.myFacet.getType().getIcon();
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        FacetEditorImpl facetEditor = this.getFacetsConfigurator().getEditor(this.myFacet);
        return facetEditor != null ? facetEditor.getHelpTopic() : null;
    }

    public boolean isModified() {
        return false;
    }

    public void apply() throws ConfigurationException {
    }
}

