/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectModel.ProjectModelBundle;
import com.intellij.ui.components.JBLabel;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0016J\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0014\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/projectRoot/LibraryJarsDiffDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "libraryFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "downloadedFile", "mavenCoordinates", "Lorg/jetbrains/jps/model/library/JpsMavenRepositoryLibraryDescriptor;", "libraryName", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/jps/model/library/JpsMavenRepositoryLibraryDescriptor;Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "panel", "Lcom/intellij/diff/DiffRequestPanel;", "createNorthPanel", "Lcom/intellij/ui/components/JBLabel;", "createCenterPanel", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "Companion", "ChangeCoordinatesAction", "intellij.java.ui"})
public final class LibraryJarsDiffDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JpsMavenRepositoryLibraryDescriptor mavenCoordinates;
    @NotNull
    private final String libraryName;
    @NotNull
    private final DiffRequestPanel panel;
    public static final int CHANGE_COORDINATES_CODE = 2;

    public LibraryJarsDiffDialog(@NotNull VirtualFile libraryFile, @NotNull VirtualFile downloadedFile, @NotNull JpsMavenRepositoryLibraryDescriptor mavenCoordinates, @NotNull String libraryName, @NotNull Project project2) {
        DirDiffSettings dirDiffSettings;
        Intrinsics.checkNotNullParameter((Object)libraryFile, (String)"libraryFile");
        Intrinsics.checkNotNullParameter((Object)downloadedFile, (String)"downloadedFile");
        Intrinsics.checkNotNullParameter((Object)mavenCoordinates, (String)"mavenCoordinates");
        Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2);
        this.mavenCoordinates = mavenCoordinates;
        this.libraryName = libraryName;
        this.setTitle(ProjectModelBundle.message((String)"dialog.title.replace.library", (Object[])new Object[0]));
        this.setOKButtonText(ProjectModelBundle.message((String)"button.text.replace", (Object[])new Object[0]));
        ContentDiffRequest contentDiffRequest = DiffRequestFactory.getInstance().createFromFiles(project2, libraryFile, downloadedFile);
        Intrinsics.checkNotNullExpressionValue((Object)contentDiffRequest, (String)"createFromFiles(...)");
        ContentDiffRequest request = contentDiffRequest;
        DiffRequestPanel diffRequestPanel = DiffManager.getInstance().createRequestPanel(project2, this.getDisposable(), this.getWindow());
        Intrinsics.checkNotNullExpressionValue((Object)diffRequestPanel, (String)"createRequestPanel(...)");
        this.panel = diffRequestPanel;
        DirDiffSettings dirDiffSettings2 = dirDiffSettings = new DirDiffSettings();
        Key key = DirDiffSettings.KEY;
        DiffRequestPanel diffRequestPanel2 = this.panel;
        boolean bl = false;
        $this$_init__u24lambda_u240.enableChoosers = false;
        $this$_init__u24lambda_u240.enableOperations = false;
        Unit unit = Unit.INSTANCE;
        diffRequestPanel2.putContextHints(key, (Object)dirDiffSettings);
        this.panel.setRequest((DiffRequest)request);
        this.init();
    }

    @NotNull
    protected JBLabel createNorthPanel() {
        Object[] objectArray = new Object[]{this.mavenCoordinates.getMavenId(), this.libraryName};
        return new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)JavaUiBundle.message("library.jars.diff.dialog.0.jars.differ.from.1.library.jars", objectArray)));
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JComponent jComponent = this.panel.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.panel.getPreferredFocusedComponent();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[3];
        Intrinsics.checkNotNullExpressionValue((Object)this.getOKAction(), (String)"getOKAction(...)");
        actionArray[1] = new ChangeCoordinatesAction();
        Intrinsics.checkNotNullExpressionValue((Object)this.getCancelAction(), (String)"getCancelAction(...)");
        return actionArray;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/projectRoot/LibraryJarsDiffDialog$ChangeCoordinatesAction;", "Lcom/intellij/openapi/ui/DialogWrapper$DialogWrapperAction;", "Lcom/intellij/openapi/ui/DialogWrapper;", "<init>", "(Lcom/intellij/openapi/roots/ui/configuration/projectRoot/LibraryJarsDiffDialog;)V", "doAction", "", "e", "Ljava/awt/event/ActionEvent;", "intellij.java.ui"})
    private final class ChangeCoordinatesAction
    extends DialogWrapper.DialogWrapperAction {
        public ChangeCoordinatesAction() {
            super((DialogWrapper)LibraryJarsDiffDialog.this, JavaUiBundle.message("library.jars.change.coordinates.action.title", new Object[0]));
        }

        protected void doAction(@Nullable ActionEvent e) {
            LibraryJarsDiffDialog.this.close(2);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/projectRoot/LibraryJarsDiffDialog$Companion;", "", "<init>", "()V", "CHANGE_COORDINATES_CODE", "", "intellij.java.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

