/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.ide.JavaUiBundle;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.navigation.Place;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleConfigurable
extends ProjectStructureElementConfigurable<Module>
implements Place.Navigator {
    private final Module myModule;
    private final ModuleGrouper myModuleGrouper;
    private final ModulesConfigurator myConfigurator;
    @NlsSafe
    private String myModuleName;
    private final ModuleProjectStructureElement myProjectStructureElement;
    private final StructureConfigurableContext myContext;

    public ModuleConfigurable(ModulesConfigurator modulesConfigurator, @NotNull Module module, Runnable updateTree, ModuleGrouper moduleGrouper) {
        if (module == null) {
            ModuleConfigurable.$$$reportNull$$$0(0);
        }
        super(true, updateTree);
        this.myModule = module;
        this.myModuleGrouper = moduleGrouper;
        this.myConfigurator = modulesConfigurator;
        this.myModuleName = this.myConfigurator.getModuleModel().getActualName(this.myModule);
        this.myContext = modulesConfigurator.getContext();
        this.myProjectStructureElement = new ModuleProjectStructureElement(this.myContext, this.myModule);
    }

    public void setDisplayName(String name) {
        ModifiableModuleModel modifiableModuleModel = this.myConfigurator.getModuleModel();
        if (StringUtil.isEmpty((String)name)) {
            return;
        }
        if (Comparing.strEqual((String)name, (String)this.myModuleName)) {
            return;
        }
        try {
            modifiableModuleModel.renameModule(this.myModule, name);
        }
        catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
            // empty catch block
        }
        this.myConfigurator.moduleRenamed(this.myModule, this.myModuleName, name);
        this.myModuleName = name;
        this.myConfigurator.setModified(!Comparing.strEqual((String)this.myModuleName, (String)this.myModule.getName()));
        this.myContext.getDaemonAnalyzer().queueUpdateForAllElementsWithErrors();
    }

    protected void checkName(@NotNull String name) throws ConfigurationException {
        if (name == null) {
            ModuleConfigurable.$$$reportNull$$$0(1);
        }
        super.checkName(name);
        if (this.myModuleGrouper.getShortenedNameByFullModuleName(name).isEmpty()) {
            throw new ConfigurationException(LangBundle.message((String)"error.short.name.module.cannot.be.empty", (Object[])new Object[0]));
        }
        List list2 = this.myModuleGrouper.getGroupPathByModuleName(name);
        if (list2.stream().anyMatch(String::isEmpty)) {
            throw new ConfigurationException(LangBundle.message((String)"error.names.of.parent.groups.cannot.be.empty", (Object[])new Object[0]));
        }
    }

    public ModuleGrouper getModuleGrouper() {
        return this.myModuleGrouper;
    }

    @Override
    public ProjectStructureElement getProjectStructureElement() {
        return this.myProjectStructureElement;
    }

    @NotNull
    public Module getEditableObject() {
        Module module = this.myModule;
        if (module == null) {
            ModuleConfigurable.$$$reportNull$$$0(2);
        }
        return module;
    }

    public String getBannerSlogan() {
        return JavaUiBundle.message("project.roots.module.banner.text", this.myModuleName);
    }

    public String getDisplayName() {
        return this.myModuleName;
    }

    public Icon getIcon(boolean open) {
        return this.myModule.isDisposed() ? null : ModuleType.get((Module)this.myModule).getIcon();
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            ModuleConfigurable.$$$reportNull$$$0(3);
        }
        return module;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        ModuleEditor editor = this.getModuleEditor();
        return editor == null ? null : editor.getHelpTopic();
    }

    public JComponent createOptionsPanel() {
        ModuleEditor editor = this.getModuleEditor();
        return editor == null ? null : editor.getPanel();
    }

    public boolean isModified() {
        return false;
    }

    public void apply() throws ConfigurationException {
    }

    public ModuleEditor getModuleEditor() {
        return this.myConfigurator.getModuleEditor(this.myModule);
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        ModuleEditor editor = this.getModuleEditor();
        return editor == null ? ActionCallback.REJECTED : editor.navigateTo(place, requestFocus);
    }

    public void queryPlace(@NotNull Place place) {
        ModuleEditor editor;
        if (place == null) {
            ModuleConfigurable.$$$reportNull$$$0(4);
        }
        if ((editor = this.getModuleEditor()) != null) {
            editor.queryPlace(place);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleConfigurable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditableObject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkName";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "queryPlace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

