/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.CommonBundle;
import com.intellij.facet.Facet;
import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.facet.impl.ui.actions.AddFacetToModuleAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.impl.FlattenModulesToggleAction;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ModuleGroupingImplementation;
import com.intellij.ide.projectView.impl.ModuleGroupingTreeHelper;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.NamePathComponent;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleGrouperKt;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.actions.ChangeModuleNamesAction;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FacetConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FacetEditorFacadeImpl;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureExtension;
import com.intellij.openapi.roots.ui.configuration.projectRoot.RemoveConfigurableHandler;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.TextConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.platform.eel.EelMachine;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.ui.navigation.Place;
import com.intellij.util.PlatformIcons;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class ModuleStructureConfigurable
extends BaseStructureConfigurable
implements Place.Navigator,
Configurable.WithEpDependencies {
    private static final Comparator<MasterDetailsComponent.MyNode> NODE_COMPARATOR = (o1, o2) -> {
        NamedConfigurable configurable1 = o1.getConfigurable();
        NamedConfigurable configurable2 = o2.getConfigurable();
        if (configurable1.getClass() == configurable2.getClass()) {
            return StringUtil.naturalCompare((String)o1.getDisplayName(), (String)o2.getDisplayName());
        }
        Object editableObject1 = configurable1.getEditableObject();
        Object editableObject2 = configurable2.getEditableObject();
        if (editableObject2 instanceof Module && editableObject1 instanceof ModuleGroup) {
            return -1;
        }
        if (editableObject1 instanceof Module && editableObject2 instanceof ModuleGroup) {
            return 1;
        }
        if (editableObject2 instanceof Module && editableObject1 instanceof String) {
            return 1;
        }
        if (editableObject1 instanceof Module && editableObject2 instanceof String) {
            return -1;
        }
        if (editableObject2 instanceof Module && editableObject1 instanceof Facet) {
            return 1;
        }
        if (editableObject1 instanceof Module && editableObject2 instanceof Facet) {
            return -1;
        }
        if (editableObject2 instanceof ModuleGroup && editableObject1 instanceof String) {
            return 1;
        }
        if (editableObject1 instanceof ModuleGroup && editableObject2 instanceof String) {
            return -1;
        }
        return 0;
    };
    private boolean myHideModuleGroups;
    private boolean myFlattenModules;
    private final ModuleManager myModuleManager;
    private final FacetEditorFacadeImpl myFacetEditorFacade;
    private final List<RemoveConfigurableHandler<?>> myRemoveHandlers;

    public ModuleStructureConfigurable(ProjectStructureConfigurable projectStructureConfigurable) {
        super(projectStructureConfigurable);
        this.myFacetEditorFacade = new FacetEditorFacadeImpl(this.myProjectStructureConfigurable, this.TREE_UPDATER);
        this.myModuleManager = ModuleManager.getInstance((Project)this.myProject);
        this.myRemoveHandlers = new ArrayList();
        this.myRemoveHandlers.add(new ModuleRemoveHandler());
        this.myRemoveHandlers.add(new FacetInModuleRemoveHandler());
        for (ModuleStructureExtension extension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            this.myRemoveHandlers.addAll(extension.getRemoveHandlers());
        }
    }

    protected String getComponentStateKey() {
        return "ModuleStructureConfigurable.UI";
    }

    @Override
    protected void initTree() {
        super.initTree();
        this.myTree.setRootVisible(false);
    }

    @Override
    @NotNull
    protected String getTextForSpeedSearch(@NotNull MasterDetailsComponent.MyNode node) {
        if (node == null) {
            ModuleStructureConfigurable.$$$reportNull$$$0(0);
        }
        MasterDetailsComponent.MyNode myNode = node;
        Objects.requireNonNull(myNode);
        MasterDetailsComponent.MyNode myNode2 = myNode;
        int n = 0;
        String string = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ModuleNode.class, ModuleGroupNodeImpl.class}, (Object)myNode2, n)) {
            case 0 -> {
                ModuleNode moduleNode = (ModuleNode)myNode2;
                yield moduleNode.getFullModuleName();
            }
            case 1 -> {
                ModuleGroupNodeImpl groupNode = (ModuleGroupNodeImpl)myNode2;
                yield groupNode.getModuleGroup().getQualifiedName();
            }
            default -> super.getTextForSpeedSearch(node);
        };
        if (string == null) {
            ModuleStructureConfigurable.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected ArrayList<AnAction> getAdditionalActions() {
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        result.add(ActionManager.getInstance().getAction("MoveModuleToGroup"));
        result.add((AnAction)new ChangeModuleNamesAction());
        return result;
    }

    public void addNode(MasterDetailsComponent.MyNode nodeToAdd, MasterDetailsComponent.MyNode parent) {
        super.addNode(nodeToAdd, parent);
    }

    @Override
    @NotNull
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        List result = super.createActions(fromPopup);
        if (fromPopup) {
            ((ArrayList)result).add(Separator.getInstance());
            ((ArrayList)result).add(new FlattenModulesToggleAction(this.myProject, () -> true, () -> this.myFlattenModules, value -> {
                this.myFlattenModules = value;
                this.regroupModules();
            }));
            ((ArrayList)result).add(new HideGroupsAction());
            this.addCollapseExpandActions(result);
        }
        List list2 = result;
        if (list2 == null) {
            ModuleStructureConfigurable.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Override
    @NotNull
    protected List<? extends AnAction> createCopyActions(boolean fromPopup) {
        List<MyCopyAction> list2 = List.of(new MyCopyAction());
        if (list2 == null) {
            ModuleStructureConfigurable.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    protected void loadTree() {
        this.createProjectNodes();
        this.getTreeModel().reload();
        this.myUiDisposed = false;
    }

    @Override
    @NotNull
    protected Collection<? extends ProjectStructureElement> getProjectStructureElements() {
        ArrayList<ModuleProjectStructureElement> result = new ArrayList<ModuleProjectStructureElement>();
        for (Module module : this.myModuleManager.getModules()) {
            result.add(new ModuleProjectStructureElement(this.myContext, module));
        }
        ArrayList<ModuleProjectStructureElement> arrayList = result;
        if (arrayList == null) {
            ModuleStructureConfigurable.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    protected void updateSelection(@Nullable NamedConfigurable configurable) {
        this.myProjectStructureConfigurable.getFacetStructureConfigurable().disposeMultipleSettingsEditor();
        ThreadingAssertions.assertEventDispatchThread();
        super.updateSelection(configurable);
        if (configurable != null) {
            this.updateModuleEditorSelection(configurable);
        }
    }

    protected boolean isAutoScrollEnabled() {
        return this.myAutoScrollEnabled;
    }

    protected boolean updateMultiSelection(List<? extends NamedConfigurable> selectedConfigurables) {
        return this.myProjectStructureConfigurable.getFacetStructureConfigurable().updateMultiSelection(selectedConfigurables, this.getDetailsComponent());
    }

    @NotNull
    public Collection<BaseExtensionPointName<?>> getDependencies() {
        List<ExtensionPointName<ModuleStructureExtension>> list2 = List.of(ModuleStructureExtension.EP_NAME);
        if (list2 == null) {
            ModuleStructureConfigurable.$$$reportNull$$$0(5);
        }
        return list2;
    }

    private void updateModuleEditorSelection(NamedConfigurable configurable) {
        ModuleConfigurable moduleConfigurable;
        ModuleEditor editor;
        if (configurable instanceof ModuleConfigurable && (editor = (moduleConfigurable = (ModuleConfigurable)configurable).getModuleEditor()) != null) {
            editor.init(this.myHistory);
        }
        if (configurable instanceof FacetConfigurable) {
            FacetConfigurable facetConfigurable = (FacetConfigurable)configurable;
            facetConfigurable.getEditor().onFacetSelected();
        }
    }

    private void createProjectNodes() {
        ModuleGrouper moduleGrouper = this.getModuleGrouper();
        ModuleGroupingTreeHelper helper = ModuleGroupingTreeHelper.forEmptyTree((!this.myHideModuleGroups && !this.myFlattenModules ? 1 : 0) != 0, (ModuleGroupingImplementation)ModuleGroupingTreeHelper.createDefaultGrouping((ModuleGrouper)moduleGrouper), ModuleStructureConfigurable::createModuleGroupNode, m -> this.createModuleNode((Module)m, moduleGrouper), this.getNodeComparator());
        List<Module> modules = Arrays.stream(this.myModuleManager.getModules()).toList();
        helper.createModuleNodes(modules, (MutableTreeNode)this.myRoot, this.getTreeModel());
        if (ModuleStructureConfigurable.containsSecondLevelNodes((TreeNode)this.myRoot)) {
            this.myTree.setShowsRootHandles(true);
        }
        this.sortDescendants(this.myRoot);
        if (this.myProject.isDefault()) {
            this.myRoot.removeAllChildren();
        }
        this.addRootNodesFromExtensions(this.myRoot, this.myProject);
    }

    private static boolean containsSecondLevelNodes(TreeNode rootNode) {
        int count = rootNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            TreeNode child = rootNode.getChildAt(i);
            if (child.getChildCount() <= 0) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private ModuleNode createModuleNode(Module module, ModuleGrouper moduleGrouper) {
        ModuleConfigurable configurable = new ModuleConfigurable(this.myContext.myModulesConfigurator, module, this.TREE_UPDATER, moduleGrouper);
        List groupPath = moduleGrouper.getModuleAsGroupPath(module);
        ModuleNode node = new ModuleNode(configurable, groupPath != null ? new ModuleGroup(groupPath) : null);
        this.myFacetEditorFacade.addFacetsNodes(module, node);
        this.addNodesFromExtensions(module, node);
        ModuleNode moduleNode = node;
        if (moduleNode == null) {
            ModuleStructureConfigurable.$$$reportNull$$$0(6);
        }
        return moduleNode;
    }

    @NotNull
    private static MasterDetailsComponent.MyNode createModuleGroupNode(ModuleGroup moduleGroup) {
        TextConfigurable<ModuleGroup> moduleGroupConfigurable = new TextConfigurable<ModuleGroup>(moduleGroup, moduleGroup.toString(), JavaUiBundle.message("module.group.banner.text", moduleGroup.toString()), JavaUiBundle.message("project.roots.module.groups.text", new Object[0]), PlatformIcons.CLOSED_MODULE_GROUP_ICON);
        return new ModuleGroupNodeImpl(moduleGroupConfigurable, moduleGroup);
    }

    private void addRootNodesFromExtensions(MasterDetailsComponent.MyNode root, Project project2) {
        for (ModuleStructureExtension extension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            extension.addRootNodes(root, project2, this.TREE_UPDATER);
        }
    }

    private void addNodesFromExtensions(Module module, MasterDetailsComponent.MyNode moduleNode) {
        for (ModuleStructureExtension extension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            extension.addModuleNodeChildren(module, moduleNode, this.TREE_UPDATER);
        }
    }

    public boolean updateProjectTree(Module[] modules) {
        if (this.myRoot.getChildCount() == 0) {
            return false;
        }
        ArrayList<Pair> nodes = new ArrayList<Pair>(modules.length);
        HashSet<MasterDetailsComponent.MyNode> nodeSet = new HashSet<MasterDetailsComponent.MyNode>();
        for (Module module : modules) {
            MasterDetailsComponent.MyNode node = this.findModuleNode(module);
            LOG.assertTrue(node != null, (Object)("Module " + module.getName() + " is not in project."));
            nodes.add(Pair.create((Object)node, (Object)module));
            nodeSet.add(node);
        }
        ModuleGroupingTreeHelper<Module, MasterDetailsComponent.MyNode> helper = this.createGroupingHelper(nodeSet::contains);
        helper.moveModuleNodesToProperGroup(nodes, (MutableTreeNode)this.myRoot, this.getTreeModel(), (JTree)this.myTree);
        return true;
    }

    private DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)this.myTree.getModel();
    }

    @NotNull
    private ModuleGroupingTreeHelper<Module, MasterDetailsComponent.MyNode> createGroupingHelper(Predicate<? super MasterDetailsComponent.MyNode> nodeToBeMovedFilter) {
        ModuleGrouper grouper = this.getModuleGrouper();
        ModuleGroupingImplementation grouping = ModuleGroupingTreeHelper.createDefaultGrouping((ModuleGrouper)grouper);
        ModuleGroupingTreeHelper moduleGroupingTreeHelper = ModuleGroupingTreeHelper.forTree((MutableTreeNode)this.myRoot, node -> node instanceof ModuleGroupNode ? ((ModuleGroupNode)node).getModuleGroup() : null, node -> node instanceof ModuleNode ? ((ModuleNode)node).getModule() : null, (!this.myHideModuleGroups && !this.myFlattenModules ? 1 : 0) != 0, (ModuleGroupingImplementation)grouping, ModuleStructureConfigurable::createModuleGroupNode, module -> this.createModuleNode((Module)module, grouper), this.getNodeComparator(), node -> nodeToBeMovedFilter.test((MasterDetailsComponent.MyNode)node));
        if (moduleGroupingTreeHelper == null) {
            ModuleStructureConfigurable.$$$reportNull$$$0(7);
        }
        return moduleGroupingTreeHelper;
    }

    protected Comparator<MasterDetailsComponent.MyNode> getNodeComparator() {
        List comparators = ContainerUtil.mapNotNull((Object[])((ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()), ModuleStructureExtension::getNodeComparator);
        return new MergingComparator<MasterDetailsComponent.MyNode>(ContainerUtil.concat((List)comparators, Collections.singletonList(NODE_COMPARATOR)));
    }

    @Override
    public void init(StructureConfigurableContext context) {
        super.init(context);
        this.addItemsChangeListener(new MasterDetailsComponent.ItemsChangeListener(){

            public void itemChanged(@Nullable Object deletedItem) {
                if (deletedItem instanceof Library) {
                    Library library = (Library)deletedItem;
                    MasterDetailsComponent.MyNode node = MasterDetailsComponent.findNodeByObject((TreeNode)ModuleStructureConfigurable.this.myRoot, (Object)library);
                    if (node != null) {
                        TreeNode parent = node.getParent();
                        node.removeFromParent();
                        ModuleStructureConfigurable.this.getTreeModel().reload(parent);
                    }
                    ModuleStructureConfigurable.this.myContext.getDaemonAnalyzer().removeElement(new LibraryProjectStructureElement(ModuleStructureConfigurable.this.myContext, library));
                }
            }
        });
    }

    @Override
    public void reset() {
        super.reset();
        for (ModuleStructureExtension extension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            extension.reset(this.myProject);
        }
    }

    public void apply() throws ConfigurationException {
        this.checkForEmptyAndDuplicatedNames(JavaUiBundle.message("rename.message.prefix.module", new Object[0]), JavaUiBundle.message("rename.module.title", new Object[0]), ModuleConfigurable.class);
        for (ModuleStructureExtension extension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            if (!extension.isModified()) continue;
            extension.apply();
        }
        if (this.myContext.myModulesConfigurator.isModified()) {
            this.myContext.myModulesConfigurator.apply();
        }
        for (ModuleStructureExtension extension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            extension.afterModelCommit();
        }
    }

    public boolean isModified() {
        if (this.myContext.myModulesConfigurator.isModified()) {
            return true;
        }
        for (ModuleStructureExtension extension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            if (!extension.isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void disposeUIResources() {
        super.disposeUIResources();
        this.myFacetEditorFacade.clearMaps(true);
        this.myContext.myModulesConfigurator.disposeUIResources();
        super.disposeUIResources();
        for (ModuleStructureExtension extension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            extension.disposeUIResources();
        }
    }

    public void dispose() {
    }

    @NotNull
    public JComponent createComponent() {
        JComponent jComponent = UiDataProvider.wrapComponent((JComponent)super.createComponent(), sink -> {
            sink.set(LangDataKeys.MODULE_CONTEXT_ARRAY, (Object)this.getModuleContexts());
            sink.set(LangDataKeys.MODULE_CONTEXT, (Object)this.getSelectedModule());
            sink.set(LangDataKeys.MODIFIABLE_MODULE_MODEL, (Object)this.myContext.myModulesConfigurator.getModuleModel());
            sink.set(PlatformCoreDataKeys.SELECTED_ITEM, this.getSelectedObject());
        });
        if (jComponent == null) {
            ModuleStructureConfigurable.$$$reportNull$$$0(8);
        }
        return jComponent;
    }

    public String getDisplayName() {
        return JavaUiBundle.message("project.roots.display.name", new Object[0]);
    }

    @NonNls
    @NotNull
    public String getHelpTopic() {
        String topic = super.getHelpTopic();
        if (topic != null) {
            String string = topic;
            if (string == null) {
                ModuleStructureConfigurable.$$$reportNull$$$0(9);
            }
            return string;
        }
        return "reference.settingsdialog.project.structure.module";
    }

    public ActionCallback selectOrderEntry(@NotNull Module module, @Nullable OrderEntry orderEntry) {
        if (module == null) {
            ModuleStructureConfigurable.$$$reportNull$$$0(10);
        }
        for (ModuleStructureExtension extension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            ActionCallback callback = extension.selectOrderEntry(module, orderEntry);
            if (callback == null) continue;
            return callback;
        }
        Place p = new Place();
        p.putPath("category", (Object)this);
        Runnable r = null;
        MasterDetailsComponent.MyNode node = this.findModuleNode(module);
        if (node != null) {
            p.putPath("treeObject", (Object)module);
            p.putPath("selectedEditor", (Object)ClasspathEditor.getName());
            r = () -> {
                ModuleEditor moduleEditor;
                ModuleConfigurationEditor editor;
                if (orderEntry != null && (editor = (moduleEditor = ((ModuleConfigurable)node.getConfigurable()).getModuleEditor()).getEditor(ClasspathEditor.getName())) instanceof ClasspathEditor) {
                    ((ClasspathEditor)editor).selectOrderEntry(orderEntry);
                }
            };
        }
        ActionCallback result = this.myProjectStructureConfigurable.navigateTo(p, true);
        return r != null ? result.doWhenDone(r) : result;
    }

    private ModuleGrouper getModuleGrouper() {
        return ModuleGrouper.instanceFor((Project)this.myProject, (ModifiableModuleModel)this.myContext.myModulesConfigurator.getModuleModel());
    }

    public Project getProject() {
        return this.myProject;
    }

    public Module[] getModules() {
        if (this.myContext.myModulesConfigurator != null) {
            ModifiableModuleModel model = this.myContext.myModulesConfigurator.getModuleModel();
            return model.getModules();
        }
        return this.myModuleManager.getModules();
    }

    public void removeLibraryOrderEntry(Module module, Library library) {
        OrderEntry[] entries;
        ModuleEditor moduleEditor = this.myContext.myModulesConfigurator.getModuleEditor(module);
        LOG.assertTrue(moduleEditor != null, (Object)"Current module editor was not initialized");
        ModifiableRootModel modelProxy = moduleEditor.getModifiableRootModelProxy();
        for (OrderEntry entry : entries = modelProxy.getOrderEntries()) {
            if (!(entry instanceof LibraryOrderEntry) || !Comparing.strEqual((String)entry.getPresentableName(), (String)library.getName())) continue;
            modelProxy.removeOrderEntry(entry);
            break;
        }
        this.myContext.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(this.myContext, module));
        this.myTree.repaint();
    }

    public void addLibraryOrderEntry(Module module, Library library) {
        OrderEntry[] entries;
        ModuleEditor moduleEditor = this.myContext.myModulesConfigurator.getModuleEditor(module);
        LOG.assertTrue(moduleEditor != null, (Object)"Current module editor was not initialized");
        ModifiableRootModel modelProxy = moduleEditor.getModifiableRootModelProxy();
        for (OrderEntry entry : entries = modelProxy.getOrderEntries()) {
            if (!(entry instanceof LibraryOrderEntry) || !Comparing.strEqual((String)entry.getPresentableName(), (String)library.getName()) || Messages.showYesNoDialog((Project)module.getProject(), (String)JavaUiBundle.message("project.roots.replace.library.entry.message", entry.getPresentableName()), (String)JavaUiBundle.message("project.roots.replace.library.entry.title", new Object[0]), (Icon)Messages.getInformationIcon()) != 0) continue;
            modelProxy.removeOrderEntry(entry);
            break;
        }
        modelProxy.addLibraryEntry(library);
        this.myContext.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(this.myContext, module));
        this.myTree.repaint();
    }

    @Nullable
    public MasterDetailsComponent.MyNode findModuleNode(Module module) {
        return ModuleStructureConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)module);
    }

    public FacetEditorFacadeImpl getFacetEditorFacade() {
        return this.myFacetEditorFacade;
    }

    public ProjectFacetsConfigurator getFacetConfigurator() {
        return this.myContext.myModulesConfigurator.getFacetsConfigurator();
    }

    private void addModule(boolean anImport, boolean detectModuleBase) {
        List<Module> modules;
        if (anImport) {
            modules = this.myContext.myModulesConfigurator.addImportModule((Component)this.myTree);
        } else {
            VirtualFile file;
            Module selectedModule;
            String basePath = null;
            if (detectModuleBase && (selectedModule = this.getSelectedModule()) != null && (file = (VirtualFile)Arrays.stream(ModuleRootManager.getInstance((Module)selectedModule).getContentRoots()).findFirst().orElse(null)) != null) {
                basePath = file.getPath();
            }
            modules = this.myContext.myModulesConfigurator.addNewModule(basePath);
        }
        if (modules != null && !modules.isEmpty()) {
            EelMachine eelMachine = Registry.is((String)"java.home.finder.use.eel") ? EelProviderUtil.getEelMachine((Project)this.myProject) : null;
            this.myProjectStructureConfigurable.getProjectJdksModel().syncSdks(eelMachine);
            for (Module module : modules) {
                this.addModuleNode(module);
            }
        }
    }

    private void addModuleNode(@NotNull Module module) {
        if (module == null) {
            ModuleStructureConfigurable.$$$reportNull$$$0(11);
        }
        TreePath selectionPath = this.myTree.getSelectionPath();
        MasterDetailsComponent.MyNode parent = null;
        if (selectionPath != null) {
            ModifiableModuleModel modifiableModuleModel;
            String[] groupPath;
            MasterDetailsComponent.MyNode selected = (MasterDetailsComponent.MyNode)selectionPath.getLastPathComponent();
            Object o = selected.getConfigurable().getEditableObject();
            if (o instanceof ModuleGroup) {
                if (!ModuleGrouperKt.isQualifiedModuleNamesEnabled((Project)module.getProject())) {
                    this.myContext.myModulesConfigurator.getModuleModel().setModuleGroupPath(module, ((ModuleGroup)o).getGroupPath());
                }
                parent = selected;
            } else if (o instanceof Module && (groupPath = (modifiableModuleModel = this.myContext.myModulesConfigurator.getModuleModel()).getModuleGroupPath((Module)o)) != null) {
                modifiableModuleModel.setModuleGroupPath(module, groupPath);
                parent = ModuleStructureConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)new ModuleGroup(Arrays.asList(groupPath)));
            }
        }
        if (parent == null) {
            parent = this.myRoot;
        }
        ModuleNode node = this.createModuleNode(module, this.getModuleGrouper());
        TreeUtil.insertNode((MutableTreeNode)node, (MutableTreeNode)parent, (DefaultTreeModel)this.getTreeModel(), this.getNodeComparator());
        this.selectNodeInTree((DefaultMutableTreeNode)((Object)node));
        ProjectStructureDaemonAnalyzer daemonAnalyzer = this.myContext.getDaemonAnalyzer();
        daemonAnalyzer.queueUpdate(new ModuleProjectStructureElement(this.myContext, module));
        daemonAnalyzer.queueUpdateForAllElementsWithErrors();
    }

    @Nullable
    public Module getSelectedModule() {
        Object selectedObject = this.getSelectedObject();
        if (selectedObject instanceof Module) {
            return (Module)selectedObject;
        }
        if (selectedObject instanceof Library && ((Library)selectedObject).getTable() == null) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myTree.getSelectionPath().getLastPathComponent();
            return (Module)((MasterDetailsComponent.MyNode)node.getParent()).getConfigurable().getEditableObject();
        }
        return null;
    }

    @NotNull
    @NonNls
    public String getId() {
        return "project.structure";
    }

    @Nullable
    public Module getModule(String moduleName) {
        if (moduleName == null) {
            return null;
        }
        return this.myContext != null && this.myContext.myModulesConfigurator != null ? this.myContext.myModulesConfigurator.getModule(moduleName) : this.myModuleManager.findModuleByName(moduleName);
    }

    public StructureConfigurableContext getContext() {
        return this.myContext;
    }

    private static boolean canBeCopiedByExtension(NamedConfigurable<?> configurable) {
        for (ModuleStructureExtension extension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            if (!extension.canBeCopied(configurable)) continue;
            return true;
        }
        return false;
    }

    private void copyByExtension(NamedConfigurable<?> configurable) {
        for (ModuleStructureExtension extension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            extension.copy(configurable, this.TREE_UPDATER);
        }
    }

    private Module @Nullable [] getModuleContexts() {
        TreePath[] paths = this.myTree.getSelectionPaths();
        LinkedHashSet<Module> modules = new LinkedHashSet<Module>();
        if (paths != null) {
            for (TreePath path : paths) {
                MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)path.getLastPathComponent();
                NamedConfigurable configurable = node.getConfigurable();
                LOG.assertTrue(configurable != null, (Object)"already disposed");
                Object o = configurable.getEditableObject();
                if (o instanceof Module) {
                    modules.add((Module)o);
                    continue;
                }
                if (!(node instanceof ModuleGroupNode) || ((ModuleGroupNode)node).getModuleGroup() == null) continue;
                TreeUtil.treeNodeTraverser((TreeNode)node).forEach(descendant -> {
                    Object object;
                    if (descendant instanceof MasterDetailsComponent.MyNode && (object = ((MasterDetailsComponent.MyNode)descendant).getConfigurable().getEditableObject()) instanceof Module) {
                        modules.add((Module)object);
                    }
                });
            }
        }
        return !modules.isEmpty() ? modules.toArray(Module.EMPTY_ARRAY) : null;
    }

    private void regroupModules() {
        DefaultMutableTreeNode selection = null;
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null) {
            selection = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        }
        this.createGroupingHelper(node -> true).moveAllModuleNodesToProperGroups((MutableTreeNode)this.myRoot, this.getTreeModel());
        if (selection != null) {
            TreeUtil.selectInTree((DefaultMutableTreeNode)selection, (boolean)true, (JTree)this.myTree);
        }
    }

    @Override
    protected BaseStructureConfigurable.AbstractAddGroup createAddAction(final boolean fromPopup) {
        return new BaseStructureConfigurable.AbstractAddGroup(JavaUiBundle.message("add.new.header.text", new Object[0])){

            public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                AddModuleAction addModuleAction = new AddModuleAction(false, fromPopup);
                addModuleAction.getTemplatePresentation().setText(JavaUiBundle.message("action.text.new.module", new Object[0]));
                ArrayList<Object> result = new ArrayList<Object>();
                result.add((Object)addModuleAction);
                AddModuleAction importModuleAction = new AddModuleAction(true, fromPopup);
                importModuleAction.getTemplatePresentation().setText(JavaUiBundle.message("action.text.import.module", new Object[0]));
                importModuleAction.getTemplatePresentation().setIcon(AllIcons.ToolbarDecorator.Import);
                result.add((Object)importModuleAction);
                Collection<AnAction> actions = AddFacetToModuleAction.createAddFrameworkActions(ModuleStructureConfigurable.this.myFacetEditorFacade, ModuleStructureConfigurable.this.myProject);
                if (!actions.isEmpty()) {
                    result.add(new Separator(JavaUiBundle.message("add.group.framework.separator", new Object[0])));
                    result.addAll(actions);
                }
                NullableComputable selectedNodeRetriever = () -> {
                    Object lastPathComponent;
                    TreePath selectionPath = ModuleStructureConfigurable.this.myTree.getSelectionPath();
                    Object object = lastPathComponent = selectionPath == null ? null : selectionPath.getLastPathComponent();
                    if (lastPathComponent instanceof MasterDetailsComponent.MyNode) {
                        return (MasterDetailsComponent.MyNode)lastPathComponent;
                    }
                    return null;
                };
                ArrayList<AnAction> actionsFromExtensions = new ArrayList<AnAction>();
                for (ModuleStructureExtension extension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
                    actionsFromExtensions.addAll(extension.createAddActions((NullableComputable<MasterDetailsComponent.MyNode>)selectedNodeRetriever, ModuleStructureConfigurable.this.TREE_UPDATER, ModuleStructureConfigurable.this.myProject, ModuleStructureConfigurable.this.myRoot));
                }
                if (!actionsFromExtensions.isEmpty() && !result.isEmpty()) {
                    result.add(new Separator());
                }
                result.addAll(actionsFromExtensions);
                AnAction[] anActionArray = result.toArray(AnAction.EMPTY_ARRAY);
                if (anActionArray == null) {
                    2.$$$reportNull$$$0(0);
                }
                return anActionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable$2", "getChildren"));
            }
        };
    }

    protected List<RemoveConfigurableHandler<?>> getRemoveHandlers() {
        return this.myRemoveHandlers;
    }

    @NotNull
    protected String getEmptySelectionString() {
        String string = JavaUiBundle.message("empty.module.selection.string", new Object[0]);
        if (string == null) {
            ModuleStructureConfigurable.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextForSpeedSearch";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopyActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectStructureElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleNode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createGroupingHelper";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptySelectionString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTextForSpeedSearch";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "selectOrderEntry";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addModuleNode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 12 -> new IllegalStateException(string);
        };
    }

    private class ModuleRemoveHandler
    extends RemoveConfigurableHandler<Module> {
        ModuleRemoveHandler() {
            super(ModuleConfigurable.class);
        }

        @Override
        public boolean remove(@NotNull Collection<? extends Module> modules) {
            if (modules == null) {
                ModuleRemoveHandler.$$$reportNull$$$0(0);
            }
            ModulesConfigurator modulesConfigurator = ModuleStructureConfigurable.this.myContext.myModulesConfigurator;
            List moduleEditors = ContainerUtil.mapNotNull(modules, modulesConfigurator::getModuleEditor);
            if (moduleEditors.isEmpty()) {
                return false;
            }
            if (!modulesConfigurator.canDeleteModules(moduleEditors)) {
                return false;
            }
            List modulesToDelete = ContainerUtil.mapNotNull((Collection)moduleEditors, ModuleEditor::getModule);
            for (Module module : modulesToDelete) {
                List<Facet> removed = modulesConfigurator.getFacetsConfigurator().removeAllFacets(module);
                ModuleStructureConfigurable.this.myProjectStructureConfigurable.getFacetStructureConfigurable().removeFacetNodes(removed);
            }
            modulesConfigurator.deleteModules(moduleEditors);
            for (Module module : modulesToDelete) {
                ModuleStructureConfigurable.this.myContext.getDaemonAnalyzer().removeElement(new ModuleProjectStructureElement(ModuleStructureConfigurable.this.myContext, module));
                for (ModuleStructureExtension extension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
                    extension.moduleRemoved(module);
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable$ModuleRemoveHandler", "remove"));
        }
    }

    private class FacetInModuleRemoveHandler
    extends RemoveConfigurableHandler<Facet> {
        FacetInModuleRemoveHandler() {
            super(FacetConfigurable.class);
        }

        @Override
        public boolean remove(@NotNull Collection<? extends Facet> facets) {
            if (facets == null) {
                FacetInModuleRemoveHandler.$$$reportNull$$$0(0);
            }
            for (Facet facet : facets) {
                List<Facet> removed = ModuleStructureConfigurable.this.myContext.myModulesConfigurator.getFacetsConfigurator().removeFacet(facet);
                ModuleStructureConfigurable.this.myProjectStructureConfigurable.getFacetStructureConfigurable().removeFacetNodes(removed);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facets", "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable$FacetInModuleRemoveHandler", "remove"));
        }
    }

    private class ModuleNode
    extends MasterDetailsComponent.MyNode
    implements ModuleGroupNode {
        private final ModuleGroup myModuleAsGroup;

        ModuleNode(@Nullable ModuleConfigurable configurable, ModuleGroup moduleAsGroup) {
            if (configurable == null) {
                ModuleNode.$$$reportNull$$$0(0);
            }
            super((NamedConfigurable)configurable);
            this.myModuleAsGroup = moduleAsGroup;
        }

        @Override
        public ModuleGroup getModuleGroup() {
            return this.myModuleAsGroup;
        }

        @NotNull
        public String getDisplayName() {
            ModuleGroup group;
            if (ModuleStructureConfigurable.this.myFlattenModules) {
                return this.getFullModuleName();
            }
            String parentGroupName = null;
            if (this.parent instanceof ModuleGroupNode && (group = ((ModuleGroupNode)this.parent).getModuleGroup()) != null) {
                parentGroupName = group.getQualifiedName();
            }
            String string = this.getModuleGrouper().getShortenedName(this.getModule(), parentGroupName);
            if (string == null) {
                ModuleNode.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        private String getFullModuleName() {
            String string = ModuleStructureConfigurable.this.myContext.myModulesConfigurator.getModuleModel().getActualName(this.getModule());
            if (string == null) {
                ModuleNode.$$$reportNull$$$0(2);
            }
            return string;
        }

        private ModuleGrouper getModuleGrouper() {
            return this.getConfigurable().getModuleGrouper();
        }

        public ModuleConfigurable getConfigurable() {
            return (ModuleConfigurable)super.getConfigurable();
        }

        private Module getModule() {
            return this.getConfigurable().getModule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reloadNode(DefaultTreeModel treeModel) {
            boolean autoScrollWasEnabled = ModuleStructureConfigurable.this.myAutoScrollEnabled;
            try {
                ModuleStructureConfigurable.this.myAutoScrollEnabled = false;
                ModuleGroupingTreeHelper<Module, MasterDetailsComponent.MyNode> helper = ModuleStructureConfigurable.this.createGroupingHelper(Predicate.isEqual(this));
                MasterDetailsComponent.MyNode newNode = (MasterDetailsComponent.MyNode)helper.moveModuleNodeToProperGroup((MutableTreeNode)this, (Object)this.getModule(), (MutableTreeNode)ModuleStructureConfigurable.this.myRoot, treeModel, (JTree)ModuleStructureConfigurable.this.myTree);
                treeModel.reload((TreeNode)newNode);
            }
            finally {
                ModuleStructureConfigurable.this.myAutoScrollEnabled = autoScrollWasEnabled;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurable";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable$ModuleNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable$ModuleNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFullModuleName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class ModuleGroupNodeImpl
    extends MasterDetailsComponent.MyNode
    implements ModuleGroupNode {
        private final ModuleGroup myModuleGroup;

        ModuleGroupNodeImpl(@NotNull NamedConfigurable configurable, @NotNull ModuleGroup moduleGroup) {
            if (configurable == null) {
                ModuleGroupNodeImpl.$$$reportNull$$$0(0);
            }
            if (moduleGroup == null) {
                ModuleGroupNodeImpl.$$$reportNull$$$0(1);
            }
            super(configurable, true);
            this.myModuleGroup = moduleGroup;
        }

        @NotNull
        public String getDisplayName() {
            ModuleGroup parentGroup;
            List parentGroupPath = this.parent instanceof ModuleGroupNode ? ((parentGroup = ((ModuleGroupNode)this.parent).getModuleGroup()) != null ? parentGroup.getGroupPathList() : Collections.emptyList()) : Collections.emptyList();
            List groupPath = this.myModuleGroup.getGroupPathList();
            if (ContainerUtil.startsWith((List)groupPath, (List)parentGroupPath)) {
                String string = StringUtil.join(groupPath.subList(parentGroupPath.size(), groupPath.size()), (String)".");
                if (string == null) {
                    ModuleGroupNodeImpl.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = StringUtil.join((Collection)groupPath, (String)".");
            if (string == null) {
                ModuleGroupNodeImpl.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public ModuleGroup getModuleGroup() {
            ModuleGroup moduleGroup = this.myModuleGroup;
            if (moduleGroup == null) {
                ModuleGroupNodeImpl.$$$reportNull$$$0(4);
            }
            return moduleGroup;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleGroup";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable$ModuleGroupNodeImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable$ModuleGroupNodeImpl";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private class HideGroupsAction
    extends ToggleAction
    implements DumbAware {
        HideGroupsAction() {
            super("", "", AllIcons.ObjectBrowser.CompactEmptyPackages);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                HideGroupsAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            Presentation presentation = e.getPresentation();
            String text = JavaUiBundle.message(ModuleStructureConfigurable.this.myHideModuleGroups ? "project.roots.plain.mode.action.text.enabled" : "project.roots.plain.mode.action.text.disabled", new Object[0]);
            presentation.setText(text);
            presentation.setDescription(text);
            if (ModuleStructureConfigurable.this.myContext.myModulesConfigurator != null) {
                presentation.setVisible(ModuleStructureConfigurable.this.myContext.myModulesConfigurator.getModuleModel().hasModuleGroups());
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                HideGroupsAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                HideGroupsAction.$$$reportNull$$$0(2);
            }
            return ModuleStructureConfigurable.this.myHideModuleGroups;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                HideGroupsAction.$$$reportNull$$$0(3);
            }
            ModuleStructureConfigurable.this.myHideModuleGroups = state;
            ModuleStructureConfigurable.this.regroupModules();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable$HideGroupsAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable$HideGroupsAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private final class MyCopyAction
    extends AnAction
    implements DumbAware {
        private MyCopyAction() {
            super(CommonBundle.messagePointer((String)"button.copy", (Object[])new Object[0]), CommonBundle.messagePointer((String)"button.copy", (Object[])new Object[0]), COPY_ICON);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            NamedConfigurable namedConfigurable;
            if (e == null) {
                MyCopyAction.$$$reportNull$$$0(0);
            }
            if (!((namedConfigurable = ModuleStructureConfigurable.this.getSelectedConfigurable()) instanceof ModuleConfigurable)) {
                ModuleStructureConfigurable.this.copyByExtension(namedConfigurable);
            }
            try {
                ModuleEditor moduleEditor = ((ModuleConfigurable)namedConfigurable).getModuleEditor();
                String modulePresentation = IdeCoreBundle.message((String)"project.new.wizard.module.identification", (Object[])new Object[0]);
                NamePathComponent component = new NamePathComponent(JavaUiBundle.message("label.module.name", new Object[0]), JavaUiBundle.message("label.component.file.location", StringUtil.capitalize((String)modulePresentation)), JavaUiBundle.message("title.select.project.file.directory", modulePresentation), JavaUiBundle.message("description.select.project.file.directory", StringUtil.capitalize((String)modulePresentation)), true, false);
                Module originalModule = moduleEditor.getModule();
                if (originalModule != null) {
                    component.setPath(FileUtil.toSystemDependentName((String)originalModule.getModuleNioFile().getParent().toString()));
                }
                DialogBuilder dialogBuilder = new DialogBuilder((Component)ModuleStructureConfigurable.this.myTree);
                dialogBuilder.setTitle(JavaUiBundle.message("copy.module.dialog.title", new Object[0]));
                dialogBuilder.setCenterPanel((JComponent)component);
                dialogBuilder.setPreferredFocusComponent((JComponent)component.getNameComponent());
                dialogBuilder.setOkOperation(() -> {
                    String name = component.getNameValue();
                    if (name.isEmpty()) {
                        Messages.showErrorDialog((String)JavaUiBundle.message("enter.module.copy.name.error.message", new Object[0]), (String)CommonBundle.getErrorTitle());
                        return;
                    }
                    if (ModuleStructureConfigurable.this.getModule(name) != null) {
                        Messages.showErrorDialog((String)JavaUiBundle.message("module.0.already.exists.error.message", name), (String)CommonBundle.getErrorTitle());
                        return;
                    }
                    if (component.getPath().isEmpty()) {
                        Messages.showErrorDialog((String)JavaUiBundle.message("prompt.enter.project.file.location", modulePresentation), (String)CommonBundle.getErrorTitle());
                        return;
                    }
                    if (!ProjectWizardUtil.createDirectoryIfNotExists(JavaUiBundle.message("directory.project.file.directory", modulePresentation), component.getPath(), true)) {
                        Messages.showErrorDialog((String)JavaUiBundle.message("path.0.is.invalid.error.message", component.getPath()), (String)CommonBundle.getErrorTitle());
                        return;
                    }
                    dialogBuilder.getDialogWrapper().close(0);
                });
                if (dialogBuilder.show() != 0) {
                    return;
                }
                ModifiableRootModel rootModel = moduleEditor.getModifiableRootModel();
                Path path = Paths.get(component.getPath(), new String[0]);
                CopiedModuleBuilder builder = new CopiedModuleBuilder(rootModel, path, ModuleStructureConfigurable.this.myProject);
                builder.setName(component.getNameValue());
                builder.setModuleFilePath(path.resolve(builder.getName() + ".iml").toString());
                Module module = ModuleStructureConfigurable.this.myContext.myModulesConfigurator.addModule(builder);
                if (module != null) {
                    ModuleStructureConfigurable.this.addModuleNode(module);
                }
            }
            catch (Exception e1) {
                LOG.error((Throwable)e1);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            TreePath[] selectionPaths;
            if (e == null) {
                MyCopyAction.$$$reportNull$$$0(1);
            }
            if ((selectionPaths = ModuleStructureConfigurable.this.myTree.getSelectionPaths()) == null || selectionPaths.length != 1) {
                e.getPresentation().setEnabled(false);
            } else {
                NamedConfigurable selectedConfigurable = ModuleStructureConfigurable.this.getSelectedConfigurable();
                e.getPresentation().setEnabled(selectedConfigurable instanceof ModuleConfigurable || ModuleStructureConfigurable.canBeCopiedByExtension(selectedConfigurable));
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MyCopyAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable$MyCopyAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable$MyCopyAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MergingComparator<T>
    implements Comparator<T> {
        private final List<? extends Comparator<T>> myDelegates;

        MergingComparator(List<? extends Comparator<T>> delegates) {
            this.myDelegates = delegates;
        }

        @Override
        public int compare(T o1, T o2) {
            for (Comparator<T> delegate : this.myDelegates) {
                int value = delegate.compare(o1, o2);
                if (value == 0) continue;
                return value;
            }
            return 0;
        }
    }

    private static interface ModuleGroupNode
    extends MutableTreeNode {
        @Nullable
        public ModuleGroup getModuleGroup();
    }

    private final class AddModuleAction
    extends AnAction
    implements DumbAware {
        private final boolean myImport;
        private final boolean myDetectModuleBase;

        AddModuleAction(boolean anImport, boolean detectModuleBase) {
            super(JavaUiBundle.message("add.new.module.text.full", new Object[0]), null, AllIcons.Nodes.Module);
            this.myImport = anImport;
            this.myDetectModuleBase = detectModuleBase;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddModuleAction.$$$reportNull$$$0(0);
            }
            ModuleStructureConfigurable.this.addModule(this.myImport, this.myDetectModuleBase);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable$AddModuleAction", "actionPerformed"));
        }
    }

    @ApiStatus.Internal
    public static final class CopiedModuleBuilder
    extends ModuleBuilder {
        @NotNull
        private final ModifiableRootModel myRootModel;
        @NotNull
        private final Path myComponentPath;
        @NotNull
        private final Project myProject;

        @VisibleForTesting
        public CopiedModuleBuilder(@NotNull ModifiableRootModel rootModel, @NotNull Path componentPath, @NotNull Project project2) {
            if (rootModel == null) {
                CopiedModuleBuilder.$$$reportNull$$$0(0);
            }
            if (componentPath == null) {
                CopiedModuleBuilder.$$$reportNull$$$0(1);
            }
            if (project2 == null) {
                CopiedModuleBuilder.$$$reportNull$$$0(2);
            }
            this.myRootModel = rootModel;
            this.myComponentPath = componentPath;
            this.myProject = project2;
        }

        public void setupRootModel(@NotNull ModifiableRootModel modifiableRootModel) {
            if (modifiableRootModel == null) {
                CopiedModuleBuilder.$$$reportNull$$$0(3);
            }
            if (this.myRootModel.isSdkInherited()) {
                modifiableRootModel.inheritSdk();
            } else {
                modifiableRootModel.setSdk(this.myRootModel.getSdk());
            }
            ((CompilerModuleExtension)modifiableRootModel.getModuleExtension(CompilerModuleExtension.class)).inheritCompilerOutputPath(true);
            ((LanguageLevelModuleExtension)modifiableRootModel.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(LanguageLevelUtil.getCustomLanguageLevel((Module)this.myRootModel.getModule()));
            for (OrderEntry entry : this.myRootModel.getOrderEntries()) {
                if (entry instanceof JdkOrderEntry || entry instanceof ModuleSourceOrderEntry || !(entry instanceof ClonableOrderEntry)) continue;
                modifiableRootModel.addOrderEntry(((ClonableOrderEntry)entry).cloneEntry(modifiableRootModel, (ProjectRootManagerImpl)ProjectRootManager.getInstance((Project)this.myProject), VirtualFilePointerManager.getInstance()));
            }
            VirtualFile content = LocalFileSystem.getInstance().findFileByNioFile(this.myComponentPath);
            if (content == null) {
                try {
                    Files.createFile(NioFiles.createParentDirectories((Path)this.myComponentPath), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                content = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(this.myComponentPath);
            }
            modifiableRootModel.addContentEntry(content);
        }

        public ModuleType<?> getModuleType() {
            return ModuleType.get((Module)this.myRootModel.getModule());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootModel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentPath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifiableRootModel";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable$CopiedModuleBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setupRootModel";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

