/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibraryConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ConfigurationErrorQuickFix;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructureBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureValidator;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.navigation.Place;
import com.intellij.util.PathUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class LibraryProjectStructureElement
extends ProjectStructureElement {
    private final Library myLibrary;

    public LibraryProjectStructureElement(@NotNull StructureConfigurableContext context, @NotNull Library library) {
        if (context == null) {
            LibraryProjectStructureElement.$$$reportNull$$$0(0);
        }
        if (library == null) {
            LibraryProjectStructureElement.$$$reportNull$$$0(1);
        }
        super(context);
        this.myLibrary = library;
    }

    public Library getLibrary() {
        return this.myLibrary;
    }

    @Override
    public void check(ProjectStructureProblemsHolder problemsHolder) {
        if (((LibraryEx)this.myLibrary).isDisposed()) {
            return;
        }
        LibraryEx library = (LibraryEx)this.myContext.getLibraryModel(this.myLibrary);
        if (library == null || library.isDisposed()) {
            return;
        }
        this.reportInvalidRoots(problemsHolder, library, OrderRootType.CLASSES, "classes", ProjectStructureProblemType.error("library-invalid-classes-path"));
        String libraryName = library.getName();
        if (libraryName == null || !libraryName.startsWith("Maven: ")) {
            this.reportInvalidRoots(problemsHolder, library, OrderRootType.SOURCES, "sources", ProjectStructureProblemType.warning("library-invalid-source-javadoc-path"));
            this.reportInvalidRoots(problemsHolder, library, JavadocOrderRootType.getInstance(), "javadoc", ProjectStructureProblemType.warning("library-invalid-source-javadoc-path"));
        }
    }

    private void reportInvalidRoots(ProjectStructureProblemsHolder problemsHolder, LibraryEx library, @NotNull OrderRootType type, String rootName, ProjectStructureProblemType problemType) {
        List invalidUrls;
        if (type == null) {
            LibraryProjectStructureElement.$$$reportNull$$$0(2);
        }
        if (!(invalidUrls = library.getInvalidRootUrls(type)).isEmpty()) {
            HtmlChunk description = LibraryProjectStructureElement.createInvalidRootsDescription(invalidUrls, rootName, library.getName());
            PlaceInProjectStructure place = this.createPlace();
            String message = JavaUiBundle.message("project.roots.error.message.invalid.roots", rootName, invalidUrls.size());
            ProjectStructureProblemDescription.ProblemLevel level = library.getTable().getTableLevel().equals("project") ? ProjectStructureProblemDescription.ProblemLevel.PROJECT : ProjectStructureProblemDescription.ProblemLevel.GLOBAL;
            problemsHolder.registerProblem(new ProjectStructureProblemDescription(message, description, place, problemType, level, Collections.singletonList(new RemoveInvalidRootsQuickFix((Library)library, type, invalidUrls)), true));
        }
    }

    private static HtmlChunk createInvalidRootsDescription(List<String> invalidClasses, String rootName, @NlsSafe String libraryName) {
        HtmlBuilder buffer = new HtmlBuilder();
        String name = StringUtil.escapeXmlEntities((String)libraryName);
        HtmlChunk.Element link = HtmlChunk.link((String)("http://library/" + name), (String)name);
        buffer.appendRaw(JavaUiBundle.message("library.project.structure.invalid.roots.description", link, rootName, invalidClasses.size()));
        for (String url : invalidClasses) {
            buffer.br().nbsp(2);
            buffer.append(PathUtil.toPresentableUrl((String)url));
        }
        return buffer.toFragment();
    }

    @NotNull
    private PlaceInProjectStructure createPlace() {
        Project project2 = this.myContext.getProject();
        Place place = this.myContext.getModulesConfigurator().getProjectStructureConfigurable().createProjectOrGlobalLibraryPlace(this.myLibrary);
        return new PlaceInProjectStructureBase(project2, place, this);
    }

    @Override
    public List<ProjectStructureElementUsage> getUsagesInElement() {
        return Collections.emptyList();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LibraryProjectStructureElement)) {
            return false;
        }
        return this.getSourceOrThis() == ((LibraryProjectStructureElement)o).getSourceOrThis();
    }

    public ActionCallback navigate() {
        return this.createPlace().navigate();
    }

    @NotNull
    private Library getSourceOrThis() {
        InvocationHandler invocationHandler = Proxy.isProxyClass(this.myLibrary.getClass()) ? Proxy.getInvocationHandler(this.myLibrary) : null;
        Library realLibrary = invocationHandler instanceof ModuleEditor.ProxyDelegateAccessor ? (Library)((ModuleEditor.ProxyDelegateAccessor)((Object)invocationHandler)).getDelegate() : this.myLibrary;
        Library source = realLibrary instanceof LibraryEx ? ((LibraryEx)realLibrary).getSource() : null;
        Library library = source != null ? source : this.myLibrary;
        if (library == null) {
            LibraryProjectStructureElement.$$$reportNull$$$0(3);
        }
        return library;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this.getSourceOrThis());
    }

    @Override
    public boolean shouldShowWarningIfUnused() {
        LibraryTable libraryTable = this.myLibrary.getTable();
        if (libraryTable == null) {
            return false;
        }
        return "project".equals(libraryTable.getTableLevel());
    }

    @Override
    public ProjectStructureProblemDescription createUnusedElementWarning() {
        List<ConfigurationErrorQuickFix> fixes = Arrays.asList(new AddLibraryToDependenciesFix(), new RemoveLibraryFix(), new RemoveAllUnusedLibrariesFix());
        String name = Objects.toString(this.myLibrary.getName());
        String libraryName = HtmlChunk.link((String)("http://library/" + name), (String)name).toString();
        String result = JavaUiBundle.message("library.0.is.not.used", libraryName);
        return new ProjectStructureProblemDescription(result, HtmlChunk.empty(), this.createPlace(), ProjectStructureProblemType.unused("unused-library"), ProjectStructureProblemDescription.ProblemLevel.PROJECT, fixes, false);
    }

    @Override
    public String getPresentableName() {
        return this.myLibrary.getName();
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getTypeName() {
        return JavaUiBundle.message("configurable.library.prefix", new Object[0]);
    }

    @Override
    public String getId() {
        return "library:" + this.myLibrary.getTable().getTableLevel() + ":" + this.myLibrary.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/LibraryProjectStructureElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/LibraryProjectStructureElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceOrThis";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reportInvalidRoots";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private class RemoveInvalidRootsQuickFix
    extends ConfigurationErrorQuickFix {
        private final Library myLibrary;
        private final OrderRootType myType;
        private final List<String> myInvalidUrls;

        RemoveInvalidRootsQuickFix(Library library, OrderRootType type, List<String> invalidUrls) {
            super(JavaUiBundle.message("label.remove.invalid.roots", invalidUrls.size()));
            this.myLibrary = library;
            this.myType = type;
            this.myInvalidUrls = invalidUrls;
        }

        @Override
        public void performFix() {
            LibraryTable.ModifiableModel libraryTable = LibraryProjectStructureElement.this.myContext.getModifiableLibraryTable(this.myLibrary.getTable());
            if (libraryTable instanceof LibrariesModifiableModel) {
                for (String invalidRoot : this.myInvalidUrls) {
                    ExistingLibraryEditor libraryEditor = ((LibrariesModifiableModel)libraryTable).getLibraryEditor(this.myLibrary);
                    libraryEditor.removeRoot(invalidRoot, this.myType);
                }
                LibraryProjectStructureElement.this.myContext.getDaemonAnalyzer().queueUpdate(LibraryProjectStructureElement.this);
                ProjectStructureConfigurable structureConfigurable = LibraryProjectStructureElement.this.myContext.getModulesConfigurator().getProjectStructureConfigurable();
                LibraryProjectStructureElement.this.navigate().doWhenDone(() -> {
                    NamedConfigurable configurable = structureConfigurable.getConfigurableFor(this.myLibrary).getSelectedConfigurable();
                    if (configurable instanceof LibraryConfigurable) {
                        ((LibraryConfigurable)configurable).updateComponent();
                    }
                });
            }
        }
    }

    private final class AddLibraryToDependenciesFix
    extends ConfigurationErrorQuickFix {
        private AddLibraryToDependenciesFix() {
            super(JavaUiBundle.message("label.add.to.dependencies", new Object[0]));
        }

        @Override
        public void performFix() {
            ProjectStructureValidator.showDialogAndAddLibraryToDependencies(LibraryProjectStructureElement.this.myLibrary, LibraryProjectStructureElement.this.myContext.getModulesConfigurator().getProjectStructureConfigurable(), false);
        }
    }

    private final class RemoveLibraryFix
    extends ConfigurationErrorQuickFix {
        private RemoveLibraryFix() {
            super(JavaUiBundle.message("label.remove.library", new Object[0]));
        }

        @Override
        public void performFix() {
            BaseLibrariesConfigurable.getInstance(LibraryProjectStructureElement.this.myContext.getModulesConfigurator().getProjectStructureConfigurable(), LibraryProjectStructureElement.this.myLibrary.getTable().getTableLevel()).removeLibrary(LibraryProjectStructureElement.this);
        }
    }

    private final class RemoveAllUnusedLibrariesFix
    extends ConfigurationErrorQuickFix {
        private RemoveAllUnusedLibrariesFix() {
            super(JavaUiBundle.message("label.remove.all.unused.libraries", new Object[0]));
        }

        @Override
        public void performFix() {
            ProjectStructureConfigurable projectStructureConfigurable = LibraryProjectStructureElement.this.myContext.getModulesConfigurator().getProjectStructureConfigurable();
            BaseLibrariesConfigurable configurable = BaseLibrariesConfigurable.getInstance(projectStructureConfigurable, "project");
            Library[] libraries = configurable.getModelProvider().getModifiableModel().getLibraries();
            ArrayList<LibraryProjectStructureElement> toRemove = new ArrayList<LibraryProjectStructureElement>();
            for (Library library : libraries) {
                LibraryProjectStructureElement libraryElement = new LibraryProjectStructureElement(LibraryProjectStructureElement.this.myContext, library);
                if (!LibraryProjectStructureElement.this.myContext.getDaemonAnalyzer().getUsages(libraryElement).isEmpty()) continue;
                toRemove.add(libraryElement);
            }
            configurable.removeLibraries(toRemove);
        }
    }
}

