/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.SdkProjectStructureElement;
import com.intellij.openapi.util.ActionCallback;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class PlaceInModuleClasspath
extends PlaceInProjectStructure {
    private final StructureConfigurableContext myContext;
    private final Module myModule;
    private final ProjectStructureElement myElement;
    private final OrderEntry myOrderEntry;

    public PlaceInModuleClasspath(StructureConfigurableContext context, Module module, ProjectStructureElement element, OrderEntry orderEntry) {
        this.myContext = context;
        this.myModule = module;
        this.myElement = element;
        this.myOrderEntry = orderEntry;
    }

    public PlaceInModuleClasspath(@NotNull StructureConfigurableContext context, @NotNull Module module, ProjectStructureElement element, @NotNull ProjectStructureElement elementInClasspath) {
        if (context == null) {
            PlaceInModuleClasspath.$$$reportNull$$$0(0);
        }
        if (module == null) {
            PlaceInModuleClasspath.$$$reportNull$$$0(1);
        }
        if (elementInClasspath == null) {
            PlaceInModuleClasspath.$$$reportNull$$$0(2);
        }
        this.myContext = context;
        this.myModule = module;
        this.myElement = element;
        ModuleRootModel rootModel = this.myContext.getModulesConfigurator().getRootModel(this.myModule);
        ProjectStructureElement projectStructureElement = elementInClasspath;
        Objects.requireNonNull(projectStructureElement);
        ProjectStructureElement projectStructureElement2 = projectStructureElement;
        int n = 0;
        this.myOrderEntry = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LibraryProjectStructureElement.class, ModuleProjectStructureElement.class, SdkProjectStructureElement.class}, (Object)projectStructureElement2, n)) {
            case 0 -> {
                LibraryProjectStructureElement structureElement = (LibraryProjectStructureElement)projectStructureElement2;
                yield OrderEntryUtil.findLibraryOrderEntry((ModuleRootModel)rootModel, (Library)structureElement.getLibrary());
            }
            case 1 -> {
                ModuleProjectStructureElement structureElement = (ModuleProjectStructureElement)projectStructureElement2;
                yield OrderEntryUtil.findModuleOrderEntry((ModuleRootModel)rootModel, (Module)structureElement.getModule());
            }
            case 2 -> {
                SdkProjectStructureElement structureElement = (SdkProjectStructureElement)projectStructureElement2;
                yield OrderEntryUtil.findJdkOrderEntry((ModuleRootModel)rootModel, (Sdk)structureElement.getSdk());
            }
            default -> null;
        };
    }

    @Override
    @NotNull
    public ProjectStructureElement getContainingElement() {
        ProjectStructureElement projectStructureElement = this.myElement;
        if (projectStructureElement == null) {
            PlaceInModuleClasspath.$$$reportNull$$$0(3);
        }
        return projectStructureElement;
    }

    @Override
    public String getPlacePath() {
        return this.myOrderEntry != null ? this.myOrderEntry.getPresentableName() : null;
    }

    @Override
    @NotNull
    public ActionCallback navigate() {
        ActionCallback actionCallback = this.myContext.getModulesConfigurator().getProjectStructureConfigurable().selectOrderEntry(this.myModule, this.myOrderEntry);
        if (actionCallback == null) {
            PlaceInModuleClasspath.$$$reportNull$$$0(4);
        }
        return actionCallback;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementInClasspath";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/PlaceInModuleClasspath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/PlaceInModuleClasspath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "navigate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

