/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ConfigurationErrorQuickFix;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ProjectStructureProblemDescription {
    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    private final String myMessage;
    private final HtmlChunk myDescription;
    private final PlaceInProjectStructure myPlace;
    private final List<? extends ConfigurationErrorQuickFix> myFixes;
    private final ProjectStructureProblemType myProblemType;
    private final ProblemLevel myProblemLevel;
    private final boolean myCanShowPlace;

    public ProjectStructureProblemDescription(@NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String message, @NotNull HtmlChunk description, @NotNull PlaceInProjectStructure place, @NotNull ProjectStructureProblemType problemType, @NotNull List<? extends ConfigurationErrorQuickFix> fixes) {
        if (message == null) {
            ProjectStructureProblemDescription.$$$reportNull$$$0(0);
        }
        if (description == null) {
            ProjectStructureProblemDescription.$$$reportNull$$$0(1);
        }
        if (place == null) {
            ProjectStructureProblemDescription.$$$reportNull$$$0(2);
        }
        if (problemType == null) {
            ProjectStructureProblemDescription.$$$reportNull$$$0(3);
        }
        if (fixes == null) {
            ProjectStructureProblemDescription.$$$reportNull$$$0(4);
        }
        this(message, description, place, problemType, ProblemLevel.PROJECT, fixes, true);
    }

    public ProjectStructureProblemDescription(@NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String message, @NotNull HtmlChunk description, @NotNull PlaceInProjectStructure place, @NotNull ProjectStructureProblemType problemType, @NotNull ProblemLevel level, @NotNull List<? extends ConfigurationErrorQuickFix> fixes, boolean canShowPlace) {
        if (message == null) {
            ProjectStructureProblemDescription.$$$reportNull$$$0(5);
        }
        if (description == null) {
            ProjectStructureProblemDescription.$$$reportNull$$$0(6);
        }
        if (place == null) {
            ProjectStructureProblemDescription.$$$reportNull$$$0(7);
        }
        if (problemType == null) {
            ProjectStructureProblemDescription.$$$reportNull$$$0(8);
        }
        if (level == null) {
            ProjectStructureProblemDescription.$$$reportNull$$$0(9);
        }
        if (fixes == null) {
            ProjectStructureProblemDescription.$$$reportNull$$$0(10);
        }
        this.myMessage = message;
        this.myDescription = description;
        this.myPlace = place;
        this.myFixes = fixes;
        this.myProblemType = problemType;
        this.myProblemLevel = level;
        this.myCanShowPlace = canShowPlace;
    }

    public ProblemLevel getProblemLevel() {
        return this.myProblemLevel;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getMessage() {
        String string = this.myMessage;
        if (string == null) {
            ProjectStructureProblemDescription.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getMessage(boolean includePlace) {
        String result;
        if (!includePlace || !this.myCanShowPlace) {
            String string = this.myMessage;
            if (string == null) {
                ProjectStructureProblemDescription.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = result = this.myPlace.getContainingElement().getPresentableText() + ": " + StringUtil.decapitalize((String)this.myMessage);
        if (string == null) {
            ProjectStructureProblemDescription.$$$reportNull$$$0(13);
        }
        return string;
    }

    public boolean canShowPlace() {
        return this.myCanShowPlace;
    }

    @NotNull
    public HtmlChunk getDescription() {
        HtmlChunk htmlChunk = this.myDescription;
        if (htmlChunk == null) {
            ProjectStructureProblemDescription.$$$reportNull$$$0(14);
        }
        return htmlChunk;
    }

    public List<? extends ConfigurationErrorQuickFix> getFixes() {
        return this.myFixes;
    }

    public ProjectStructureProblemType.Severity getSeverity() {
        return this.myProblemType.getSeverity();
    }

    @NotNull
    public PlaceInProjectStructure getPlace() {
        PlaceInProjectStructure placeInProjectStructure = this.myPlace;
        if (placeInProjectStructure == null) {
            ProjectStructureProblemDescription.$$$reportNull$$$0(15);
        }
        return placeInProjectStructure;
    }

    public String getId() {
        String placePath = this.myPlace.getPlacePath();
        return this.myProblemType.getId() + "(" + this.myPlace.getContainingElement().getId() + (String)(placePath != null ? "," + placePath : "") + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemType";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureProblemDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureProblemDescription";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 13, 14, 15 -> new IllegalStateException(string);
        };
    }

    public static enum ProblemLevel {
        PROJECT,
        GLOBAL;

    }
}

