/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.SimpleMergingQueueKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B/\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0018J\u0013\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001cJ\u0014\u0010\u001a\u001a\u00020\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eJ\b\u0010\u001f\u001a\u00020\u0018H\u0002J\b\u0010 \u001a\u00020\u0018H\u0002J\n\u0010!\u001a\u00020\u0005H\u0096\u0080\u0004J\b\u0010\"\u001a\u00020\u0018H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0010j\b\u0012\u0004\u0012\u00028\u0000`\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/projectRoot/daemon/SimpleMergingQueue;", "T", "Ljava/lang/Runnable;", "Lcom/intellij/openapi/Disposable;", "name", "", "delayMillis", "", "isActive", "", "threadToUse", "Lcom/intellij/util/Alarm$ThreadToUse;", "disposableParent", "<init>", "(Ljava/lang/String;IZLcom/intellij/util/Alarm$ThreadToUse;Lcom/intellij/openapi/Disposable;)V", "taskHolder", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "timer", "Lcom/intellij/util/Alarm;", "lock", "", "Lorg/jetbrains/annotations/NotNull;", "start", "", "stop", "queue", "task", "(Ljava/lang/Runnable;)V", "tasks", "", "waitAndRun", "flush", "toString", "dispose", "intellij.java.ui"})
@ApiStatus.Internal
@VisibleForTesting
public final class SimpleMergingQueue<T extends Runnable>
implements Disposable {
    @NotNull
    private final String name;
    private final int delayMillis;
    private volatile boolean isActive;
    @NotNull
    private LinkedHashSet<T> taskHolder;
    @NotNull
    private final Alarm timer;
    @NotNull
    private final Object lock;

    public SimpleMergingQueue(@NotNull String name, int delayMillis, boolean isActive, @NotNull Alarm.ThreadToUse threadToUse, @NotNull Disposable disposableParent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)threadToUse, (String)"threadToUse");
        Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
        this.name = name;
        this.delayMillis = delayMillis;
        this.isActive = isActive;
        this.taskHolder = new LinkedHashSet();
        this.timer = new Alarm(threadToUse, (Disposable)this);
        Object object = ObjectUtils.sentinel((String)("SimpleMergingQueue(" + this.name + ")"));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sentinel(...)");
        this.lock = object;
        Disposer.register((Disposable)disposableParent, (Disposable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.isActive) {
                return;
            }
            this.isActive = true;
            if (!((Collection)this.taskHolder).isEmpty()) {
                this.waitAndRun();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.isActive = false;
            int n = this.timer.cancelAllRequests();
        }
    }

    public final void queue(@NotNull T task2) {
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        this.queue(CollectionsKt.listOf(task2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void queue(@NotNull List<? extends T> tasks) {
        Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean hasTasks = !((Collection)this.taskHolder).isEmpty();
            this.taskHolder.addAll((Collection)tasks);
            if (!hasTasks && this.isActive) {
                this.waitAndRun();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void waitAndRun() {
        this.timer.cancelAllRequests();
        this.timer.addRequest(() -> SimpleMergingQueue.waitAndRun$lambda$0(this), this.delayMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void flush() {
        LinkedHashSet<T> tasks = null;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!this.isActive) {
                return;
            }
            tasks = this.taskHolder;
            this.taskHolder = new LinkedHashSet();
            Unit $i$a$-synchronized-SimpleMergingQueue$flush$2 = Unit.INSTANCE;
        }
        for (Runnable task2 : (Set)tasks) {
            try {
                task2.run();
            }
            catch (Throwable e) {
                SimpleMergingQueueKt.access$getLog$p().error(e);
            }
        }
    }

    @NotNull
    public String toString() {
        return "SimpleMergingQueue(name='" + this.name + "', delayMillis=" + this.delayMillis + ", isActive=" + this.isActive + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.stop();
            this.taskHolder = new LinkedHashSet();
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final void waitAndRun$lambda$0(SimpleMergingQueue this$0) {
        this$0.flush();
    }
}

