/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.schema;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLAnchor;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLQuotedText;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.YamlPsiUtilKt;
import org.jetbrains.yaml.psi.impl.YAMLArrayImpl;
import org.jetbrains.yaml.psi.impl.YAMLBlockMappingImpl;
import org.jetbrains.yaml.psi.impl.YAMLHashImpl;
import org.jetbrains.yaml.schema.YamlEmptyObjectAdapter;
import org.jetbrains.yaml.schema.YamlObjectAdapter;
import org.jetbrains.yaml.schema.YamlPropertyAdapter;

public final class YamlJsonPsiWalker
implements JsonLikePsiWalker {
    public static final YamlJsonPsiWalker INSTANCE = new YamlJsonPsiWalker();

    private YamlJsonPsiWalker() {
    }

    public boolean isQuotedString(@NotNull PsiElement element) {
        if (element == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(0);
        }
        return element instanceof YAMLQuotedText;
    }

    public ThreeState isName(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof YAMLDocument || parent instanceof YAMLMapping) {
            return ThreeState.YES;
        }
        if (parent instanceof YAMLKeyValue && YamlJsonPsiWalker.isFirstChild(element, parent)) {
            ASTNode prev = element.getNode().getTreePrev();
            return prev != null && prev.getElementType() == YAMLTokenTypes.INDENT ? ThreeState.YES : ThreeState.NO;
        }
        if (parent instanceof YAMLSequenceItem && YamlJsonPsiWalker.isFirstChild(element, parent)) {
            return ThreeState.UNSURE;
        }
        return ThreeState.NO;
    }

    private static boolean isFirstChild(PsiElement element, PsiElement parent) {
        PsiElement[] children = parent.getChildren();
        return children.length != 0 && children[0] == element;
    }

    public boolean isPropertyWithValue(@NotNull PsiElement element) {
        if (element == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(1);
        }
        return element instanceof YAMLKeyValue && ((YAMLKeyValue)element).getValue() != null;
    }

    public boolean isTopJsonElement(@NotNull PsiElement element) {
        if (element == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(2);
        }
        return element instanceof YAMLFile || element instanceof YAMLDocument;
    }

    public boolean acceptsEmptyRoot() {
        return true;
    }

    public PsiElement findElementToCheck(@NotNull PsiElement element) {
        if (element == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(3);
        }
        for (PsiElement current = element; current != null && !(current instanceof PsiFile); current = current.getParent()) {
            if (!(current instanceof YAMLValue) && !(current instanceof YAMLKeyValue)) continue;
            return current;
        }
        return null;
    }

    public boolean requiresNameQuotes() {
        return false;
    }

    @Nullable
    public JsonValueAdapter createValueAdapter(@NotNull PsiElement element) {
        LeafPsiElement leaf;
        if (element == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(4);
        }
        if (element instanceof YAMLValue) {
            return YamlPropertyAdapter.createValueAdapterByType((YAMLValue)element);
        }
        if (element instanceof YAMLDocument) {
            if (element.getChildren().length == 0) {
                return new YamlEmptyObjectAdapter(element);
            }
            return this.createValueAdapter(element.getFirstChild());
        }
        if (element instanceof LeafPsiElement && (leaf = (LeafPsiElement)element).getElementType() == YAMLTokenTypes.INDENT) {
            return YamlPropertyAdapter.createEmptyValueAdapter(element, true);
        }
        if (element instanceof LeafPsiElement) {
            JsonPropertyAdapter parentPropertyAdapter = this.getParentPropertyAdapter(element);
            return parentPropertyAdapter == null ? null : parentPropertyAdapter.getNameValueAdapter();
        }
        return null;
    }

    public boolean allowsSingleQuotes() {
        return true;
    }

    public boolean hasMissingCommaAfter(@NotNull PsiElement element) {
        if (element == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(5);
        }
        return false;
    }

    @Nullable
    public JsonPropertyAdapter getParentPropertyAdapter(@NotNull PsiElement element) {
        boolean isValue;
        boolean isKey;
        YAMLMapping mapping;
        if (element == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(6);
        }
        if ((mapping = (YAMLMapping)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLMapping.class, (boolean)true, (Class[])new Class[]{YAMLKeyValue.class})) != null && (element instanceof YAMLScalar || element.getParent() instanceof YAMLScalar)) {
            return new YamlPropertyAdapter(element.getParent());
        }
        YAMLKeyValue property = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLKeyValue.class, (boolean)false);
        if (property == null) {
            return null;
        }
        YAMLValue value = property.getValue();
        boolean isSelf = element == property;
        PsiElement key = property.getKey();
        boolean bl = isKey = key != null && PsiTreeUtil.isAncestor((PsiElement)key, (PsiElement)element, (boolean)false);
        if (!isSelf && !isKey && value instanceof YAMLSequence && value != element) {
            return null;
        }
        boolean bl2 = isValue = value != null && PsiTreeUtil.isAncestor((PsiElement)value, (PsiElement)element, (boolean)false);
        if (!(isKey || isValue || isSelf)) {
            return null;
        }
        return new YamlPropertyAdapter((PsiElement)property);
    }

    public Set<String> getPropertyNamesOfParentObject(@NotNull PsiElement originalPosition, PsiElement computedPosition) {
        int firstPropIndent;
        if (originalPosition == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(7);
        }
        YAMLMapping object = (YAMLMapping)PsiTreeUtil.getParentOfType((PsiElement)originalPosition, YAMLMapping.class, (boolean)false);
        YAMLMapping otherObject = (YAMLMapping)PsiTreeUtil.getParentOfType((PsiElement)computedPosition, YAMLMapping.class, (boolean)false);
        if (object == null || otherObject != null && PsiTreeUtil.isAncestor((PsiElement)CompletionUtil.getOriginalOrSelf((PsiElement)object), (PsiElement)CompletionUtil.getOriginalOrSelf((PsiElement)otherObject), (boolean)true)) {
            object = otherObject;
        }
        if (object == null) {
            return Collections.emptySet();
        }
        int mappingIndent = this.indentOf((PsiElement)object);
        int caretIndent = this.indentOf(computedPosition);
        List keyValues = object.getKeyValues().stream().toList();
        if (!keyValues.isEmpty() ? caretIndent > (firstPropIndent = this.indentOf((PsiElement)keyValues.getFirst())) : caretIndent > mappingIndent) {
            return Collections.emptySet();
        }
        return new YamlObjectAdapter(object).getPropertyList().stream().map(p -> p.getName()).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public int indentOf(@NotNull PsiElement element) {
        if (element == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(8);
        }
        return YAMLUtil.getIndentToThisElement((PsiElement)element);
    }

    public int indentOf(@NotNull PsiFile file) {
        if (file == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(9);
        }
        return CodeStyle.getSettings((Project)file.getProject(), (VirtualFile)file.getVirtualFile()).getIndentOptionsByFile((PsiFile)file).INDENT_SIZE;
    }

    @Nullable
    public JsonPointerPosition findPosition(@NotNull PsiElement element, boolean forceLastTransition) {
        if (element == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(10);
        }
        JsonPointerPosition pos = new JsonPointerPosition();
        PsiElement current = element;
        while (!YamlJsonPsiWalker.breakCondition(current)) {
            String propertyName;
            PsiElement position = current;
            if ((current = current.getParent()) instanceof YAMLSequence) {
                YAMLSequence array = (YAMLSequence)current;
                List expressions = array.getItems();
                int idx = -1;
                for (int i = 0; i < expressions.size(); ++i) {
                    YAMLSequenceItem value = (YAMLSequenceItem)expressions.get(i);
                    if (!position.equals((Object)value)) continue;
                    idx = i;
                    break;
                }
                if (idx == -1) continue;
                pos.addPrecedingStep(idx);
                continue;
            }
            if (current instanceof YAMLSequenceItem) continue;
            if (current instanceof YAMLKeyValue) {
                propertyName = StringUtil.notNullize((String)((YAMLKeyValue)current).getName());
                if (!((current = current.getParent()) instanceof YAMLMapping)) {
                    return null;
                }
                pos.addPrecedingStep(propertyName);
                continue;
            }
            if (current instanceof YAMLMapping && position instanceof YAMLKeyValue) {
                propertyName = StringUtil.notNullize((String)((YAMLKeyValue)position).getName());
                if (propertyName.contains("IntellijIdeaRulezzz") || position == element && !forceLastTransition) continue;
                pos.addPrecedingStep(propertyName);
                continue;
            }
            if (YamlJsonPsiWalker.breakCondition(current)) break;
            if (current instanceof YAMLMapping) {
                List elements = ((YAMLMapping)current).getYAMLElements();
                if (elements.isEmpty()) {
                    return null;
                }
                if (position instanceof YAMLPsiElement && elements.contains(position)) continue;
            }
            return null;
        }
        return pos;
    }

    private static boolean breakCondition(PsiElement current) {
        return current instanceof PsiFile || current instanceof YAMLDocument || current instanceof YAMLBlockMappingImpl && current.getParent() instanceof YAMLDocument;
    }

    public boolean requiresValueQuotes() {
        return false;
    }

    public String getDefaultObjectValue() {
        return "";
    }

    public String getDefaultArrayValue() {
        return "- ";
    }

    public boolean hasWhitespaceDelimitedCodeBlocks() {
        return true;
    }

    public String getNodeTextForValidation(PsiElement element) {
        String text = element.getText();
        if (!StringUtil.startsWith((CharSequence)text, (CharSequence)"!!") && !StringUtil.startsWithChar((CharSequence)text, (char)'&')) {
            return text;
        }
        int spaceIndex = text.indexOf(32);
        return spaceIndex > 0 ? text.substring(spaceIndex + 1) : text;
    }

    public TextRange adjustErrorHighlightingRange(@NotNull PsiElement element) {
        YAMLAnchor[] anchors;
        if (element == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(11);
        }
        if ((anchors = (YAMLAnchor[])PsiTreeUtil.getChildrenOfType((PsiElement)element, YAMLAnchor.class)) != null && anchors.length > 0) {
            YAMLAnchor lastAnchor = anchors[anchors.length - 1];
            PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)lastAnchor);
            return next == null ? element.getTextRange() : next.getTextRange();
        }
        PsiElement parent = element.getParent();
        if (parent instanceof YAMLDocument) {
            PsiElement firstYamlChild;
            for (firstYamlChild = element.getFirstChild(); firstYamlChild != null && !(firstYamlChild instanceof YAMLPsiElement); firstYamlChild = firstYamlChild.getNextSibling()) {
            }
            return firstYamlChild == null ? element.getTextRange() : firstYamlChild.getTextRange();
        }
        return element.getTextRange();
    }

    public JsonLikeSyntaxAdapter getSyntaxAdapter(Project project) {
        return YamlJsonLikeSyntaxAdapter.INSTANCE;
    }

    public PsiElement getParentContainer(PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLKeyValue.class), (Class[])new Class[]{YAMLMapping.class, YAMLSequence.class});
    }

    @NotNull
    public Collection<PsiElement> getRoots(@NotNull PsiFile file) {
        if (file == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(12);
        }
        if (!(file instanceof YAMLFile)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                YamlJsonPsiWalker.$$$reportNull$$$0(13);
            }
            return list;
        }
        HashSet<PsiElement> roots = new HashSet<PsiElement>();
        for (YAMLDocument document : ((YAMLFile)file).getDocuments()) {
            YAMLValue topLevelValue = document.getTopLevelValue();
            roots.add((PsiElement)(topLevelValue == null ? document : topLevelValue));
        }
        HashSet<PsiElement> hashSet = roots;
        if (hashSet == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(14);
        }
        return hashSet;
    }

    @Deprecated(forRemoval=true)
    public boolean requiresReformatAfterArrayInsertion() {
        return false;
    }

    @Nullable
    public PsiElement getPropertyNameElement(PsiElement property) {
        return property instanceof YAMLKeyValue ? ((YAMLKeyValue)property).getKey() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPosition";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/schema/YamlJsonPsiWalker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/schema/YamlJsonPsiWalker";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isQuotedString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyWithValue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isTopJsonElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findElementToCheck";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createValueAdapter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasMissingCommaAfter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getParentPropertyAdapter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyNamesOfParentObject";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "indentOf";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findPosition";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "adjustErrorHighlightingRange";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 13: 
            case 14: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 14 -> new IllegalStateException(string);
        };
    }

    private static class YamlJsonLikeSyntaxAdapter
    implements JsonLikeSyntaxAdapter {
        private static final YamlJsonLikeSyntaxAdapter INSTANCE = new YamlJsonLikeSyntaxAdapter();

        private YamlJsonLikeSyntaxAdapter() {
        }

        @NotNull
        public PsiElement adjustValue(@NotNull PsiElement value) {
            if (value == null) {
                YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(0);
            }
            if (!(value instanceof YAMLValue)) {
                YAMLKeyValue keyValue = YamlJsonLikeSyntaxAdapter.findPrecedingKeyValueWithNoValue(value);
                if (keyValue == null) {
                    keyValue = (YAMLKeyValue)ObjectUtils.tryCast((Object)value.getParent(), YAMLKeyValue.class);
                }
                if (keyValue != null) {
                    YAMLValue adjustedValue = keyValue.getValue();
                    if (adjustedValue != null) {
                        YAMLValue yAMLValue = adjustedValue;
                        if (yAMLValue == null) {
                            YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(1);
                        }
                        return yAMLValue;
                    }
                    YAMLElementGenerator generator = YAMLElementGenerator.getInstance((Project)keyValue.getProject());
                    YAMLValue newValue = Objects.requireNonNull(generator.createYamlKeyValue("a", "\"\"").getValue());
                    PsiElement psiElement = keyValue.add((PsiElement)newValue);
                    if (psiElement == null) {
                        YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(2);
                    }
                    return psiElement;
                }
                PsiElement psiElement = value;
                if (psiElement == null) {
                    YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(3);
                }
                return psiElement;
            }
            YAMLAnchor[] anchors = (YAMLAnchor[])PsiTreeUtil.getChildrenOfType((PsiElement)value, YAMLAnchor.class);
            if (anchors == null || anchors.length == 0) {
                PsiElement psiElement = value;
                if (psiElement == null) {
                    YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(4);
                }
                return psiElement;
            }
            PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)anchors[anchors.length - 1]);
            PsiElement psiElement = next == null ? value : next;
            if (psiElement == null) {
                YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(5);
            }
            return psiElement;
        }

        private static YAMLKeyValue findPrecedingKeyValueWithNoValue(PsiElement element) {
            YAMLKeyValue keyValue;
            PsiElement prev = PsiUtilCore.getElementType((PsiElement)element) == YAMLTokenTypes.INDENT ? element.getPrevSibling() : element;
            if ((prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)prev)) instanceof YAMLKeyValue && (keyValue = (YAMLKeyValue)prev).getValue() == null) {
                return keyValue;
            }
            return null;
        }

        @NotNull
        public PsiElement createProperty(@NotNull String name, @NotNull String value, @NotNull Project project) {
            if (name == null) {
                YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(6);
            }
            if (value == null) {
                YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(7);
            }
            if (project == null) {
                YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(8);
            }
            YAMLElementGenerator generator = YAMLElementGenerator.getInstance((Project)project);
            YAMLKeyValue yAMLKeyValue = generator.createYamlKeyValue(name, StringUtil.unquoteString((String)value));
            if (yAMLKeyValue == null) {
                YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(9);
            }
            return yAMLKeyValue;
        }

        @NotNull
        public PsiElement createEmptyArray(@NotNull Project project, boolean preferInline) {
            if (project == null) {
                YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(10);
            }
            YAMLElementGenerator generator = YAMLElementGenerator.getInstance((Project)project);
            YAMLSequence yAMLSequence = preferInline ? generator.createEmptyArray() : generator.createEmptySequence();
            if (yAMLSequence == null) {
                YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(11);
            }
            return yAMLSequence;
        }

        @Nullable
        private static PsiElement skipWsBackward(@Nullable PsiElement item) {
            while (item instanceof PsiWhiteSpace || item instanceof PsiComment) {
                item = PsiTreeUtil.prevLeaf((PsiElement)item);
            }
            return item;
        }

        @Nullable
        private static PsiElement skipWsForward(@Nullable PsiElement item) {
            while (item instanceof PsiWhiteSpace || item instanceof PsiComment) {
                item = PsiTreeUtil.nextLeaf((PsiElement)item);
            }
            return item;
        }

        public void removeArrayItem(@NotNull PsiElement item) {
            PsiElement parent;
            if (item == null) {
                YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(12);
            }
            PsiElement psiElement = parent = item instanceof YAMLSequenceItem ? item : item.getParent();
            if (parent instanceof YAMLSequenceItem) {
                PsiElement grandParent = parent.getParent();
                PsiElement prev = YamlJsonLikeSyntaxAdapter.skipWsBackward(PsiTreeUtil.prevLeaf((PsiElement)parent));
                PsiElement next = YamlJsonLikeSyntaxAdapter.skipWsForward(PsiTreeUtil.nextLeaf((PsiElement)parent));
                parent.delete();
                if (grandParent instanceof YAMLArrayImpl && prev instanceof LeafPsiElement && ((LeafPsiElement)prev).getElementType() == YAMLTokenTypes.COMMA) {
                    prev.delete();
                } else if (grandParent instanceof YAMLArrayImpl && next instanceof LeafPsiElement && ((LeafPsiElement)next).getElementType() == YAMLTokenTypes.COMMA) {
                    next.delete();
                }
                if (!(grandParent instanceof YAMLArrayImpl) && prev instanceof LeafPsiElement && ((LeafPsiElement)prev).getElementType() == YAMLTokenTypes.EOL) {
                    prev.delete();
                } else if (!(grandParent instanceof YAMLArrayImpl) && next instanceof LeafPsiElement && ((LeafPsiElement)next).getElementType() == YAMLTokenTypes.EOL) {
                    next.delete();
                }
            } else {
                throw new IllegalArgumentException("Cannot remove item from a non-sequence element");
            }
        }

        @NotNull
        public PsiElement addArrayItem(@NotNull PsiElement array, @NotNull String itemValue) {
            if (array == null) {
                YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(13);
            }
            if (itemValue == null) {
                YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(14);
            }
            if (array instanceof YAMLArrayImpl) {
                PsiElement psiElement = YamlJsonLikeSyntaxAdapter.addInlineArrayItem((YAMLSequence)array, itemValue);
                if (psiElement == null) {
                    YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(15);
                }
                return psiElement;
            }
            if (array instanceof YAMLSequence) {
                PsiElement psiElement = YamlJsonLikeSyntaxAdapter.addSequenceItem((YAMLSequence)array, itemValue);
                if (psiElement == null) {
                    YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(16);
                }
                return psiElement;
            }
            throw new IllegalArgumentException("Cannot add item to a non-sequence element");
        }

        private static PsiElement addInlineArrayItem(@NotNull YAMLSequence array, @NotNull String itemValue) {
            YAMLElementGenerator generator;
            YAMLSequenceItem sequenceItem;
            PsiElement addedItem;
            if (array == null) {
                YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(17);
            }
            if (itemValue == null) {
                YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(18);
            }
            if (!((addedItem = array.addBefore((PsiElement)(sequenceItem = (generator = YAMLElementGenerator.getInstance((Project)array.getProject())).createArrayItem(itemValue)), array.getLastChild())).getPrevSibling() instanceof PsiWhiteSpace)) {
                array.addBefore(generator.createSpace(), addedItem);
            }
            if (array.getItems().size() > 1) {
                array.addAfter(generator.createComma(), PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)addedItem));
            }
            array.addAfter(generator.createSpace(), addedItem);
            return addedItem;
        }

        private static PsiElement addSequenceItem(@NotNull YAMLSequence sequence, @NotNull String itemValue) {
            List items;
            if (sequence == null) {
                YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(19);
            }
            if (itemValue == null) {
                YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(20);
            }
            YAMLElementGenerator generator = YAMLElementGenerator.getInstance((Project)sequence.getProject());
            YAMLSequenceItem sequenceItem = generator.createSequenceItem(itemValue);
            PsiElement lastChild = sequence.getLastChild();
            if (lastChild != null && lastChild.getNode().getElementType() != YAMLTokenTypes.EOL) {
                sequence.add(generator.createEol());
            }
            YAMLSequenceItem lastItem = (items = sequence.getItems()).isEmpty() ? null : (YAMLSequenceItem)items.get(items.size() - 1);
            int indent = lastChild != null && lastItem != null ? YAMLUtil.getIndentToThisElement((PsiElement)lastItem) : YAMLUtil.getIndentToThisElement((PsiElement)sequence) + 2;
            sequence.add(generator.createIndent(indent));
            return sequence.add((PsiElement)sequenceItem);
        }

        public void ensureComma(PsiElement self, PsiElement newElement) {
            if (newElement instanceof YAMLKeyValue && self instanceof YAMLKeyValue) {
                PsiElement sibling = YamlJsonLikeSyntaxAdapter.skipSiblingsForward(self, new Class[0]);
                if (sibling != null && sibling.getText().equals("\n")) {
                    return;
                }
                PsiElement parent = self.getParent();
                parent.addAfter(YamlJsonLikeSyntaxAdapter.generateSeparator(parent), self);
                if (parent.getParent() instanceof YAMLDocument && YamlJsonLikeSyntaxAdapter.isCompoundValue(((YAMLKeyValue)self).getValue())) {
                    parent.addAfter(YamlJsonLikeSyntaxAdapter.generateSeparator(parent), self);
                }
            }
        }

        private static boolean isCompoundValue(@Nullable YAMLValue value) {
            return value instanceof YAMLMapping || value instanceof YAMLSequence;
        }

        @Nullable
        private static PsiElement skipSiblingsForward(@Nullable PsiElement element, Class<? extends PsiElement> ... elementClasses) {
            if (elementClasses == null) {
                YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(21);
            }
            if (element != null) {
                for (PsiElement e = element.getNextSibling(); e != null; e = e.getNextSibling()) {
                    if (e instanceof PsiComment || e instanceof PsiWhiteSpace && !e.textContains('\n')) continue;
                    return e;
                }
            }
            return null;
        }

        @NotNull
        private static PsiElement generateSeparator(PsiElement parent) {
            YAMLElementGenerator generator = YAMLElementGenerator.getInstance((Project)parent.getProject());
            if (parent instanceof YAMLHashImpl) {
                PsiElement psiElement = generator.createComma();
                if (psiElement == null) {
                    YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(22);
                }
                return psiElement;
            }
            PsiElement psiElement = generator.createEol();
            if (psiElement == null) {
                YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(23);
            }
            return psiElement;
        }

        public void removeIfComma(PsiElement forward) {
            if (forward instanceof LeafPsiElement && ((LeafPsiElement)forward).getElementType() == YAMLTokenTypes.EOL) {
                PsiElement nextSibling;
                while ((nextSibling = forward.getNextSibling()) instanceof LeafPsiElement && ((LeafPsiElement)nextSibling).getElementType() == YAMLTokenTypes.INDENT) {
                    nextSibling.delete();
                }
                forward.delete();
            }
        }

        public boolean fixWhitespaceBefore(PsiElement initialElement, PsiElement element) {
            return initialElement instanceof YAMLValue && initialElement != element;
        }

        @NotNull
        public String getDefaultValueFromType(@Nullable JsonSchemaType type) {
            if (type == null) {
                return "";
            }
            if (type == JsonSchemaType._object) {
                return " ";
            }
            if (type == JsonSchemaType._array) {
                return " - ";
            }
            String string = type.getDefaultValue();
            if (string == null) {
                YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(24);
            }
            return string;
        }

        @NotNull
        public PsiElement adjustNewProperty(@NotNull PsiElement element) {
            if (element == null) {
                YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(25);
            }
            if (element instanceof YAMLMapping) {
                PsiElement psiElement = element.getFirstChild();
                if (psiElement == null) {
                    YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(26);
                }
                return psiElement;
            }
            PsiElement psiElement = element;
            if (psiElement == null) {
                YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(27);
            }
            return psiElement;
        }

        @NotNull
        public PsiElement adjustPropertyAnchor(@NotNull LeafPsiElement element) {
            if (element == null) {
                YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(28);
            }
            YAMLElementGenerator generator = YAMLElementGenerator.getInstance((Project)element.getProject());
            YAMLKeyValue keyValue = YamlJsonLikeSyntaxAdapter.findPrecedingKeyValueWithNoValue((PsiElement)element);
            assert (keyValue != null) : "Should come here only for YAMLKeyValue with no value and a following indent";
            PsiComment nextComment = (PsiComment)ObjectUtils.tryCast((Object)YamlJsonLikeSyntaxAdapter.skipNonNewlineSpaces(keyValue), PsiComment.class);
            if (nextComment != null) {
                keyValue.addBefore(generator.createSpace(), null);
                keyValue.addBefore(nextComment.copy(), null);
            }
            keyValue.addBefore(generator.createEol(), null);
            keyValue.addBefore(generator.createIndent(element.getTextLength()), null);
            PsiElement prev = element.getPrevSibling();
            if (prev != null) {
                prev.delete();
            }
            element.delete();
            if (nextComment != null) {
                nextComment.delete();
            }
            YAMLKeyValue yAMLKeyValue = keyValue;
            if (yAMLKeyValue == null) {
                YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(29);
            }
            return yAMLKeyValue;
        }

        @Nullable
        private static PsiElement skipNonNewlineSpaces(YAMLKeyValue keyValue) {
            PsiElement sibling = keyValue.getNextSibling();
            while (sibling instanceof PsiWhiteSpace && !sibling.getText().contains("\n")) {
                sibling = sibling.getNextSibling();
            }
            return sibling;
        }

        @NotNull
        public PsiElement addProperty(@NotNull PsiElement contextForInsertion, @NotNull PsiElement newProperty) {
            if (contextForInsertion == null) {
                YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(30);
            }
            if (newProperty == null) {
                YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(31);
            }
            YamlJsonLikeSyntaxAdapter.preFormatAround(contextForInsertion);
            PsiElement psiElement = super.addProperty(contextForInsertion, newProperty);
            if (psiElement == null) {
                YamlJsonLikeSyntaxAdapter.$$$reportNull$$$0(32);
            }
            return psiElement;
        }

        private static void preFormatAround(PsiElement element) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)element.getProject());
            Document document = documentManager.getDocument(element.getContainingFile());
            if (document == null) {
                return;
            }
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            PsiElement elementToFormat = YamlPsiUtilKt.findClosestAncestorWithoutIndent(document, element);
            if (elementToFormat instanceof YAMLDocument || elementToFormat instanceof YAMLMapping) {
                elementToFormat = elementToFormat.getContainingFile();
            }
            CodeStyleManager.getInstance((Project)element.getProject()).reformat(elementToFormat, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5, 9, 11, 15, 16, 22, 23, 24, 26, 27, 29, 32 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 11: 
                case 15: 
                case 16: 
                case 22: 
                case 23: 
                case 24: 
                case 26: 
                case 27: 
                case 29: 
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/yaml/schema/YamlJsonPsiWalker$YamlJsonLikeSyntaxAdapter";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 13: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "array";
                    break;
                }
                case 14: 
                case 18: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "itemValue";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sequence";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementClasses";
                    break;
                }
                case 25: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contextForInsertion";
                    break;
                }
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newProperty";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/yaml/schema/YamlJsonPsiWalker$YamlJsonLikeSyntaxAdapter";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "adjustValue";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createProperty";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEmptyArray";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addArrayItem";
                    break;
                }
                case 22: 
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generateSeparator";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultValueFromType";
                    break;
                }
                case 26: 
                case 27: {
                    objectArray = objectArray2;
                    objectArray2[1] = "adjustNewProperty";
                    break;
                }
                case 29: {
                    objectArray = objectArray2;
                    objectArray2[1] = "adjustPropertyAnchor";
                    break;
                }
                case 32: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addProperty";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "adjustValue";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 11: 
                case 15: 
                case 16: 
                case 22: 
                case 23: 
                case 24: 
                case 26: 
                case 27: 
                case 29: 
                case 32: {
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createProperty";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "createEmptyArray";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "removeArrayItem";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "addArrayItem";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "addInlineArrayItem";
                    break;
                }
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "addSequenceItem";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "skipSiblingsForward";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "adjustNewProperty";
                    break;
                }
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "adjustPropertyAnchor";
                    break;
                }
                case 30: 
                case 31: {
                    objectArray = objectArray;
                    objectArray[2] = "addProperty";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5, 9, 11, 15, 16, 22, 23, 24, 26, 27, 29, 32 -> new IllegalStateException(string);
            };
        }
    }
}

