/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.explorer.forest;

import com.intellij.database.explorer.forest.DvArm;
import com.intellij.database.explorer.forest.DvBushRef;
import com.intellij.database.explorer.forest.DvFolder;
import com.intellij.database.explorer.forest.DvForestRootFolder;
import com.intellij.database.explorer.forest.DvNiceFolder;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicUniqueBush;
import com.intellij.database.util.common.AnyFun;
import com.intellij.database.util.tree.AbstractTree;
import com.intellij.util.containers.UtilKt;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 Y*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001YB\u0017\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010 \u001a\u0002H!\"\u0004\b\u0001\u0010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0#\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0002\u0010$J6\u0010%\u001a\u0002H!\"\u0004\b\u0001\u0010!2\b\b\u0002\u0010&\u001a\u00020'2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0#\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0002 \u0001\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020*H\u0002J\u001b\u00102\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00142\u0006\u00103\u001a\u00028\u0000\u00a2\u0006\u0002\u00104J\u0013\u00105\u001a\u00020'2\u0006\u00103\u001a\u00028\u0000\u00a2\u0006\u0002\u00106J\u0019\u00107\u001a\u00020\u00172\f\u00108\u001a\b\u0012\u0004\u0012\u00020:09\u00a2\u0006\u0002\u0010;J\r\u0010<\u001a\u00020*H\u0000\u00a2\u0006\u0002\b=J\r\u0010>\u001a\u00020*H\u0000\u00a2\u0006\u0002\b?J\r\u0010@\u001a\u00020/H\u0000\u00a2\u0006\u0002\bAJ\u0015\u0010B\u001a\u00020*2\u0006\u0010C\u001a\u00020/H\u0000\u00a2\u0006\u0002\bDJ\u0019\u0010E\u001a\u00020*2\n\u00103\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0000\u00a2\u0006\u0002\bFJ\u0012\u0010G\u001a\u00020*2\n\u00103\u001a\u0006\u0012\u0002\b\u00030\u0014J\u0013\u0010G\u001a\u00020*2\u0006\u00103\u001a\u00028\u0000\u00a2\u0006\u0002\u0010HJ\u0010\u0010I\u001a\u0004\u0018\u00010\u001e2\u0006\u0010J\u001a\u00020\u001bJ\u0013\u0010K\u001a\u00020\u001e2\u0006\u00103\u001a\u00028\u0000\u00a2\u0006\u0002\u0010LJ\u0014\u0010M\u001a\b\u0012\u0004\u0012\u00020\u001e0N2\u0006\u0010J\u001a\u00020\u001bJ\u0014\u0010O\u001a\b\u0012\u0004\u0012\u00020\u001b0N2\u0006\u0010J\u001a\u00020\u001bJ\u000e\u0010P\u001a\u00020/2\u0006\u0010J\u001a\u00020\u001bJ\u0006\u0010Q\u001a\u00020:J$\u0010R\u001a\u00020*2\n\u0010S\u001a\u00060Tj\u0002`U2\u0006\u0010V\u001a\u00020:2\u0006\u0010W\u001a\u00020\u001eH\u0002J\n\u0010X\u001a\u00020:H\u0096\u0080\u0004R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019R\u0011\u0010+\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010,R\u0011\u0010.\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u0006Z"}, d2={"Lcom/intellij/database/explorer/forest/DvForest;", "B", "Lcom/intellij/database/model/basic/BasicUniqueBush;", "", "bushClass", "Ljava/lang/Class;", "<init>", "(Ljava/lang/Class;)V", "getBushClass", "()Ljava/lang/Class;", "root", "Lcom/intellij/database/explorer/forest/DvForestRootFolder;", "getRoot", "()Lcom/intellij/database/explorer/forest/DvForestRootFolder;", "orderCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "bushes", "Ljava/util/WeakHashMap;", "Lcom/intellij/database/explorer/forest/DvBushRef;", "foldersTree", "Lcom/intellij/database/util/tree/AbstractTree;", "Lcom/intellij/database/explorer/forest/DvFolder;", "getFoldersTree", "()Lcom/intellij/database/util/tree/AbstractTree;", "visibleTree", "Lcom/intellij/database/model/basic/BasicNode;", "getVisibleTree", "internalTree", "Lcom/intellij/database/explorer/forest/DvArm;", "getInternalTree", "readTree", "R", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "modifyTree", "autoRenumber", "", "(ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "renumberAllThis", "", "isNotEmpty", "()Z", "isEmpty", "bushRefCount", "", "getBushRefCount", "()I", "getBushRef", "bush", "(Lcom/intellij/database/model/basic/BasicUniqueBush;)Lcom/intellij/database/explorer/forest/DvBushRef;", "isBushRegistered", "(Lcom/intellij/database/model/basic/BasicUniqueBush;)Z", "ensureFolderPath", "path", "", "", "([Ljava/lang/String;)Lcom/intellij/database/explorer/forest/DvFolder;", "clearAll", "clearAll$intellij_database_core_impl", "checkModifyingThread", "checkModifyingThread$intellij_database_core_impl", "nextOrderId", "nextOrderId$intellij_database_core_impl", "adjustOrderId", "orderId", "adjustOrderId$intellij_database_core_impl", "registerBush", "registerBush$intellij_database_core_impl", "deregisterBush", "(Lcom/intellij/database/model/basic/BasicUniqueBush;)V", "treeParentOf", "node", "treeParentOfBush", "(Lcom/intellij/database/model/basic/BasicUniqueBush;)Lcom/intellij/database/explorer/forest/DvArm;", "treeArmChildrenOf", "Lkotlin/sequences/Sequence;", "treeVisibleChildrenOf", "treeCountAllVisibleChildrenOf", "dump", "dumpArm", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "prefix", "arm", "toString", "Companion", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDvForest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvForest.kt\ncom/intellij/database/explorer/forest/DvForest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 BooleanFun.kt\ncom/intellij/database/util/common/BooleanFun\n*L\n1#1,258:1\n1#2:259\n18#3:260\n*S KotlinDebug\n*F\n+ 1 DvForest.kt\ncom/intellij/database/explorer/forest/DvForest\n*L\n226#1:260\n*E\n"})
public final class DvForest<B extends BasicUniqueBush> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Class<B> bushClass;
    @NotNull
    private final DvForestRootFolder root;
    @NotNull
    private final AtomicInteger orderCounter;
    @NotNull
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final WeakHashMap<B, DvBushRef<B>> bushes;
    @NotNull
    private final AbstractTree<DvFolder> foldersTree;
    @NotNull
    private final AbstractTree<BasicNode> visibleTree;
    @NotNull
    private final AbstractTree<DvArm> internalTree;

    @NotNull
    public final Class<B> getBushClass() {
        return this.bushClass;
    }

    @NotNull
    public final DvForestRootFolder getRoot() {
        return this.root;
    }

    @NotNull
    public final AbstractTree<DvFolder> getFoldersTree() {
        return this.foldersTree;
    }

    @NotNull
    public final AbstractTree<BasicNode> getVisibleTree() {
        return this.visibleTree;
    }

    @NotNull
    public final AbstractTree<DvArm> getInternalTree() {
        return this.internalTree;
    }

    public DvForest(@NotNull Class<B> bushClass) {
        Intrinsics.checkNotNullParameter(bushClass, (String)"bushClass");
        this.orderCounter = new AtomicInteger(0);
        this.bushClass = bushClass;
        this.root = new DvForestRootFolder(this);
        this.lock = new ReentrantReadWriteLock();
        this.bushes = new WeakHashMap();
        this.foldersTree = new AbstractTree((Object)this.root, null, null, 6, null).withParent((Function1)1.INSTANCE).withChildren(DvForest::_init_$lambda$0);
        this.visibleTree = new AbstractTree((Object)this.root, null, null, 6, null).withParent((Function1)new Function1<BasicNode, DvArm>((Object)this){

            public final DvArm invoke(BasicNode p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((DvForest)this.receiver).treeParentOf(p0);
            }
        }).withChildren(arg_0 -> DvForest._init_$lambda$1(this, arg_0));
        this.internalTree = new AbstractTree((Object)this.root, null, null, 6, null).withParent((Function1)5.INSTANCE).withChildren(arg_0 -> DvForest._init_$lambda$2(this, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R readTree(@NotNull Function0<? extends R> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        ReentrantReadWriteLock.ReadLock wl = this.lock.readLock();
        wl.lock();
        try {
            Object object = action.invoke();
            return (R)object;
        }
        finally {
            wl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R modifyTree(boolean autoRenumber, @NotNull Function0<? extends R> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        ReentrantReadWriteLock.WriteLock wl = this.lock.writeLock();
        if (wl.isHeldByCurrentThread()) {
            return (R)action.invoke();
        }
        Intrinsics.checkNotNull((Object)wl);
        Lock lock = wl;
        lock.lock();
        try {
            Object object;
            boolean bl = false;
            try {
                Object object2 = action.invoke();
                if (autoRenumber) {
                    this.renumberAllThis();
                }
                object = object2;
            }
            catch (Throwable throwable) {
                if (autoRenumber) {
                    this.renumberAllThis();
                }
                throw throwable;
            }
            return (R)object;
        }
        finally {
            lock.unlock();
        }
    }

    public static /* synthetic */ Object modifyTree$default(DvForest dvForest, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return dvForest.modifyTree(bl, function0);
    }

    private final void renumberAllThis() {
        this.orderCounter.set(0);
        this.root.renumberAllRecursively$intellij_database_core_impl();
    }

    public final boolean isNotEmpty() {
        return this.root.isNotEmpty();
    }

    public final boolean isEmpty() {
        return this.root.isEmpty();
    }

    public final int getBushRefCount() {
        return this.bushes.size();
    }

    @Nullable
    public final DvBushRef<B> getBushRef(@NotNull B bush) {
        Intrinsics.checkNotNullParameter(bush, (String)"bush");
        return this.bushes.get(bush);
    }

    public final boolean isBushRegistered(@NotNull B bush) {
        Intrinsics.checkNotNullParameter(bush, (String)"bush");
        return this.bushes.containsKey(bush);
    }

    @NotNull
    public final DvFolder ensureFolderPath(@NotNull String[] path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.checkModifyingThread$intellij_database_core_impl();
        DvFolder folder = this.root;
        for (String nameInPath : path) {
            Object v0;
            String name;
            block3: {
                name = ((Object)StringsKt.trim((CharSequence)nameInPath)).toString();
                if (((CharSequence)name).length() == 0) continue;
                Iterable iterable = folder.getInnerFolders();
                for (Object t : iterable) {
                    DvNiceFolder it = (DvNiceFolder)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            DvNiceFolder f = v0;
            if (f == null) {
                f = folder.createNewInnerFolder(name);
            }
            folder = f;
        }
        return folder;
    }

    public final void clearAll$intellij_database_core_impl() {
        this.checkModifyingThread$intellij_database_core_impl();
        this.root.clearAll$intellij_database_core_impl();
        this.bushes.clear();
        this.orderCounter.set(0);
    }

    public final void checkModifyingThread$intellij_database_core_impl() throws ConcurrentModificationException {
        if (!this.lock.isWriteLocked()) {
            throw new ConcurrentModificationException("Attempting to modify the forest without capturing the lock.");
        }
        if (!this.lock.isWriteLockedByCurrentThread()) {
            throw new ConcurrentModificationException("Attempting to modify the forest without capturing the lock, when another thread is already modifying it.");
        }
    }

    public final int nextOrderId$intellij_database_core_impl() {
        return this.orderCounter.incrementAndGet();
    }

    public final void adjustOrderId$intellij_database_core_impl(int orderId) {
        this.orderCounter.getAndUpdate(arg_0 -> DvForest.adjustOrderId$lambda$0(orderId, arg_0));
    }

    public final void registerBush$intellij_database_core_impl(@NotNull DvBushRef<?> bush) {
        Intrinsics.checkNotNullParameter(bush, (String)"bush");
        Map map = this.bushes;
        Object obj = bush.getBush();
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type B of com.intellij.database.explorer.forest.DvForest");
        Object obj2 = obj;
        DvBushRef<?> dvBushRef = bush;
        map.put(obj2, dvBushRef);
    }

    public final void deregisterBush(@NotNull DvBushRef<?> bush) {
        Intrinsics.checkNotNullParameter(bush, (String)"bush");
        Map map = this.bushes;
        Object obj = bush.getBush();
        TypeIntrinsics.asMutableMap((Object)map).remove(obj);
    }

    public final void deregisterBush(@NotNull B bush) {
        Intrinsics.checkNotNullParameter(bush, (String)"bush");
        this.bushes.remove(bush);
    }

    @Nullable
    public final DvArm treeParentOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node instanceof DvArm ? (DvArm)((DvArm)node).getParent() : (AnyFun.isInstanceOf((Object)node, this.bushClass) ? this.treeParentOfBush((BasicUniqueBush)node) : null);
    }

    @NotNull
    public final DvArm treeParentOfBush(@NotNull B bush) {
        Intrinsics.checkNotNullParameter(bush, (String)"bush");
        DvBushRef<B> dvBushRef = this.bushes.get(bush);
        return dvBushRef != null && (dvBushRef = dvBushRef.getParent()) != null ? (DvArm)dvBushRef : (DvArm)this.root;
    }

    @NotNull
    public final Sequence<DvArm> treeArmChildrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node instanceof DvFolder ? ((DvFolder)node).getInnerChildren() : SequencesKt.emptySequence();
    }

    @NotNull
    public final Sequence<BasicNode> treeVisibleChildrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        return basicNode instanceof DvFolder ? ((DvFolder)node).getSuitableChildren() : (basicNode instanceof DvBushRef ? UtilKt.sequenceOfNotNull(((DvBushRef)node).getBush()) : SequencesKt.emptySequence());
    }

    /*
     * WARNING - void declaration
     */
    public final int treeCountAllVisibleChildrenOf(@NotNull BasicNode node) {
        int n;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        if (basicNode instanceof DvFolder) {
            n = ((DvFolder)node).getSuitableChildrenCount();
        } else if (basicNode instanceof DvBushRef) {
            int _true_$iv;
            void $this$choose$iv;
            boolean bl = ((DvBushRef)node).isValid();
            boolean bl2 = true;
            int _false_$iv = 0;
            boolean $i$f$choose = false;
            n = $this$choose$iv != false ? _true_$iv : _false_$iv;
        } else {
            n = 0;
        }
        return n;
    }

    @NotNull
    public final String dump() {
        StringBuilder b = new StringBuilder();
        this.dumpArm(b, "", this.root);
        String string = b.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void dumpArm(StringBuilder builder, String prefix, DvArm arm) {
        char c2;
        DvArm dvArm = arm;
        if (dvArm instanceof DvForestRootFolder) {
            c2 = 'R';
        } else if (dvArm instanceof DvNiceFolder) {
            c2 = 'F';
        } else if (dvArm instanceof DvBushRef) {
            c2 = 'B';
        } else {
            throw new NoWhenBranchMatchedException();
        }
        char c1 = c2;
        builder.append(prefix).append(c1).append(" - ").append(arm.toString()).append('\n');
        if (arm instanceof DvFolder) {
            String innerPrefix = prefix + "    ";
            for (DvNiceFolder f : ((DvFolder)arm).getInnerFolders()) {
                this.dumpArm(builder, innerPrefix, f);
            }
            Iterator<DvBushRef<?>> iterator = ((DvFolder)arm).getInnerBushRefList().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<DvArm> iterator2 = iterator;
            while (iterator2.hasNext()) {
                DvBushRef b = (DvBushRef)iterator2.next();
                Intrinsics.checkNotNull((Object)b);
                this.dumpArm(builder, innerPrefix, b);
            }
        }
    }

    @NotNull
    public String toString() {
        return this.dump();
    }

    private static final Iterable _init_$lambda$0(DvFolder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getInnerFolders();
    }

    private static final Iterable _init_$lambda$1(DvForest this$0, BasicNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SequencesKt.asIterable(this$0.treeVisibleChildrenOf(it));
    }

    private static final Iterable _init_$lambda$2(DvForest this$0, DvArm it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SequencesKt.asIterable(this$0.treeArmChildrenOf(it));
    }

    private static final int adjustOrderId$lambda$0(int $orderId, int curr) {
        return Math.max($orderId, curr);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\n\b\u0001\u0010\u0006\u0018\u0001*\u00020\u0007H\u0086\b\u00a8\u0006\b"}, d2={"Lcom/intellij/database/explorer/forest/DvForest$Companion;", "", "<init>", "()V", "createForest", "Lcom/intellij/database/explorer/forest/DvForest;", "B", "Lcom/intellij/database/model/basic/BasicUniqueBush;", "intellij.database.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final /* synthetic */ <B extends BasicUniqueBush> DvForest<B> createForest() {
            boolean $i$f$createForest = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"B");
            return new DvForest<BasicUniqueBush>(BasicUniqueBush.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

