/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.explorer.structure;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001dB\u001b\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\nJ\u0013\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017J\u001a\u0010\u0018\u001a\u00020\u00152\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00110\u001aJ\u0006\u0010\u001b\u001a\u00020\u0015J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/explorer/structure/CollectionCache;", "E", "", "gather", "Lkotlin/Function0;", "", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "content", "Ljava/util/concurrent/atomic/AtomicReference;", "", "value", "", "populationsCount", "getPopulationsCount", "()I", "ready", "", "getReady", "()Z", "include", "", "element", "(Ljava/lang/Object;)V", "exclude", "predicate", "Lkotlin/Function1;", "invalidate", "populate", "Companion", "intellij.database.core.impl"})
public final class CollectionCache<E> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<Iterable<E>> gather;
    @NotNull
    private final AtomicReference<Collection<E>> content;
    private transient int populationsCount;

    public CollectionCache(@NotNull Function0<? extends Iterable<? extends E>> gather) {
        Intrinsics.checkNotNullParameter(gather, (String)"gather");
        this.gather = gather;
        this.content = new AtomicReference<Object>(null);
    }

    public final int getPopulationsCount() {
        return this.populationsCount;
    }

    public final boolean getReady() {
        return this.content.get() != null;
    }

    @NotNull
    public final Collection<E> content() {
        Collection<E> theContent = this.content.get();
        if (theContent == null) {
            theContent = this.populate();
        }
        return theContent;
    }

    public final void include(E element) {
        this.content.updateAndGet(arg_0 -> CollectionCache.include$lambda$0(element, arg_0));
    }

    public final void exclude(E element) {
        this.content.updateAndGet(arg_0 -> CollectionCache.exclude$lambda$0(element, arg_0));
    }

    public final void exclude(@NotNull Function1<? super E, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        this.content.updateAndGet(arg_0 -> CollectionCache.exclude$lambda$1(predicate, arg_0));
    }

    public final void invalidate() {
        this.content.set(null);
    }

    private final Collection<E> populate() {
        List list = CollectionsKt.toList((Iterable)((Iterable)this.gather.invoke()));
        this.content.set(list);
        int n = this.populationsCount;
        this.populationsCount = n + 1;
        return list;
    }

    private static final Collection include$lambda$0(Object $element, Collection oldContent) {
        return Companion.includeElement(oldContent, $element);
    }

    private static final Collection exclude$lambda$0(Object $element, Collection oldContent) {
        return Companion.excludeElement(oldContent, $element);
    }

    private static final Collection exclude$lambda$1(Function1 $predicate, Collection oldContent) {
        return Companion.excludeElements(oldContent, $predicate);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0004\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\u0005\"\u0004\b\u0001\u0010\u00062\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\u00052\u0006\u0010\b\u001a\u0002H\u0006\u00a2\u0006\u0002\u0010\tJ1\u0010\n\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\u0005\"\u0004\b\u0001\u0010\u00062\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\u00052\u0006\u0010\b\u001a\u0002H\u0006\u00a2\u0006\u0002\u0010\tJ8\u0010\u000b\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\u0005\"\u0004\b\u0001\u0010\u00062\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\u00052\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u000e0\r\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/explorer/structure/CollectionCache$Companion;", "", "<init>", "()V", "includeElement", "", "E", "collection", "element", "(Ljava/util/Collection;Ljava/lang/Object;)Ljava/util/Collection;", "excludeElement", "excludeElements", "predicate", "Lkotlin/Function1;", "", "intellij.database.core.impl"})
    private static final class Companion {
        private Companion() {
        }

        @Nullable
        public final <E> Collection<E> includeElement(@Nullable Collection<? extends E> collection, E element) {
            if (collection == null) {
                return null;
            }
            if (collection.contains(element)) {
                return collection;
            }
            return collection.isEmpty() ? (Collection)Collections.singleton(element) : (Collection)CollectionsKt.plus(collection, element);
        }

        @Nullable
        public final <E> Collection<E> excludeElement(@Nullable Collection<? extends E> collection, E element) {
            if (collection == null || collection.isEmpty()) {
                return collection;
            }
            return collection.contains(element) ? (Collection)CollectionsKt.minus((Iterable)collection, element) : collection;
        }

        @Nullable
        public final <E> Collection<E> excludeElements(@Nullable Collection<? extends E> collection, @NotNull Function1<? super E, Boolean> predicate) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            if (collection == null || collection.isEmpty()) {
                return collection;
            }
            Set elementsToExclude = SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)collection), predicate));
            if (elementsToExclude.isEmpty()) {
                return collection;
            }
            List result = CollectionsKt.minus((Iterable)collection, (Iterable)elementsToExclude);
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

