/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.explorer.structure;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.DataSourcePerFileMappings;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.explorer.structure.DvExtraNode;
import com.intellij.database.explorer.structure.DvTreeIconItem;
import com.intellij.database.explorer.structure.DvTreeNodeRank;
import com.intellij.database.explorer.structure.DvTreeStoreyLayer;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.view.DataSourceNode;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002&'B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00192\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u00192\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00192\u0006\u0010\u001c\u001a\u00020\fH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0015\u0010\u001f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010 \u001a\u00020!H\u0016J\u001b\u0010\"\u001a\u00020!2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0$H\u0010\u00a2\u0006\u0002\b%R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/database/explorer/structure/DvTreeFilesLayer;", "Lcom/intellij/database/explorer/structure/DvTreeStoreyLayer;", "<init>", "()V", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "getName", "()Ljava/lang/String;", "qFolders", "Ljava/util/WeakHashMap;", "Lcom/intellij/database/view/DataSourceNode;", "Lcom/intellij/database/explorer/structure/DvTreeFilesLayer$QueryFolder;", "qFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/database/explorer/structure/DvTreeFilesLayer$QueryFile;", "getQueryFolder", "dsn", "getQueryFile", "vFolder", "vFile", "parentOf", "Lcom/intellij/database/model/basic/BasicNode;", "node", "childrenOf", "Lkotlin/sequences/Sequence;", "childrenOfDSN", "listFilesInFolder", "folder", "isAlwaysLeaf", "", "presentableNameOf", "clearAll", "", "onFileChanged", "virtualFiles", "", "onFileChanged$intellij_database_core_impl", "QueryFolder", "QueryFile", "intellij.database.core.impl"})
public final class DvTreeFilesLayer
extends DvTreeStoreyLayer {
    @NotNull
    private final WeakHashMap<DataSourceNode, QueryFolder> qFolders = new WeakHashMap();
    @NotNull
    private final WeakHashMap<VirtualFile, QueryFile> qFiles = new WeakHashMap();

    @Override
    @NotNull
    protected String getName() {
        return "Query Files";
    }

    private final QueryFolder getQueryFolder(DataSourceNode dsn) {
        QueryFolder folder = this.qFolders.get(dsn);
        if (folder == null) {
            folder = new QueryFolder(dsn);
            ((Map)this.qFolders).put(dsn, folder);
        }
        return folder;
    }

    private final QueryFile getQueryFile(QueryFolder vFolder, VirtualFile vFile) {
        QueryFile file = this.qFiles.get(vFile);
        if (file == null) {
            file = new QueryFile(vFolder, vFile, this.getContext().project);
            ((Map)this.qFiles).put(vFile, file);
        }
        return file;
    }

    @Override
    @Nullable
    public BasicNode parentOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        return basicNode instanceof QueryFolder ? (BasicNode)((QueryFolder)node).getDsn() : (basicNode instanceof QueryFile ? (BasicNode)((QueryFile)node).getFolder() : this.baseParentOf(node));
    }

    @Override
    @NotNull
    public Sequence<BasicNode> childrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        return basicNode instanceof DataSourceNode ? this.childrenOfDSN((DataSourceNode)node) : (basicNode instanceof QueryFolder ? this.listFilesInFolder((QueryFolder)node) : this.getBase().childrenOf(node));
    }

    private final Sequence<BasicNode> childrenOfDSN(DataSourceNode dsn) {
        Sequence children = this.getBase().childrenOf(dsn);
        if (!this.getContext().vo.getShowQueryFiles()) {
            return children;
        }
        if (dsn.dataSource instanceof LocalDataSource) {
            QueryFolder qFolder = this.getQueryFolder(dsn);
            children = SequencesKt.plus(children, (Object)qFolder);
        }
        return children;
    }

    private final Sequence<QueryFile> listFilesInFolder(QueryFolder folder) {
        Object object;
        Object object2 = folder.getDsn().getLocalDataSource();
        if (object2 == null || (object2 = ((AbstractDataSource)((Object)object2)).getUniqueId()) == null) {
            return SequencesKt.emptySequence();
        }
        Object dsId = object2;
        Object object3 = this;
        try {
            DvTreeFilesLayer $this$listFilesInFolder_u24lambda_u240 = object3;
            boolean bl = false;
            object = Result.constructor-impl((Object)((Object)DataSourcePerFileMappings.Companion.getInstance($this$listFilesInFolder_u24lambda_u240.getContext().project)));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object3 = object;
        DataSourcePerFileMappings dataSourcePerFileMappings = (DataSourcePerFileMappings)((Object)(Result.isFailure-impl((Object)object3) ? null : object3));
        if (dataSourcePerFileMappings == null) {
            return SequencesKt.emptySequence();
        }
        DataSourcePerFileMappings mapping = dataSourcePerFileMappings;
        Sequence vFiles = CollectionsKt.asSequence((Iterable)mapping.getAttachedFiles((String)dsId));
        return SequencesKt.map((Sequence)vFiles, arg_0 -> DvTreeFilesLayer.listFilesInFolder$lambda$1(this, folder, arg_0));
    }

    @Override
    public boolean isAlwaysLeaf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        return basicNode instanceof QueryFolder ? false : (basicNode instanceof QueryFile ? true : this.getBase().isAlwaysLeaf(node));
    }

    @Override
    @NotNull
    public String presentableNameOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.getBase().presentableNameOf(node);
    }

    @Override
    public void clearAll() {
        this.qFiles.clear();
        this.qFolders.clear();
    }

    @Override
    public void onFileChanged$intellij_database_core_impl(@NotNull Collection<? extends VirtualFile> virtualFiles) {
        Intrinsics.checkNotNullParameter(virtualFiles, (String)"virtualFiles");
        this.qFiles.keySet().removeAll(CollectionsKt.toSet((Iterable)virtualFiles));
    }

    private static final QueryFile listFilesInFolder$lambda$1(DvTreeFilesLayer this$0, QueryFolder $folder, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getQueryFile($folder, it);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010#\u001a\u0004\u0018\u00010$H\u0016J\r\u0010%\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013H\u0016J\b\u0010'\u001a\u00020\u001dH\u0016J\b\u0010(\u001a\u00020\u001dH\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001dH\u0016J\b\u0010,\u001a\u00020\u0012H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010&\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001e\u00a8\u0006-"}, d2={"Lcom/intellij/database/explorer/structure/DvTreeFilesLayer$QueryFile;", "Lcom/intellij/database/explorer/structure/DvExtraNode;", "Lcom/intellij/pom/Navigatable;", "folder", "Lcom/intellij/database/explorer/structure/DvTreeFilesLayer$QueryFolder;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/database/explorer/structure/DvTreeFilesLayer$QueryFolder;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)V", "getFolder", "()Lcom/intellij/database/explorer/structure/DvTreeFilesLayer$QueryFolder;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getProject", "()Lcom/intellij/openapi/project/Project;", "displayPath", "", "Lcom/intellij/openapi/util/NlsSafe;", "getDisplayPath", "()Ljava/lang/String;", "displayPath$delegate", "Lkotlin/Lazy;", "treeNodeRank", "Lcom/intellij/database/explorer/structure/DvTreeNodeRank;", "getTreeNodeRank", "()Lcom/intellij/database/explorer/structure/DvTreeNodeRank;", "isItselfMeaningful", "", "()Z", "iconItem", "Lcom/intellij/database/explorer/structure/DvTreeIconItem;", "getIconItem", "()Lcom/intellij/database/explorer/structure/DvTreeIconItem;", "getModel", "Lcom/intellij/database/model/basic/BasicModel;", "getDisplayName", "isAlwaysLeaf", "canNavigate", "canNavigateToSource", "navigate", "", "requestFocus", "getVirtualFileDisplayPath", "intellij.database.core.impl"})
    public static final class QueryFile
    implements DvExtraNode,
    Navigatable {
        @NotNull
        private final QueryFolder folder;
        @NotNull
        private final VirtualFile virtualFile;
        @NotNull
        private final Project project;
        @NotNull
        private final Lazy displayPath$delegate;

        public QueryFile(@NotNull QueryFolder folder, @NotNull VirtualFile virtualFile, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.folder = folder;
            this.virtualFile = virtualFile;
            this.project = project;
            this.displayPath$delegate = LazyKt.lazy(() -> QueryFile.displayPath_delegate$lambda$0(this));
        }

        @NotNull
        public final QueryFolder getFolder() {
            return this.folder;
        }

        @NotNull
        public final VirtualFile getVirtualFile() {
            return this.virtualFile;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final String getDisplayPath() {
            Lazy lazy = this.displayPath$delegate;
            return (String)lazy.getValue();
        }

        @Override
        @NotNull
        public DvTreeNodeRank getTreeNodeRank() {
            return DvTreeNodeRank.TL_EXTERNAL;
        }

        @Override
        public boolean isItselfMeaningful() {
            return true;
        }

        @Override
        @NotNull
        public DvTreeIconItem getIconItem() {
            return DvTreeIconItem.QUERY_FILE;
        }

        @Override
        @Nullable
        public BasicModel getModel() {
            return this.folder.getModel();
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = this.virtualFile.getPresentableName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableName(...)");
            return string;
        }

        @Override
        public boolean isAlwaysLeaf() {
            return true;
        }

        public boolean canNavigate() {
            return true;
        }

        public boolean canNavigateToSource() {
            return true;
        }

        public void navigate(boolean requestFocus) {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
            if (this.virtualFile.isValid()) {
                fileEditorManager.openFile(this.virtualFile, requestFocus);
            }
        }

        private final String getVirtualFileDisplayPath() {
            if (ScratchUtil.isScratch((VirtualFile)this.virtualFile)) {
                RootType rootType = RootType.forFile((VirtualFile)this.virtualFile);
                if (rootType == null) {
                    String string = this.virtualFile.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    return string;
                }
                RootType root = rootType;
                String string = ScratchFileService.getInstance().getRootPath(root);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRootPath(...)");
                String rootPath = string;
                String string2 = this.virtualFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                return StringsKt.replace$default((String)string2, (String)rootPath, (String)"../scratches", (boolean)false, (int)4, null);
            }
            String string = this.project.getBasePath();
            if (string == null) {
                String string3 = this.virtualFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                return string3;
            }
            String basePath = string;
            String string4 = this.virtualFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
            return StringsKt.replace$default((String)string4, (String)basePath, (String)"..", (boolean)false, (int)4, null);
        }

        private static final String displayPath_delegate$lambda$0(QueryFile this$0) {
            return this$0.getVirtualFileDisplayPath();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\r\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0018\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/explorer/structure/DvTreeFilesLayer$QueryFolder;", "Lcom/intellij/database/explorer/structure/DvExtraNode;", "dsn", "Lcom/intellij/database/view/DataSourceNode;", "<init>", "(Lcom/intellij/database/view/DataSourceNode;)V", "getDsn", "()Lcom/intellij/database/view/DataSourceNode;", "treeNodeRank", "Lcom/intellij/database/explorer/structure/DvTreeNodeRank;", "getTreeNodeRank", "()Lcom/intellij/database/explorer/structure/DvTreeNodeRank;", "isItselfMeaningful", "", "()Z", "iconItem", "Lcom/intellij/database/explorer/structure/DvTreeIconItem;", "getIconItem", "()Lcom/intellij/database/explorer/structure/DvTreeIconItem;", "getModel", "Lcom/intellij/database/model/basic/BasicModel;", "getDisplayName", "", "Lorg/jetbrains/annotations/Nls;", "showCount", "getShowCount", "intellij.database.core.impl"})
    public static final class QueryFolder
    implements DvExtraNode {
        @NotNull
        private final DataSourceNode dsn;
        private final boolean showCount;

        public QueryFolder(@NotNull DataSourceNode dsn) {
            Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
            this.dsn = dsn;
            this.showCount = true;
        }

        @NotNull
        public final DataSourceNode getDsn() {
            return this.dsn;
        }

        @Override
        @NotNull
        public DvTreeNodeRank getTreeNodeRank() {
            return DvTreeNodeRank.TL_SYNTHETIC;
        }

        @Override
        public boolean isItselfMeaningful() {
            return false;
        }

        @Override
        @NotNull
        public DvTreeIconItem getIconItem() {
            return DvTreeIconItem.QUERY_FOLDER;
        }

        @Override
        @Nullable
        public BasicModel getModel() {
            return this.dsn.getModel();
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = DatabaseBundle.message((String)"database.view.layers.files.folder.name", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Override
        public boolean getShowCount() {
            return this.showCount;
        }
    }
}

