/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabasePluginId;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.BlackHoleTextStorage;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataSourceSnapshotManager;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDataObject;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicHierarchicalObject;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.serialization.ModelImporter;
import com.intellij.database.psi.ModelNameIndex;
import com.intellij.database.script.SqlModelBuilderUtils;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.Version;
import com.intellij.ide.PlatformIdeService;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.EDT;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.XppReader;
import io.github.xstream.mxparser.MXParser;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.xmlpull.v1.XmlPullParser;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 <2\u00020\u0001:\u0003:;<B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J,\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#\u0018\u00010!2\u0006\u0010\u001d\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&J.\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#\u0018\u00010!2\u0006\u0010\u001d\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010(\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001a\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u001d\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J \u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020-2\u0006\u0010%\u001a\u00020&J(\u0010.\u001a\u0004\u0018\u00010\u00012\u0006\u0010/\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020-2\u0006\u0010+\u001a\u00020\nH\u0082@\u00a2\u0006\u0002\u00100J\u0018\u00101\u001a\u0004\u0018\u0001022\u0006\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020-J\u001e\u00103\u001a\u00020&2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020&2\u0006\u0010%\u001a\u00020&J\u0018\u00107\u001a\u0004\u0018\u00010#2\u0006\u00104\u001a\u0002052\u0006\u0010%\u001a\u00020&J,\u00108\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020-09\u0012\u0004\u0012\u00020*\u0018\u00010!2\u0006\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020-H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/intellij/database/model/DataSourceSnapshotManager;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCs", "()Lkotlinx/coroutines/CoroutineScope;", "myModels", "", "Lcom/intellij/database/Dbms;", "Lcom/intellij/database/model/DataSourceSnapshotManager$ModelsForDbms;", "myHiddenNamespacesCache", "", "Lcom/intellij/database/model/basic/BasicHierarchicalObject;", "Lcom/intellij/database/model/DataSourceSnapshotManager$BasicSnippet;", "apply", "", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "clearOrReviveNamespacesLater", "model", "Lcom/intellij/database/model/basic/BasicModModel;", "scope", "Lcom/intellij/database/util/TreePattern;", "clearOrReviveNamespaces", "merge", "e", "mapping", "Lcom/intellij/database/dataSource/DataSourceSchemaMapping;", "map", "Lcom/intellij/openapi/util/Pair;", "", "Lcom/intellij/database/util/ObjectPath;", "Lcom/intellij/database/model/basic/BasicElement;", "load", "", "mapAuto", "isAutoMappedWildCard", "getSnapshotModel", "Lcom/intellij/database/model/basic/BasicModel;", "dbms", "version", "Lcom/intellij/database/util/Version;", "loadModelLocked", "models", "(Lcom/intellij/database/model/DataSourceSnapshotManager$ModelsForDbms;Lcom/intellij/database/util/Version;Lcom/intellij/database/Dbms;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getSnapshotModelIndex", "Lcom/intellij/database/psi/ModelNameIndex;", "canSubstitute", "nsp", "Lcom/intellij/database/model/basic/BasicNamespace;", "ignoreWildcard", "getBasePath", "loadModel", "Lcom/intellij/openapi/util/Couple;", "ModelsForDbms", "BasicSnippet", "Companion", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDataSourceSnapshotManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceSnapshotManager.kt\ncom/intellij/database/model/DataSourceSnapshotManager\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,476:1\n116#2,10:477\n1#3:487\n23#4:488\n1915#5,2:489\n*S KotlinDebug\n*F\n+ 1 DataSourceSnapshotManager.kt\ncom/intellij/database/model/DataSourceSnapshotManager\n*L\n223#1:477,10\n268#1:488\n105#1:489,2\n*E\n"})
public final class DataSourceSnapshotManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final Map<Dbms, ModelsForDbms> myModels;
    @NotNull
    private final Map<BasicHierarchicalObject, BasicSnippet> myHiddenNamespacesCache;
    @JvmField
    public static final boolean IGNORE_AUTO_MINI_CAT = !Registry.Companion.is("database.snapshots.auto");
    private static boolean ourEmptyMiniCat;
    @JvmField
    @NotNull
    public static final ModelTextStorage MINICAT_STORAGE;

    public DataSourceSnapshotManager(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.create(arg_0 -> DataSourceSnapshotManager.myModels$lambda$1(DataSourceSnapshotManager::myModels$lambda$0, arg_0), DataSourceSnapshotManager::myModels$lambda$2);
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"create(...)");
        this.myModels = concurrentMap;
        ConcurrentMap concurrentMap2 = CollectionFactory.createConcurrentWeakKeySoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap2, (String)"createConcurrentWeakKeySoftValueMap(...)");
        this.myHiddenNamespacesCache = concurrentMap2;
    }

    @NotNull
    public final CoroutineScope getCs() {
        return this.cs;
    }

    public final void apply(@Nullable Project project, @NotNull LocalDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        DasModel dasModel = dataSource.getModel();
        BaseModel baseModel = dasModel instanceof BaseModel ? (BaseModel)dasModel : null;
        if (baseModel == null) {
            return;
        }
        BaseModel model = baseModel;
        DataSourceSchemaMapping dataSourceSchemaMapping = dataSource.getSchemaMapping();
        Intrinsics.checkNotNullExpressionValue((Object)dataSourceSchemaMapping, (String)"getSchemaMapping(...)");
        DataSourceSchemaMapping mapping = dataSourceSchemaMapping;
        DbImplUtilCore.performSrcOperation(null, model, ModalityState.defaultModalityState(), true, () -> DataSourceSnapshotManager.apply$lambda$0(model, dataSource, project, this, mapping));
    }

    public final void clearOrReviveNamespacesLater(@NotNull BasicModModel model, @NotNull TreePattern scope) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        if (ApplicationManager.getApplication().isDispatchThread()) {
            Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> DataSourceSnapshotManager.clearOrReviveNamespacesLater$lambda$0(this, model, scope));
            Intrinsics.checkNotNull((Object)future);
        } else {
            this.clearOrReviveNamespaces(model, scope);
        }
    }

    public final void clearOrReviveNamespaces(@NotNull BasicModModel model, @NotNull TreePattern scope) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        ((BaseModel)model).modify((BasicElement)((BaseModel)model).getRoot(), BasicModRoot.class, true, new ModelModifier(model, scope, this){
            final /* synthetic */ BasicModModel $model;
            final /* synthetic */ TreePattern $scope;
            final /* synthetic */ DataSourceSnapshotManager this$0;
            {
                this.$model = $model;
                this.$scope = $scope;
                this.this$0 = $receiver;
            }

            public final void perform(BasicModRoot it) {
                for (BasicMateNamespace nsp : ((JBTreeTraverser)this.$model.traverser().expandAndFilter(arg_0 -> clearOrReviveNamespaces.1.perform$lambda$1(clearOrReviveNamespaces.1::perform$lambda$0, arg_0))).bfsTraversal().filter(BasicMateNamespace.class)) {
                    if (!(nsp instanceof BasicHierarchicalObject) || nsp.isSubstituted()) continue;
                    boolean introspected = DataSourceSchemaMapping.isIntrospected(this.$scope, nsp);
                    if (introspected) {
                        BasicSnippet snippet = (BasicSnippet)DataSourceSnapshotManager.access$getMyHiddenNamespacesCache$p(this.this$0).remove(nsp);
                        if (snippet == null || ((BasicMixinElement)nsp).hasChildren()) continue;
                        snippet.recover((BasicHierarchicalObject)((Object)nsp));
                        continue;
                    }
                    if (!((BasicMixinElement)nsp).hasChildren()) continue;
                    DataSourceSnapshotManager.access$getMyHiddenNamespacesCache$p(this.this$0).put(nsp, BasicSnippet.Companion.build((BasicHierarchicalObject)((Object)nsp), DataSourceSnapshotManager.access$getMyHiddenNamespacesCache$p(this.this$0)));
                    ((BaseModel)this.$model).preserveSources(() -> clearOrReviveNamespaces.1.perform$lambda$2(nsp));
                }
            }

            private static final boolean perform$lambda$0(DasObject it) {
                return it instanceof BasicModNamespace;
            }

            private static final boolean perform$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final void perform$lambda$2(BasicMateNamespace $nsp) {
                for (ModFamily modFamily : ((BasicModElement)((Object)$nsp)).getFamilies()) {
                    if (modFamily.getMetaObject().kindOf(BasicMateNamespace.class)) continue;
                    modFamily.clear();
                }
            }
        });
    }

    private final void merge(BasicHierarchicalObject e, DataSourceSchemaMapping mapping) {
        BasicModel miniMod;
        Pair<String, ObjectPath> map = this.map(e, mapping, true);
        BasicModel basicModel = miniMod = map == null ? null : this.getSnapshotModel(e, true);
        if (miniMod == null) {
            if (e instanceof BasicModMateNamespace) {
                ((BasicModNamespace)((Object)e)).setSubstituted(false);
            }
            return;
        }
        DasModel dasModel = miniMod;
        Pair<String, ObjectPath> pair = map;
        Intrinsics.checkNotNull(pair);
        JBIterable<DasObject> jBIterable = QNameUtil.findByPath(dasModel, (ObjectPath)pair.second);
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"findByPath(...)");
        JBIterable<DasObject> objs = jBIterable;
        for (BasicHierarchicalObject target : objs.filter(BasicHierarchicalObject.class)) {
            DataSourceSnapshotManager.Companion.merge(e, target, true);
        }
    }

    @Nullable
    public final Pair<String, ObjectPath> map(@NotNull BasicElement e, @NotNull DataSourceSchemaMapping mapping, boolean load) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        ObjectPath path = BasicPaths.of(e);
        if (mapping.isIntrospected(e)) {
            return null;
        }
        Pair<String, ObjectPath> map = mapping.map(path);
        if (map != null) {
            return map;
        }
        if (IGNORE_AUTO_MINI_CAT || !mapping.isUseMiniCat()) {
            return null;
        }
        return this.mapAuto(e, mapping, load);
    }

    private final Pair<String, ObjectPath> mapAuto(BasicElement e, DataSourceSchemaMapping mapping, boolean load) {
        BasicDatabase db;
        ObjectPath basePath;
        BasicNamespace nsp;
        if (e.getKind() != ObjectKind.SCHEMA && e.getKind() != ObjectKind.DATABASE) {
            return null;
        }
        BasicNamespace basicNamespace = nsp = e instanceof BasicNamespace ? (BasicNamespace)e : null;
        ObjectPath objectPath = basePath = basicNamespace == null ? null : this.getBasePath(basicNamespace, load);
        if (basePath == null) {
            return null;
        }
        ObjectPath dbPath = basePath.findParent(ObjectKind.DATABASE, false);
        if (dbPath != null && StringUtil.isEmpty((String)dbPath.name) && (db = e.getDatabase()) != null && !mapping.isIntrospected(db)) {
            return null;
        }
        return Pair.create((Object)"minicat", (Object)basePath);
    }

    private final boolean isAutoMappedWildCard(BasicElement e, DataSourceSchemaMapping mapping) {
        if (IGNORE_AUTO_MINI_CAT || !mapping.isUseMiniCat()) {
            return false;
        }
        ObjectPath path = BasicPaths.of(e);
        if (mapping.isIntrospected(e)) {
            return false;
        }
        Pair<String, ObjectPath> map = mapping.map(path);
        if (map != null) {
            return false;
        }
        map = this.mapAuto(e, mapping, true);
        if (map == null) {
            return false;
        }
        ObjectPath db = ((ObjectPath)map.second).findParent(ObjectKind.DATABASE, false);
        return db != null && StringUtil.isEmpty((String)db.name);
    }

    private final BasicModel getSnapshotModel(BasicElement e, boolean load) {
        Dbms dbms = e.getMetaObject().getModel().getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        BasicModel model = e.getModel();
        Object object = model;
        if (object == null || (object = object.getRoot()) == null || (object = object.getServerVersion()) == null) {
            object = Version.INFINITY;
        }
        Object version = object;
        Intrinsics.checkNotNull((Object)version);
        return this.getSnapshotModel(dbms2, (Version)version, load);
    }

    @Nullable
    public final BasicModel getSnapshotModel(@NotNull Dbms dbms, @NotNull Version version, boolean load) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (ourEmptyMiniCat) {
            return null;
        }
        ModelsForDbms modelsForDbms = this.myModels.get(dbms);
        Intrinsics.checkNotNull((Object)modelsForDbms);
        ModelsForDbms models2 = modelsForDbms;
        Object res = DataSourceSnapshotManager.Companion.findModel(models2.getModels(), version);
        if (res == null) {
            if (load && !EDT.isCurrentThreadEdt()) {
                res = CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Object>, Object>(this, models2, version, dbms, null){
                    int label;
                    final /* synthetic */ DataSourceSnapshotManager this$0;
                    final /* synthetic */ ModelsForDbms $models;
                    final /* synthetic */ Version $version;
                    final /* synthetic */ Dbms $dbms;
                    {
                        this.this$0 = $receiver;
                        this.$models = $models;
                        this.$version = $version;
                        this.$dbms = $dbms;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = DataSourceSnapshotManager.access$loadModelLocked(this.this$0, this.$models, this.$version, this.$dbms, (Continuation)this);
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<Object> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            } else if (!models2.getMutex().isLocked()) {
                BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, models2, version, dbms, null){
                    int label;
                    final /* synthetic */ DataSourceSnapshotManager this$0;
                    final /* synthetic */ ModelsForDbms $models;
                    final /* synthetic */ Version $version;
                    final /* synthetic */ Dbms $dbms;
                    {
                        this.this$0 = $receiver;
                        this.$models = $models;
                        this.$version = $version;
                        this.$dbms = $dbms;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = DataSourceSnapshotManager.access$loadModelLocked(this.this$0, this.$models, this.$version, this.$dbms, (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }
        return res == ObjectUtils.NULL ? null : (BasicModel)res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object loadModelLocked(ModelsForDbms models, Version version, Dbms dbms, Continuation<Object> $completion) {
        if (!($completion instanceof loadModelLocked.1)) ** GOTO lbl-1000
        var17_5 = $completion;
        if ((var17_5.label & -2147483648) != 0) {
            var17_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ DataSourceSnapshotManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DataSourceSnapshotManager.access$loadModelLocked(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var18_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = models.getMutex();
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = models;
                $continuation.L$1 = version;
                $continuation.L$2 = dbms;
                $continuation.L$3 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var18_7) {
                    return var18_7;
                }
                ** GOTO lbl35
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$3;
                dbms = (Dbms)$continuation.L$2;
                version = (Version)$continuation.L$1;
                models = (ModelsForDbms)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl35:
                // 3 sources

                $i$a$-withLock$default-DataSourceSnapshotManager$loadModelLocked$2 = 0;
                v1 = com.intellij.database.model.DataSourceSnapshotManager$Companion.access$findModel(DataSourceSnapshotManager.Companion, models.getModels(), version);
                if (v1 == null) ** GOTO lbl45
                it = v1;
                $i$a$-let-DataSourceSnapshotManager$loadModelLocked$2$1 = false;
                var15_16 = it;
                $this$withLock_u24default$iv.unlock(owner$iv);
                return var15_16;
lbl45:
                // 2 sources

                $continuation.L$0 = models;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)version);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)dbms);
                $continuation.L$3 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.I$1 = $i$a$-withLock$default-DataSourceSnapshotManager$loadModelLocked$2;
                $continuation.label = 2;
                v2 = CoroutinesKt.coroutineToIndicator((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, loadModelLocked$lambda$0$1(com.intellij.database.model.DataSourceSnapshotManager com.intellij.database.Dbms com.intellij.database.util.Version com.intellij.openapi.progress.ProgressIndicator ), (Lcom/intellij/openapi/progress/ProgressIndicator;)Lcom/intellij/openapi/util/Pair;)((DataSourceSnapshotManager)this, (Dbms)dbms, (Version)version), (Continuation)$continuation);
                ** if (v2 != var18_7) goto lbl55
lbl54:
                // 1 sources

                return var18_7;
lbl55:
                // 1 sources

                ** GOTO lbl68
            }
            case 2: {
                $i$a$-withLock$default-DataSourceSnapshotManager$loadModelLocked$2 = $continuation.I$1;
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$3;
                dbms = (Dbms)$continuation.L$2;
                version = (Version)$continuation.L$1;
                models = (ModelsForDbms)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl68:
                // 2 sources

                if ((loaded = (Pair)v2) == null) {
                    models.getModels().put((Couple<Version>)Couple.of((Object)Version.ZERO, (Object)Version.INFINITY), ObjectUtils.NULL);
                    var14_18 = null;
                    return var14_18;
                }
                models.getModels().put((Couple<Version>)loaded.first, loaded.second);
                var13_19 = loaded.second;
                return var13_19;
            }
            catch (Throwable var12_20) {
                throw var12_20;
            }
            {
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final ModelNameIndex getSnapshotModelIndex(@NotNull Dbms dbms, @NotNull Version version) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        BasicModel model = this.getSnapshotModel(dbms, version, true);
        return model instanceof BaseModel ? ((BaseModel)model).getNameIndex() : null;
    }

    public final boolean canSubstitute(@NotNull BasicNamespace nsp, boolean ignoreWildcard, boolean load) {
        Intrinsics.checkNotNullParameter((Object)nsp, (String)"nsp");
        BasicModel snap = this.getSnapshotModel(nsp, load);
        if (snap == null) {
            return false;
        }
        BasicHierarchicalObject basicHierarchicalObject = (BasicHierarchicalObject)((Object)nsp);
        BasicRoot basicRoot = snap.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)basicRoot, (String)"getRoot(...)");
        JBIterable targets = DataSourceSnapshotManager.Companion.getTargets(basicHierarchicalObject, basicRoot);
        if (ignoreWildcard) {
            JBIterable jBIterable = targets.filter(arg_0 -> DataSourceSnapshotManager.canSubstitute$lambda$1(DataSourceSnapshotManager::canSubstitute$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            targets = jBIterable;
        }
        return targets.isNotEmpty();
    }

    @Nullable
    public final ObjectPath getBasePath(@NotNull BasicNamespace nsp, boolean load) {
        Intrinsics.checkNotNullParameter((Object)nsp, (String)"nsp");
        BasicModel snap = this.getSnapshotModel(nsp, load);
        if (snap == null) {
            return null;
        }
        BasicHierarchicalObject basicHierarchicalObject = (BasicHierarchicalObject)((Object)nsp);
        BasicRoot basicRoot = snap.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)basicRoot, (String)"getRoot(...)");
        BasicElement tgt = (BasicElement)DataSourceSnapshotManager.Companion.getTargets(basicHierarchicalObject, basicRoot).first();
        return tgt == null ? null : (ObjectPath)BasicPaths.of(tgt).reduce(null, DataSourceSnapshotManager::getBasePath$lambda$0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<Couple<Version>, BasicModel> loadModel(Dbms dbms, Version version) {
        try {
            Pair<Couple<Version>, BasicModel> pair;
            InputStream inputStream = Companion.getMiniCatStream(dbms);
            if (inputStream != null) {
                Closeable closeable = inputStream;
                Throwable throwable = null;
                try {
                    Pair<Couple<Version>, BasicModel> it = (Pair<Couple<Version>, BasicModel>)closeable;
                    boolean bl = false;
                    it = Companion.loadModel(dbms, version, (InputStream)it);
                    pair = it;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                pair = null;
            }
            return pair;
        }
        catch (IOException e) {
            DataSourceSnapshotManager $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(DataSourceSnapshotManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn((Throwable)e);
            return null;
        }
    }

    private static final ModelsForDbms myModels$lambda$0(Dbms it) {
        return new ModelsForDbms();
    }

    private static final ModelsForDbms myModels$lambda$1(Function1 $tmp0, Object p0) {
        return (ModelsForDbms)$tmp0.invoke(p0);
    }

    private static final ConcurrentMap myModels$lambda$2() {
        return ContainerUtil.createConcurrentSoftValueMap();
    }

    private static final Iterable apply$lambda$0$0$0(BasicElement obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return (Iterable)obj.getChildren();
    }

    private static final Iterable apply$lambda$0$0$1(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final boolean apply$lambda$0$0$2(BasicElement o) {
        return o instanceof BasicNamespace || o instanceof BasicRoot;
    }

    private static final boolean apply$lambda$0$0$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean apply$lambda$0$0$4(DataSourceSnapshotManager this$0, DataSourceSchemaMapping $mapping, BasicElement e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return this$0.isAutoMappedWildCard(e, $mapping);
    }

    private static final boolean apply$lambda$0$0$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final BasicDatabase apply$lambda$0$0$6(BasicElement e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getDatabase();
    }

    private static final BasicDatabase apply$lambda$0$0$7(Function1 $tmp0, Object p0) {
        return (BasicDatabase)$tmp0.invoke(p0);
    }

    private static final Iterable apply$lambda$0$0$8(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final boolean apply$lambda$0$0$9(BasicElement it) {
        return it instanceof BasicNamespace || it instanceof BasicRoot;
    }

    private static final boolean apply$lambda$0$0$10(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final void apply$lambda$0$0(LocalDataSource $dataSource, Project $project, DataSourceSnapshotManager this$0, DataSourceSchemaMapping $mapping, BasicModRoot r) {
        void $this$forEach$iv;
        int autoMappedWildcards = ((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(arg_0 -> DataSourceSnapshotManager.apply$lambda$0$0$1(DataSourceSnapshotManager::apply$lambda$0$0$0, arg_0)).withRoot((Object)r)).expandAndFilter(arg_0 -> DataSourceSnapshotManager.apply$lambda$0$0$3(DataSourceSnapshotManager::apply$lambda$0$0$2, arg_0))).traverse().filter(arg_0 -> DataSourceSnapshotManager.apply$lambda$0$0$5(arg_0 -> DataSourceSnapshotManager.apply$lambda$0$0$4(this$0, $mapping, arg_0), arg_0)).filterMap(arg_0 -> DataSourceSnapshotManager.apply$lambda$0$0$7(DataSourceSnapshotManager::apply$lambda$0$0$6, arg_0)).unique().size();
        if (autoMappedWildcards > 10) {
            $dataSource.getSchemaMapping().setUseMiniCat(false);
            PlatformIdeService.getInstance().notification("Database view", PlatformIdeService.NotificationType.INFORMATION, DatabaseBundle.message((String)"notification.title.too.many.pre.introspected.objects.are.used", (Object[])new Object[0]), $dataSource.getName(), DatabaseBundle.message((String)"notification.content.to.improve.performance.automatic.usage.pre.introspected.objects.disabled.you.can.select.necessary.schemas.manually", (Object[])new Object[0]), $project, "DataSourceSnapshotManager.too.many.wildcards");
        }
        Object object = ((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(arg_0 -> DataSourceSnapshotManager.apply$lambda$0$0$8(apply.1.1.1.INSTANCE, arg_0)).withRoot((Object)r)).expandAndFilter(arg_0 -> DataSourceSnapshotManager.apply$lambda$0$0$10(DataSourceSnapshotManager::apply$lambda$0$0$9, arg_0))).filter(BasicHierarchicalObject.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"filter(...)");
        object = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BasicHierarchicalObject it = (BasicHierarchicalObject)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this$0.merge(it, $mapping);
        }
    }

    private static final void apply$lambda$0(BaseModel $model, LocalDataSource $dataSource, Project $project, DataSourceSnapshotManager this$0, DataSourceSchemaMapping $mapping) {
        $model.modify((BasicElement)$model.getRoot(), BasicModRoot.class, true, arg_0 -> DataSourceSnapshotManager.apply$lambda$0$0($dataSource, $project, this$0, $mapping, arg_0));
    }

    private static final void clearOrReviveNamespacesLater$lambda$0(DataSourceSnapshotManager this$0, BasicModModel $model, TreePattern $scope) {
        this$0.clearOrReviveNamespaces($model, $scope);
    }

    private static final Pair loadModelLocked$lambda$0$1(DataSourceSnapshotManager this$0, Dbms $dbms, Version $version, ProgressIndicator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.loadModel($dbms, $version);
    }

    private static final boolean canSubstitute$lambda$0(BasicElement o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        String string = o.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return !(((CharSequence)string).length() == 0);
    }

    private static final boolean canSubstitute$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final ObjectPath getBasePath$lambda$0(ObjectPath parent, ObjectPath cur) {
        Intrinsics.checkNotNullParameter((Object)cur, (String)"cur");
        return cur.getIdentity() == null && parent == cur.parent ? cur : ObjectPath.create((String)cur.name, (ObjectKind)cur.kind, (boolean)cur.isQuoted(), null, (ObjectPath)parent);
    }

    @JvmStatic
    @TestOnly
    public static final void setEmptyMiniCat(@NotNull Disposable p) {
        Companion.setEmptyMiniCat(p);
    }

    @JvmStatic
    @NotNull
    public static final DataSourceSnapshotManager getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ Map access$getMyHiddenNamespacesCache$p(DataSourceSnapshotManager $this) {
        return $this.myHiddenNamespacesCache;
    }

    public static final /* synthetic */ Object access$loadModelLocked(DataSourceSnapshotManager $this, ModelsForDbms models2, Version version, Dbms dbms, Continuation $completion) {
        return $this.loadModelLocked(models2, version, dbms, (Continuation<Object>)$completion);
    }

    static {
        MINICAT_STORAGE = BlackHoleTextStorage.INSTANCE.unique();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0002R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006$"}, d2={"Lcom/intellij/database/model/DataSourceSnapshotManager$BasicSnippet;", "", "<init>", "()V", "path", "Lcom/intellij/database/util/ObjectPath;", "getPath", "()Lcom/intellij/database/util/ObjectPath;", "setPath", "(Lcom/intellij/database/util/ObjectPath;)V", "root", "Lcom/intellij/database/model/basic/BasicDataObject;", "getRoot", "()Lcom/intellij/database/model/basic/BasicDataObject;", "setRoot", "(Lcom/intellij/database/model/basic/BasicDataObject;)V", "nodes", "", "getNodes", "()Ljava/util/List;", "setNodes", "(Ljava/util/List;)V", "children", "Lit/unimi/dsi/fastutil/ints/IntList;", "getChildren", "()Lit/unimi/dsi/fastutil/ints/IntList;", "setChildren", "(Lit/unimi/dsi/fastutil/ints/IntList;)V", "recover", "", "to", "Lcom/intellij/database/model/basic/BasicHierarchicalObject;", "ni", "", "ci", "Companion", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nDataSourceSnapshotManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceSnapshotManager.kt\ncom/intellij/database/model/DataSourceSnapshotManager$BasicSnippet\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,476:1\n1915#2,2:477\n1915#2,2:479\n*S KotlinDebug\n*F\n+ 1 DataSourceSnapshotManager.kt\ncom/intellij/database/model/DataSourceSnapshotManager$BasicSnippet\n*L\n284#1:477,2\n295#1:479,2\n*E\n"})
    public static final class BasicSnippet {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private ObjectPath path;
        @Nullable
        private BasicDataObject root;
        @NotNull
        private List<BasicDataObject> nodes = new ArrayList();
        @NotNull
        private IntList children = (IntList)new IntArrayList();

        @Nullable
        public final ObjectPath getPath() {
            return this.path;
        }

        public final void setPath(@Nullable ObjectPath objectPath) {
            this.path = objectPath;
        }

        @Nullable
        public final BasicDataObject getRoot() {
            return this.root;
        }

        public final void setRoot(@Nullable BasicDataObject basicDataObject) {
            this.root = basicDataObject;
        }

        @NotNull
        public final List<BasicDataObject> getNodes() {
            return this.nodes;
        }

        public final void setNodes(@NotNull List<BasicDataObject> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.nodes = list;
        }

        @NotNull
        public final IntList getChildren() {
            return this.children;
        }

        public final void setChildren(@NotNull IntList intList) {
            Intrinsics.checkNotNullParameter((Object)intList, (String)"<set-?>");
            this.children = intList;
        }

        public final void recover(@NotNull BasicHierarchicalObject to) {
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            int[] nArray = new int[]{0};
            int[] nArray2 = nArray;
            nArray = new int[]{0};
            this.recover(to, nArray2, nArray);
        }

        private final void recover(BasicHierarchicalObject to, int[] ni, int[] ci) {
            List<? extends Family<? extends BasicElement>> list = to.getFamilies();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getFamilies(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ModFamily obj = (ModFamily)element$iv;
                boolean bl = false;
                obj.markChildrenAsSyncPending();
            }
            int b = ni[0];
            int c2 = this.children.getInt(ci[0]);
            ni[0] = b + c2;
            ci[0] = ci[0] + 1;
            int cfr_ignored_0 = ci[0];
            for (int i2 = 0; i2 < c2; ++i2) {
                BasicDataObject e = this.nodes.get(b + i2);
                Family<? extends BasicElement> family = to.familyOf(e.getKind());
                Intrinsics.checkNotNull(family);
                ModFamily<BasicHierarchicalObject> family2 = ((ModFamily)family).asHierarchical();
                Intrinsics.checkNotNull(family2);
                BasicHierarchicalObject h = BasicSnippet.Companion.getOrCreate(family2, e);
                this.recover(h, ni, ci);
            }
            List<? extends Family<? extends BasicElement>> list2 = to.getFamilies();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getFamilies(...)");
            Iterable $this$forEach$iv2 = list2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                ModFamily obj = (ModFamily)element$iv;
                boolean bl = false;
                obj.removeSyncPendingChildren();
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\tJ,\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00052\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\tH\u0002J \u0010\r\u001a\u00020\u00072\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/model/DataSourceSnapshotManager$BasicSnippet$Companion;", "", "<init>", "()V", "build", "Lcom/intellij/database/model/DataSourceSnapshotManager$BasicSnippet;", "r", "Lcom/intellij/database/model/basic/BasicHierarchicalObject;", "subSnippets", "", "layout", "", "snippet", "getOrCreate", "family", "Lcom/intellij/database/model/families/ModFamily;", "e", "Lcom/intellij/database/model/basic/BasicDataObject;", "intellij.database.core.impl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BasicSnippet build(@NotNull BasicHierarchicalObject r, @NotNull Map<BasicHierarchicalObject, BasicSnippet> subSnippets) {
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                Intrinsics.checkNotNullParameter(subSnippets, (String)"subSnippets");
                BasicSnippet snippet = new BasicSnippet();
                snippet.setRoot(r.frozenData());
                snippet.setPath(BasicPaths.of(r));
                this.layout(r, snippet, subSnippets);
                return snippet;
            }

            private final void layout(BasicHierarchicalObject r, BasicSnippet snippet, Map<BasicHierarchicalObject, BasicSnippet> subSnippets) {
                if (!r.hasChildren()) {
                    BasicSnippet sub = subSnippets.remove(r);
                    if (sub != null) {
                        snippet.getNodes().addAll((Collection<BasicDataObject>)sub.getNodes());
                        v0 = snippet.getChildren().addAll(sub.getChildren());
                    } else {
                        v0 = snippet.getChildren().add(0);
                    }
                } else {
                    int b = snippet.getNodes().size();
                    JBIterable jBIterable = r.getChildren().filter(BasicHierarchicalObject.class);
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                    JBIterable children = jBIterable;
                    for (BasicHierarchicalObject child : children) {
                        List<BasicDataObject> list = snippet.getNodes();
                        BasicDataObject basicDataObject = child.frozenData();
                        Intrinsics.checkNotNullExpressionValue((Object)basicDataObject, (String)"frozenData(...)");
                        list.add(basicDataObject);
                    }
                    snippet.getChildren().add(snippet.getNodes().size() - b);
                    for (BasicHierarchicalObject e : children) {
                        Intrinsics.checkNotNull((Object)e);
                        this.layout(e, snippet, subSnippets);
                    }
                }
            }

            private final BasicHierarchicalObject getOrCreate(ModFamily<? extends BasicHierarchicalObject> family, BasicDataObject e) {
                BasicHierarchicalObject h = (BasicHierarchicalObject)family.find(arg_0 -> Companion.getOrCreate$lambda$1(arg_0 -> Companion.getOrCreate$lambda$0(e, arg_0), arg_0));
                if (h == null) {
                    h = family.createNewOne(e);
                } else {
                    h.resetSyncPending();
                }
                return h;
            }

            private static final boolean getOrCreate$lambda$0(BasicDataObject $e, BasicHierarchicalObject o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                return o.hasData($e);
            }

            private static final boolean getOrCreate$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J$\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0016\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fJ(\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u00142\u0006\u0010\r\u001a\u00020\f2\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0014H\u0002J \u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J \u0010\u0019\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\f2\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0014H\u0002J(\u0010\u001b\u001a\u00020\b2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u00142\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0014H\u0002J*\u0010\u001c\u001a\u0004\u0018\u00010\u00012\u0016\u0010\u001d\u001a\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f\u0012\u0002\b\u00030\u001e2\u0006\u0010!\u001a\u00020 H\u0002J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+J0\u0010,\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f\u0012\u0004\u0012\u00020.0-2\u0006\u0010*\u001a\u00020+2\u0006\u0010!\u001a\u00020 2\u0006\u0010/\u001a\u00020)J\b\u00102\u001a\u000203H\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0002018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/database/model/DataSourceSnapshotManager$Companion;", "", "<init>", "()V", "IGNORE_AUTO_MINI_CAT", "", "ourEmptyMiniCat", "setEmptyMiniCat", "", "p", "Lcom/intellij/openapi/Disposable;", "merge", "Lcom/intellij/database/model/basic/BasicHierarchicalObject;", "e", "target", "apply", "substituteChildren", "where", "what", "sameFamily", "Lcom/intellij/database/model/families/ModFamily;", "f", "substitute", "self", "recursive", "substituteFamily", "family", "substituteFamilies", "findModel", "models", "", "Lcom/intellij/openapi/util/Couple;", "Lcom/intellij/database/util/Version;", "version", "getTargets", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/model/basic/BasicElement;", "to", "r", "Lcom/intellij/database/model/basic/BasicRoot;", "getMiniCatStream", "Ljava/io/InputStream;", "dbms", "Lcom/intellij/database/Dbms;", "loadModel", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/database/model/basic/BasicModel;", "input", "MINICAT_STORAGE", "Lcom/intellij/database/model/ModelTextStorage;", "getInstance", "Lcom/intellij/database/model/DataSourceSnapshotManager;", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nDataSourceSnapshotManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceSnapshotManager.kt\ncom/intellij/database/model/DataSourceSnapshotManager$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,476:1\n1#2:477\n57#3:478\n35#3,2:479\n30#4,2:481\n*S KotlinDebug\n*F\n+ 1 DataSourceSnapshotManager.kt\ncom/intellij/database/model/DataSourceSnapshotManager$Companion\n*L\n450#1:478\n450#1:479,2\n473#1:481,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @TestOnly
        public final void setEmptyMiniCat(@NotNull Disposable p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            ourEmptyMiniCat = true;
            Disposer.register((Disposable)p, Companion::setEmptyMiniCat$lambda$0);
        }

        private final BasicHierarchicalObject merge(BasicHierarchicalObject e, BasicHierarchicalObject target, boolean apply2) {
            if (target == null) {
                return null;
            }
            boolean exact = Intrinsics.areEqual((Object)e.getMetaObject(), (Object)target.getMetaObject());
            BasicHierarchicalObject te = null;
            if (exact) {
                te = e;
            } else {
                te = this.merge(e, (BasicHierarchicalObject)target.getParent(), false);
                ObjectPath tp = BasicPaths.of(target);
                BasicHierarchicalObject basicHierarchicalObject = te = te == null ? null : (BasicHierarchicalObject)SqlModelBuilderUtils.createObject(te, tp.name, tp.isQuoted(), tp.getIdentity(), tp.kind);
                if (te == null) {
                    return null;
                }
            }
            if (apply2) {
                if (te instanceof BasicModMateNamespace) {
                    ((BasicModMateNamespace)((Object)te)).setSubstituted(true);
                }
                this.substituteChildren(te, target);
            }
            return te;
        }

        public final void substituteChildren(@NotNull BasicHierarchicalObject where, @NotNull BasicHierarchicalObject what) {
            Intrinsics.checkNotNullParameter((Object)where, (String)"where");
            Intrinsics.checkNotNullParameter((Object)what, (String)"what");
            for (ModFamily modFamily : where.getFamilies()) {
                ModFamily<BasicHierarchicalObject> modFamily2 = modFamily.asHierarchical();
                Intrinsics.checkNotNullExpressionValue(modFamily2, (String)"asHierarchical(...)");
                this.substituteFamily(what, modFamily2);
            }
        }

        private final ModFamily<? extends BasicHierarchicalObject> sameFamily(BasicHierarchicalObject e, ModFamily<? extends BasicHierarchicalObject> f) {
            Family<? extends BasicElement> family = e.familyOf(f.getMetaObject().kind);
            Intrinsics.checkNotNull(family);
            ModFamily<BasicHierarchicalObject> modFamily = ((ModFamily)family).asHierarchical();
            Intrinsics.checkNotNullExpressionValue(modFamily, (String)"asHierarchical(...)");
            return modFamily;
        }

        private final void substitute(BasicHierarchicalObject self, BasicHierarchicalObject what, boolean recursive) {
            boolean bl = Intrinsics.areEqual((Object)what.getMetaObject(), (Object)self.getMetaObject());
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "Wrong object";
                throw new AssertionError((Object)string);
            }
            BasicDataObject data = what.frozenData();
            if (self.hasData(data)) {
                return;
            }
            self.applyData(data);
            if (recursive) {
                for (ModFamily modFamily : self.getFamilies()) {
                    ModFamily<BasicHierarchicalObject> modFamily2 = modFamily.asHierarchical();
                    Intrinsics.checkNotNullExpressionValue(modFamily2, (String)"asHierarchical(...)");
                    this.substituteFamily(what, modFamily2);
                }
            }
        }

        private final void substituteFamily(BasicHierarchicalObject what, ModFamily<? extends BasicHierarchicalObject> family) {
            this.substituteFamilies(this.sameFamily(what, family), family);
        }

        private final void substituteFamilies(ModFamily<? extends BasicHierarchicalObject> what, ModFamily<? extends BasicHierarchicalObject> where) {
            boolean bl = Intrinsics.areEqual(what.getMetaObject(), where.getMetaObject());
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "Wrong object";
                throw new AssertionError((Object)string);
            }
            if (where.size() == what.size()) {
                Iterator fromIt = what.iterator();
                Iterator iterator = where.iterator();
                while (fromIt.hasNext() && iterator.hasNext()) {
                    this.substitute((BasicHierarchicalObject)iterator.next(), (BasicHierarchicalObject)fromIt.next(), true);
                }
            } else {
                where.clear();
                for (BasicHierarchicalObject basicHierarchicalObject : what) {
                    BasicHierarchicalObject basicHierarchicalObject2 = where.createNewOne(basicHierarchicalObject.frozenData());
                    Intrinsics.checkNotNullExpressionValue((Object)basicHierarchicalObject2, (String)"createNewOne(...)");
                    Intrinsics.checkNotNull((Object)basicHierarchicalObject);
                    this.substituteChildren(basicHierarchicalObject2, basicHierarchicalObject);
                }
            }
        }

        private final Object findModel(Map<Couple<Version>, ?> models2, Version version) {
            for (Map.Entry<Couple<Version>, ?> entry : models2.entrySet()) {
                Couple<Version> key = entry.getKey();
                Object value = entry.getValue();
                Object object = key.first;
                Intrinsics.checkNotNull((Object)object);
                if (!version.isOrGreater((Version)object)) continue;
                Object object2 = key.second;
                Intrinsics.checkNotNull((Object)object2);
                if (version.isOrGreater((Version)object2) && version != Version.INFINITY) continue;
                return value;
            }
            return null;
        }

        private final JBIterable<BasicElement> getTargets(BasicHierarchicalObject to, BasicRoot r) {
            if (to instanceof BasicRoot) {
                JBIterable jBIterable = JBIterable.of((Object)r);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"of(...)");
                return jBIterable;
            }
            if (to.getParent() == null) {
                JBIterable jBIterable = JBIterable.empty();
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
                return jBIterable;
            }
            BasicHierarchicalObject basicHierarchicalObject = (BasicHierarchicalObject)to.getParent();
            Intrinsics.checkNotNull((Object)basicHierarchicalObject);
            JBIterable<BasicElement> targets = this.getTargets(basicHierarchicalObject, r);
            JBIterable jBIterable = targets.flatten(arg_0 -> Companion.getTargets$lambda$1(arg_0 -> Companion.getTargets$lambda$0(to, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"flatten(...)");
            return jBIterable;
        }

        @Nullable
        public final InputStream getMiniCatStream(@NotNull Dbms dbms) {
            String string;
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            if (Intrinsics.areEqual((Object)dbms, (Object)Dbms.HSQL)) {
                string = "hsql";
            } else {
                String string2 = dbms.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                String string3 = string2.toLowerCase(Locale.ROOT);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            }
            String name = string;
            Class<?> aClass = DbImplUtilCore.getDatabaseDialect(dbms).getClass();
            String ext = PluginManagerCore.isRunningFromSources() ? "" : ".gzip";
            String string4 = aClass.getPackage().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
            String p1 = StringsKt.replace$default((String)string4, (char)'.', (char)'/', (boolean)false, (int)4, null) + "/" + name + ".minicat.xml" + ext;
            String p2 = (Intrinsics.areEqual((Object)dbms, (Object)Dbms.MARIA) ? "maria" : name) + ".xml" + ext;
            Object object = PluginManagerCore.getPlugin((PluginId)DatabasePluginId.getOrNull());
            if (object == null || (object = object.getPluginClassLoader()) == null) {
                Companion $this$getMiniCatStream_u24lambda_u240 = this;
                boolean bl = false;
                boolean $i$f$fileLogger = false;
                boolean $i$f$currentClassLogger = false;
                Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
                Logger logger2 = Logger.getInstance(clazz$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                logger2.info("Failed to get the main class loader for the database plugin, dbms=" + dbms);
                return null;
            }
            Object classLoader = object;
            InputStream inputStream = ((ClassLoader)classLoader).getResourceAsStream(p1);
            if (inputStream == null && (inputStream = ((ClassLoader)classLoader).getResourceAsStream(p2)) == null) {
                return null;
            }
            InputStream stream = inputStream;
            return ((CharSequence)ext).length() == 0 ? stream : (InputStream)new GZIPInputStream(stream);
        }

        @NotNull
        public final Pair<Couple<Version>, BasicModel> loadModel(@NotNull Dbms dbms, @NotNull Version version, @NotNull InputStream input) {
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            ModelImporter importer = new ModelImporter(new ModelFactory(MINICAT_STORAGE));
            importer.expectedVersion = version;
            importer.currentFormat = true;
            BasicModModel model = importer.deserialize((HierarchicalStreamReader)new XppReader((Reader)new InputStreamReader(input, StandardCharsets.UTF_8), (XmlPullParser)new MXParser()), dbms.getName() + "/minicat");
            Intrinsics.checkNotNull((Object)model, (String)"null cannot be cast to non-null type com.intellij.database.model.BaseModel");
            ((BaseModel)model).setFrozen(true);
            return new Pair((Object)Couple.of((Object)importer.versionRange[0], (Object)importer.versionRange[1]), (Object)model);
        }

        @JvmStatic
        @NotNull
        public final DataSourceSnapshotManager getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<DataSourceSnapshotManager> serviceClass$iv = DataSourceSnapshotManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DataSourceSnapshotManager)object;
        }

        private static final void setEmptyMiniCat$lambda$0() {
            ourEmptyMiniCat = false;
        }

        private static final boolean getTargets$lambda$0$0$0(BasicHierarchicalObject $to, String $name, BasicElement c2) {
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            return c2.getKind() == $to.getKind() && Intrinsics.areEqual((Object)c2.getName(), (Object)$name);
        }

        private static final boolean getTargets$lambda$0$0$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final BasicElement getTargets$lambda$0$0(BasicElement $o, BasicHierarchicalObject $to, String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return (BasicElement)$o.getChildren().filter(arg_0 -> Companion.getTargets$lambda$0$0$1(arg_0 -> Companion.getTargets$lambda$0$0$0($to, name, arg_0), arg_0)).first();
        }

        private static final BasicElement getTargets$lambda$0$1(Function1 $tmp0, Object p0) {
            return (BasicElement)$tmp0.invoke(p0);
        }

        private static final Iterable getTargets$lambda$0(BasicHierarchicalObject $to, BasicElement o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            Object[] objectArray = new String[]{"", $to.getName()};
            return (Iterable)JBIterable.of((Object[])objectArray).filterMap(arg_0 -> Companion.getTargets$lambda$0$1(arg_0 -> Companion.getTargets$lambda$0$0(o, $to, arg_0), arg_0));
        }

        private static final Iterable getTargets$lambda$1(Function1 $tmp0, Object p0) {
            return (Iterable)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R#\u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/model/DataSourceSnapshotManager$ModelsForDbms;", "", "<init>", "()V", "mutex", "Lkotlinx/coroutines/sync/Mutex;", "getMutex", "()Lkotlinx/coroutines/sync/Mutex;", "models", "", "Lcom/intellij/openapi/util/Couple;", "Lcom/intellij/database/util/Version;", "getModels", "()Ljava/util/Map;", "intellij.database.core.impl"})
    private static final class ModelsForDbms {
        @NotNull
        private final Mutex mutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        @NotNull
        private final Map<Couple<Version>, Object> models;

        public ModelsForDbms() {
            ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftValueMap();
            Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftValueMap(...)");
            this.models = concurrentMap;
        }

        @NotNull
        public final Mutex getMutex() {
            return this.mutex;
        }

        @NotNull
        public final Map<Couple<Version>, Object> getModels() {
            return this.models;
        }
    }
}

