/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasicPaths {
    @Contract(value="!null->!null")
    public static ObjectPath of(@Nullable BasicElement o) {
        return BasicPaths.of(o, null);
    }

    @Contract(value="!null->!null")
    public static ObjectPath of(@Nullable BasicObjectNode o) {
        if (o == null) {
            return null;
        }
        BasicObjectNode parent = o.getParent();
        if (parent != null && parent.getMetaObject().kind == ObjectKind.ROOT) {
            parent = null;
        }
        return BasicPaths.append(o.extractObject(), null, BasicPaths.of(parent));
    }

    @Contract(value="!null,_->!null")
    public static ObjectPath of(@Nullable BasicElement o, @Nullable CasingProvider normalizer) {
        if (o == null) {
            return null;
        }
        BasicElement parent = o.getParent();
        if (parent != null && parent.getKind() == ObjectKind.ROOT) {
            parent = null;
        }
        return BasicPaths.append(o, normalizer, BasicPaths.of(parent, normalizer));
    }

    @NotNull
    public static ObjectPath append(@NotNull BasicElement o, @Nullable ObjectPath parentPath) {
        if (o == null) {
            BasicPaths.$$$reportNull$$$0(0);
        }
        return BasicPaths.append(o, null, parentPath);
    }

    @NotNull
    public static ObjectPath append(@NotNull BasicElement o, @Nullable CasingProvider normalizer, @Nullable ObjectPath parentPath) {
        if (o == null) {
            BasicPaths.$$$reportNull$$$0(1);
        }
        return BasicPaths.append(o, o.getName(), normalizer, parentPath);
    }

    @NotNull
    public static ObjectPath append(@NotNull BasicElement o, @NotNull String name, @Nullable CasingProvider normalizer, @Nullable ObjectPath parentPath) {
        if (o == null) {
            BasicPaths.$$$reportNull$$$0(2);
        }
        if (name == null) {
            BasicPaths.$$$reportNull$$$0(3);
        }
        return BasicPaths.createNormalized(o, name, BasicPaths.isQuoted(o), BasicPaths.getIdentity(o), parentPath, normalizer);
    }

    @NotNull
    public static ObjectPath createNormalized(@NotNull DasObject o, boolean quoted, @Nullable String identity, @Nullable ObjectPath parentPath, @Nullable CasingProvider normalizer) {
        if (o == null) {
            BasicPaths.$$$reportNull$$$0(4);
        }
        return BasicPaths.createNormalized(o, o.getName(), quoted, identity, parentPath, normalizer);
    }

    @NotNull
    public static ObjectPath createNormalized(@NotNull DasObject o, @NotNull String name, boolean quoted, @Nullable String identity, @Nullable ObjectPath parentPath, @Nullable CasingProvider normalizer) {
        if (o == null) {
            BasicPaths.$$$reportNull$$$0(5);
        }
        if (name == null) {
            BasicPaths.$$$reportNull$$$0(6);
        }
        ObjectKind kind = o.getKind();
        if (normalizer != null) {
            Casing casing = normalizer.getCasing(kind, o);
            Case q = casing.choose(!quoted);
            name = q.apply(name);
            if (!(quoted || q == Case.MIXED && casing.quoted != Case.MIXED)) {
                quoted = true;
            }
        }
        ObjectPath objectPath = ObjectPath.create((String)name, (ObjectKind)kind, (boolean)quoted, (String)identity, (ObjectPath)parentPath);
        if (objectPath == null) {
            BasicPaths.$$$reportNull$$$0(7);
        }
        return objectPath;
    }

    public static boolean isQuoted(@NotNull BasicElement o) {
        if (o == null) {
            BasicPaths.$$$reportNull$$$0(8);
        }
        return !(o instanceof BasicNamedElement) || ((BasicNamedElement)o).isNameQuoted() || !((BasicNamedElement)o).isNameScripted();
    }

    @Nullable
    public static String getIdentity(@NotNull BasicElement obj) {
        if (obj == null) {
            BasicPaths.$$$reportNull$$$0(9);
        }
        return BasicPaths.getIdentity(obj, false, true);
    }

    @Nullable
    public static String getIdentity(@NotNull BasicElement obj, boolean normalize, boolean withSurrogates) {
        if (obj == null) {
            BasicPaths.$$$reportNull$$$0(10);
        }
        return StringUtil.nullize((String)obj.identity(withSurrogates, true, normalize));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/BasicPaths";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/BasicPaths";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createNormalized";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNormalized";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isQuoted";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getIdentity";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

