/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.lifecycle.mappings.model.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.LiveHandlerMethod;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.LiveRequestMapping;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.LiveRequestMappingsModel;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.impl.LiveHandlerMethodImpl;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class LiveRequestMappingsModelImpl
implements LiveRequestMappingsModel {
    private static final String METHOD_NAME_SEPARATOR = "#";
    private final List<LiveRequestMapping> myMappings;
    private final Map<String, List<LiveRequestMapping>> myMethodToMappings;

    public LiveRequestMappingsModelImpl(@NotNull Collection<? extends LiveRequestMapping> mappings) {
        if (mappings == null) {
            LiveRequestMappingsModelImpl.$$$reportNull$$$0(0);
        }
        this.myMappings = new SmartList();
        this.myMethodToMappings = new HashMap<String, List<LiveRequestMapping>>();
        this.myMappings.addAll(mappings);
        this.myMappings.forEach(mapping -> {
            LiveHandlerMethod method = mapping.getMethod();
            if (method == null) {
                return;
            }
            List methodMappings = this.myMethodToMappings.computeIfAbsent(method.getClassName() + METHOD_NAME_SEPARATOR + method.getMethodName(), key -> new SmartList());
            methodMappings.add(mapping);
        });
    }

    @Override
    @NotNull
    public List<LiveRequestMapping> getRequestMappings() {
        List<LiveRequestMapping> list = Collections.unmodifiableList(this.myMappings);
        if (list == null) {
            LiveRequestMappingsModelImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public List<LiveRequestMapping> getRequestMappingsByMethod(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            LiveRequestMappingsModelImpl.$$$reportNull$$$0(2);
        }
        if (!psiMethod.isValid()) {
            List<LiveRequestMapping> list = Collections.emptyList();
            if (list == null) {
                LiveRequestMappingsModelImpl.$$$reportNull$$$0(3);
            }
            return list;
        }
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiClass == null) {
            List<LiveRequestMapping> list = Collections.emptyList();
            if (list == null) {
                LiveRequestMappingsModelImpl.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<LiveRequestMapping> mappings = this.myMethodToMappings.get(psiClass.getQualifiedName() + METHOD_NAME_SEPARATOR + psiMethod.getName());
        if (mappings == null) {
            if (LiveHandlerMethodImpl.isRouterFunctionBean(psiMethod) && (mappings = this.myMethodToMappings.get(psiClass.getQualifiedName() + "#$$Lambda")) != null) {
                List<LiveRequestMapping> list = mappings;
                if (list == null) {
                    LiveRequestMappingsModelImpl.$$$reportNull$$$0(5);
                }
                return list;
            }
            List<LiveRequestMapping> list = Collections.emptyList();
            if (list == null) {
                LiveRequestMappingsModelImpl.$$$reportNull$$$0(6);
            }
            return list;
        }
        List list = ContainerUtil.filter(mappings, mapping -> {
            LiveHandlerMethod liveHandlerMethod = mapping.getMethod();
            return liveHandlerMethod != null && liveHandlerMethod.matches(psiMethod);
        });
        if (list == null) {
            LiveRequestMappingsModelImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/mvc/lifecycle/mappings/model/impl/LiveRequestMappingsModelImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/mvc/lifecycle/mappings/model/impl/LiveRequestMappingsModelImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestMappings";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestMappingsByMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRequestMappingsByMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

