/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.actions.test;

import com.intellij.ktor.actions.test.TestActionsUtils;
import com.intellij.openapi.util.text.Strings;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001:\u0001\u0011J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0012\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ktor/actions/test/KtorMultiRouteTestDialog;", "", "showAndGet", "", "testClassName", "", "getTestClassName", "()Ljava/lang/String;", "selectedPackageName", "getSelectedPackageName", "selectedUrls", "", "Lcom/intellij/ktor/actions/test/KtorMultiRouteTestDialog$SelectedTestRoute;", "getSelectedUrls", "()Ljava/util/List;", "calculateTestClassName", "moduleName", "SelectedTestRoute", "intellij.ktor"})
public interface KtorMultiRouteTestDialog {
    public boolean showAndGet();

    @NotNull
    public String getTestClassName();

    @NotNull
    public String getSelectedPackageName();

    @NotNull
    public List<SelectedTestRoute> getSelectedUrls();

    @NotNull
    default public String calculateTestClassName(@NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        return Strings.capitalize((String)moduleName) + "Test";
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0016\u001a\u00020\u0017H\u00d6\u0081\u0004J\n\u0010\u0018\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\n\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ktor/actions/test/KtorMultiRouteTestDialog$SelectedTestRoute;", "", "url", "", "method", "testName", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/String;)V", "getUrl", "()Ljava/lang/String;", "getMethod", "getTestName", "setTestName", "(Ljava/lang/String;)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ktor"})
    public static final class SelectedTestRoute {
        @NotNull
        private final String url;
        @NotNull
        private final String method;
        @NotNull
        private String testName;

        public SelectedTestRoute(@NotNull String url, @NotNull String method, @NotNull String testName) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
            this.url = url;
            this.method = method;
            this.testName = testName;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final String getMethod() {
            return this.method;
        }

        @NotNull
        public final String getTestName() {
            return this.testName;
        }

        public final void setTestName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.testName = string;
        }

        public SelectedTestRoute(@NotNull String url, @NotNull String method) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            this(url, method, TestActionsUtils.Companion.calculateTestName(url, method));
        }

        @NotNull
        public final String component1() {
            return this.url;
        }

        @NotNull
        public final String component2() {
            return this.method;
        }

        @NotNull
        public final String component3() {
            return this.testName;
        }

        @NotNull
        public final SelectedTestRoute copy(@NotNull String url, @NotNull String method, @NotNull String testName) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
            return new SelectedTestRoute(url, method, testName);
        }

        public static /* synthetic */ SelectedTestRoute copy$default(SelectedTestRoute selectedTestRoute, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = selectedTestRoute.url;
            }
            if ((n & 2) != 0) {
                string2 = selectedTestRoute.method;
            }
            if ((n & 4) != 0) {
                string3 = selectedTestRoute.testName;
            }
            return selectedTestRoute.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "SelectedTestRoute(url=" + this.url + ", method=" + this.method + ", testName=" + this.testName + ")";
        }

        public int hashCode() {
            int result = this.url.hashCode();
            result = result * 31 + this.method.hashCode();
            result = result * 31 + this.testName.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SelectedTestRoute)) {
                return false;
            }
            SelectedTestRoute selectedTestRoute = (SelectedTestRoute)other;
            if (!Intrinsics.areEqual((Object)this.url, (Object)selectedTestRoute.url)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.method, (Object)selectedTestRoute.method)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.testName, (Object)selectedTestRoute.testName);
        }
    }
}

